/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v17.leanback.widget.BaseGridView;
import android.support.v17.leanback.widget.FacetProvider;
import android.support.v17.leanback.widget.FacetProviderAdapter;
import android.support.v17.leanback.widget.Grid;
import android.support.v17.leanback.widget.ItemAlignment;
import android.support.v17.leanback.widget.ItemAlignmentFacet;
import android.support.v17.leanback.widget.ItemAlignmentFacetHelper;
import android.support.v17.leanback.widget.OnChildLaidOutListener;
import android.support.v17.leanback.widget.OnChildSelectedListener;
import android.support.v17.leanback.widget.OnChildViewHolderSelectedListener;
import android.support.v17.leanback.widget.ViewsStateBundle;
import android.support.v17.leanback.widget.WindowAlignment;
import android.support.v4.util.CircularIntArray;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import java.util.ArrayList;

final class GridLayoutManager
extends RecyclerView.LayoutManager {
    private static final String TAG = "GridLayoutManager";
    private static final boolean DEBUG = false;
    private static final boolean TRACE = false;
    private static final int MAX_PENDING_MOVES = 10;
    private final BaseGridView mBaseGridView;
    private int mOrientation = 0;
    private RecyclerView.State mState;
    private RecyclerView.Recycler mRecycler;
    private boolean mInLayout;
    private boolean mInScroll;
    private boolean mInFastRelayout;
    private boolean mInLayoutSearchFocus;
    private boolean mInSelection = false;
    private OnChildSelectedListener mChildSelectedListener = null;
    private OnChildViewHolderSelectedListener mChildViewHolderSelectedListener = null;
    private OnChildLaidOutListener mChildLaidOutListener = null;
    private int mFocusPosition = -1;
    private int mSubFocusPosition = 0;
    private PendingMoveSmoothScroller mPendingMoveSmoothScroller;
    private int mFocusPositionOffset = 0;
    private int mPrimaryScrollExtra;
    private boolean mForceFullLayout;
    private boolean mLayoutEnabled = true;
    private int mChildVisibility = -1;
    private int mScrollOffsetPrimary;
    private int mScrollOffsetSecondary;
    private int mRowSizeSecondaryRequested;
    private int mFixedRowSizeSecondary;
    private int[] mRowSizeSecondary;
    private boolean mRowSecondarySizeRefresh;
    private int mMaxSizeSecondary;
    private int mHorizontalMargin;
    private int mVerticalMargin;
    private int mMarginPrimary;
    private int mMarginSecondary;
    private int mGravity = 0x800033;
    private int mNumRows;
    private int mNumRowsRequested = 1;
    Grid mGrid;
    private int mFocusScrollStrategy = 0;
    private final WindowAlignment mWindowAlignment = new WindowAlignment();
    private final ItemAlignment mItemAlignment = new ItemAlignment();
    private int mSizePrimary;
    private boolean mFocusOutFront;
    private boolean mFocusOutEnd;
    private boolean mFocusSearchDisabled;
    private boolean mPruneChild = true;
    private boolean mScrollEnabled = true;
    private static int[] sTwoInts = new int[2];
    private boolean mReverseFlowPrimary = false;
    private boolean mReverseFlowSecondary = false;
    private int[] mMeasuredDimension = new int[2];
    final ViewsStateBundle mChildrenStates = new ViewsStateBundle();
    private FacetProviderAdapter mFacetProviderAdapter;
    private final Runnable mRequestLayoutRunnable = new Runnable(){

        @Override
        public void run() {
            GridLayoutManager.this.requestLayout();
        }
    };
    private Grid.Provider mGridProvider = new Grid.Provider(){

        @Override
        public int getCount() {
            return GridLayoutManager.this.mState.getItemCount();
        }

        @Override
        public int createItem(int index, boolean append, Object[] item) {
            View v = GridLayoutManager.this.getViewForPosition(index);
            LayoutParams lp = (LayoutParams)v.getLayoutParams();
            RecyclerView.ViewHolder vh = GridLayoutManager.this.mBaseGridView.getChildViewHolder(v);
            lp.setItemAlignmentFacet((ItemAlignmentFacet)GridLayoutManager.this.getFacet(vh, ItemAlignmentFacet.class));
            if (!lp.isItemRemoved()) {
                if (append) {
                    GridLayoutManager.this.addView(v);
                } else {
                    GridLayoutManager.this.addView(v, 0);
                }
                if (GridLayoutManager.this.mChildVisibility != -1) {
                    v.setVisibility(GridLayoutManager.this.mChildVisibility);
                }
                if (GridLayoutManager.this.mPendingMoveSmoothScroller != null) {
                    GridLayoutManager.this.mPendingMoveSmoothScroller.consumePendingMovesBeforeLayout();
                }
                int subindex = GridLayoutManager.this.getSubPositionByView(v, v.findFocus());
                if (!GridLayoutManager.this.mInLayout) {
                    if (index == GridLayoutManager.this.mFocusPosition && subindex == GridLayoutManager.this.mSubFocusPosition && (GridLayoutManager.this.mPendingMoveSmoothScroller == null || GridLayoutManager.this.mPendingMoveSmoothScroller.mPendingMoves == 0)) {
                        GridLayoutManager.this.dispatchChildSelected();
                    }
                } else if (!GridLayoutManager.this.mInFastRelayout) {
                    if (!GridLayoutManager.this.mInLayoutSearchFocus && index == GridLayoutManager.this.mFocusPosition && subindex == GridLayoutManager.this.mSubFocusPosition) {
                        GridLayoutManager.this.dispatchChildSelected();
                    } else if (GridLayoutManager.this.mInLayoutSearchFocus && index >= GridLayoutManager.this.mFocusPosition && v.hasFocusable()) {
                        GridLayoutManager.this.mFocusPosition = index;
                        GridLayoutManager.this.mSubFocusPosition = subindex;
                        GridLayoutManager.this.mInLayoutSearchFocus = false;
                        GridLayoutManager.this.dispatchChildSelected();
                    }
                }
                GridLayoutManager.this.measureChild(v);
            }
            item[0] = v;
            return GridLayoutManager.this.mOrientation == 0 ? v.getMeasuredWidth() : v.getMeasuredHeight();
        }

        @Override
        public void addItem(Object item, int index, int length, int rowIndex, int edge) {
            int end;
            int start;
            boolean edgeIsMin;
            View v = (View)item;
            if (edge == Integer.MIN_VALUE || edge == Integer.MAX_VALUE) {
                edge = !GridLayoutManager.this.mGrid.isReversedFlow() ? GridLayoutManager.this.mWindowAlignment.mainAxis().getPaddingLow() : GridLayoutManager.this.mWindowAlignment.mainAxis().getSize() - GridLayoutManager.this.mWindowAlignment.mainAxis().getPaddingHigh();
            }
            boolean bl = edgeIsMin = !GridLayoutManager.this.mGrid.isReversedFlow();
            if (edgeIsMin) {
                start = edge;
                end = edge + length;
            } else {
                start = edge - length;
                end = edge;
            }
            int startSecondary = GridLayoutManager.this.getRowStartSecondary(rowIndex) - GridLayoutManager.this.mScrollOffsetSecondary;
            GridLayoutManager.this.mChildrenStates.loadView(v, index);
            GridLayoutManager.this.layoutChild(rowIndex, v, start, end, startSecondary);
            if (index == GridLayoutManager.this.mGrid.getFirstVisibleIndex()) {
                if (!GridLayoutManager.this.mGrid.isReversedFlow()) {
                    GridLayoutManager.this.updateScrollMin();
                } else {
                    GridLayoutManager.this.updateScrollMax();
                }
            }
            if (index == GridLayoutManager.this.mGrid.getLastVisibleIndex()) {
                if (!GridLayoutManager.this.mGrid.isReversedFlow()) {
                    GridLayoutManager.this.updateScrollMax();
                } else {
                    GridLayoutManager.this.updateScrollMin();
                }
            }
            if (!GridLayoutManager.this.mInLayout && GridLayoutManager.this.mPendingMoveSmoothScroller != null) {
                GridLayoutManager.this.mPendingMoveSmoothScroller.consumePendingMovesAfterLayout();
            }
            if (GridLayoutManager.this.mChildLaidOutListener != null) {
                RecyclerView.ViewHolder vh = GridLayoutManager.this.mBaseGridView.getChildViewHolder(v);
                GridLayoutManager.this.mChildLaidOutListener.onChildLaidOut((ViewGroup)GridLayoutManager.this.mBaseGridView, v, index, vh == null ? -1L : vh.getItemId());
            }
        }

        @Override
        public void removeItem(int index) {
            View v = GridLayoutManager.this.findViewByPosition(index);
            if (GridLayoutManager.this.mInLayout) {
                GridLayoutManager.this.detachAndScrapView(v, GridLayoutManager.this.mRecycler);
            } else {
                GridLayoutManager.this.removeAndRecycleView(v, GridLayoutManager.this.mRecycler);
            }
        }

        @Override
        public int getEdge(int index) {
            if (GridLayoutManager.this.mReverseFlowPrimary) {
                return GridLayoutManager.this.getViewMax(GridLayoutManager.this.findViewByPosition(index));
            }
            return GridLayoutManager.this.getViewMin(GridLayoutManager.this.findViewByPosition(index));
        }

        @Override
        public int getSize(int index) {
            return GridLayoutManager.this.getViewPrimarySize(GridLayoutManager.this.findViewByPosition(index));
        }
    };
    private static final int PREV_ITEM = 0;
    private static final int NEXT_ITEM = 1;
    private static final int PREV_ROW = 2;
    private static final int NEXT_ROW = 3;

    private String getTag() {
        return "GridLayoutManager:" + this.mBaseGridView.getId();
    }

    public GridLayoutManager(BaseGridView baseGridView) {
        this.mBaseGridView = baseGridView;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            return;
        }
        this.mOrientation = orientation;
        this.mWindowAlignment.setOrientation(orientation);
        this.mItemAlignment.setOrientation(orientation);
        this.mForceFullLayout = true;
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        if (this.mOrientation == 0) {
            this.mReverseFlowPrimary = layoutDirection == 1;
            this.mReverseFlowSecondary = false;
        } else {
            this.mReverseFlowSecondary = layoutDirection == 1;
            this.mReverseFlowPrimary = false;
        }
        this.mWindowAlignment.horizontal.setReversedFlow(layoutDirection == 1);
    }

    public int getFocusScrollStrategy() {
        return this.mFocusScrollStrategy;
    }

    public void setFocusScrollStrategy(int focusScrollStrategy) {
        this.mFocusScrollStrategy = focusScrollStrategy;
    }

    public void setWindowAlignment(int windowAlignment) {
        this.mWindowAlignment.mainAxis().setWindowAlignment(windowAlignment);
    }

    public int getWindowAlignment() {
        return this.mWindowAlignment.mainAxis().getWindowAlignment();
    }

    public void setWindowAlignmentOffset(int alignmentOffset) {
        this.mWindowAlignment.mainAxis().setWindowAlignmentOffset(alignmentOffset);
    }

    public int getWindowAlignmentOffset() {
        return this.mWindowAlignment.mainAxis().getWindowAlignmentOffset();
    }

    public void setWindowAlignmentOffsetPercent(float offsetPercent) {
        this.mWindowAlignment.mainAxis().setWindowAlignmentOffsetPercent(offsetPercent);
    }

    public float getWindowAlignmentOffsetPercent() {
        return this.mWindowAlignment.mainAxis().getWindowAlignmentOffsetPercent();
    }

    public void setItemAlignmentOffset(int alignmentOffset) {
        this.mItemAlignment.mainAxis().setItemAlignmentOffset(alignmentOffset);
        this.updateChildAlignments();
    }

    public int getItemAlignmentOffset() {
        return this.mItemAlignment.mainAxis().getItemAlignmentOffset();
    }

    public void setItemAlignmentOffsetWithPadding(boolean withPadding) {
        this.mItemAlignment.mainAxis().setItemAlignmentOffsetWithPadding(withPadding);
        this.updateChildAlignments();
    }

    public boolean isItemAlignmentOffsetWithPadding() {
        return this.mItemAlignment.mainAxis().isItemAlignmentOffsetWithPadding();
    }

    public void setItemAlignmentOffsetPercent(float offsetPercent) {
        this.mItemAlignment.mainAxis().setItemAlignmentOffsetPercent(offsetPercent);
        this.updateChildAlignments();
    }

    public float getItemAlignmentOffsetPercent() {
        return this.mItemAlignment.mainAxis().getItemAlignmentOffsetPercent();
    }

    public void setItemAlignmentViewId(int viewId) {
        this.mItemAlignment.mainAxis().setItemAlignmentViewId(viewId);
        this.updateChildAlignments();
    }

    public int getItemAlignmentViewId() {
        return this.mItemAlignment.mainAxis().getItemAlignmentViewId();
    }

    public void setFocusOutAllowed(boolean throughFront, boolean throughEnd) {
        this.mFocusOutFront = throughFront;
        this.mFocusOutEnd = throughEnd;
    }

    public void setNumRows(int numRows) {
        if (numRows < 0) {
            throw new IllegalArgumentException();
        }
        this.mNumRowsRequested = numRows;
    }

    public void setRowHeight(int height) {
        if (height < 0 && height != -2) {
            throw new IllegalArgumentException("Invalid row height: " + height);
        }
        this.mRowSizeSecondaryRequested = height;
    }

    public void setItemMargin(int margin) {
        this.mVerticalMargin = this.mHorizontalMargin = margin;
        this.mMarginPrimary = this.mMarginSecondary = margin;
    }

    public void setVerticalMargin(int margin) {
        if (this.mOrientation == 0) {
            this.mMarginSecondary = this.mVerticalMargin = margin;
        } else {
            this.mMarginPrimary = this.mVerticalMargin = margin;
        }
    }

    public void setHorizontalMargin(int margin) {
        if (this.mOrientation == 0) {
            this.mMarginPrimary = this.mHorizontalMargin = margin;
        } else {
            this.mMarginSecondary = this.mHorizontalMargin = margin;
        }
    }

    public int getVerticalMargin() {
        return this.mVerticalMargin;
    }

    public int getHorizontalMargin() {
        return this.mHorizontalMargin;
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
    }

    protected boolean hasDoneFirstLayout() {
        return this.mGrid != null;
    }

    public void setOnChildSelectedListener(OnChildSelectedListener listener) {
        this.mChildSelectedListener = listener;
    }

    public void setOnChildViewHolderSelectedListener(OnChildViewHolderSelectedListener listener) {
        this.mChildViewHolderSelectedListener = listener;
    }

    void setOnChildLaidOutListener(OnChildLaidOutListener listener) {
        this.mChildLaidOutListener = listener;
    }

    private int getPositionByView(View view) {
        if (view == null) {
            return -1;
        }
        LayoutParams params = (LayoutParams)view.getLayoutParams();
        if (params == null || params.isItemRemoved()) {
            return -1;
        }
        return params.getViewPosition();
    }

    private int getSubPositionByView(View view, View childView) {
        ItemAlignmentFacet.ItemAlignmentDef[] defs;
        if (view == null || childView == null) {
            return 0;
        }
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        ItemAlignmentFacet facet = lp.getItemAlignmentFacet();
        if (facet != null && (defs = facet.getAlignmentDefs()).length > 1) {
            while (childView != view) {
                int id2 = childView.getId();
                if (id2 != -1) {
                    for (int i = 1; i < defs.length; ++i) {
                        if (defs[i].getItemAlignmentFocusViewId() != id2) continue;
                        return i;
                    }
                }
                childView = (View)childView.getParent();
            }
        }
        return 0;
    }

    private int getPositionByIndex(int index) {
        return this.getPositionByView(this.getChildAt(index));
    }

    private void dispatchChildSelected() {
        View view;
        if (this.mChildSelectedListener == null && this.mChildViewHolderSelectedListener == null) {
            return;
        }
        View view2 = view = this.mFocusPosition == -1 ? null : this.findViewByPosition(this.mFocusPosition);
        if (view != null) {
            RecyclerView.ViewHolder vh = this.mBaseGridView.getChildViewHolder(view);
            if (this.mChildSelectedListener != null) {
                this.mChildSelectedListener.onChildSelected((ViewGroup)this.mBaseGridView, view, this.mFocusPosition, vh == null ? -1L : vh.getItemId());
            }
            if (this.mChildViewHolderSelectedListener != null) {
                this.mChildViewHolderSelectedListener.onChildViewHolderSelected(this.mBaseGridView, vh, this.mFocusPosition, this.mSubFocusPosition);
            }
        } else {
            if (this.mChildSelectedListener != null) {
                this.mChildSelectedListener.onChildSelected((ViewGroup)this.mBaseGridView, null, -1, -1L);
            }
            if (this.mChildViewHolderSelectedListener != null) {
                this.mChildViewHolderSelectedListener.onChildViewHolderSelected(this.mBaseGridView, null, -1, 0);
            }
        }
        if (!this.mInLayout && !this.mBaseGridView.isLayoutRequested()) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                if (!this.getChildAt(i).isLayoutRequested()) continue;
                this.forceRequestLayout();
                break;
            }
        }
    }

    public boolean canScrollHorizontally() {
        return this.mOrientation == 0 || this.mNumRows > 1;
    }

    public boolean canScrollVertically() {
        return this.mOrientation == 1 || this.mNumRows > 1;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public RecyclerView.LayoutParams generateLayoutParams(Context context, AttributeSet attrs) {
        return new LayoutParams(context, attrs);
    }

    public RecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (lp instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)lp);
        }
        if (lp instanceof RecyclerView.LayoutParams) {
            return new LayoutParams((RecyclerView.LayoutParams)lp);
        }
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    protected View getViewForPosition(int position) {
        return this.mRecycler.getViewForPosition(position);
    }

    final int getOpticalLeft(View v) {
        return ((LayoutParams)v.getLayoutParams()).getOpticalLeft(v);
    }

    final int getOpticalRight(View v) {
        return ((LayoutParams)v.getLayoutParams()).getOpticalRight(v);
    }

    final int getOpticalTop(View v) {
        return ((LayoutParams)v.getLayoutParams()).getOpticalTop(v);
    }

    final int getOpticalBottom(View v) {
        return ((LayoutParams)v.getLayoutParams()).getOpticalBottom(v);
    }

    private int getViewMin(View v) {
        return this.mOrientation == 0 ? this.getOpticalLeft(v) : this.getOpticalTop(v);
    }

    private int getViewMax(View v) {
        return this.mOrientation == 0 ? this.getOpticalRight(v) : this.getOpticalBottom(v);
    }

    private int getViewPrimarySize(View view) {
        LayoutParams p = (LayoutParams)view.getLayoutParams();
        return this.mOrientation == 0 ? p.getOpticalWidth(view) : p.getOpticalHeight(view);
    }

    private int getViewCenter(View view) {
        return this.mOrientation == 0 ? this.getViewCenterX(view) : this.getViewCenterY(view);
    }

    private int getViewCenterSecondary(View view) {
        return this.mOrientation == 0 ? this.getViewCenterY(view) : this.getViewCenterX(view);
    }

    private int getViewCenterX(View v) {
        LayoutParams p = (LayoutParams)v.getLayoutParams();
        return p.getOpticalLeft(v) + p.getAlignX();
    }

    private int getViewCenterY(View v) {
        LayoutParams p = (LayoutParams)v.getLayoutParams();
        return p.getOpticalTop(v) + p.getAlignY();
    }

    private void saveContext(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mRecycler != null || this.mState != null) {
            Log.e((String)TAG, (String)"Recycler information was not released, bug!");
        }
        this.mRecycler = recycler;
        this.mState = state;
    }

    private void leaveContext() {
        this.mRecycler = null;
        this.mState = null;
    }

    private boolean layoutInit() {
        int firstVisibleIndex;
        boolean focusViewWasInTree = this.mGrid != null && this.mFocusPosition >= 0 && this.mFocusPosition >= this.mGrid.getFirstVisibleIndex() && this.mFocusPosition <= this.mGrid.getLastVisibleIndex();
        int newItemCount = this.mState.getItemCount();
        if (newItemCount == 0) {
            this.mFocusPosition = -1;
            this.mSubFocusPosition = 0;
        } else if (this.mFocusPosition >= newItemCount) {
            this.mFocusPosition = newItemCount - 1;
            this.mSubFocusPosition = 0;
        } else if (this.mFocusPosition == -1 && newItemCount > 0) {
            this.mFocusPosition = 0;
            this.mSubFocusPosition = 0;
        }
        if (!this.mState.didStructureChange() && this.mGrid.getFirstVisibleIndex() >= 0 && !this.mForceFullLayout && this.mGrid != null && this.mGrid.getNumRows() == this.mNumRows) {
            this.updateScrollController();
            this.updateScrollSecondAxis();
            this.mGrid.setMargin(this.mMarginPrimary);
            if (!focusViewWasInTree && this.mFocusPosition != -1) {
                this.mGrid.setStart(this.mFocusPosition);
            }
            return true;
        }
        this.mForceFullLayout = false;
        int n = firstVisibleIndex = focusViewWasInTree ? this.mGrid.getFirstVisibleIndex() : 0;
        if (this.mGrid == null || this.mNumRows != this.mGrid.getNumRows() || this.mReverseFlowPrimary != this.mGrid.isReversedFlow()) {
            this.mGrid = Grid.createStaggeredMultipleRows(this.mNumRows);
            this.mGrid.setProvider(this.mGridProvider);
            this.mGrid.setReversedFlow(this.mReverseFlowPrimary);
        }
        this.initScrollController();
        this.updateScrollSecondAxis();
        this.mGrid.setMargin(this.mMarginPrimary);
        this.detachAndScrapAttachedViews(this.mRecycler);
        this.mGrid.resetVisibleIndex();
        if (this.mFocusPosition == -1) {
            this.mBaseGridView.clearFocus();
        }
        this.mWindowAlignment.mainAxis().invalidateScrollMin();
        this.mWindowAlignment.mainAxis().invalidateScrollMax();
        if (focusViewWasInTree && firstVisibleIndex <= this.mFocusPosition) {
            this.mGrid.setStart(firstVisibleIndex);
        } else {
            this.mGrid.setStart(this.mFocusPosition);
        }
        return false;
    }

    private int getRowSizeSecondary(int rowIndex) {
        if (this.mFixedRowSizeSecondary != 0) {
            return this.mFixedRowSizeSecondary;
        }
        if (this.mRowSizeSecondary == null) {
            return 0;
        }
        return this.mRowSizeSecondary[rowIndex];
    }

    private int getRowStartSecondary(int rowIndex) {
        int start = 0;
        if (this.mReverseFlowSecondary) {
            for (int i = this.mNumRows - 1; i > rowIndex; --i) {
                start += this.getRowSizeSecondary(i) + this.mMarginSecondary;
            }
        } else {
            for (int i = 0; i < rowIndex; ++i) {
                start += this.getRowSizeSecondary(i) + this.mMarginSecondary;
            }
        }
        return start;
    }

    private int getSizeSecondary() {
        int rightmostIndex = this.mReverseFlowSecondary ? 0 : this.mNumRows - 1;
        return this.getRowStartSecondary(rightmostIndex) + this.getRowSizeSecondary(rightmostIndex);
    }

    private void measureScrapChild(int position, int widthSpec, int heightSpec, int[] measuredDimension) {
        View view = this.mRecycler.getViewForPosition(position);
        if (view != null) {
            LayoutParams p = (LayoutParams)view.getLayoutParams();
            int childWidthSpec = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)p.width);
            int childHeightSpec = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)p.height);
            view.measure(childWidthSpec, childHeightSpec);
            measuredDimension[0] = view.getMeasuredWidth();
            measuredDimension[1] = view.getMeasuredHeight();
            this.mRecycler.recycleView(view);
        }
    }

    private boolean processRowSizeSecondary(boolean measure) {
        if (this.mFixedRowSizeSecondary != 0 || this.mRowSizeSecondary == null) {
            return false;
        }
        CircularIntArray[] rows = this.mGrid == null ? null : this.mGrid.getItemPositionsInRows();
        boolean changed = false;
        int scrapChildWidth = -1;
        int scrapChildHeight = -1;
        for (int rowIndex = 0; rowIndex < this.mNumRows; ++rowIndex) {
            CircularIntArray row = rows == null ? null : rows[rowIndex];
            int rowItemsPairCount = row == null ? 0 : row.size();
            int rowSize = -1;
            for (int rowItemPairIndex = 0; rowItemPairIndex < rowItemsPairCount; rowItemPairIndex += 2) {
                int rowIndexStart = row.get(rowItemPairIndex);
                int rowIndexEnd = row.get(rowItemPairIndex + 1);
                for (int i = rowIndexStart; i <= rowIndexEnd; ++i) {
                    int secondarySize;
                    View view = this.findViewByPosition(i);
                    if (view == null) continue;
                    if (measure && view.isLayoutRequested()) {
                        this.measureChild(view);
                    }
                    int n = secondarySize = this.mOrientation == 0 ? view.getMeasuredHeight() : view.getMeasuredWidth();
                    if (secondarySize <= rowSize) continue;
                    rowSize = secondarySize;
                }
            }
            int itemCount = this.mState.getItemCount();
            if (measure && rowSize < 0 && itemCount > 0) {
                if (scrapChildWidth < 0 && scrapChildHeight < 0) {
                    int position = this.mFocusPosition == -1 ? 0 : (this.mFocusPosition >= itemCount ? itemCount - 1 : this.mFocusPosition);
                    this.measureScrapChild(position, View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0), this.mMeasuredDimension);
                    scrapChildWidth = this.mMeasuredDimension[0];
                    scrapChildHeight = this.mMeasuredDimension[1];
                }
                int n = rowSize = this.mOrientation == 0 ? scrapChildHeight : scrapChildWidth;
            }
            if (rowSize < 0) {
                rowSize = 0;
            }
            if (this.mRowSizeSecondary[rowIndex] == rowSize) continue;
            this.mRowSizeSecondary[rowIndex] = rowSize;
            changed = true;
        }
        return changed;
    }

    private void updateRowSecondarySizeRefresh() {
        this.mRowSecondarySizeRefresh = this.processRowSizeSecondary(false);
        if (this.mRowSecondarySizeRefresh) {
            this.forceRequestLayout();
        }
    }

    private void forceRequestLayout() {
        ViewCompat.postOnAnimation((View)this.mBaseGridView, (Runnable)this.mRequestLayoutRunnable);
    }

    public void onMeasure(RecyclerView.Recycler recycler, RecyclerView.State state, int widthSpec, int heightSpec) {
        int measuredSizeSecondary;
        int sizePrimary;
        block23: {
            int paddingSecondary;
            int modeSecondary;
            int sizeSecondary;
            block22: {
                this.saveContext(recycler, state);
                if (this.mOrientation == 0) {
                    sizePrimary = View.MeasureSpec.getSize((int)widthSpec);
                    sizeSecondary = View.MeasureSpec.getSize((int)heightSpec);
                    modeSecondary = View.MeasureSpec.getMode((int)heightSpec);
                    paddingSecondary = this.getPaddingTop() + this.getPaddingBottom();
                } else {
                    sizeSecondary = View.MeasureSpec.getSize((int)widthSpec);
                    sizePrimary = View.MeasureSpec.getSize((int)heightSpec);
                    modeSecondary = View.MeasureSpec.getMode((int)widthSpec);
                    paddingSecondary = this.getPaddingLeft() + this.getPaddingRight();
                }
                this.mMaxSizeSecondary = sizeSecondary;
                if (this.mRowSizeSecondaryRequested != -2) break block22;
                this.mNumRows = this.mNumRowsRequested == 0 ? 1 : this.mNumRowsRequested;
                this.mFixedRowSizeSecondary = 0;
                if (this.mRowSizeSecondary == null || this.mRowSizeSecondary.length != this.mNumRows) {
                    this.mRowSizeSecondary = new int[this.mNumRows];
                }
                this.processRowSizeSecondary(true);
                switch (modeSecondary) {
                    case 0: {
                        measuredSizeSecondary = this.getSizeSecondary() + paddingSecondary;
                        break block23;
                    }
                    case -2147483648: {
                        measuredSizeSecondary = Math.min(this.getSizeSecondary() + paddingSecondary, this.mMaxSizeSecondary);
                        break block23;
                    }
                    case 0x40000000: {
                        measuredSizeSecondary = this.mMaxSizeSecondary;
                        break block23;
                    }
                    default: {
                        throw new IllegalStateException("wrong spec");
                    }
                }
            }
            switch (modeSecondary) {
                case 0: {
                    if (this.mRowSizeSecondaryRequested == 0) {
                        if (this.mOrientation == 0) {
                            throw new IllegalStateException("Must specify rowHeight or view height");
                        }
                        throw new IllegalStateException("Must specify columnWidth or view width");
                    }
                    this.mFixedRowSizeSecondary = this.mRowSizeSecondaryRequested;
                    this.mNumRows = this.mNumRowsRequested == 0 ? 1 : this.mNumRowsRequested;
                    measuredSizeSecondary = this.mFixedRowSizeSecondary * this.mNumRows + this.mMarginSecondary * (this.mNumRows - 1) + paddingSecondary;
                    break;
                }
                case -2147483648: 
                case 0x40000000: {
                    int childrenSize;
                    if (this.mNumRowsRequested == 0 && this.mRowSizeSecondaryRequested == 0) {
                        this.mNumRows = 1;
                        this.mFixedRowSizeSecondary = sizeSecondary - paddingSecondary;
                    } else if (this.mNumRowsRequested == 0) {
                        this.mFixedRowSizeSecondary = this.mRowSizeSecondaryRequested;
                        this.mNumRows = (sizeSecondary + this.mMarginSecondary) / (this.mRowSizeSecondaryRequested + this.mMarginSecondary);
                    } else if (this.mRowSizeSecondaryRequested == 0) {
                        this.mNumRows = this.mNumRowsRequested;
                        this.mFixedRowSizeSecondary = (sizeSecondary - paddingSecondary - this.mMarginSecondary * (this.mNumRows - 1)) / this.mNumRows;
                    } else {
                        this.mNumRows = this.mNumRowsRequested;
                        this.mFixedRowSizeSecondary = this.mRowSizeSecondaryRequested;
                    }
                    measuredSizeSecondary = sizeSecondary;
                    if (modeSecondary != Integer.MIN_VALUE || (childrenSize = this.mFixedRowSizeSecondary * this.mNumRows + this.mMarginSecondary * (this.mNumRows - 1) + paddingSecondary) >= measuredSizeSecondary) break;
                    measuredSizeSecondary = childrenSize;
                    break;
                }
                default: {
                    throw new IllegalStateException("wrong spec");
                }
            }
        }
        if (this.mOrientation == 0) {
            this.setMeasuredDimension(sizePrimary, measuredSizeSecondary);
        } else {
            this.setMeasuredDimension(measuredSizeSecondary, sizePrimary);
        }
        this.leaveContext();
    }

    private void measureChild(View child) {
        int heightSpec;
        int widthSpec;
        int secondarySpec;
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        int n = secondarySpec = this.mRowSizeSecondaryRequested == -2 ? View.MeasureSpec.makeMeasureSpec((int)0, (int)0) : View.MeasureSpec.makeMeasureSpec((int)this.mFixedRowSizeSecondary, (int)0x40000000);
        if (this.mOrientation == 0) {
            widthSpec = ViewGroup.getChildMeasureSpec((int)View.MeasureSpec.makeMeasureSpec((int)0, (int)0), (int)0, (int)lp.width);
            heightSpec = ViewGroup.getChildMeasureSpec((int)secondarySpec, (int)0, (int)lp.height);
        } else {
            heightSpec = ViewGroup.getChildMeasureSpec((int)View.MeasureSpec.makeMeasureSpec((int)0, (int)0), (int)0, (int)lp.height);
            widthSpec = ViewGroup.getChildMeasureSpec((int)secondarySpec, (int)0, (int)lp.width);
        }
        child.measure(widthSpec, heightSpec);
    }

    private <E> E getFacet(RecyclerView.ViewHolder vh, Class<? extends E> facetClass) {
        FacetProvider p;
        Object facet = null;
        if (vh instanceof FacetProvider) {
            facet = ((FacetProvider)vh).getFacet(facetClass);
        }
        if (facet == null && this.mFacetProviderAdapter != null && (p = this.mFacetProviderAdapter.getFacetProvider(vh.getItemViewType())) != null) {
            facet = p.getFacet(facetClass);
        }
        return (E)facet;
    }

    private void layoutChild(int rowIndex, View v, int start, int end, int startSecondary) {
        int bottom;
        int right;
        int top;
        int left;
        int horizontalGravity;
        int sizeSecondary;
        int n = sizeSecondary = this.mOrientation == 0 ? v.getMeasuredHeight() : v.getMeasuredWidth();
        if (this.mFixedRowSizeSecondary > 0) {
            sizeSecondary = Math.min(sizeSecondary, this.mFixedRowSizeSecondary);
        }
        int verticalGravity = this.mGravity & 0x70;
        int n2 = horizontalGravity = this.mReverseFlowPrimary || this.mReverseFlowSecondary ? Gravity.getAbsoluteGravity((int)(this.mGravity & 0x800007), (int)1) : this.mGravity & 7;
        if (!(this.mOrientation == 0 && verticalGravity == 48 || this.mOrientation == 1 && horizontalGravity == 3)) {
            if (this.mOrientation == 0 && verticalGravity == 80 || this.mOrientation == 1 && horizontalGravity == 5) {
                startSecondary += this.getRowSizeSecondary(rowIndex) - sizeSecondary;
            } else if (this.mOrientation == 0 && verticalGravity == 16 || this.mOrientation == 1 && horizontalGravity == 1) {
                startSecondary += (this.getRowSizeSecondary(rowIndex) - sizeSecondary) / 2;
            }
        }
        if (this.mOrientation == 0) {
            left = start;
            top = startSecondary;
            right = end;
            bottom = startSecondary + sizeSecondary;
        } else {
            top = start;
            left = startSecondary;
            bottom = end;
            right = startSecondary + sizeSecondary;
        }
        v.layout(left, top, right, bottom);
        this.updateChildOpticalInsets(v, left, top, right, bottom);
        this.updateChildAlignments(v);
    }

    private void updateChildOpticalInsets(View v, int left, int top, int right, int bottom) {
        LayoutParams p = (LayoutParams)v.getLayoutParams();
        p.setOpticalInsets(left - v.getLeft(), top - v.getTop(), v.getRight() - right, v.getBottom() - bottom);
    }

    private void updateChildAlignments(View v) {
        LayoutParams p = (LayoutParams)v.getLayoutParams();
        if (p.getItemAlignmentFacet() == null) {
            p.setAlignX(this.mItemAlignment.horizontal.getAlignmentPosition(v));
            p.setAlignY(this.mItemAlignment.vertical.getAlignmentPosition(v));
        } else {
            p.calculateItemAlignments(this.mOrientation, v);
            if (this.mOrientation == 0) {
                p.setAlignY(this.mItemAlignment.vertical.getAlignmentPosition(v));
            } else {
                p.setAlignX(this.mItemAlignment.horizontal.getAlignmentPosition(v));
            }
        }
    }

    private void updateChildAlignments() {
        int c = this.getChildCount();
        for (int i = 0; i < c; ++i) {
            this.updateChildAlignments(this.getChildAt(i));
        }
    }

    private void removeInvisibleViewsAtEnd() {
        if (this.mPruneChild) {
            this.mGrid.removeInvisibleItemsAtEnd(this.mFocusPosition, this.mReverseFlowPrimary ? 0 : this.mSizePrimary);
        }
    }

    private void removeInvisibleViewsAtFront() {
        if (this.mPruneChild) {
            this.mGrid.removeInvisibleItemsAtFront(this.mFocusPosition, this.mReverseFlowPrimary ? this.mSizePrimary : 0);
        }
    }

    private boolean appendOneColumnVisibleItems() {
        return this.mGrid.appendOneColumnVisibleItems();
    }

    private boolean prependOneColumnVisibleItems() {
        return this.mGrid.prependOneColumnVisibleItems();
    }

    private void appendVisibleItems() {
        this.mGrid.appendVisibleItems(this.mReverseFlowPrimary ? 0 : this.mSizePrimary);
    }

    private void prependVisibleItems() {
        this.mGrid.prependVisibleItems(this.mReverseFlowPrimary ? this.mSizePrimary : 0);
    }

    private void fastRelayout() {
        boolean invalidateAfter = false;
        int childCount = this.getChildCount();
        int position = -1;
        for (int index = 0; index < childCount; ++index) {
            int end;
            int primarySize;
            View view = this.getChildAt(index);
            position = this.getPositionByIndex(index);
            Grid.Location location = this.mGrid.getLocation(position);
            if (location == null) {
                invalidateAfter = true;
                break;
            }
            int startSecondary = this.getRowStartSecondary(location.row) - this.mScrollOffsetSecondary;
            int start = this.getViewMin(view);
            int oldPrimarySize = this.getViewPrimarySize(view);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (lp.viewNeedsUpdate()) {
                int viewIndex = this.mBaseGridView.indexOfChild(view);
                this.detachAndScrapView(view, this.mRecycler);
                view = this.getViewForPosition(position);
                this.addView(view, viewIndex);
            }
            if (view.isLayoutRequested()) {
                this.measureChild(view);
            }
            if (this.mOrientation == 0) {
                primarySize = view.getMeasuredWidth();
                end = start + primarySize;
            } else {
                primarySize = view.getMeasuredHeight();
                end = start + primarySize;
            }
            this.layoutChild(location.row, view, start, end, startSecondary);
            if (oldPrimarySize == primarySize) continue;
            invalidateAfter = true;
            break;
        }
        if (invalidateAfter) {
            int savedLastPos = this.mGrid.getLastVisibleIndex();
            this.mGrid.invalidateItemsAfter(position);
            if (this.mPruneChild) {
                this.appendVisibleItems();
                if (this.mFocusPosition >= 0 && this.mFocusPosition <= savedLastPos) {
                    while (this.mGrid.getLastVisibleIndex() < this.mFocusPosition) {
                        this.mGrid.appendOneColumnVisibleItems();
                    }
                }
            } else {
                while (this.mGrid.appendOneColumnVisibleItems() && this.mGrid.getLastVisibleIndex() < savedLastPos) {
                }
            }
        }
        this.updateScrollMin();
        this.updateScrollMax();
        this.updateScrollSecondAxis();
    }

    public void removeAndRecycleAllViews(RecyclerView.Recycler recycler) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.removeAndRecycleViewAt(i, recycler);
        }
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        View focusView;
        boolean scrollToFocus;
        if (this.mNumRows == 0) {
            return;
        }
        int itemCount = state.getItemCount();
        if (itemCount < 0) {
            return;
        }
        if (!this.mLayoutEnabled) {
            this.discardLayoutInfo();
            this.removeAndRecycleAllViews(recycler);
            return;
        }
        this.mInLayout = true;
        boolean bl = scrollToFocus = !this.isSmoothScrolling() && this.mFocusScrollStrategy == 0;
        if (this.mFocusPosition != -1 && this.mFocusPositionOffset != Integer.MIN_VALUE) {
            this.mFocusPosition += this.mFocusPositionOffset;
            this.mSubFocusPosition = 0;
        }
        this.mFocusPositionOffset = 0;
        this.saveContext(recycler, state);
        int delta = 0;
        int deltaSecondary = 0;
        if (this.mFocusPosition != -1 && scrollToFocus && this.mBaseGridView.getScrollState() != 0 && (focusView = this.findViewByPosition(this.mFocusPosition)) != null) {
            this.getScrollPosition(focusView, focusView.findFocus(), sTwoInts);
            delta = sTwoInts[0];
            deltaSecondary = sTwoInts[1];
        }
        boolean hadFocus = this.mBaseGridView.hasFocus();
        int savedFocusPos = this.mFocusPosition;
        this.mInFastRelayout = this.layoutInit();
        if (this.mInFastRelayout) {
            View focusView2;
            this.fastRelayout();
            if (this.mFocusPosition != -1 && (focusView2 = this.findViewByPosition(this.mFocusPosition)) != null) {
                if (scrollToFocus) {
                    this.scrollToView(focusView2, false);
                }
                if (hadFocus && !focusView2.hasFocus()) {
                    focusView2.requestFocus();
                }
            }
        } else {
            int oldLastVisible;
            int oldFirstVisible;
            this.mInLayoutSearchFocus = hadFocus;
            if (this.mFocusPosition != -1) {
                while (this.appendOneColumnVisibleItems() && this.findViewByPosition(this.mFocusPosition) == null) {
                }
            }
            do {
                this.updateScrollMin();
                this.updateScrollMax();
                oldFirstVisible = this.mGrid.getFirstVisibleIndex();
                oldLastVisible = this.mGrid.getLastVisibleIndex();
                View focusView3 = this.findViewByPosition(this.mFocusPosition);
                this.scrollToView(focusView3, false);
                if (focusView3 != null && hadFocus && !focusView3.hasFocus()) {
                    focusView3.requestFocus();
                }
                this.appendVisibleItems();
                this.prependVisibleItems();
                this.removeInvisibleViewsAtFront();
                this.removeInvisibleViewsAtEnd();
            } while (this.mGrid.getFirstVisibleIndex() != oldFirstVisible || this.mGrid.getLastVisibleIndex() != oldLastVisible);
        }
        if (scrollToFocus) {
            this.scrollDirectionPrimary(-delta);
            this.scrollDirectionSecondary(-deltaSecondary);
        }
        this.appendVisibleItems();
        this.prependVisibleItems();
        this.removeInvisibleViewsAtFront();
        this.removeInvisibleViewsAtEnd();
        if (this.mRowSecondarySizeRefresh) {
            this.mRowSecondarySizeRefresh = false;
        } else {
            this.updateRowSecondarySizeRefresh();
        }
        if (this.mInFastRelayout && this.mFocusPosition != savedFocusPos) {
            this.dispatchChildSelected();
        } else if (!this.mInFastRelayout && this.mInLayoutSearchFocus) {
            this.dispatchChildSelected();
        }
        this.mInLayout = false;
        this.leaveContext();
    }

    private void offsetChildrenSecondary(int increment) {
        int childCount = this.getChildCount();
        if (this.mOrientation == 0) {
            for (int i = 0; i < childCount; ++i) {
                this.getChildAt(i).offsetTopAndBottom(increment);
            }
        } else {
            for (int i = 0; i < childCount; ++i) {
                this.getChildAt(i).offsetLeftAndRight(increment);
            }
        }
    }

    private void offsetChildrenPrimary(int increment) {
        int childCount = this.getChildCount();
        if (this.mOrientation == 1) {
            for (int i = 0; i < childCount; ++i) {
                this.getChildAt(i).offsetTopAndBottom(increment);
            }
        } else {
            for (int i = 0; i < childCount; ++i) {
                this.getChildAt(i).offsetLeftAndRight(increment);
            }
        }
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (!this.mLayoutEnabled || !this.hasDoneFirstLayout()) {
            return 0;
        }
        this.saveContext(recycler, state);
        this.mInScroll = true;
        int result = this.mOrientation == 0 ? this.scrollDirectionPrimary(dx) : this.scrollDirectionSecondary(dx);
        this.leaveContext();
        this.mInScroll = false;
        return result;
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (!this.mLayoutEnabled || !this.hasDoneFirstLayout()) {
            return 0;
        }
        this.mInScroll = true;
        this.saveContext(recycler, state);
        int result = this.mOrientation == 1 ? this.scrollDirectionPrimary(dy) : this.scrollDirectionSecondary(dy);
        this.leaveContext();
        this.mInScroll = false;
        return result;
    }

    private int scrollDirectionPrimary(int da) {
        boolean isMaxUnknown = false;
        boolean isMinUnknown = false;
        int minScroll = 0;
        int maxScroll = 0;
        if (da > 0) {
            isMaxUnknown = this.mWindowAlignment.mainAxis().isMaxUnknown();
            if (!isMaxUnknown && this.mScrollOffsetPrimary + da > (maxScroll = this.mWindowAlignment.mainAxis().getMaxScroll())) {
                da = maxScroll - this.mScrollOffsetPrimary;
            }
        } else if (da < 0 && !(isMinUnknown = this.mWindowAlignment.mainAxis().isMinUnknown()) && this.mScrollOffsetPrimary + da < (minScroll = this.mWindowAlignment.mainAxis().getMinScroll())) {
            da = minScroll - this.mScrollOffsetPrimary;
        }
        if (da == 0) {
            return 0;
        }
        this.offsetChildrenPrimary(-da);
        this.mScrollOffsetPrimary += da;
        if (this.mInLayout) {
            return da;
        }
        int childCount = this.getChildCount();
        if (this.mReverseFlowPrimary ? da > 0 : da < 0) {
            this.prependVisibleItems();
        } else {
            this.appendVisibleItems();
        }
        boolean updated = this.getChildCount() > childCount;
        childCount = this.getChildCount();
        if (this.mReverseFlowPrimary ? da > 0 : da < 0) {
            this.removeInvisibleViewsAtEnd();
        } else {
            this.removeInvisibleViewsAtFront();
        }
        if (updated |= this.getChildCount() < childCount) {
            this.updateRowSecondarySizeRefresh();
        }
        this.mBaseGridView.invalidate();
        return da;
    }

    private int scrollDirectionSecondary(int dy) {
        if (dy == 0) {
            return 0;
        }
        this.offsetChildrenSecondary(-dy);
        this.mScrollOffsetSecondary += dy;
        this.mBaseGridView.invalidate();
        return dy;
    }

    private void updateScrollMax() {
        int highMaxPos;
        int highVisiblePos = !this.mReverseFlowPrimary ? this.mGrid.getLastVisibleIndex() : this.mGrid.getFirstVisibleIndex();
        int n = highMaxPos = !this.mReverseFlowPrimary ? this.mState.getItemCount() - 1 : 0;
        if (highVisiblePos < 0) {
            return;
        }
        boolean highAvailable = highVisiblePos == highMaxPos;
        boolean maxUnknown = this.mWindowAlignment.mainAxis().isMaxUnknown();
        if (!highAvailable && maxUnknown) {
            return;
        }
        int maxEdge = this.mGrid.findRowMax(true, sTwoInts) + this.mScrollOffsetPrimary;
        int rowIndex = sTwoInts[0];
        int pos = sTwoInts[1];
        int savedMaxEdge = this.mWindowAlignment.mainAxis().getMaxEdge();
        this.mWindowAlignment.mainAxis().setMaxEdge(maxEdge);
        int maxScroll = this.getPrimarySystemScrollPosition(this.findViewByPosition(pos));
        this.mWindowAlignment.mainAxis().setMaxEdge(savedMaxEdge);
        if (highAvailable) {
            this.mWindowAlignment.mainAxis().setMaxEdge(maxEdge);
            this.mWindowAlignment.mainAxis().setMaxScroll(maxScroll);
        } else {
            this.mWindowAlignment.mainAxis().invalidateScrollMax();
        }
    }

    private void updateScrollMin() {
        int lowMinPos;
        int lowVisiblePos = !this.mReverseFlowPrimary ? this.mGrid.getFirstVisibleIndex() : this.mGrid.getLastVisibleIndex();
        int n = lowMinPos = !this.mReverseFlowPrimary ? 0 : this.mState.getItemCount() - 1;
        if (lowVisiblePos < 0) {
            return;
        }
        boolean lowAvailable = lowVisiblePos == lowMinPos;
        boolean minUnknown = this.mWindowAlignment.mainAxis().isMinUnknown();
        if (!lowAvailable && minUnknown) {
            return;
        }
        int minEdge = this.mGrid.findRowMin(false, sTwoInts) + this.mScrollOffsetPrimary;
        int rowIndex = sTwoInts[0];
        int pos = sTwoInts[1];
        int savedMinEdge = this.mWindowAlignment.mainAxis().getMinEdge();
        this.mWindowAlignment.mainAxis().setMinEdge(minEdge);
        int minScroll = this.getPrimarySystemScrollPosition(this.findViewByPosition(pos));
        this.mWindowAlignment.mainAxis().setMinEdge(savedMinEdge);
        if (lowAvailable) {
            this.mWindowAlignment.mainAxis().setMinEdge(minEdge);
            this.mWindowAlignment.mainAxis().setMinScroll(minScroll);
        } else {
            this.mWindowAlignment.mainAxis().invalidateScrollMin();
        }
    }

    private void updateScrollSecondAxis() {
        this.mWindowAlignment.secondAxis().setMinEdge(0);
        this.mWindowAlignment.secondAxis().setMaxEdge(this.getSizeSecondary());
    }

    private void initScrollController() {
        this.mWindowAlignment.reset();
        this.mWindowAlignment.horizontal.setSize(this.getWidth());
        this.mWindowAlignment.vertical.setSize(this.getHeight());
        this.mWindowAlignment.horizontal.setPadding(this.getPaddingLeft(), this.getPaddingRight());
        this.mWindowAlignment.vertical.setPadding(this.getPaddingTop(), this.getPaddingBottom());
        this.mSizePrimary = this.mWindowAlignment.mainAxis().getSize();
        this.mScrollOffsetPrimary = -this.mWindowAlignment.mainAxis().getPaddingLow();
        this.mScrollOffsetSecondary = -this.mWindowAlignment.secondAxis().getPaddingLow();
    }

    private void updateScrollController() {
        int paddingSecondaryDiff;
        int paddingPrimaryDiff;
        if (this.mOrientation == 0) {
            paddingPrimaryDiff = this.getPaddingLeft() - this.mWindowAlignment.horizontal.getPaddingLow();
            paddingSecondaryDiff = this.getPaddingTop() - this.mWindowAlignment.vertical.getPaddingLow();
        } else {
            paddingPrimaryDiff = this.getPaddingTop() - this.mWindowAlignment.vertical.getPaddingLow();
            paddingSecondaryDiff = this.getPaddingLeft() - this.mWindowAlignment.horizontal.getPaddingLow();
        }
        this.mScrollOffsetPrimary -= paddingPrimaryDiff;
        this.mScrollOffsetSecondary -= paddingSecondaryDiff;
        this.mWindowAlignment.horizontal.setSize(this.getWidth());
        this.mWindowAlignment.vertical.setSize(this.getHeight());
        this.mWindowAlignment.horizontal.setPadding(this.getPaddingLeft(), this.getPaddingRight());
        this.mWindowAlignment.vertical.setPadding(this.getPaddingTop(), this.getPaddingBottom());
        this.mSizePrimary = this.mWindowAlignment.mainAxis().getSize();
    }

    public void setSelection(RecyclerView parent, int position, int primaryScrollExtra) {
        this.setSelection(parent, position, 0, false, primaryScrollExtra);
    }

    public void setSelectionSmooth(RecyclerView parent, int position) {
        this.setSelection(parent, position, 0, true, 0);
    }

    public void setSelectionWithSub(RecyclerView parent, int position, int subposition, int primaryScrollExtra) {
        this.setSelection(parent, position, subposition, false, primaryScrollExtra);
    }

    public void setSelectionSmoothWithSub(RecyclerView parent, int position, int subposition) {
        this.setSelection(parent, position, subposition, true, 0);
    }

    public int getSelection() {
        return this.mFocusPosition;
    }

    public int getSubSelection() {
        return this.mSubFocusPosition;
    }

    public void setSelection(RecyclerView parent, int position, int subposition, boolean smooth, int primaryScrollExtra) {
        if (this.mFocusPosition != position && position != -1 || subposition != this.mSubFocusPosition || primaryScrollExtra != this.mPrimaryScrollExtra) {
            this.scrollToSelection(parent, position, subposition, smooth, primaryScrollExtra);
        }
    }

    private void scrollToSelection(RecyclerView parent, int position, int subposition, boolean smooth, int primaryScrollExtra) {
        this.mPrimaryScrollExtra = primaryScrollExtra;
        View view = this.findViewByPosition(position);
        if (view != null) {
            this.mInSelection = true;
            this.scrollToView(view, smooth);
            this.mInSelection = false;
        } else {
            this.mFocusPosition = position;
            this.mSubFocusPosition = subposition;
            this.mFocusPositionOffset = Integer.MIN_VALUE;
            if (!this.mLayoutEnabled) {
                return;
            }
            if (smooth) {
                if (!this.hasDoneFirstLayout()) {
                    Log.w((String)this.getTag(), (String)"setSelectionSmooth should not be called before first layout pass");
                    return;
                }
                this.startPositionSmoothScroller(position);
            } else {
                this.mForceFullLayout = true;
                parent.requestLayout();
            }
        }
    }

    void startPositionSmoothScroller(int position) {
        GridLinearSmoothScroller linearSmoothScroller = new GridLinearSmoothScroller(){

            public PointF computeScrollVectorForPosition(int targetPosition) {
                int direction;
                if (this.getChildCount() == 0) {
                    return null;
                }
                int firstChildPos = GridLayoutManager.this.getPosition(GridLayoutManager.this.getChildAt(0));
                boolean isStart = GridLayoutManager.this.mReverseFlowPrimary ? targetPosition > firstChildPos : targetPosition < firstChildPos;
                int n = direction = isStart ? -1 : 1;
                if (GridLayoutManager.this.mOrientation == 0) {
                    return new PointF((float)direction, 0.0f);
                }
                return new PointF(0.0f, (float)direction);
            }
        };
        linearSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
    }

    private void processPendingMovement(boolean forward) {
        if (forward ? this.hasCreatedLastItem() : this.hasCreatedFirstItem()) {
            return;
        }
        if (this.mPendingMoveSmoothScroller == null) {
            this.mBaseGridView.stopScroll();
            PendingMoveSmoothScroller linearSmoothScroller = new PendingMoveSmoothScroller(forward ? 1 : -1, this.mNumRows > 1);
            this.mFocusPositionOffset = 0;
            this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
            if (linearSmoothScroller.isRunning()) {
                this.mPendingMoveSmoothScroller = linearSmoothScroller;
            }
        } else if (forward) {
            this.mPendingMoveSmoothScroller.increasePendingMoves();
        } else {
            this.mPendingMoveSmoothScroller.decreasePendingMoves();
        }
    }

    public void onItemsAdded(RecyclerView recyclerView, int positionStart, int itemCount) {
        int pos;
        if (this.mFocusPosition != -1 && this.mFocusPositionOffset != Integer.MIN_VALUE && positionStart <= (pos = this.mFocusPosition + this.mFocusPositionOffset)) {
            this.mFocusPositionOffset += itemCount;
        }
        this.mChildrenStates.clear();
    }

    public void onItemsChanged(RecyclerView recyclerView) {
        this.mFocusPositionOffset = 0;
        this.mChildrenStates.clear();
    }

    public void onItemsRemoved(RecyclerView recyclerView, int positionStart, int itemCount) {
        int pos;
        if (this.mFocusPosition != -1 && this.mFocusPositionOffset != Integer.MIN_VALUE && positionStart <= (pos = this.mFocusPosition + this.mFocusPositionOffset)) {
            this.mFocusPositionOffset = positionStart + itemCount > pos ? Integer.MIN_VALUE : (this.mFocusPositionOffset -= itemCount);
        }
        this.mChildrenStates.clear();
    }

    public void onItemsMoved(RecyclerView recyclerView, int fromPosition, int toPosition, int itemCount) {
        if (this.mFocusPosition != -1 && this.mFocusPositionOffset != Integer.MIN_VALUE) {
            int pos = this.mFocusPosition + this.mFocusPositionOffset;
            if (fromPosition <= pos && pos < fromPosition + itemCount) {
                this.mFocusPositionOffset += toPosition - fromPosition;
            } else if (fromPosition < pos && toPosition > pos - itemCount) {
                this.mFocusPositionOffset -= itemCount;
            } else if (fromPosition > pos && toPosition < pos) {
                this.mFocusPositionOffset += itemCount;
            }
        }
        this.mChildrenStates.clear();
    }

    public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount) {
        int end = positionStart + itemCount;
        for (int i = positionStart; i < end; ++i) {
            this.mChildrenStates.remove(i);
        }
    }

    public boolean onRequestChildFocus(RecyclerView parent, View child, View focused) {
        if (this.mFocusSearchDisabled) {
            return true;
        }
        if (this.getPositionByView(child) == -1) {
            return true;
        }
        if (!(this.mInLayout || this.mInSelection || this.mInScroll)) {
            this.scrollToView(child, focused, true);
        }
        return true;
    }

    public boolean requestChildRectangleOnScreen(RecyclerView parent, View view, Rect rect, boolean immediate) {
        return false;
    }

    int getScrollOffsetX() {
        return this.mOrientation == 0 ? this.mScrollOffsetPrimary : this.mScrollOffsetSecondary;
    }

    int getScrollOffsetY() {
        return this.mOrientation == 0 ? this.mScrollOffsetSecondary : this.mScrollOffsetPrimary;
    }

    public void getViewSelectedOffsets(View view, int[] offsets) {
        if (this.mOrientation == 0) {
            offsets[0] = this.getPrimarySystemScrollPosition(view) - this.mScrollOffsetPrimary;
            offsets[1] = this.getSecondarySystemScrollPosition(view) - this.mScrollOffsetSecondary;
        } else {
            offsets[1] = this.getPrimarySystemScrollPosition(view) - this.mScrollOffsetPrimary;
            offsets[0] = this.getSecondarySystemScrollPosition(view) - this.mScrollOffsetSecondary;
        }
    }

    private int getPrimarySystemScrollPosition(View view) {
        boolean isMax;
        boolean isMin;
        int viewCenterPrimary = this.mScrollOffsetPrimary + this.getViewCenter(view);
        int viewMin = this.getViewMin(view);
        int viewMax = this.getViewMax(view);
        if (!this.mReverseFlowPrimary) {
            isMin = this.mGrid.getFirstVisibleIndex() == 0;
            isMax = this.mGrid.getLastVisibleIndex() == (this.mState == null ? this.getItemCount() : this.mState.getItemCount()) - 1;
        } else {
            isMax = this.mGrid.getFirstVisibleIndex() == 0;
            isMin = this.mGrid.getLastVisibleIndex() == (this.mState == null ? this.getItemCount() : this.mState.getItemCount()) - 1;
        }
        for (int i = this.getChildCount() - 1; (isMin || isMax) && i >= 0; --i) {
            View v = this.getChildAt(i);
            if (v == view || v == null) continue;
            if (isMin && this.getViewMin(v) < viewMin) {
                isMin = false;
            }
            if (!isMax || this.getViewMax(v) <= viewMax) continue;
            isMax = false;
        }
        return this.mWindowAlignment.mainAxis().getSystemScrollPos(viewCenterPrimary, isMin, isMax);
    }

    private int getAdjustedPrimaryScrollPosition(int scrollPrimary, View view, View childView) {
        int subindex = this.getSubPositionByView(view, childView);
        if (subindex != 0) {
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            scrollPrimary += lp.getAlignMultiple()[subindex] - lp.getAlignMultiple()[0];
        }
        return scrollPrimary;
    }

    private int getSecondarySystemScrollPosition(View view) {
        boolean isMax;
        boolean isMin;
        int viewCenterSecondary = this.mScrollOffsetSecondary + this.getViewCenterSecondary(view);
        int pos = this.getPositionByView(view);
        Grid.Location location = this.mGrid.getLocation(pos);
        int row = location.row;
        if (!this.mReverseFlowSecondary) {
            isMin = row == 0;
            isMax = row == this.mGrid.getNumRows() - 1;
        } else {
            isMax = row == 0;
            isMin = row == this.mGrid.getNumRows() - 1;
        }
        return this.mWindowAlignment.secondAxis().getSystemScrollPos(viewCenterSecondary, isMin, isMax);
    }

    private void scrollToView(View view, boolean smooth) {
        this.scrollToView(view, view == null ? null : view.findFocus(), smooth);
    }

    private void scrollToView(View view, View childView, boolean smooth) {
        int newFocusPosition = this.getPositionByView(view);
        int newSubFocusPosition = this.getSubPositionByView(view, childView);
        if (newFocusPosition != this.mFocusPosition || newSubFocusPosition != this.mSubFocusPosition) {
            this.mFocusPosition = newFocusPosition;
            this.mSubFocusPosition = newSubFocusPosition;
            this.mFocusPositionOffset = 0;
            if (!this.mInLayout) {
                this.dispatchChildSelected();
            }
            if (this.mBaseGridView.isChildrenDrawingOrderEnabledInternal()) {
                this.mBaseGridView.invalidate();
            }
        }
        if (view == null) {
            return;
        }
        if (!view.hasFocus() && this.mBaseGridView.hasFocus()) {
            view.requestFocus();
        }
        if (!this.mScrollEnabled && smooth) {
            return;
        }
        if (this.getScrollPosition(view, childView, sTwoInts)) {
            this.scrollGrid(sTwoInts[0], sTwoInts[1], smooth);
        }
    }

    private boolean getScrollPosition(View view, View childView, int[] deltas) {
        switch (this.mFocusScrollStrategy) {
            default: {
                return this.getAlignedPosition(view, childView, deltas);
            }
            case 1: 
            case 2: 
        }
        return this.getNoneAlignedPosition(view, deltas);
    }

    private boolean getNoneAlignedPosition(View view, int[] deltas) {
        CircularIntArray positions;
        int pos = this.getPositionByView(view);
        int viewMin = this.getViewMin(view);
        int viewMax = this.getViewMax(view);
        View firstView = null;
        View lastView = null;
        int paddingLow = this.mWindowAlignment.mainAxis().getPaddingLow();
        int clientSize = this.mWindowAlignment.mainAxis().getClientSize();
        int row = this.mGrid.getRowIndex(pos);
        if (viewMin < paddingLow) {
            firstView = view;
            if (this.mFocusScrollStrategy == 2) {
                while (this.prependOneColumnVisibleItems()) {
                    positions = this.mGrid.getItemPositionsInRows(this.mGrid.getFirstVisibleIndex(), pos)[row];
                    firstView = this.findViewByPosition(positions.get(0));
                    if (viewMax - this.getViewMin(firstView) <= clientSize) continue;
                    if (positions.size() > 2) {
                        firstView = this.findViewByPosition(positions.get(2));
                    }
                    break;
                }
            }
        } else if (viewMax > clientSize + paddingLow) {
            if (this.mFocusScrollStrategy == 2) {
                firstView = view;
                do {
                    if (this.getViewMax(lastView = this.findViewByPosition((positions = this.mGrid.getItemPositionsInRows(pos, this.mGrid.getLastVisibleIndex())[row]).get(positions.size() - 1))) - viewMin <= clientSize) continue;
                    lastView = null;
                    break;
                } while (this.appendOneColumnVisibleItems());
                if (lastView != null) {
                    firstView = null;
                }
            } else {
                lastView = view;
            }
        }
        int scrollPrimary = 0;
        int scrollSecondary = 0;
        if (firstView != null) {
            scrollPrimary = this.getViewMin(firstView) - paddingLow;
        } else if (lastView != null) {
            scrollPrimary = this.getViewMax(lastView) - (paddingLow + clientSize);
        }
        View secondaryAlignedView = firstView != null ? firstView : (lastView != null ? lastView : view);
        scrollSecondary = this.getSecondarySystemScrollPosition(secondaryAlignedView);
        if (scrollPrimary != 0 || (scrollSecondary -= this.mScrollOffsetSecondary) != 0) {
            deltas[0] = scrollPrimary;
            deltas[1] = scrollSecondary;
            return true;
        }
        return false;
    }

    private boolean getAlignedPosition(View view, View childView, int[] deltas) {
        int scrollPrimary = this.getPrimarySystemScrollPosition(view);
        if (childView != null) {
            scrollPrimary = this.getAdjustedPrimaryScrollPosition(scrollPrimary, view, childView);
        }
        int scrollSecondary = this.getSecondarySystemScrollPosition(view);
        scrollPrimary -= this.mScrollOffsetPrimary;
        if ((scrollPrimary += this.mPrimaryScrollExtra) != 0 || (scrollSecondary -= this.mScrollOffsetSecondary) != 0) {
            deltas[0] = scrollPrimary;
            deltas[1] = scrollSecondary;
            return true;
        }
        return false;
    }

    private void scrollGrid(int scrollPrimary, int scrollSecondary, boolean smooth) {
        if (this.mInLayout) {
            this.scrollDirectionPrimary(scrollPrimary);
            this.scrollDirectionSecondary(scrollSecondary);
        } else {
            int scrollY;
            int scrollX;
            if (this.mOrientation == 0) {
                scrollX = scrollPrimary;
                scrollY = scrollSecondary;
            } else {
                scrollX = scrollSecondary;
                scrollY = scrollPrimary;
            }
            if (smooth) {
                this.mBaseGridView.smoothScrollBy(scrollX, scrollY);
            } else {
                this.mBaseGridView.scrollBy(scrollX, scrollY);
            }
        }
    }

    public void setPruneChild(boolean pruneChild) {
        if (this.mPruneChild != pruneChild) {
            this.mPruneChild = pruneChild;
            if (this.mPruneChild) {
                this.requestLayout();
            }
        }
    }

    public boolean getPruneChild() {
        return this.mPruneChild;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        if (this.mScrollEnabled != scrollEnabled) {
            this.mScrollEnabled = scrollEnabled;
            if (this.mScrollEnabled && this.mFocusScrollStrategy == 0 && this.mFocusPosition != -1) {
                this.scrollToSelection(this.mBaseGridView, this.mFocusPosition, this.mSubFocusPosition, true, this.mPrimaryScrollExtra);
            }
        }
    }

    public boolean isScrollEnabled() {
        return this.mScrollEnabled;
    }

    private int findImmediateChildIndex(View view) {
        while (view != null && view != this.mBaseGridView) {
            int index = this.mBaseGridView.indexOfChild(view);
            if (index >= 0) {
                return index;
            }
            view = (View)view.getParent();
        }
        return -1;
    }

    void setFocusSearchDisabled(boolean disabled) {
        this.mFocusSearchDisabled = disabled;
    }

    boolean isFocusSearchDisabled() {
        return this.mFocusSearchDisabled;
    }

    public View onInterceptFocusSearch(View focused, int direction) {
        if (this.mFocusSearchDisabled) {
            return focused;
        }
        return null;
    }

    boolean hasPreviousViewInSameRow(int pos) {
        if (this.mGrid == null || pos == -1 || this.mGrid.getFirstVisibleIndex() < 0) {
            return false;
        }
        if (this.mGrid.getFirstVisibleIndex() > 0) {
            return true;
        }
        int focusedRow = this.mGrid.getLocation((int)pos).row;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            int position = this.getPositionByIndex(i);
            Grid.Location loc = this.mGrid.getLocation(position);
            if (loc == null || loc.row != focusedRow || position >= pos) continue;
            return true;
        }
        return false;
    }

    public boolean onAddFocusables(RecyclerView recyclerView, ArrayList<View> views, int direction, int focusableMode) {
        if (this.mFocusSearchDisabled) {
            return true;
        }
        if (recyclerView.hasFocus()) {
            int focusedRow;
            int movement = this.getMovement(direction);
            if (movement != 0 && movement != 1) {
                return false;
            }
            if (this.mPendingMoveSmoothScroller != null) {
                return true;
            }
            View focused = recyclerView.findFocus();
            int focusedPos = this.getPositionByIndex(this.findImmediateChildIndex(focused));
            if (focusedPos != -1) {
                this.findViewByPosition(focusedPos).addFocusables(views, direction, focusableMode);
            }
            int n = focusedRow = this.mGrid != null && focusedPos != -1 ? this.mGrid.getLocation((int)focusedPos).row : -1;
            if (this.mGrid != null) {
                int focusableCount = views.size();
                int count = this.getChildCount();
                for (int i = 0; i < count; ++i) {
                    int index = movement == 1 ? i : count - 1 - i;
                    View child = this.getChildAt(index);
                    if (child.getVisibility() != 0 || !child.hasFocusable()) continue;
                    int position = this.getPositionByIndex(index);
                    Grid.Location loc = this.mGrid.getLocation(position);
                    if (focusedRow != -1 && (loc == null || loc.row != focusedRow) || focusedPos != -1 && (movement != 1 || position <= focusedPos) && (movement != 0 || position >= focusedPos)) continue;
                    child.addFocusables(views, direction, focusableMode);
                    if (views.size() <= focusableCount) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            if (this.mFocusScrollStrategy != 0) {
                View child;
                int i;
                int left = this.mWindowAlignment.mainAxis().getPaddingLow();
                int right = this.mWindowAlignment.mainAxis().getClientSize() + left;
                int focusableCount = views.size();
                int count = this.getChildCount();
                for (i = 0; i < count; ++i) {
                    child = this.getChildAt(i);
                    if (child.getVisibility() != 0 || this.getViewMin(child) < left || this.getViewMax(child) > right) continue;
                    child.addFocusables(views, direction, focusableMode);
                }
                if (views.size() == focusableCount) {
                    count = this.getChildCount();
                    for (i = 0; i < count; ++i) {
                        child = this.getChildAt(i);
                        if (child.getVisibility() != 0) continue;
                        child.addFocusables(views, direction, focusableMode);
                    }
                    if (views.size() != focusableCount) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            if (recyclerView.isFocusable()) {
                views.add((View)recyclerView);
            }
        }
        return true;
    }

    private boolean hasCreatedLastItem() {
        int count = this.mState.getItemCount();
        return count == 0 || this.findViewByPosition(count - 1) != null;
    }

    private boolean hasCreatedFirstItem() {
        int count = this.mState.getItemCount();
        return count == 0 || this.findViewByPosition(0) != null;
    }

    boolean canScrollTo(View view) {
        return view.getVisibility() == 0 && (!this.hasFocus() || view.hasFocusable());
    }

    public View onFocusSearchFailed(View focused, int direction, RecyclerView.Recycler recycler, RecyclerView.State state) {
        View view = null;
        int movement = this.getMovement(direction);
        boolean isScroll = this.mBaseGridView.getScrollState() != 0;
        this.saveContext(recycler, state);
        if (movement == 1) {
            if (isScroll || !this.mFocusOutEnd) {
                view = focused;
            }
            if (this.mScrollEnabled && !this.hasCreatedLastItem()) {
                this.processPendingMovement(true);
                view = focused;
            }
        } else if (movement == 0) {
            if (isScroll || !this.mFocusOutFront) {
                view = focused;
            }
            if (this.mScrollEnabled && !this.hasCreatedFirstItem()) {
                this.processPendingMovement(false);
                view = focused;
            }
        }
        this.leaveContext();
        return view;
    }

    boolean gridOnRequestFocusInDescendants(RecyclerView recyclerView, int direction, Rect previouslyFocusedRect) {
        switch (this.mFocusScrollStrategy) {
            default: {
                return this.gridOnRequestFocusInDescendantsAligned(recyclerView, direction, previouslyFocusedRect);
            }
            case 1: 
            case 2: 
        }
        return this.gridOnRequestFocusInDescendantsUnaligned(recyclerView, direction, previouslyFocusedRect);
    }

    private boolean gridOnRequestFocusInDescendantsAligned(RecyclerView recyclerView, int direction, Rect previouslyFocusedRect) {
        View view = this.findViewByPosition(this.mFocusPosition);
        if (view != null) {
            boolean result = view.requestFocus(direction, previouslyFocusedRect);
            if (!result) {
                // empty if block
            }
            return result;
        }
        return false;
    }

    private boolean gridOnRequestFocusInDescendantsUnaligned(RecyclerView recyclerView, int direction, Rect previouslyFocusedRect) {
        int end;
        int increment;
        int index;
        int count = this.getChildCount();
        if ((direction & 2) != 0) {
            index = 0;
            increment = 1;
            end = count;
        } else {
            index = count - 1;
            increment = -1;
            end = -1;
        }
        int left = this.mWindowAlignment.mainAxis().getPaddingLow();
        int right = this.mWindowAlignment.mainAxis().getClientSize() + left;
        for (int i = index; i != end; i += increment) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || this.getViewMin(child) < left || this.getViewMax(child) > right || !child.requestFocus(direction, previouslyFocusedRect)) continue;
            return true;
        }
        return false;
    }

    private int getMovement(int direction) {
        int movement = 17;
        if (this.mOrientation == 0) {
            switch (direction) {
                case 17: {
                    movement = !this.mReverseFlowPrimary ? 0 : 1;
                    break;
                }
                case 66: {
                    movement = !this.mReverseFlowPrimary ? 1 : 0;
                    break;
                }
                case 33: {
                    movement = 2;
                    break;
                }
                case 130: {
                    movement = 3;
                }
            }
        } else if (this.mOrientation == 1) {
            switch (direction) {
                case 17: {
                    movement = !this.mReverseFlowPrimary ? 2 : 3;
                    break;
                }
                case 66: {
                    movement = !this.mReverseFlowPrimary ? 3 : 2;
                    break;
                }
                case 33: {
                    movement = 0;
                    break;
                }
                case 130: {
                    movement = 1;
                }
            }
        }
        return movement;
    }

    int getChildDrawingOrder(RecyclerView recyclerView, int childCount, int i) {
        View view = this.findViewByPosition(this.mFocusPosition);
        if (view == null) {
            return i;
        }
        int focusIndex = recyclerView.indexOfChild(view);
        if (i < focusIndex) {
            return i;
        }
        if (i < childCount - 1) {
            return focusIndex + childCount - 1 - i;
        }
        return focusIndex;
    }

    public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
        if (oldAdapter != null) {
            this.discardLayoutInfo();
            this.mFocusPosition = -1;
            this.mFocusPositionOffset = 0;
            this.mChildrenStates.clear();
        }
        this.mFacetProviderAdapter = newAdapter instanceof FacetProviderAdapter ? (FacetProviderAdapter)newAdapter : null;
        super.onAdapterChanged(oldAdapter, newAdapter);
    }

    private void discardLayoutInfo() {
        this.mGrid = null;
        this.mRowSizeSecondary = null;
        this.mRowSecondarySizeRefresh = false;
    }

    public void setLayoutEnabled(boolean layoutEnabled) {
        if (this.mLayoutEnabled != layoutEnabled) {
            this.mLayoutEnabled = layoutEnabled;
            this.requestLayout();
        }
    }

    void setChildrenVisibility(int visiblity) {
        this.mChildVisibility = visiblity;
        if (this.mChildVisibility != -1) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setVisibility(this.mChildVisibility);
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        SavedState ss = new SavedState();
        ss.index = this.getSelection();
        Bundle bundle = this.mChildrenStates.saveAsBundle();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            int position = this.getPositionByView(view);
            if (position == -1) continue;
            bundle = this.mChildrenStates.saveOnScreenView(bundle, view, position);
        }
        ss.childStates = bundle;
        return ss;
    }

    void onChildRecycled(RecyclerView.ViewHolder holder) {
        int position = holder.getAdapterPosition();
        if (position != -1) {
            this.mChildrenStates.saveOffscreenView(holder.itemView, position);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            return;
        }
        SavedState loadingState = (SavedState)state;
        this.mFocusPosition = loadingState.index;
        this.mFocusPositionOffset = 0;
        this.mChildrenStates.loadFromBundle(loadingState.childStates);
        this.mForceFullLayout = true;
        this.requestLayout();
    }

    static final class SavedState
    implements Parcelable {
        int index;
        Bundle childStates = Bundle.EMPTY;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.index);
            out.writeBundle(this.childStates);
        }

        public int describeContents() {
            return 0;
        }

        SavedState(Parcel in) {
            this.index = in.readInt();
            this.childStates = in.readBundle(GridLayoutManager.class.getClassLoader());
        }

        SavedState() {
        }
    }

    final class PendingMoveSmoothScroller
    extends GridLinearSmoothScroller {
        static final int TARGET_UNDEFINED = -2;
        private final boolean mStaggeredGrid;
        private int mPendingMoves;

        PendingMoveSmoothScroller(int initialPendingMoves, boolean staggeredGrid) {
            this.mPendingMoves = initialPendingMoves;
            this.mStaggeredGrid = staggeredGrid;
            this.setTargetPosition(-2);
        }

        void increasePendingMoves() {
            if (this.mPendingMoves < 10) {
                ++this.mPendingMoves;
                if (this.mPendingMoves == 0) {
                    GridLayoutManager.this.dispatchChildSelected();
                }
            }
        }

        void decreasePendingMoves() {
            if (this.mPendingMoves > -10) {
                --this.mPendingMoves;
                if (this.mPendingMoves == 0) {
                    GridLayoutManager.this.dispatchChildSelected();
                }
            }
        }

        void consumePendingMovesBeforeLayout() {
            View v;
            int startPos;
            if (this.mStaggeredGrid || this.mPendingMoves == 0) {
                return;
            }
            View newSelected = null;
            int pos = startPos = this.mPendingMoves > 0 ? GridLayoutManager.this.mFocusPosition + GridLayoutManager.this.mNumRows : GridLayoutManager.this.mFocusPosition - GridLayoutManager.this.mNumRows;
            while (this.mPendingMoves != 0 && (v = this.findViewByPosition(pos)) != null) {
                if (GridLayoutManager.this.canScrollTo(v)) {
                    newSelected = v;
                    GridLayoutManager.this.mFocusPosition = pos;
                    GridLayoutManager.this.mSubFocusPosition = 0;
                    this.mPendingMoves = this.mPendingMoves > 0 ? --this.mPendingMoves : ++this.mPendingMoves;
                }
                pos = this.mPendingMoves > 0 ? pos + GridLayoutManager.this.mNumRows : pos - GridLayoutManager.this.mNumRows;
            }
            if (newSelected != null && GridLayoutManager.this.hasFocus()) {
                GridLayoutManager.this.mInSelection = true;
                newSelected.requestFocus();
                GridLayoutManager.this.mInSelection = false;
            }
        }

        void consumePendingMovesAfterLayout() {
            if (this.mStaggeredGrid && this.mPendingMoves != 0) {
                int focusedRow = GridLayoutManager.this.mGrid != null && GridLayoutManager.this.mFocusPosition != -1 ? GridLayoutManager.this.mGrid.getLocation((int)((GridLayoutManager)GridLayoutManager.this).mFocusPosition).row : -1;
                View newSelected = null;
                int count = this.getChildCount();
                for (int i = 0; i < count && this.mPendingMoves != 0; ++i) {
                    int index = this.mPendingMoves > 0 ? i : count - 1 - i;
                    View child = GridLayoutManager.this.getChildAt(index);
                    if (!GridLayoutManager.this.canScrollTo(child)) continue;
                    int position = GridLayoutManager.this.getPositionByIndex(index);
                    Grid.Location loc = GridLayoutManager.this.mGrid.getLocation(position);
                    if (focusedRow != -1 && (loc == null || loc.row != focusedRow)) continue;
                    if (GridLayoutManager.this.mFocusPosition == -1) {
                        GridLayoutManager.this.mFocusPosition = position;
                        GridLayoutManager.this.mSubFocusPosition = 0;
                        newSelected = child;
                        continue;
                    }
                    if ((this.mPendingMoves <= 0 || position <= GridLayoutManager.this.mFocusPosition) && (this.mPendingMoves >= 0 || position >= GridLayoutManager.this.mFocusPosition)) continue;
                    GridLayoutManager.this.mFocusPosition = position;
                    GridLayoutManager.this.mSubFocusPosition = 0;
                    this.mPendingMoves = this.mPendingMoves > 0 ? --this.mPendingMoves : ++this.mPendingMoves;
                    newSelected = child;
                }
                if (newSelected != null && GridLayoutManager.this.hasFocus()) {
                    GridLayoutManager.this.mInSelection = true;
                    newSelected.requestFocus();
                    GridLayoutManager.this.mInSelection = false;
                }
                if (this.mPendingMoves == 0) {
                    GridLayoutManager.this.dispatchChildSelected();
                }
            }
            if (this.mPendingMoves == 0 || this.mPendingMoves > 0 && GridLayoutManager.this.hasCreatedLastItem() || this.mPendingMoves < 0 && GridLayoutManager.this.hasCreatedFirstItem()) {
                this.setTargetPosition(GridLayoutManager.this.mFocusPosition);
                this.stop();
            }
        }

        protected void updateActionForInterimTarget(RecyclerView.SmoothScroller.Action action) {
            if (this.mPendingMoves == 0) {
                return;
            }
            super.updateActionForInterimTarget(action);
        }

        public PointF computeScrollVectorForPosition(int targetPosition) {
            int direction;
            if (this.mPendingMoves == 0) {
                return null;
            }
            int n = (GridLayoutManager.this.mReverseFlowPrimary ? this.mPendingMoves > 0 : this.mPendingMoves < 0) ? -1 : (direction = 1);
            if (GridLayoutManager.this.mOrientation == 0) {
                return new PointF((float)direction, 0.0f);
            }
            return new PointF(0.0f, (float)direction);
        }

        @Override
        boolean needsDispatchChildSelectedOnStop() {
            return this.mPendingMoves != 0;
        }

        @Override
        protected void onStop() {
            super.onStop();
            this.mPendingMoves = 0;
            GridLayoutManager.this.mPendingMoveSmoothScroller = null;
            View v = this.findViewByPosition(this.getTargetPosition());
            if (v != null) {
                GridLayoutManager.this.scrollToView(v, true);
            }
        }
    }

    abstract class GridLinearSmoothScroller
    extends LinearSmoothScroller {
        GridLinearSmoothScroller() {
            super(GridLayoutManager.this.mBaseGridView.getContext());
        }

        protected void onStop() {
            View targetView = this.findViewByPosition(this.getTargetPosition());
            if (GridLayoutManager.this.hasFocus() && targetView != null) {
                GridLayoutManager.this.mInSelection = true;
                targetView.requestFocus();
                GridLayoutManager.this.mInSelection = false;
            }
            if (this.needsDispatchChildSelectedOnStop()) {
                GridLayoutManager.this.dispatchChildSelected();
            }
            super.onStop();
        }

        boolean needsDispatchChildSelectedOnStop() {
            return true;
        }

        protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
            if (GridLayoutManager.this.getScrollPosition(targetView, null, sTwoInts)) {
                int dy;
                int dx;
                if (GridLayoutManager.this.mOrientation == 0) {
                    dx = sTwoInts[0];
                    dy = sTwoInts[1];
                } else {
                    dx = sTwoInts[1];
                    dy = sTwoInts[0];
                }
                int distance = (int)Math.sqrt(dx * dx + dy * dy);
                int time = this.calculateTimeForDeceleration(distance);
                action.update(dx, dy, time, (Interpolator)this.mDecelerateInterpolator);
            }
        }
    }

    static class LayoutParams
    extends RecyclerView.LayoutParams {
        private int mLeftInset;
        private int mTopInset;
        private int mRightInset;
        private int mBottomInset;
        private int mAlignX;
        private int mAlignY;
        private int[] mAlignMultiple;
        private ItemAlignmentFacet mAlignmentFacet;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(RecyclerView.LayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((RecyclerView.LayoutParams)source);
        }

        int getAlignX() {
            return this.mAlignX;
        }

        int getAlignY() {
            return this.mAlignY;
        }

        int getOpticalLeft(View view) {
            return view.getLeft() + this.mLeftInset;
        }

        int getOpticalTop(View view) {
            return view.getTop() + this.mTopInset;
        }

        int getOpticalRight(View view) {
            return view.getRight() - this.mRightInset;
        }

        int getOpticalBottom(View view) {
            return view.getBottom() - this.mBottomInset;
        }

        int getOpticalWidth(View view) {
            return view.getWidth() - this.mLeftInset - this.mRightInset;
        }

        int getOpticalHeight(View view) {
            return view.getHeight() - this.mTopInset - this.mBottomInset;
        }

        int getOpticalLeftInset() {
            return this.mLeftInset;
        }

        int getOpticalRightInset() {
            return this.mRightInset;
        }

        int getOpticalTopInset() {
            return this.mTopInset;
        }

        int getOpticalBottomInset() {
            return this.mBottomInset;
        }

        void setAlignX(int alignX) {
            this.mAlignX = alignX;
        }

        void setAlignY(int alignY) {
            this.mAlignY = alignY;
        }

        void setItemAlignmentFacet(ItemAlignmentFacet facet) {
            this.mAlignmentFacet = facet;
        }

        ItemAlignmentFacet getItemAlignmentFacet() {
            return this.mAlignmentFacet;
        }

        void calculateItemAlignments(int orientation, View view) {
            ItemAlignmentFacet.ItemAlignmentDef[] defs = this.mAlignmentFacet.getAlignmentDefs();
            if (this.mAlignMultiple == null || this.mAlignMultiple.length != defs.length) {
                this.mAlignMultiple = new int[defs.length];
            }
            for (int i = 0; i < defs.length; ++i) {
                this.mAlignMultiple[i] = ItemAlignmentFacetHelper.getAlignmentPosition(view, defs[i], orientation);
            }
            if (orientation == 0) {
                this.mAlignX = this.mAlignMultiple[0];
            } else {
                this.mAlignY = this.mAlignMultiple[0];
            }
        }

        int[] getAlignMultiple() {
            return this.mAlignMultiple;
        }

        void setOpticalInsets(int leftInset, int topInset, int rightInset, int bottomInset) {
            this.mLeftInset = leftInset;
            this.mTopInset = topInset;
            this.mRightInset = rightInset;
            this.mBottomInset = bottomInset;
        }
    }
}

