/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.database.Observable;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.PresenterSelector;
import android.support.v17.leanback.widget.SinglePresenterSelector;

public abstract class ObjectAdapter {
    public static final int NO_ID = -1;
    private final DataObservable mObservable = new DataObservable();
    private boolean mHasStableIds;
    private PresenterSelector mPresenterSelector;

    public ObjectAdapter(PresenterSelector presenterSelector) {
        this.setPresenterSelector(presenterSelector);
    }

    public ObjectAdapter(Presenter presenter) {
        this.setPresenterSelector(new SinglePresenterSelector(presenter));
    }

    public ObjectAdapter() {
    }

    public final void setPresenterSelector(PresenterSelector presenterSelector) {
        if (presenterSelector == null) {
            throw new IllegalArgumentException("Presenter selector must not be null");
        }
        boolean update = this.mPresenterSelector != null;
        boolean selectorChanged = update && this.mPresenterSelector != presenterSelector;
        this.mPresenterSelector = presenterSelector;
        if (selectorChanged) {
            this.onPresenterSelectorChanged();
        }
        if (update) {
            this.notifyChanged();
        }
    }

    protected void onPresenterSelectorChanged() {
    }

    public final PresenterSelector getPresenterSelector() {
        return this.mPresenterSelector;
    }

    public final void registerObserver(DataObserver observer) {
        this.mObservable.registerObserver(observer);
    }

    public final void unregisterObserver(DataObserver observer) {
        this.mObservable.unregisterObserver(observer);
    }

    public final void unregisterAllObservers() {
        this.mObservable.unregisterAll();
    }

    protected final void notifyItemRangeChanged(int positionStart, int itemCount) {
        this.mObservable.notifyItemRangeChanged(positionStart, itemCount);
    }

    protected final void notifyItemRangeInserted(int positionStart, int itemCount) {
        this.mObservable.notifyItemRangeInserted(positionStart, itemCount);
    }

    protected final void notifyItemRangeRemoved(int positionStart, int itemCount) {
        this.mObservable.notifyItemRangeRemoved(positionStart, itemCount);
    }

    protected final void notifyChanged() {
        this.mObservable.notifyChanged();
    }

    public final boolean hasStableIds() {
        return this.mHasStableIds;
    }

    public final void setHasStableIds(boolean hasStableIds) {
        boolean changed = this.mHasStableIds != hasStableIds;
        this.mHasStableIds = hasStableIds;
        if (changed) {
            this.onHasStableIdsChanged();
        }
    }

    protected void onHasStableIdsChanged() {
    }

    public final Presenter getPresenter(Object item) {
        if (this.mPresenterSelector == null) {
            throw new IllegalStateException("Presenter selector must not be null");
        }
        return this.mPresenterSelector.getPresenter(item);
    }

    public abstract int size();

    public abstract Object get(int var1);

    public long getId(int position) {
        return -1L;
    }

    private static final class DataObservable
    extends Observable<DataObserver> {
        private DataObservable() {
        }

        public void notifyChanged() {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((DataObserver)this.mObservers.get(i)).onChanged();
            }
        }

        public void notifyItemRangeChanged(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((DataObserver)this.mObservers.get(i)).onItemRangeChanged(positionStart, itemCount);
            }
        }

        public void notifyItemRangeInserted(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((DataObserver)this.mObservers.get(i)).onItemRangeInserted(positionStart, itemCount);
            }
        }

        public void notifyItemRangeRemoved(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((DataObserver)this.mObservers.get(i)).onItemRangeRemoved(positionStart, itemCount);
            }
        }
    }

    public static abstract class DataObserver {
        public void onChanged() {
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            this.onChanged();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.onChanged();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.onChanged();
        }
    }
}

