/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.ControlBarPresenter;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.PlaybackControlsRow;
import android.support.v17.leanback.widget.Presenter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

class PlaybackControlsPresenter
extends ControlBarPresenter {
    private boolean mMoreActionsEnabled = true;
    private static int sChildMarginBigger;
    private static int sChildMarginBiggest;

    private static void formatTime(int seconds, StringBuilder sb) {
        int minutes = seconds / 60;
        int hours = minutes / 60;
        seconds -= minutes * 60;
        minutes -= hours * 60;
        sb.setLength(0);
        if (hours > 0) {
            sb.append(hours).append(':');
            if (minutes < 10) {
                sb.append('0');
            }
        }
        sb.append(minutes).append(':');
        if (seconds < 10) {
            sb.append('0');
        }
        sb.append(seconds);
    }

    public PlaybackControlsPresenter(int layoutResourceId) {
        super(layoutResourceId);
    }

    public void enableSecondaryActions(boolean enable) {
        this.mMoreActionsEnabled = enable;
    }

    public boolean areMoreActionsEnabled() {
        return this.mMoreActionsEnabled;
    }

    public void setProgressColor(ViewHolder vh, int color2) {
        ClipDrawable drawable2 = new ClipDrawable((Drawable)new ColorDrawable(color2), 3, 1);
        ((LayerDrawable)vh.mProgressBar.getProgressDrawable()).setDrawableByLayerId(16908301, (Drawable)drawable2);
    }

    public void setTotalTime(ViewHolder vh, int ms) {
        vh.setTotalTime(ms);
    }

    public int getTotalTime(ViewHolder vh) {
        return vh.getTotalTime();
    }

    public void setCurrentTime(ViewHolder vh, int ms) {
        vh.setCurrentTime(ms);
    }

    public int getCurrentTime(ViewHolder vh) {
        return vh.getCurrentTime();
    }

    public void setSecondaryProgress(ViewHolder vh, int progressMs) {
        vh.setSecondaryProgress(progressMs);
    }

    public int getSecondaryProgress(ViewHolder vh) {
        return vh.getSecondaryProgress();
    }

    public void showPrimaryActions(ViewHolder vh) {
        if (vh.mMoreActionsShowing) {
            vh.toggleMoreActions();
        }
    }

    public void enableTimeMargins(ViewHolder vh, boolean enable) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)vh.mCurrentTime.getLayoutParams();
        lp.setMarginStart(enable ? vh.mCurrentTimeMarginStart : 0);
        vh.mCurrentTime.setLayoutParams((ViewGroup.LayoutParams)lp);
        lp = (ViewGroup.MarginLayoutParams)vh.mTotalTime.getLayoutParams();
        lp.setMarginEnd(enable ? vh.mTotalTimeMarginEnd : 0);
        vh.mTotalTime.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    @Override
    public Presenter.ViewHolder onCreateViewHolder(ViewGroup parent) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutResourceId(), parent, false);
        return new ViewHolder(v);
    }

    @Override
    public void onBindViewHolder(Presenter.ViewHolder holder, Object item) {
        ViewHolder vh = (ViewHolder)holder;
        BoundData data = (BoundData)item;
        if (vh.mMoreActionsAdapter != data.secondaryActionsAdapter) {
            vh.mMoreActionsAdapter = data.secondaryActionsAdapter;
            vh.mMoreActionsAdapter.registerObserver(vh.mMoreActionsObserver);
            vh.mMoreActionsShowing = false;
        }
        super.onBindViewHolder(holder, item);
        vh.showMoreActions(this.mMoreActionsEnabled);
    }

    @Override
    public void onUnbindViewHolder(Presenter.ViewHolder holder) {
        super.onUnbindViewHolder(holder);
        ViewHolder vh = (ViewHolder)holder;
        if (vh.mMoreActionsAdapter != null) {
            vh.mMoreActionsAdapter.unregisterObserver(vh.mMoreActionsObserver);
            vh.mMoreActionsAdapter = null;
        }
    }

    int getChildMarginBigger(Context context) {
        if (sChildMarginBigger == 0) {
            sChildMarginBigger = context.getResources().getDimensionPixelSize(R.dimen.lb_playback_controls_child_margin_bigger);
        }
        return sChildMarginBigger;
    }

    int getChildMarginBiggest(Context context) {
        if (sChildMarginBiggest == 0) {
            sChildMarginBiggest = context.getResources().getDimensionPixelSize(R.dimen.lb_playback_controls_child_margin_biggest);
        }
        return sChildMarginBiggest;
    }

    class ViewHolder
    extends ControlBarPresenter.ViewHolder {
        ObjectAdapter mMoreActionsAdapter;
        ObjectAdapter.DataObserver mMoreActionsObserver;
        final FrameLayout mMoreActionsDock;
        Presenter.ViewHolder mMoreActionsViewHolder;
        boolean mMoreActionsShowing;
        final TextView mCurrentTime;
        final TextView mTotalTime;
        final ProgressBar mProgressBar;
        int mCurrentTimeInSeconds;
        StringBuilder mTotalTimeStringBuilder;
        StringBuilder mCurrentTimeStringBuilder;
        int mCurrentTimeMarginStart;
        int mTotalTimeMarginEnd;

        ViewHolder(View rootView) {
            super(rootView);
            this.mTotalTimeStringBuilder = new StringBuilder();
            this.mCurrentTimeStringBuilder = new StringBuilder();
            this.mMoreActionsDock = (FrameLayout)rootView.findViewById(R.id.more_actions_dock);
            this.mCurrentTime = (TextView)rootView.findViewById(R.id.current_time);
            this.mTotalTime = (TextView)rootView.findViewById(R.id.total_time);
            this.mProgressBar = (ProgressBar)rootView.findViewById(R.id.playback_progress);
            this.mMoreActionsObserver = new ObjectAdapter.DataObserver(){

                @Override
                public void onChanged() {
                    if (ViewHolder.this.mMoreActionsShowing) {
                        ViewHolder.this.showControls(ViewHolder.this.mPresenter);
                    }
                }

                @Override
                public void onItemRangeChanged(int positionStart, int itemCount) {
                    if (ViewHolder.this.mMoreActionsShowing) {
                        for (int i = 0; i < itemCount; ++i) {
                            ViewHolder.this.bindControlToAction(positionStart + i, ViewHolder.this.mPresenter);
                        }
                    }
                }
            };
            this.mCurrentTimeMarginStart = ((ViewGroup.MarginLayoutParams)this.mCurrentTime.getLayoutParams()).getMarginStart();
            this.mTotalTimeMarginEnd = ((ViewGroup.MarginLayoutParams)this.mTotalTime.getLayoutParams()).getMarginEnd();
        }

        void showMoreActions(boolean show) {
            if (show) {
                if (this.mMoreActionsViewHolder == null) {
                    PlaybackControlsRow.MoreActions action = new PlaybackControlsRow.MoreActions(this.mMoreActionsDock.getContext());
                    this.mMoreActionsViewHolder = this.mPresenter.onCreateViewHolder((ViewGroup)this.mMoreActionsDock);
                    this.mPresenter.onBindViewHolder(this.mMoreActionsViewHolder, action);
                    this.mPresenter.setOnClickListener(this.mMoreActionsViewHolder, new View.OnClickListener(){

                        public void onClick(View v) {
                            ViewHolder.this.toggleMoreActions();
                        }
                    });
                }
                if (this.mMoreActionsViewHolder.view.getParent() == null) {
                    this.mMoreActionsDock.addView(this.mMoreActionsViewHolder.view);
                }
            } else if (this.mMoreActionsViewHolder != null && this.mMoreActionsViewHolder.view.getParent() != null) {
                this.mMoreActionsDock.removeView(this.mMoreActionsViewHolder.view);
            }
        }

        void toggleMoreActions() {
            this.mMoreActionsShowing = !this.mMoreActionsShowing;
            this.showControls(this.mPresenter);
        }

        @Override
        ObjectAdapter getDisplayedAdapter() {
            return this.mMoreActionsShowing ? this.mMoreActionsAdapter : this.mAdapter;
        }

        @Override
        int getChildMarginFromCenter(Context context, int numControls) {
            int margin = PlaybackControlsPresenter.this.getControlIconWidth(context);
            margin = numControls < 4 ? (margin += PlaybackControlsPresenter.this.getChildMarginBiggest(context)) : (numControls < 6 ? (margin += PlaybackControlsPresenter.this.getChildMarginBigger(context)) : (margin += PlaybackControlsPresenter.this.getChildMarginDefault(context)));
            return margin;
        }

        void setTotalTime(int totalTimeMs) {
            if (totalTimeMs <= 0) {
                this.mTotalTime.setVisibility(8);
                this.mProgressBar.setVisibility(8);
            } else {
                this.mTotalTime.setVisibility(0);
                this.mProgressBar.setVisibility(0);
                PlaybackControlsPresenter.formatTime(totalTimeMs / 1000, this.mTotalTimeStringBuilder);
                this.mTotalTime.setText((CharSequence)this.mTotalTimeStringBuilder.toString());
                this.mProgressBar.setMax(totalTimeMs);
            }
        }

        int getTotalTime() {
            return this.mProgressBar.getMax();
        }

        void setCurrentTime(int currentTimeMs) {
            int seconds = currentTimeMs / 1000;
            if (seconds != this.mCurrentTimeInSeconds) {
                this.mCurrentTimeInSeconds = seconds;
                PlaybackControlsPresenter.formatTime(this.mCurrentTimeInSeconds, this.mCurrentTimeStringBuilder);
                this.mCurrentTime.setText((CharSequence)this.mCurrentTimeStringBuilder.toString());
            }
            this.mProgressBar.setProgress(currentTimeMs);
        }

        int getCurrentTime() {
            return this.mProgressBar.getProgress();
        }

        void setSecondaryProgress(int progressMs) {
            this.mProgressBar.setSecondaryProgress(progressMs);
        }

        int getSecondaryProgress() {
            return this.mProgressBar.getSecondaryProgress();
        }
    }

    static class BoundData
    extends ControlBarPresenter.BoundData {
        ObjectAdapter secondaryActionsAdapter;

        BoundData() {
        }
    }
}

