/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.Action;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.Row;
import android.util.TypedValue;

public class PlaybackControlsRow
extends Row {
    private Object mItem;
    private Drawable mImageDrawable;
    private ObjectAdapter mPrimaryActionsAdapter;
    private ObjectAdapter mSecondaryActionsAdapter;
    private int mTotalTimeMs;
    private int mCurrentTimeMs;
    private int mBufferedProgressMs;
    private OnPlaybackStateChangedListener mListener;

    private static Bitmap createBitmap(Bitmap bitmap, int color2) {
        Bitmap dst = bitmap.copy(bitmap.getConfig(), true);
        Canvas canvas = new Canvas(dst);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_ATOP));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return dst;
    }

    private static int getIconHighlightColor(Context context) {
        TypedValue outValue = new TypedValue();
        if (context.getTheme().resolveAttribute(R.attr.playbackControlsIconHighlightColor, outValue, true)) {
            return outValue.data;
        }
        return context.getResources().getColor(R.color.lb_playback_icon_highlight_no_theme);
    }

    private static Drawable getStyledDrawable(Context context, int index) {
        TypedValue outValue = new TypedValue();
        if (!context.getTheme().resolveAttribute(R.attr.playbackControlsActionIcons, outValue, false)) {
            return null;
        }
        TypedArray array = context.getTheme().obtainStyledAttributes(outValue.data, R.styleable.lbPlaybackControlsActionIcons);
        Drawable drawable2 = array.getDrawable(index);
        array.recycle();
        return drawable2;
    }

    public PlaybackControlsRow(Object item) {
        this.mItem = item;
    }

    public PlaybackControlsRow() {
    }

    public final Object getItem() {
        return this.mItem;
    }

    public final void setImageDrawable(Drawable drawable2) {
        this.mImageDrawable = drawable2;
    }

    public final void setImageBitmap(Context context, Bitmap bm) {
        this.mImageDrawable = new BitmapDrawable(context.getResources(), bm);
    }

    public final Drawable getImageDrawable() {
        return this.mImageDrawable;
    }

    public final void setPrimaryActionsAdapter(ObjectAdapter adapter) {
        this.mPrimaryActionsAdapter = adapter;
    }

    public final void setSecondaryActionsAdapter(ObjectAdapter adapter) {
        this.mSecondaryActionsAdapter = adapter;
    }

    public final ObjectAdapter getPrimaryActionsAdapter() {
        return this.mPrimaryActionsAdapter;
    }

    public final ObjectAdapter getSecondaryActionsAdapter() {
        return this.mSecondaryActionsAdapter;
    }

    public void setTotalTime(int ms) {
        this.mTotalTimeMs = ms;
    }

    public int getTotalTime() {
        return this.mTotalTimeMs;
    }

    public void setCurrentTime(int ms) {
        if (this.mCurrentTimeMs != ms) {
            this.mCurrentTimeMs = ms;
            this.currentTimeChanged();
        }
    }

    public int getCurrentTime() {
        return this.mCurrentTimeMs;
    }

    public void setBufferedProgress(int ms) {
        if (this.mBufferedProgressMs != ms) {
            this.mBufferedProgressMs = ms;
            this.bufferedProgressChanged();
        }
    }

    public int getBufferedProgress() {
        return this.mBufferedProgressMs;
    }

    public Action getActionForKeyCode(int keyCode) {
        Action action = this.getActionForKeyCode(this.getPrimaryActionsAdapter(), keyCode);
        if (action != null) {
            return action;
        }
        return this.getActionForKeyCode(this.getSecondaryActionsAdapter(), keyCode);
    }

    public Action getActionForKeyCode(ObjectAdapter adapter, int keyCode) {
        if (adapter != this.mPrimaryActionsAdapter && adapter != this.mSecondaryActionsAdapter) {
            throw new IllegalArgumentException("Invalid adapter");
        }
        for (int i = 0; i < adapter.size(); ++i) {
            Action action = (Action)adapter.get(i);
            if (!action.respondsToKeyCode(keyCode)) continue;
            return action;
        }
        return null;
    }

    void setOnPlaybackStateChangedListener(OnPlaybackStateChangedListener listener) {
        this.mListener = listener;
    }

    OnPlaybackStateChangedListener getOnPlaybackStateChangedListener() {
        return this.mListener;
    }

    private void currentTimeChanged() {
        if (this.mListener != null) {
            this.mListener.onCurrentTimeChanged(this.mCurrentTimeMs);
        }
    }

    private void bufferedProgressChanged() {
        if (this.mListener != null) {
            this.mListener.onBufferedProgressChanged(this.mBufferedProgressMs);
        }
    }

    static interface OnPlaybackStateChangedListener {
        public void onCurrentTimeChanged(int var1);

        public void onBufferedProgressChanged(int var1);
    }

    public static class ClosedCaptioningAction
    extends MultiAction {
        public static int OFF = 0;
        public static int ON = 1;

        public ClosedCaptioningAction(Context context) {
            this(context, PlaybackControlsRow.getIconHighlightColor(context));
        }

        public ClosedCaptioningAction(Context context, int highlightColor) {
            super(R.id.lb_control_high_quality);
            BitmapDrawable uncoloredDrawable = (BitmapDrawable)PlaybackControlsRow.getStyledDrawable(context, R.styleable.lbPlaybackControlsActionIcons_closed_captioning);
            Drawable[] drawables = new Drawable[2];
            drawables[ClosedCaptioningAction.OFF] = uncoloredDrawable;
            drawables[ClosedCaptioningAction.ON] = new BitmapDrawable(context.getResources(), PlaybackControlsRow.createBitmap(uncoloredDrawable.getBitmap(), highlightColor));
            this.setDrawables(drawables);
            String[] labels = new String[drawables.length];
            labels[ClosedCaptioningAction.OFF] = context.getString(R.string.lb_playback_controls_closed_captioning_enable);
            labels[ClosedCaptioningAction.ON] = context.getString(R.string.lb_playback_controls_closed_captioning_disable);
            this.setLabels(labels);
        }
    }

    public static class HighQualityAction
    extends MultiAction {
        public static int OFF = 0;
        public static int ON = 1;

        public HighQualityAction(Context context) {
            this(context, PlaybackControlsRow.getIconHighlightColor(context));
        }

        public HighQualityAction(Context context, int highlightColor) {
            super(R.id.lb_control_high_quality);
            BitmapDrawable uncoloredDrawable = (BitmapDrawable)PlaybackControlsRow.getStyledDrawable(context, R.styleable.lbPlaybackControlsActionIcons_high_quality);
            Drawable[] drawables = new Drawable[2];
            drawables[HighQualityAction.OFF] = uncoloredDrawable;
            drawables[HighQualityAction.ON] = new BitmapDrawable(context.getResources(), PlaybackControlsRow.createBitmap(uncoloredDrawable.getBitmap(), highlightColor));
            this.setDrawables(drawables);
            String[] labels = new String[drawables.length];
            labels[HighQualityAction.OFF] = context.getString(R.string.lb_playback_controls_high_quality_enable);
            labels[HighQualityAction.ON] = context.getString(R.string.lb_playback_controls_high_quality_disable);
            this.setLabels(labels);
        }
    }

    public static class ShuffleAction
    extends MultiAction {
        public static int OFF = 0;
        public static int ON = 1;

        public ShuffleAction(Context context) {
            this(context, PlaybackControlsRow.getIconHighlightColor(context));
        }

        public ShuffleAction(Context context, int highlightColor) {
            super(R.id.lb_control_shuffle);
            BitmapDrawable uncoloredDrawable = (BitmapDrawable)PlaybackControlsRow.getStyledDrawable(context, R.styleable.lbPlaybackControlsActionIcons_shuffle);
            Drawable[] drawables = new Drawable[2];
            drawables[ShuffleAction.OFF] = uncoloredDrawable;
            drawables[ShuffleAction.ON] = new BitmapDrawable(context.getResources(), PlaybackControlsRow.createBitmap(uncoloredDrawable.getBitmap(), highlightColor));
            this.setDrawables(drawables);
            String[] labels = new String[drawables.length];
            labels[ShuffleAction.OFF] = context.getString(R.string.lb_playback_controls_shuffle_enable);
            labels[ShuffleAction.ON] = context.getString(R.string.lb_playback_controls_shuffle_disable);
            this.setLabels(labels);
        }
    }

    public static class RepeatAction
    extends MultiAction {
        public static int NONE = 0;
        public static int ALL = 1;
        public static int ONE = 2;

        public RepeatAction(Context context) {
            this(context, PlaybackControlsRow.getIconHighlightColor(context));
        }

        public RepeatAction(Context context, int highlightColor) {
            this(context, highlightColor, highlightColor);
        }

        public RepeatAction(Context context, int repeatAllColor, int repeatOneColor) {
            super(R.id.lb_control_repeat);
            Drawable[] drawables = new Drawable[3];
            BitmapDrawable repeatDrawable = (BitmapDrawable)PlaybackControlsRow.getStyledDrawable(context, R.styleable.lbPlaybackControlsActionIcons_repeat);
            BitmapDrawable repeatOneDrawable = (BitmapDrawable)PlaybackControlsRow.getStyledDrawable(context, R.styleable.lbPlaybackControlsActionIcons_repeat_one);
            drawables[RepeatAction.NONE] = repeatDrawable;
            drawables[RepeatAction.ALL] = repeatDrawable == null ? null : new BitmapDrawable(context.getResources(), PlaybackControlsRow.createBitmap(repeatDrawable.getBitmap(), repeatAllColor));
            drawables[RepeatAction.ONE] = repeatOneDrawable == null ? null : new BitmapDrawable(context.getResources(), PlaybackControlsRow.createBitmap(repeatOneDrawable.getBitmap(), repeatOneColor));
            this.setDrawables(drawables);
            String[] labels = new String[drawables.length];
            labels[RepeatAction.NONE] = context.getString(R.string.lb_playback_controls_repeat_all);
            labels[RepeatAction.ALL] = context.getString(R.string.lb_playback_controls_repeat_one);
            labels[RepeatAction.ONE] = context.getString(R.string.lb_playback_controls_repeat_none);
            this.setLabels(labels);
        }
    }

    public static class ThumbsDownAction
    extends ThumbsAction {
        public ThumbsDownAction(Context context) {
            super(R.id.lb_control_thumbs_down, context, R.styleable.lbPlaybackControlsActionIcons_thumb_down, R.styleable.lbPlaybackControlsActionIcons_thumb_down_outline);
            String[] labels = new String[this.getActionCount()];
            labels[ThumbsDownAction.SOLID] = context.getString(R.string.lb_playback_controls_thumb_down);
            labels[ThumbsDownAction.OUTLINE] = context.getString(R.string.lb_playback_controls_thumb_down_outline);
            this.setLabels(labels);
        }
    }

    public static class ThumbsUpAction
    extends ThumbsAction {
        public ThumbsUpAction(Context context) {
            super(R.id.lb_control_thumbs_up, context, R.styleable.lbPlaybackControlsActionIcons_thumb_up, R.styleable.lbPlaybackControlsActionIcons_thumb_up_outline);
            String[] labels = new String[this.getActionCount()];
            labels[ThumbsUpAction.SOLID] = context.getString(R.string.lb_playback_controls_thumb_up);
            labels[ThumbsUpAction.OUTLINE] = context.getString(R.string.lb_playback_controls_thumb_up_outline);
            this.setLabels(labels);
        }
    }

    public static abstract class ThumbsAction
    extends MultiAction {
        public static int SOLID = 0;
        public static int OUTLINE = 1;

        public ThumbsAction(int id2, Context context, int solidIconIndex, int outlineIconIndex) {
            super(id2);
            Drawable[] drawables = new Drawable[2];
            drawables[ThumbsAction.SOLID] = PlaybackControlsRow.getStyledDrawable(context, solidIconIndex);
            drawables[ThumbsAction.OUTLINE] = PlaybackControlsRow.getStyledDrawable(context, outlineIconIndex);
            this.setDrawables(drawables);
        }
    }

    public static class MoreActions
    extends Action {
        public MoreActions(Context context) {
            super(R.id.lb_control_more_actions);
            this.setIcon(context.getResources().getDrawable(R.drawable.lb_ic_more));
            this.setLabel1(context.getString(R.string.lb_playback_controls_more_actions));
        }
    }

    public static class SkipPreviousAction
    extends Action {
        public SkipPreviousAction(Context context) {
            super(R.id.lb_control_skip_previous);
            this.setIcon(PlaybackControlsRow.getStyledDrawable(context, R.styleable.lbPlaybackControlsActionIcons_skip_previous));
            this.setLabel1(context.getString(R.string.lb_playback_controls_skip_previous));
            this.addKeyCode(88);
        }
    }

    public static class SkipNextAction
    extends Action {
        public SkipNextAction(Context context) {
            super(R.id.lb_control_skip_next);
            this.setIcon(PlaybackControlsRow.getStyledDrawable(context, R.styleable.lbPlaybackControlsActionIcons_skip_next));
            this.setLabel1(context.getString(R.string.lb_playback_controls_skip_next));
            this.addKeyCode(87);
        }
    }

    public static class RewindAction
    extends MultiAction {
        public RewindAction(Context context) {
            this(context, 1);
        }

        public RewindAction(Context context, int numSpeeds) {
            super(R.id.lb_control_fast_rewind);
            if (numSpeeds < 1) {
                throw new IllegalArgumentException("numSpeeds must be > 0");
            }
            Drawable[] drawables = new Drawable[numSpeeds];
            drawables[0] = PlaybackControlsRow.getStyledDrawable(context, R.styleable.lbPlaybackControlsActionIcons_rewind);
            this.setDrawables(drawables);
            String[] labels = new String[this.getActionCount()];
            labels[0] = context.getString(R.string.lb_playback_controls_rewind);
            String[] labels2 = new String[this.getActionCount()];
            labels2[0] = labels[0];
            for (int i = 1; i < numSpeeds; ++i) {
                int multiplier = i + 1;
                labels[i] = context.getResources().getString(R.string.lb_control_display_rewind_multiplier, new Object[]{multiplier});
                labels2[i] = context.getResources().getString(R.string.lb_playback_controls_rewind_multiplier, new Object[]{multiplier});
            }
            this.setLabels(labels);
            this.setSecondaryLabels(labels2);
            this.addKeyCode(89);
        }
    }

    public static class FastForwardAction
    extends MultiAction {
        public FastForwardAction(Context context) {
            this(context, 1);
        }

        public FastForwardAction(Context context, int numSpeeds) {
            super(R.id.lb_control_fast_forward);
            if (numSpeeds < 1) {
                throw new IllegalArgumentException("numSpeeds must be > 0");
            }
            Drawable[] drawables = new Drawable[numSpeeds];
            drawables[0] = PlaybackControlsRow.getStyledDrawable(context, R.styleable.lbPlaybackControlsActionIcons_fast_forward);
            this.setDrawables(drawables);
            String[] labels = new String[this.getActionCount()];
            labels[0] = context.getString(R.string.lb_playback_controls_fast_forward);
            String[] labels2 = new String[this.getActionCount()];
            labels2[0] = labels[0];
            for (int i = 1; i < numSpeeds; ++i) {
                int multiplier = i + 1;
                labels[i] = context.getResources().getString(R.string.lb_control_display_fast_forward_multiplier, new Object[]{multiplier});
                labels2[i] = context.getResources().getString(R.string.lb_playback_controls_fast_forward_multiplier, new Object[]{multiplier});
            }
            this.setLabels(labels);
            this.setSecondaryLabels(labels2);
            this.addKeyCode(90);
        }
    }

    public static class PlayPauseAction
    extends MultiAction {
        public static int PLAY = 0;
        public static int PAUSE = 1;

        public PlayPauseAction(Context context) {
            super(R.id.lb_control_play_pause);
            Drawable[] drawables = new Drawable[2];
            drawables[PlayPauseAction.PLAY] = PlaybackControlsRow.getStyledDrawable(context, R.styleable.lbPlaybackControlsActionIcons_play);
            drawables[PlayPauseAction.PAUSE] = PlaybackControlsRow.getStyledDrawable(context, R.styleable.lbPlaybackControlsActionIcons_pause);
            this.setDrawables(drawables);
            String[] labels = new String[drawables.length];
            labels[PlayPauseAction.PLAY] = context.getString(R.string.lb_playback_controls_play);
            labels[PlayPauseAction.PAUSE] = context.getString(R.string.lb_playback_controls_pause);
            this.setLabels(labels);
            this.addKeyCode(85);
            this.addKeyCode(126);
            this.addKeyCode(127);
        }
    }

    public static abstract class MultiAction
    extends Action {
        private int mIndex;
        private Drawable[] mDrawables;
        private String[] mLabels;
        private String[] mLabels2;

        public MultiAction(int id2) {
            super(id2);
        }

        public void setDrawables(Drawable[] drawables) {
            this.mDrawables = drawables;
            this.setIndex(0);
        }

        public void setLabels(String[] labels) {
            this.mLabels = labels;
            this.setIndex(0);
        }

        public void setSecondaryLabels(String[] labels) {
            this.mLabels2 = labels;
            this.setIndex(0);
        }

        public int getActionCount() {
            if (this.mDrawables != null) {
                return this.mDrawables.length;
            }
            if (this.mLabels != null) {
                return this.mLabels.length;
            }
            return 0;
        }

        public Drawable getDrawable(int index) {
            return this.mDrawables == null ? null : this.mDrawables[index];
        }

        public String getLabel(int index) {
            return this.mLabels == null ? null : this.mLabels[index];
        }

        public String getSecondaryLabel(int index) {
            return this.mLabels2 == null ? null : this.mLabels2[index];
        }

        public void nextIndex() {
            this.setIndex(this.mIndex < this.getActionCount() - 1 ? this.mIndex + 1 : 0);
        }

        public void setIndex(int index) {
            this.mIndex = index;
            if (this.mDrawables != null) {
                this.setIcon(this.mDrawables[this.mIndex]);
            }
            if (this.mLabels != null) {
                this.setLabel1(this.mLabels[this.mIndex]);
            }
            if (this.mLabels2 != null) {
                this.setLabel2(this.mLabels2[this.mIndex]);
            }
        }

        public int getIndex() {
            return this.mIndex;
        }
    }
}

