/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.support.v17.leanback.widget.FacetProvider;
import android.view.View;
import android.view.ViewGroup;
import java.util.HashMap;
import java.util.Map;

public abstract class Presenter
implements FacetProvider {
    private Map<Class, Object> mFacets;

    public abstract ViewHolder onCreateViewHolder(ViewGroup var1);

    public abstract void onBindViewHolder(ViewHolder var1, Object var2);

    public abstract void onUnbindViewHolder(ViewHolder var1);

    public void onViewAttachedToWindow(ViewHolder holder) {
    }

    public void onViewDetachedFromWindow(ViewHolder holder) {
        Presenter.cancelAnimationsRecursive(holder.view);
    }

    protected static void cancelAnimationsRecursive(View view) {
        if (view != null && view.hasTransientState()) {
            view.animate().cancel();
            if (view instanceof ViewGroup) {
                int count = ((ViewGroup)view).getChildCount();
                for (int i = 0; view.hasTransientState() && i < count; ++i) {
                    Presenter.cancelAnimationsRecursive(((ViewGroup)view).getChildAt(i));
                }
            }
        }
    }

    public void setOnClickListener(ViewHolder holder, View.OnClickListener listener) {
        holder.view.setOnClickListener(listener);
    }

    @Override
    public final Object getFacet(Class<?> facetClass) {
        if (this.mFacets == null) {
            return null;
        }
        return this.mFacets.get(facetClass);
    }

    public final void setFacet(Class<?> facetClass, Object facetImpl) {
        if (this.mFacets == null) {
            this.mFacets = new HashMap<Class, Object>();
        }
        this.mFacets.put(facetClass, facetImpl);
    }

    public static class ViewHolder
    implements FacetProvider {
        public final View view;
        private Map<Class, Object> mFacets;

        public ViewHolder(View view) {
            this.view = view;
        }

        @Override
        public final Object getFacet(Class<?> facetClass) {
            if (this.mFacets == null) {
                return null;
            }
            return this.mFacets.get(facetClass);
        }

        public final void setFacet(Class<?> facetClass, Object facetImpl) {
            if (this.mFacets == null) {
                this.mFacets = new HashMap<Class, Object>();
            }
            this.mFacets.put(facetClass, facetImpl);
        }
    }
}

