/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.os.Build;
import android.support.v17.leanback.widget.RoundedRectHelperApi21;
import android.view.View;

final class RoundedRectHelper {
    private static final RoundedRectHelper sInstance = new RoundedRectHelper();
    private Impl mImpl = Build.VERSION.SDK_INT >= 21 ? new Api21Impl() : new StubImpl();

    public static RoundedRectHelper getInstance() {
        return sInstance;
    }

    public void setClipToRoundedOutline(View view, boolean clip) {
        this.mImpl.setClipToRoundedOutline(view, clip);
    }

    private RoundedRectHelper() {
    }

    private static final class Api21Impl
    implements Impl {
        private Api21Impl() {
        }

        @Override
        public void setClipToRoundedOutline(View view, boolean clip) {
            RoundedRectHelperApi21.setClipToRoundedOutline(view, clip);
        }
    }

    private static final class StubImpl
    implements Impl {
        private StubImpl() {
        }

        @Override
        public void setClipToRoundedOutline(View view, boolean clip) {
        }
    }

    static interface Impl {
        public void setClipToRoundedOutline(View var1, boolean var2);
    }
}

