/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v17.leanback.R;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

final class RowContainerView
extends LinearLayout {
    private ViewGroup mHeaderDock;
    private Drawable mForeground;
    private boolean mForegroundBoundsChanged = true;

    public RowContainerView(Context context) {
        this(context, null, 0);
    }

    public RowContainerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RowContainerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setOrientation(1);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.lb_row_container, (ViewGroup)this);
        this.mHeaderDock = (ViewGroup)this.findViewById(R.id.lb_row_container_header_dock);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
    }

    public void addHeaderView(View headerView) {
        if (this.mHeaderDock.indexOfChild(headerView) < 0) {
            this.mHeaderDock.addView(headerView, 0);
        }
    }

    public void removeHeaderView(View headerView) {
        if (this.mHeaderDock.indexOfChild(headerView) >= 0) {
            this.mHeaderDock.removeView(headerView);
        }
    }

    public void addRowView(View view) {
        this.addView(view);
    }

    public void showHeader(boolean show) {
        this.mHeaderDock.setVisibility(show ? 0 : 8);
    }

    public void setForeground(Drawable d) {
        this.mForeground = d;
        this.setWillNotDraw(this.mForeground == null);
        this.invalidate();
    }

    public void setForegroundColor(int color2) {
        if (this.mForeground instanceof ColorDrawable) {
            ((ColorDrawable)this.mForeground.mutate()).setColor(color2);
            this.invalidate();
        } else {
            this.setForeground((Drawable)new ColorDrawable(color2));
        }
    }

    public Drawable getForeground() {
        return this.mForeground;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mForegroundBoundsChanged = true;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mForeground != null) {
            if (this.mForegroundBoundsChanged) {
                this.mForegroundBoundsChanged = false;
                this.mForeground.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
            this.mForeground.draw(canvas);
        }
    }
}

