/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.support.v17.leanback.graphics.ColorOverlayDimmer;
import android.support.v17.leanback.widget.OnItemViewClickedListener;
import android.support.v17.leanback.widget.OnItemViewSelectedListener;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.Row;
import android.support.v17.leanback.widget.RowContainerView;
import android.support.v17.leanback.widget.RowHeaderPresenter;
import android.view.View;
import android.view.ViewGroup;

public abstract class RowPresenter
extends Presenter {
    public static final int SYNC_ACTIVATED_CUSTOM = 0;
    public static final int SYNC_ACTIVATED_TO_EXPANDED = 1;
    public static final int SYNC_ACTIVATED_TO_SELECTED = 2;
    public static final int SYNC_ACTIVATED_TO_EXPANDED_AND_SELECTED = 3;
    private RowHeaderPresenter mHeaderPresenter = new RowHeaderPresenter();
    boolean mSelectEffectEnabled = true;
    int mSyncActivatePolicy = 1;

    public RowPresenter() {
        this.mHeaderPresenter.setNullItemVisibilityGone(true);
    }

    @Override
    public final Presenter.ViewHolder onCreateViewHolder(ViewGroup parent) {
        Presenter.ViewHolder result;
        ViewHolder vh = this.createRowViewHolder(parent);
        vh.mInitialzed = false;
        if (this.needsRowContainerView()) {
            RowContainerView containerView = new RowContainerView(parent.getContext());
            if (this.mHeaderPresenter != null) {
                vh.mHeaderViewHolder = (RowHeaderPresenter.ViewHolder)this.mHeaderPresenter.onCreateViewHolder((ViewGroup)vh.view);
            }
            result = new ContainerViewHolder(containerView, vh);
        } else {
            result = vh;
        }
        this.initializeRowViewHolder(vh);
        if (!vh.mInitialzed) {
            throw new RuntimeException("super.initializeRowViewHolder() must be called");
        }
        return result;
    }

    protected abstract ViewHolder createRowViewHolder(ViewGroup var1);

    protected boolean isClippingChildren() {
        return false;
    }

    protected void initializeRowViewHolder(ViewHolder vh) {
        vh.mInitialzed = true;
        if (!this.isClippingChildren()) {
            if (vh.view instanceof ViewGroup) {
                ((ViewGroup)vh.view).setClipChildren(false);
            }
            if (vh.mContainerViewHolder != null) {
                ((ViewGroup)vh.mContainerViewHolder.view).setClipChildren(false);
            }
        }
    }

    public final void setHeaderPresenter(RowHeaderPresenter headerPresenter) {
        this.mHeaderPresenter = headerPresenter;
    }

    public final RowHeaderPresenter getHeaderPresenter() {
        return this.mHeaderPresenter;
    }

    public final ViewHolder getRowViewHolder(Presenter.ViewHolder holder) {
        if (holder instanceof ContainerViewHolder) {
            return ((ContainerViewHolder)holder).mRowViewHolder;
        }
        return (ViewHolder)holder;
    }

    public final void setRowViewExpanded(Presenter.ViewHolder holder, boolean expanded) {
        ViewHolder rowViewHolder = this.getRowViewHolder(holder);
        rowViewHolder.mExpanded = expanded;
        this.onRowViewExpanded(rowViewHolder, expanded);
    }

    public final void setRowViewSelected(Presenter.ViewHolder holder, boolean selected) {
        ViewHolder rowViewHolder = this.getRowViewHolder(holder);
        rowViewHolder.mSelected = selected;
        this.onRowViewSelected(rowViewHolder, selected);
    }

    protected void onRowViewExpanded(ViewHolder vh, boolean expanded) {
        this.updateHeaderViewVisibility(vh);
        this.updateActivateStatus(vh, vh.view);
    }

    private void updateActivateStatus(ViewHolder vh, View view) {
        switch (this.mSyncActivatePolicy) {
            case 1: {
                vh.setActivated(vh.isExpanded());
                break;
            }
            case 2: {
                vh.setActivated(vh.isSelected());
                break;
            }
            case 3: {
                vh.setActivated(vh.isExpanded() && vh.isSelected());
            }
        }
        vh.syncActivatedStatus(view);
    }

    public final void setSyncActivatePolicy(int syncActivatePolicy) {
        this.mSyncActivatePolicy = syncActivatePolicy;
    }

    public final int getSyncActivatePolicy() {
        return this.mSyncActivatePolicy;
    }

    protected void dispatchItemSelectedListener(ViewHolder vh, boolean selected) {
        if (selected && vh.mOnItemViewSelectedListener != null) {
            vh.mOnItemViewSelectedListener.onItemSelected(null, null, vh, vh.getRow());
        }
    }

    protected void onRowViewSelected(ViewHolder vh, boolean selected) {
        this.dispatchItemSelectedListener(vh, selected);
        this.updateHeaderViewVisibility(vh);
        this.updateActivateStatus(vh, vh.view);
    }

    private void updateHeaderViewVisibility(ViewHolder vh) {
        if (this.mHeaderPresenter != null && vh.mHeaderViewHolder != null) {
            RowContainerView containerView = (RowContainerView)vh.mContainerViewHolder.view;
            containerView.showHeader(vh.isExpanded());
        }
    }

    public final void setSelectLevel(Presenter.ViewHolder vh, float level) {
        ViewHolder rowViewHolder = this.getRowViewHolder(vh);
        rowViewHolder.mSelectLevel = level;
        this.onSelectLevelChanged(rowViewHolder);
    }

    public final float getSelectLevel(Presenter.ViewHolder vh) {
        return this.getRowViewHolder((Presenter.ViewHolder)vh).mSelectLevel;
    }

    protected void onSelectLevelChanged(ViewHolder vh) {
        if (this.getSelectEffectEnabled()) {
            vh.mColorDimmer.setActiveLevel(vh.mSelectLevel);
            if (vh.mHeaderViewHolder != null) {
                this.mHeaderPresenter.setSelectLevel(vh.mHeaderViewHolder, vh.mSelectLevel);
            }
            if (this.isUsingDefaultSelectEffect()) {
                ((RowContainerView)vh.mContainerViewHolder.view).setForegroundColor(vh.mColorDimmer.getPaint().getColor());
            }
        }
    }

    public final void setSelectEffectEnabled(boolean applyDimOnSelect) {
        this.mSelectEffectEnabled = applyDimOnSelect;
    }

    public final boolean getSelectEffectEnabled() {
        return this.mSelectEffectEnabled;
    }

    public boolean isUsingDefaultSelectEffect() {
        return true;
    }

    final boolean needsDefaultSelectEffect() {
        return this.isUsingDefaultSelectEffect() && this.getSelectEffectEnabled();
    }

    final boolean needsRowContainerView() {
        return this.mHeaderPresenter != null || this.needsDefaultSelectEffect();
    }

    public boolean canDrawOutOfBounds() {
        return false;
    }

    @Override
    public final void onBindViewHolder(Presenter.ViewHolder viewHolder, Object item) {
        this.onBindRowViewHolder(this.getRowViewHolder(viewHolder), item);
    }

    protected void onBindRowViewHolder(ViewHolder vh, Object item) {
        vh.mRow = (Row)item;
        if (vh.mHeaderViewHolder != null) {
            this.mHeaderPresenter.onBindViewHolder(vh.mHeaderViewHolder, item);
        }
    }

    @Override
    public final void onUnbindViewHolder(Presenter.ViewHolder viewHolder) {
        this.onUnbindRowViewHolder(this.getRowViewHolder(viewHolder));
    }

    protected void onUnbindRowViewHolder(ViewHolder vh) {
        if (vh.mHeaderViewHolder != null) {
            this.mHeaderPresenter.onUnbindViewHolder(vh.mHeaderViewHolder);
        }
        vh.mRow = null;
    }

    @Override
    public final void onViewAttachedToWindow(Presenter.ViewHolder holder) {
        this.onRowViewAttachedToWindow(this.getRowViewHolder(holder));
    }

    protected void onRowViewAttachedToWindow(ViewHolder vh) {
        if (vh.mHeaderViewHolder != null) {
            this.mHeaderPresenter.onViewAttachedToWindow(vh.mHeaderViewHolder);
        }
    }

    @Override
    public final void onViewDetachedFromWindow(Presenter.ViewHolder holder) {
        this.onRowViewDetachedFromWindow(this.getRowViewHolder(holder));
    }

    protected void onRowViewDetachedFromWindow(ViewHolder vh) {
        if (vh.mHeaderViewHolder != null) {
            this.mHeaderPresenter.onViewDetachedFromWindow(vh.mHeaderViewHolder);
        }
        RowPresenter.cancelAnimationsRecursive(vh.view);
    }

    public void freeze(ViewHolder holder, boolean freeze) {
    }

    public void setEntranceTransitionState(ViewHolder holder, boolean afterTransition) {
        if (holder.mHeaderViewHolder != null && holder.mHeaderViewHolder.view.getVisibility() != 8) {
            holder.mHeaderViewHolder.view.setVisibility(afterTransition ? 0 : 4);
        }
    }

    public static class ViewHolder
    extends Presenter.ViewHolder {
        private static final int ACTIVATED_NOT_ASSIGNED = 0;
        private static final int ACTIVATED = 1;
        private static final int NOT_ACTIVATED = 2;
        ContainerViewHolder mContainerViewHolder;
        RowHeaderPresenter.ViewHolder mHeaderViewHolder;
        Row mRow;
        int mActivated = 0;
        boolean mSelected;
        boolean mExpanded;
        boolean mInitialzed;
        float mSelectLevel = 0.0f;
        protected final ColorOverlayDimmer mColorDimmer;
        private View.OnKeyListener mOnKeyListener;
        private OnItemViewSelectedListener mOnItemViewSelectedListener;
        private OnItemViewClickedListener mOnItemViewClickedListener;

        public ViewHolder(View view) {
            super(view);
            this.mColorDimmer = ColorOverlayDimmer.createDefault(view.getContext());
        }

        public final Row getRow() {
            return this.mRow;
        }

        public final boolean isExpanded() {
            return this.mExpanded;
        }

        public final boolean isSelected() {
            return this.mSelected;
        }

        public final float getSelectLevel() {
            return this.mSelectLevel;
        }

        public final RowHeaderPresenter.ViewHolder getHeaderViewHolder() {
            return this.mHeaderViewHolder;
        }

        public final void setActivated(boolean activated) {
            this.mActivated = activated ? 1 : 2;
        }

        public final void syncActivatedStatus(View view) {
            if (this.mActivated == 1) {
                view.setActivated(true);
            } else if (this.mActivated == 2) {
                view.setActivated(false);
            }
        }

        public void setOnKeyListener(View.OnKeyListener keyListener) {
            this.mOnKeyListener = keyListener;
        }

        public View.OnKeyListener getOnKeyListener() {
            return this.mOnKeyListener;
        }

        public final void setOnItemViewSelectedListener(OnItemViewSelectedListener listener) {
            this.mOnItemViewSelectedListener = listener;
        }

        public final OnItemViewSelectedListener getOnItemViewSelectedListener() {
            return this.mOnItemViewSelectedListener;
        }

        public final void setOnItemViewClickedListener(OnItemViewClickedListener listener) {
            this.mOnItemViewClickedListener = listener;
        }

        public final OnItemViewClickedListener getOnItemViewClickedListener() {
            return this.mOnItemViewClickedListener;
        }
    }

    static class ContainerViewHolder
    extends Presenter.ViewHolder {
        final ViewHolder mRowViewHolder;

        public ContainerViewHolder(RowContainerView containerView, ViewHolder rowViewHolder) {
            super((View)containerView);
            containerView.addRowView(rowViewHolder.view);
            if (rowViewHolder.mHeaderViewHolder != null) {
                containerView.addHeaderView(rowViewHolder.mHeaderViewHolder.view);
            }
            this.mRowViewHolder = rowViewHolder;
            this.mRowViewHolder.mContainerViewHolder = this;
        }
    }
}

