/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.media.SoundPool;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.SearchEditText;
import android.support.v17.leanback.widget.SpeechOrbView;
import android.support.v17.leanback.widget.SpeechRecognitionCallback;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;

public class SearchBar
extends RelativeLayout {
    private static final String TAG = SearchBar.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final float FULL_LEFT_VOLUME = 1.0f;
    private static final float FULL_RIGHT_VOLUME = 1.0f;
    private static final int DEFAULT_PRIORITY = 1;
    private static final int DO_NOT_LOOP = 0;
    private static final float DEFAULT_RATE = 1.0f;
    private AudioManager.OnAudioFocusChangeListener mAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

        public void onAudioFocusChange(int focusChange) {
            SearchBar.this.stopRecognition();
        }
    };
    private SearchBarListener mSearchBarListener;
    private SearchEditText mSearchTextEditor;
    private SpeechOrbView mSpeechOrbView;
    private ImageView mBadgeView;
    private String mSearchQuery;
    private String mHint;
    private String mTitle;
    private Drawable mBadgeDrawable;
    private final Handler mHandler = new Handler();
    private final InputMethodManager mInputMethodManager;
    private boolean mAutoStartRecognition = false;
    private Drawable mBarBackground;
    private final int mTextColor;
    private final int mTextColorSpeechMode;
    private final int mTextHintColor;
    private final int mTextHintColorSpeechMode;
    private int mBackgroundAlpha;
    private int mBackgroundSpeechAlpha;
    private int mBarHeight;
    private SpeechRecognizer mSpeechRecognizer;
    private SpeechRecognitionCallback mSpeechRecognitionCallback;
    private boolean mListening;
    private SoundPool mSoundPool;
    private SparseIntArray mSoundMap = new SparseIntArray();
    private boolean mRecognizing = false;
    private final Context mContext;
    private AudioManager mAudioManager;

    public SearchBar(Context context) {
        this(context, null);
    }

    public SearchBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SearchBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        Resources r = this.getResources();
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        inflater.inflate(R.layout.lb_search_bar, (ViewGroup)this, true);
        this.mBarHeight = this.getResources().getDimensionPixelSize(R.dimen.lb_search_bar_height);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, this.mBarHeight);
        params.addRule(10, -1);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setBackgroundColor(0);
        this.setClipChildren(false);
        this.mSearchQuery = "";
        this.mInputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        this.mTextColorSpeechMode = r.getColor(R.color.lb_search_bar_text_speech_mode);
        this.mTextColor = r.getColor(R.color.lb_search_bar_text);
        this.mBackgroundSpeechAlpha = r.getInteger(R.integer.lb_search_bar_speech_mode_background_alpha);
        this.mBackgroundAlpha = r.getInteger(R.integer.lb_search_bar_text_mode_background_alpha);
        this.mTextHintColorSpeechMode = r.getColor(R.color.lb_search_bar_hint_speech_mode);
        this.mTextHintColor = r.getColor(R.color.lb_search_bar_hint);
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        RelativeLayout items = (RelativeLayout)this.findViewById(R.id.lb_search_bar_items);
        this.mBarBackground = items.getBackground();
        this.mSearchTextEditor = (SearchEditText)this.findViewById(R.id.lb_search_text_editor);
        this.mBadgeView = (ImageView)this.findViewById(R.id.lb_search_bar_badge);
        if (null != this.mBadgeDrawable) {
            this.mBadgeView.setImageDrawable(this.mBadgeDrawable);
        }
        this.mSearchTextEditor.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean hasFocus) {
                if (hasFocus) {
                    SearchBar.this.showNativeKeyboard();
                }
                SearchBar.this.updateUi(hasFocus);
            }
        });
        final Runnable mOnTextChangedRunnable = new Runnable(){

            @Override
            public void run() {
                SearchBar.this.setSearchQueryInternal(SearchBar.this.mSearchTextEditor.getText().toString());
            }
        };
        this.mSearchTextEditor.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                if (SearchBar.this.mRecognizing) {
                    return;
                }
                SearchBar.this.mHandler.removeCallbacks(mOnTextChangedRunnable);
                SearchBar.this.mHandler.post(mOnTextChangedRunnable);
            }

            public void afterTextChanged(Editable editable) {
            }
        });
        this.mSearchTextEditor.setOnKeyboardDismissListener(new SearchEditText.OnKeyboardDismissListener(){

            @Override
            public void onKeyboardDismiss() {
                if (null != SearchBar.this.mSearchBarListener) {
                    SearchBar.this.mSearchBarListener.onKeyboardDismiss(SearchBar.this.mSearchQuery);
                }
            }
        });
        this.mSearchTextEditor.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int action, KeyEvent keyEvent) {
                boolean handled = true;
                if ((3 == action || 0 == action) && null != SearchBar.this.mSearchBarListener) {
                    SearchBar.this.hideNativeKeyboard();
                    SearchBar.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            SearchBar.this.submitQuery();
                        }
                    }, 500L);
                } else if (1 == action && null != SearchBar.this.mSearchBarListener) {
                    SearchBar.this.hideNativeKeyboard();
                    SearchBar.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            SearchBar.this.mSearchBarListener.onKeyboardDismiss(SearchBar.this.mSearchQuery);
                        }
                    }, 500L);
                } else if (2 == action) {
                    SearchBar.this.hideNativeKeyboard();
                    SearchBar.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            SearchBar.this.mAutoStartRecognition = true;
                            SearchBar.this.mSpeechOrbView.requestFocus();
                        }
                    }, 500L);
                } else {
                    handled = false;
                }
                return handled;
            }
        });
        this.mSearchTextEditor.setPrivateImeOptions("EscapeNorth=1;VoiceDismiss=1;");
        this.mSpeechOrbView = (SpeechOrbView)this.findViewById(R.id.lb_search_bar_speech_orb);
        this.mSpeechOrbView.setOnOrbClickedListener(new View.OnClickListener(){

            public void onClick(View view) {
                SearchBar.this.toggleRecognition();
            }
        });
        this.mSpeechOrbView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean hasFocus) {
                if (hasFocus) {
                    SearchBar.this.hideNativeKeyboard();
                    if (SearchBar.this.mAutoStartRecognition) {
                        SearchBar.this.startRecognition();
                        SearchBar.this.mAutoStartRecognition = false;
                    }
                } else {
                    SearchBar.this.stopRecognition();
                }
                SearchBar.this.updateUi(hasFocus);
            }
        });
        this.updateUi(this.hasFocus());
        this.updateHint();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mSoundPool = new SoundPool(2, 1, 0);
        this.loadSounds(this.mContext);
    }

    protected void onDetachedFromWindow() {
        this.stopRecognition();
        this.mSoundPool.release();
        super.onDetachedFromWindow();
    }

    public void setSearchBarListener(SearchBarListener listener) {
        this.mSearchBarListener = listener;
    }

    public void setSearchQuery(String query) {
        this.stopRecognition();
        this.mSearchTextEditor.setText(query);
        this.setSearchQueryInternal(query);
    }

    private void setSearchQueryInternal(String query) {
        if (TextUtils.equals((CharSequence)this.mSearchQuery, (CharSequence)query)) {
            return;
        }
        this.mSearchQuery = query;
        if (null != this.mSearchBarListener) {
            this.mSearchBarListener.onSearchQueryChange(this.mSearchQuery);
        }
    }

    public void setTitle(String title) {
        this.mTitle = title;
        this.updateHint();
    }

    public String getTitle() {
        return this.mTitle;
    }

    public CharSequence getHint() {
        return this.mHint;
    }

    public void setBadgeDrawable(Drawable drawable2) {
        this.mBadgeDrawable = drawable2;
        if (null != this.mBadgeView) {
            this.mBadgeView.setImageDrawable(drawable2);
            if (null != drawable2) {
                this.mBadgeView.setVisibility(0);
            } else {
                this.mBadgeView.setVisibility(8);
            }
        }
    }

    public Drawable getBadgeDrawable() {
        return this.mBadgeDrawable;
    }

    public void displayCompletions(List<String> completions) {
        ArrayList<CompletionInfo> infos = new ArrayList<CompletionInfo>();
        if (null != completions) {
            for (String completion : completions) {
                infos.add(new CompletionInfo((long)infos.size(), infos.size(), (CharSequence)completion));
            }
        }
        this.mInputMethodManager.displayCompletions((View)this.mSearchTextEditor, infos.toArray(new CompletionInfo[0]));
    }

    public void setSpeechRecognizer(SpeechRecognizer recognizer) {
        this.stopRecognition();
        if (null != this.mSpeechRecognizer) {
            this.mSpeechRecognizer.setRecognitionListener(null);
            if (this.mListening) {
                this.mSpeechRecognizer.cancel();
                this.mListening = false;
            }
        }
        this.mSpeechRecognizer = recognizer;
        if (this.mSpeechRecognizer != null) {
            this.enforceAudioRecordPermission();
        }
        if (this.mSpeechRecognitionCallback != null && this.mSpeechRecognizer != null) {
            throw new IllegalStateException("Can't have speech recognizer and request");
        }
    }

    public void setSpeechRecognitionCallback(SpeechRecognitionCallback request) {
        this.mSpeechRecognitionCallback = request;
        if (this.mSpeechRecognitionCallback != null && this.mSpeechRecognizer != null) {
            throw new IllegalStateException("Can't have speech recognizer and request");
        }
    }

    private void hideNativeKeyboard() {
        this.mInputMethodManager.hideSoftInputFromWindow(this.mSearchTextEditor.getWindowToken(), 0);
    }

    private void showNativeKeyboard() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                SearchBar.this.mSearchTextEditor.requestFocusFromTouch();
                SearchBar.this.mSearchTextEditor.dispatchTouchEvent(MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)0, (float)SearchBar.this.mSearchTextEditor.getWidth(), (float)SearchBar.this.mSearchTextEditor.getHeight(), (int)0));
                SearchBar.this.mSearchTextEditor.dispatchTouchEvent(MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)1, (float)SearchBar.this.mSearchTextEditor.getWidth(), (float)SearchBar.this.mSearchTextEditor.getHeight(), (int)0));
            }
        });
    }

    private void updateHint() {
        String title = this.getResources().getString(R.string.lb_search_bar_hint);
        if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
            title = this.isVoiceMode() ? this.getResources().getString(R.string.lb_search_bar_hint_with_title_speech, new Object[]{this.mTitle}) : this.getResources().getString(R.string.lb_search_bar_hint_with_title, new Object[]{this.mTitle});
        } else if (this.isVoiceMode()) {
            title = this.getResources().getString(R.string.lb_search_bar_hint_speech);
        }
        this.mHint = title;
        if (this.mSearchTextEditor != null) {
            this.mSearchTextEditor.setHint(this.mHint);
        }
    }

    private void toggleRecognition() {
        if (this.mRecognizing) {
            this.stopRecognition();
        } else {
            this.startRecognition();
        }
    }

    public void stopRecognition() {
        if (!this.mRecognizing) {
            return;
        }
        this.mSearchTextEditor.setText(this.mSearchQuery);
        this.mSearchTextEditor.setHint(this.mHint);
        this.mRecognizing = false;
        if (this.mSpeechRecognitionCallback != null || null == this.mSpeechRecognizer) {
            return;
        }
        this.mSpeechOrbView.showNotListening();
        if (this.mListening) {
            this.mSpeechRecognizer.cancel();
            this.mListening = false;
            this.mAudioManager.abandonAudioFocus(this.mAudioFocusChangeListener);
        }
        this.mSpeechRecognizer.setRecognitionListener(null);
    }

    public void startRecognition() {
        if (this.mRecognizing) {
            return;
        }
        this.mRecognizing = true;
        if (!this.hasFocus()) {
            this.requestFocus();
        }
        if (this.mSpeechRecognitionCallback != null) {
            this.mSearchTextEditor.setText("");
            this.mSearchTextEditor.setHint("");
            this.mSpeechRecognitionCallback.recognizeSpeech();
            return;
        }
        if (null == this.mSpeechRecognizer) {
            return;
        }
        int result = this.mAudioManager.requestAudioFocus(this.mAudioFocusChangeListener, 3, 3);
        if (result != 1) {
            Log.w((String)TAG, (String)"Could not get audio focus");
        }
        this.mSearchTextEditor.setText("");
        Intent recognizerIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        recognizerIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        recognizerIntent.putExtra("android.speech.extra.PARTIAL_RESULTS", true);
        this.mSpeechRecognizer.setRecognitionListener(new RecognitionListener(){

            public void onReadyForSpeech(Bundle bundle) {
                SearchBar.this.mSpeechOrbView.showListening();
                SearchBar.this.playSearchOpen();
            }

            public void onBeginningOfSpeech() {
            }

            public void onRmsChanged(float rmsdB) {
                int level = rmsdB < 0.0f ? 0 : (int)(10.0f * rmsdB);
                SearchBar.this.mSpeechOrbView.setSoundLevel(level);
            }

            public void onBufferReceived(byte[] bytes) {
            }

            public void onEndOfSpeech() {
            }

            public void onError(int error) {
                switch (error) {
                    case 1: {
                        Log.w((String)TAG, (String)"recognizer network timeout");
                        break;
                    }
                    case 2: {
                        Log.w((String)TAG, (String)"recognizer network error");
                        break;
                    }
                    case 3: {
                        Log.w((String)TAG, (String)"recognizer audio error");
                        break;
                    }
                    case 4: {
                        Log.w((String)TAG, (String)"recognizer server error");
                        break;
                    }
                    case 5: {
                        Log.w((String)TAG, (String)"recognizer client error");
                        break;
                    }
                    case 6: {
                        Log.w((String)TAG, (String)"recognizer speech timeout");
                        break;
                    }
                    case 7: {
                        Log.w((String)TAG, (String)"recognizer no match");
                        break;
                    }
                    case 8: {
                        Log.w((String)TAG, (String)"recognizer busy");
                        break;
                    }
                    case 9: {
                        Log.w((String)TAG, (String)"recognizer insufficient permissions");
                        break;
                    }
                    default: {
                        Log.d((String)TAG, (String)"recognizer other error");
                    }
                }
                SearchBar.this.stopRecognition();
                SearchBar.this.playSearchFailure();
            }

            public void onResults(Bundle bundle) {
                ArrayList matches = bundle.getStringArrayList("results_recognition");
                if (matches != null) {
                    SearchBar.this.mSearchQuery = (String)matches.get(0);
                    SearchBar.this.mSearchTextEditor.setText(SearchBar.this.mSearchQuery);
                    SearchBar.this.submitQuery();
                }
                SearchBar.this.stopRecognition();
                SearchBar.this.playSearchSuccess();
            }

            public void onPartialResults(Bundle bundle) {
                ArrayList results = bundle.getStringArrayList("results_recognition");
                if (results == null || results.size() == 0) {
                    return;
                }
                String stableText = (String)results.get(0);
                String pendingText = results.size() > 1 ? (String)results.get(1) : null;
                SearchBar.this.mSearchTextEditor.updateRecognizedText(stableText, pendingText);
            }

            public void onEvent(int i, Bundle bundle) {
            }
        });
        this.mListening = true;
        this.mSpeechRecognizer.startListening(recognizerIntent);
    }

    private void updateUi(boolean hasFocus) {
        if (hasFocus) {
            this.mBarBackground.setAlpha(this.mBackgroundSpeechAlpha);
            if (this.isVoiceMode()) {
                this.mSearchTextEditor.setTextColor(this.mTextHintColorSpeechMode);
                this.mSearchTextEditor.setHintTextColor(this.mTextHintColorSpeechMode);
            } else {
                this.mSearchTextEditor.setTextColor(this.mTextColorSpeechMode);
                this.mSearchTextEditor.setHintTextColor(this.mTextHintColorSpeechMode);
            }
        } else {
            this.mBarBackground.setAlpha(this.mBackgroundAlpha);
            this.mSearchTextEditor.setTextColor(this.mTextColor);
            this.mSearchTextEditor.setHintTextColor(this.mTextHintColor);
        }
        this.updateHint();
    }

    private boolean isVoiceMode() {
        return this.mSpeechOrbView.isFocused();
    }

    private void submitQuery() {
        if (!TextUtils.isEmpty((CharSequence)this.mSearchQuery) && null != this.mSearchBarListener) {
            this.mSearchBarListener.onSearchQuerySubmit(this.mSearchQuery);
        }
    }

    private void enforceAudioRecordPermission() {
        String permission = "android.permission.RECORD_AUDIO";
        int res = this.getContext().checkCallingOrSelfPermission(permission);
        if (0 != res) {
            throw new IllegalStateException("android.permission.RECORD_AUDIO required for search");
        }
    }

    private void loadSounds(Context context) {
        int[] sounds;
        for (int sound : sounds = new int[]{R.raw.lb_voice_failure, R.raw.lb_voice_open, R.raw.lb_voice_no_input, R.raw.lb_voice_success}) {
            this.mSoundMap.put(sound, this.mSoundPool.load(context, sound, 1));
        }
    }

    private void play(final int resId) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                int sound = SearchBar.this.mSoundMap.get(resId);
                SearchBar.this.mSoundPool.play(sound, 1.0f, 1.0f, 1, 0, 1.0f);
            }
        });
    }

    private void playSearchOpen() {
        this.play(R.raw.lb_voice_open);
    }

    private void playSearchFailure() {
        this.play(R.raw.lb_voice_failure);
    }

    private void playSearchNoInput() {
        this.play(R.raw.lb_voice_no_input);
    }

    private void playSearchSuccess() {
        this.play(R.raw.lb_voice_success);
    }

    public void setNextFocusDownId(int viewId) {
        this.mSpeechOrbView.setNextFocusDownId(viewId);
        this.mSearchTextEditor.setNextFocusDownId(viewId);
    }

    public static interface SearchBarListener {
        public void onSearchQueryChange(String var1);

        public void onSearchQuerySubmit(String var1);

        public void onKeyboardDismiss(String var1);
    }
}

