/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.ShadowHelper;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

public class SearchOrbView
extends FrameLayout
implements View.OnClickListener {
    private View.OnClickListener mListener;
    private View mRootView;
    private View mSearchOrbView;
    private ImageView mIcon;
    private Drawable mIconDrawable;
    private Colors mColors;
    private final float mFocusedZoom;
    private final int mPulseDurationMs;
    private final int mScaleDurationMs;
    private final float mUnfocusedZ;
    private final float mFocusedZ;
    private ValueAnimator mColorAnimator;
    private final ArgbEvaluator mColorEvaluator = new ArgbEvaluator();
    private final ValueAnimator.AnimatorUpdateListener mUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animator) {
            Integer color2 = (Integer)animator.getAnimatedValue();
            SearchOrbView.this.setOrbViewColor(color2);
        }
    };
    private ValueAnimator mShadowFocusAnimator;
    private final ValueAnimator.AnimatorUpdateListener mFocusUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            SearchOrbView.this.setSearchOrbZ(animation.getAnimatedFraction());
        }
    };

    private void setSearchOrbZ(float fraction2) {
        ShadowHelper.getInstance().setZ(this.mSearchOrbView, this.mUnfocusedZ + fraction2 * (this.mFocusedZ - this.mUnfocusedZ));
    }

    public SearchOrbView(Context context) {
        this(context, null);
    }

    public SearchOrbView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.searchOrbViewStyle);
    }

    public SearchOrbView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources res = context.getResources();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mRootView = inflater.inflate(this.getLayoutResourceId(), (ViewGroup)this, true);
        this.mSearchOrbView = this.mRootView.findViewById(R.id.search_orb);
        this.mIcon = (ImageView)this.mRootView.findViewById(R.id.icon);
        this.mFocusedZoom = context.getResources().getFraction(R.fraction.lb_search_orb_focused_zoom, 1, 1);
        this.mPulseDurationMs = context.getResources().getInteger(R.integer.lb_search_orb_pulse_duration_ms);
        this.mScaleDurationMs = context.getResources().getInteger(R.integer.lb_search_orb_scale_duration_ms);
        this.mFocusedZ = context.getResources().getDimensionPixelSize(R.dimen.lb_search_orb_focused_z);
        this.mUnfocusedZ = context.getResources().getDimensionPixelSize(R.dimen.lb_search_orb_unfocused_z);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.lbSearchOrbView, defStyleAttr, 0);
        Drawable img = a.getDrawable(R.styleable.lbSearchOrbView_searchOrbIcon);
        if (img == null) {
            img = res.getDrawable(R.drawable.lb_ic_in_app_search);
        }
        this.setOrbIcon(img);
        int defColor = res.getColor(R.color.lb_default_search_color);
        int color2 = a.getColor(R.styleable.lbSearchOrbView_searchOrbColor, defColor);
        int brightColor = a.getColor(R.styleable.lbSearchOrbView_searchOrbBrightColor, color2);
        int iconColor = a.getColor(R.styleable.lbSearchOrbView_searchOrbIconColor, 0);
        this.setOrbColors(new Colors(color2, brightColor, iconColor));
        a.recycle();
        this.setFocusable(true);
        this.setClipChildren(false);
        this.setOnClickListener(this);
        this.setSoundEffectsEnabled(false);
        this.setSearchOrbZ(0.0f);
        ShadowHelper.getInstance().setZ((View)this.mIcon, this.mFocusedZ);
    }

    int getLayoutResourceId() {
        return R.layout.lb_search_orb;
    }

    void scaleOrbViewOnly(float scale) {
        this.mSearchOrbView.setScaleX(scale);
        this.mSearchOrbView.setScaleY(scale);
    }

    float getFocusedZoom() {
        return this.mFocusedZoom;
    }

    public void onClick(View view) {
        if (null != this.mListener) {
            this.mListener.onClick(view);
        }
    }

    private void startShadowFocusAnimation(boolean gainFocus, int duration) {
        if (this.mShadowFocusAnimator == null) {
            this.mShadowFocusAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mShadowFocusAnimator.addUpdateListener(this.mFocusUpdateListener);
        }
        if (gainFocus) {
            this.mShadowFocusAnimator.start();
        } else {
            this.mShadowFocusAnimator.reverse();
        }
        this.mShadowFocusAnimator.setDuration((long)duration);
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        this.animateOnFocus(gainFocus);
    }

    void animateOnFocus(boolean hasFocus) {
        float zoom = hasFocus ? this.mFocusedZoom : 1.0f;
        this.mRootView.animate().scaleX(zoom).scaleY(zoom).setDuration((long)this.mScaleDurationMs).start();
        this.startShadowFocusAnimation(hasFocus, this.mScaleDurationMs);
        this.enableOrbColorAnimation(hasFocus);
    }

    public void setOrbIcon(Drawable icon) {
        this.mIconDrawable = icon;
        this.mIcon.setImageDrawable(this.mIconDrawable);
    }

    public Drawable getOrbIcon() {
        return this.mIconDrawable;
    }

    public void setOnOrbClickedListener(View.OnClickListener listener) {
        this.mListener = listener;
        if (null != listener) {
            this.setVisibility(0);
        } else {
            this.setVisibility(4);
        }
    }

    public void setOrbColor(int color2) {
        this.setOrbColors(new Colors(color2, color2, 0));
    }

    @Deprecated
    public void setOrbColor(int color2, int brightColor) {
        this.setOrbColors(new Colors(color2, brightColor, 0));
    }

    public int getOrbColor() {
        return this.mColors.color;
    }

    public void setOrbColors(Colors colors) {
        this.mColors = colors;
        this.mIcon.setColorFilter(this.mColors.iconColor);
        if (this.mColorAnimator == null) {
            this.setOrbViewColor(this.mColors.color);
        } else {
            this.enableOrbColorAnimation(true);
        }
    }

    public Colors getOrbColors() {
        return this.mColors;
    }

    public void enableOrbColorAnimation(boolean enable) {
        if (this.mColorAnimator != null) {
            this.mColorAnimator.end();
            this.mColorAnimator = null;
        }
        if (enable) {
            this.mColorAnimator = ValueAnimator.ofObject((TypeEvaluator)this.mColorEvaluator, (Object[])new Object[]{this.mColors.color, this.mColors.brightColor, this.mColors.color});
            this.mColorAnimator.setRepeatCount(-1);
            this.mColorAnimator.setDuration((long)(this.mPulseDurationMs * 2));
            this.mColorAnimator.addUpdateListener(this.mUpdateListener);
            this.mColorAnimator.start();
        }
    }

    private void setOrbViewColor(int color2) {
        if (this.mSearchOrbView.getBackground() instanceof GradientDrawable) {
            ((GradientDrawable)this.mSearchOrbView.getBackground()).setColor(color2);
        }
    }

    protected void onDetachedFromWindow() {
        this.enableOrbColorAnimation(false);
        super.onDetachedFromWindow();
    }

    public static class Colors {
        private static final float sBrightnessAlpha = 0.15f;
        public int color;
        public int brightColor;
        public int iconColor;

        public Colors(int color2) {
            this(color2, color2);
        }

        public Colors(int color2, int brightColor) {
            this(color2, brightColor, 0);
        }

        public Colors(int color2, int brightColor, int iconColor) {
            this.color = color2;
            this.brightColor = brightColor == color2 ? Colors.getBrightColor(color2) : brightColor;
            this.iconColor = iconColor;
        }

        public static int getBrightColor(int color2) {
            float brightnessValue = 38.25f;
            int red = (int)((float)Color.red((int)color2) * 0.85f + 38.25f);
            int green = (int)((float)Color.green((int)color2) * 0.85f + 38.25f);
            int blue = (int)((float)Color.blue((int)color2) * 0.85f + 38.25f);
            int alpha = (int)((float)Color.alpha((int)color2) * 0.85f + 38.25f);
            return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
        }
    }
}

