/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.graphics.Outline;
import android.support.v17.leanback.widget.RoundedRectHelperApi21;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;

class ShadowHelperApi21 {
    static final ViewOutlineProvider sOutlineProvider = new ViewOutlineProvider(){

        public void getOutline(View view, Outline outline) {
            outline.setRect(0, 0, view.getWidth(), view.getHeight());
            outline.setAlpha(1.0f);
        }
    };

    ShadowHelperApi21() {
    }

    public static Object addDynamicShadow(ViewGroup shadowContainer, float unfocusedZ, float focusedZ, boolean roundedCorners) {
        if (roundedCorners) {
            RoundedRectHelperApi21.setClipToRoundedOutline((View)shadowContainer, true);
        } else {
            shadowContainer.setOutlineProvider(sOutlineProvider);
        }
        ShadowImpl impl = new ShadowImpl();
        impl.mShadowContainer = shadowContainer;
        impl.mNormalZ = unfocusedZ;
        impl.mFocusedZ = focusedZ;
        shadowContainer.setZ(impl.mNormalZ);
        shadowContainer.setTransitionGroup(true);
        return impl;
    }

    public static void setShadowFocusLevel(Object object, float level) {
        ShadowImpl impl = (ShadowImpl)object;
        impl.mShadowContainer.setZ(impl.mNormalZ + level * (impl.mFocusedZ - impl.mNormalZ));
    }

    public static void setZ(View view, float z) {
        view.setZ(z);
    }

    static class ShadowImpl {
        ViewGroup mShadowContainer;
        float mNormalZ;
        float mFocusedZ;

        ShadowImpl() {
        }
    }
}

