/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.content.Context;
import android.graphics.Rect;
import android.support.v17.leanback.R;
import android.support.v17.leanback.widget.RoundedRectHelper;
import android.support.v17.leanback.widget.ShadowHelper;
import android.support.v17.leanback.widget.StaticShadowHelper;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class ShadowOverlayContainer
extends ViewGroup {
    public static final int SHADOW_NONE = 1;
    public static final int SHADOW_STATIC = 2;
    public static final int SHADOW_DYNAMIC = 3;
    private boolean mInitialized;
    private View mColorDimOverlay;
    private Object mShadowImpl;
    private View mWrappedView;
    private boolean mRoundedCorners;
    private int mShadowType = 1;
    private float mUnfocusedZ;
    private float mFocusedZ;
    private static final Rect sTempRect = new Rect();

    public ShadowOverlayContainer(Context context) {
        this(context, null, 0);
    }

    public ShadowOverlayContainer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShadowOverlayContainer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.useStaticShadow();
        this.useDynamicShadow();
    }

    public static boolean supportsShadow() {
        return StaticShadowHelper.getInstance().supportsShadow();
    }

    public static boolean supportsDynamicShadow() {
        return ShadowHelper.getInstance().supportsDynamicShadow();
    }

    public static void prepareParentForShadow(ViewGroup parent) {
        StaticShadowHelper.getInstance().prepareParent(parent);
    }

    public void useDynamicShadow() {
        this.useDynamicShadow(this.getResources().getDimension(R.dimen.lb_material_shadow_normal_z), this.getResources().getDimension(R.dimen.lb_material_shadow_focused_z));
    }

    public void useDynamicShadow(float unfocusedZ, float focusedZ) {
        if (this.mInitialized) {
            throw new IllegalStateException("Already initialized");
        }
        if (ShadowOverlayContainer.supportsDynamicShadow()) {
            this.mShadowType = 3;
            this.mUnfocusedZ = unfocusedZ;
            this.mFocusedZ = focusedZ;
        }
    }

    public void useStaticShadow() {
        if (this.mInitialized) {
            throw new IllegalStateException("Already initialized");
        }
        if (ShadowOverlayContainer.supportsShadow()) {
            this.mShadowType = 2;
        }
    }

    public int getShadowType() {
        return this.mShadowType;
    }

    @Deprecated
    public void initialize(boolean hasShadow, boolean hasColorDimOverlay) {
        this.initialize(hasShadow, hasColorDimOverlay, true);
    }

    public void initialize(boolean hasShadow, boolean hasColorDimOverlay, boolean roundedCorners) {
        if (this.mInitialized) {
            throw new IllegalStateException();
        }
        this.mInitialized = true;
        if (hasShadow) {
            switch (this.mShadowType) {
                case 3: {
                    this.mShadowImpl = ShadowHelper.getInstance().addDynamicShadow(this, this.mUnfocusedZ, this.mFocusedZ, roundedCorners);
                    break;
                }
                case 2: {
                    this.mShadowImpl = StaticShadowHelper.getInstance().addStaticShadow(this, roundedCorners);
                }
            }
        }
        this.mRoundedCorners = roundedCorners;
        if (hasColorDimOverlay) {
            this.mColorDimOverlay = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.lb_card_color_overlay, (ViewGroup)this, false);
            this.addView(this.mColorDimOverlay);
            if (roundedCorners) {
                RoundedRectHelper.getInstance().setClipToRoundedOutline(this.mColorDimOverlay, true);
            }
        }
    }

    public void setShadowFocusLevel(float level) {
        if (this.mShadowImpl != null) {
            if (level < 0.0f) {
                level = 0.0f;
            } else if (level > 1.0f) {
                level = 1.0f;
            }
            switch (this.mShadowType) {
                case 3: {
                    ShadowHelper.getInstance().setShadowFocusLevel(this.mShadowImpl, level);
                    break;
                }
                case 2: {
                    StaticShadowHelper.getInstance().setShadowFocusLevel(this.mShadowImpl, level);
                }
            }
        }
    }

    public void setOverlayColor(int overlayColor) {
        if (this.mColorDimOverlay != null) {
            this.mColorDimOverlay.setBackgroundColor(overlayColor);
        }
    }

    public void wrap(View view) {
        if (!this.mInitialized || this.mWrappedView != null) {
            throw new IllegalStateException();
        }
        if (this.mColorDimOverlay != null) {
            this.addView(view, this.indexOfChild(this.mColorDimOverlay));
        } else {
            this.addView(view);
        }
        this.mWrappedView = view;
        if (this.mRoundedCorners) {
            RoundedRectHelper.getInstance().setClipToRoundedOutline(this.mWrappedView, true);
        }
    }

    public View getWrappedView() {
        return this.mWrappedView;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mWrappedView == null) {
            throw new IllegalStateException();
        }
        ViewGroup.LayoutParams lp = this.mWrappedView.getLayoutParams();
        int childWidthMeasureSpec = lp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)0x40000000) : ShadowOverlayContainer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)lp.width);
        int childHeightMeasureSpec = lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)heightMeasureSpec), (int)0x40000000) : ShadowOverlayContainer.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)lp.height);
        this.mWrappedView.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        int measuredWidth = this.mWrappedView.getMeasuredWidth();
        int measuredHeight = this.mWrappedView.getMeasuredHeight();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child == this.mWrappedView) continue;
            lp = child.getLayoutParams();
            childWidthMeasureSpec = lp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)measuredWidth, (int)0x40000000) : ShadowOverlayContainer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)lp.width);
            childHeightMeasureSpec = lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)measuredHeight, (int)0x40000000) : ShadowOverlayContainer.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            child.layout(0, 0, width, height);
        }
        if (this.mWrappedView != null) {
            ShadowOverlayContainer.sTempRect.left = (int)this.mWrappedView.getPivotX();
            ShadowOverlayContainer.sTempRect.top = (int)this.mWrappedView.getPivotY();
            this.offsetDescendantRectToMyCoords(this.mWrappedView, sTempRect);
            this.setPivotX(ShadowOverlayContainer.sTempRect.left);
            this.setPivotY(ShadowOverlayContainer.sTempRect.top);
        }
    }
}

