/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.PresenterSelector;
import android.util.SparseArray;

public class SparseArrayObjectAdapter
extends ObjectAdapter {
    private SparseArray<Object> mItems = new SparseArray();

    public SparseArrayObjectAdapter(PresenterSelector presenterSelector) {
        super(presenterSelector);
    }

    public SparseArrayObjectAdapter(Presenter presenter) {
        super(presenter);
    }

    public SparseArrayObjectAdapter() {
    }

    @Override
    public int size() {
        return this.mItems.size();
    }

    @Override
    public Object get(int position) {
        return this.mItems.valueAt(position);
    }

    public int indexOf(Object item) {
        return this.mItems.indexOfValue(item);
    }

    public int indexOf(int key) {
        return this.mItems.indexOfKey(key);
    }

    public void notifyArrayItemRangeChanged(int positionStart, int itemCount) {
        this.notifyItemRangeChanged(positionStart, itemCount);
    }

    public void set(int key, Object item) {
        int index = this.mItems.indexOfKey(key);
        if (index >= 0) {
            if (this.mItems.valueAt(index) != item) {
                this.mItems.setValueAt(index, item);
                this.notifyItemRangeChanged(index, 1);
            }
        } else {
            this.mItems.append(key, item);
            index = this.mItems.indexOfKey(key);
            this.notifyItemRangeInserted(index, 1);
        }
    }

    public void clear(int key) {
        int index = this.mItems.indexOfKey(key);
        if (index >= 0) {
            this.mItems.removeAt(index);
            this.notifyItemRangeRemoved(index, 1);
        }
    }

    public void clear() {
        int itemCount = this.mItems.size();
        if (itemCount == 0) {
            return;
        }
        this.mItems.clear();
        this.notifyItemRangeRemoved(0, itemCount);
    }

    public Object lookup(int key) {
        return this.mItems.get(key);
    }
}

