/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.os.Build;
import android.support.v17.leanback.widget.ShadowHelperJbmr2;
import android.view.ViewGroup;

final class StaticShadowHelper {
    static final StaticShadowHelper sInstance = new StaticShadowHelper();
    boolean mSupportsShadow;
    ShadowHelperVersionImpl mImpl;

    private StaticShadowHelper() {
        if (Build.VERSION.SDK_INT >= 18) {
            this.mSupportsShadow = true;
            this.mImpl = new ShadowHelperJbmr2Impl();
        } else {
            this.mSupportsShadow = false;
            this.mImpl = new ShadowHelperStubImpl();
        }
    }

    public static StaticShadowHelper getInstance() {
        return sInstance;
    }

    public boolean supportsShadow() {
        return this.mSupportsShadow;
    }

    public void prepareParent(ViewGroup parent) {
        this.mImpl.prepareParent(parent);
    }

    public Object addStaticShadow(ViewGroup shadowContainer, boolean roundedCorners) {
        return this.mImpl.addStaticShadow(shadowContainer, roundedCorners);
    }

    public void setShadowFocusLevel(Object impl, float level) {
        this.mImpl.setShadowFocusLevel(impl, level);
    }

    private static final class ShadowHelperJbmr2Impl
    implements ShadowHelperVersionImpl {
        private ShadowHelperJbmr2Impl() {
        }

        @Override
        public void prepareParent(ViewGroup parent) {
            ShadowHelperJbmr2.prepareParent(parent);
        }

        @Override
        public Object addStaticShadow(ViewGroup shadowContainer, boolean roundedCorners) {
            return ShadowHelperJbmr2.addShadow(shadowContainer);
        }

        @Override
        public void setShadowFocusLevel(Object impl, float level) {
            ShadowHelperJbmr2.setShadowFocusLevel(impl, level);
        }
    }

    private static final class ShadowHelperStubImpl
    implements ShadowHelperVersionImpl {
        private ShadowHelperStubImpl() {
        }

        @Override
        public void prepareParent(ViewGroup parent) {
        }

        @Override
        public Object addStaticShadow(ViewGroup shadowContainer, boolean roundedCorners) {
            return null;
        }

        @Override
        public void setShadowFocusLevel(Object impl, float level) {
        }
    }

    static interface ShadowHelperVersionImpl {
        public void prepareParent(ViewGroup var1);

        public Object addStaticShadow(ViewGroup var1, boolean var2);

        public void setShadowFocusLevel(Object var1, float var2);
    }
}

