/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.support.v17.leanback.R;
import android.text.SpannableStringBuilder;
import android.text.SpannedString;
import android.text.style.ForegroundColorSpan;
import android.text.style.ReplacementSpan;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.EditText;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class StreamingTextView
extends EditText {
    private static final boolean DEBUG = false;
    private static final String TAG = "StreamingTextView";
    private static final float TEXT_DOT_SCALE = 1.3f;
    private static final boolean DOTS_FOR_STABLE = false;
    private static final boolean DOTS_FOR_PENDING = true;
    private static final boolean ANIMATE_DOTS_FOR_PENDING = true;
    private static final long STREAM_UPDATE_DELAY_MILLIS = 50L;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\S+");
    private static final Property<StreamingTextView, Integer> STREAM_POSITION_PROPERTY = new Property<StreamingTextView, Integer>(Integer.class, "streamPosition"){

        public Integer get(StreamingTextView view) {
            return view.getStreamPosition();
        }

        public void set(StreamingTextView view, Integer value) {
            view.setStreamPosition(value);
        }
    };
    private final Random mRandom = new Random();
    private Bitmap mOneDot;
    private Bitmap mTwoDot;
    private int mStreamPosition;
    private ObjectAnimator mStreamingAnimation;

    public StreamingTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public StreamingTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mOneDot = this.getScaledBitmap(R.drawable.lb_text_dot_one, 1.3f);
        this.mTwoDot = this.getScaledBitmap(R.drawable.lb_text_dot_two, 1.3f);
        this.reset();
    }

    private Bitmap getScaledBitmap(int resourceId, float scaled) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resourceId);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((float)bitmap.getWidth() * scaled)), (int)((int)((float)bitmap.getHeight() * scaled)), (boolean)false);
    }

    public void reset() {
        this.mStreamPosition = -1;
        this.cancelStreamAnimation();
        this.setText("");
    }

    public void updateRecognizedText(String stableText, String pendingText) {
        if (stableText == null) {
            stableText = "";
        }
        SpannableStringBuilder displayText = new SpannableStringBuilder((CharSequence)stableText);
        if (pendingText != null) {
            int pendingTextStart = displayText.length();
            displayText.append((CharSequence)pendingText);
            this.addDottySpans(displayText, pendingText, pendingTextStart);
        }
        this.mStreamPosition = Math.max(stableText.length(), this.mStreamPosition);
        this.updateText((CharSequence)new SpannedString((CharSequence)displayText));
        this.startStreamAnimation();
    }

    private int getStreamPosition() {
        return this.mStreamPosition;
    }

    private void setStreamPosition(int streamPosition) {
        this.mStreamPosition = streamPosition;
        this.invalidate();
    }

    private void startStreamAnimation() {
        this.cancelStreamAnimation();
        int pos = this.getStreamPosition();
        int totalLen = this.length();
        int animLen = totalLen - pos;
        if (animLen > 0) {
            if (this.mStreamingAnimation == null) {
                this.mStreamingAnimation = new ObjectAnimator();
                this.mStreamingAnimation.setTarget((Object)this);
                this.mStreamingAnimation.setProperty(STREAM_POSITION_PROPERTY);
            }
            this.mStreamingAnimation.setIntValues(new int[]{pos, totalLen});
            this.mStreamingAnimation.setDuration(50L * (long)animLen);
            this.mStreamingAnimation.start();
        }
    }

    private void cancelStreamAnimation() {
        if (this.mStreamingAnimation != null) {
            this.mStreamingAnimation.cancel();
        }
    }

    private void addDottySpans(SpannableStringBuilder displayText, String text, int textStart) {
        Matcher m = SPLIT_PATTERN.matcher(text);
        while (m.find()) {
            int wordStart = textStart + m.start();
            int wordEnd = textStart + m.end();
            DottySpan span = new DottySpan(text.charAt(m.start()), wordStart);
            displayText.setSpan((Object)span, wordStart, wordEnd, 33);
        }
    }

    private void addColorSpan(SpannableStringBuilder displayText, int color2, String text, int textStart) {
        ForegroundColorSpan span = new ForegroundColorSpan(color2);
        int start = textStart;
        int end = textStart + text.length();
        displayText.setSpan((Object)span, start, end, 33);
    }

    public void setFinalRecognizedText(CharSequence finalText) {
        this.updateText(finalText);
    }

    private void updateText(CharSequence displayText) {
        this.setText(displayText);
        this.bringPointIntoView(this.length());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)StreamingTextView.class.getCanonicalName());
    }

    public static boolean isLayoutRtl(View view) {
        if (Build.VERSION.SDK_INT >= 17) {
            return 1 == view.getLayoutDirection();
        }
        return false;
    }

    public void updateRecognizedText(String stableText, List<Float> rmsValues) {
    }

    private class DottySpan
    extends ReplacementSpan {
        private final int mSeed;
        private final int mPosition;

        public DottySpan(int seed, int pos) {
            this.mSeed = seed;
            this.mPosition = pos;
        }

        public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
            int width = (int)paint.measureText(text, start, end);
            int dotWidth = StreamingTextView.this.mOneDot.getWidth();
            int sliceWidth = 2 * dotWidth;
            int sliceCount = width / sliceWidth;
            int excess = width % sliceWidth;
            int prop = excess / 2;
            boolean rtl = StreamingTextView.isLayoutRtl((View)StreamingTextView.this);
            StreamingTextView.this.mRandom.setSeed(this.mSeed);
            int oldAlpha = paint.getAlpha();
            for (int i = 0; i < sliceCount && this.mPosition + i < StreamingTextView.this.mStreamPosition; ++i) {
                float left = i * sliceWidth + prop + dotWidth / 2;
                float dotLeft = rtl ? x + (float)width - left - (float)dotWidth : x + left;
                paint.setAlpha((StreamingTextView.this.mRandom.nextInt(4) + 1) * 63);
                if (StreamingTextView.this.mRandom.nextBoolean()) {
                    canvas.drawBitmap(StreamingTextView.this.mTwoDot, dotLeft, (float)(y - StreamingTextView.this.mTwoDot.getHeight()), paint);
                    continue;
                }
                canvas.drawBitmap(StreamingTextView.this.mOneDot, dotLeft, (float)(y - StreamingTextView.this.mOneDot.getHeight()), paint);
            }
            paint.setAlpha(oldAlpha);
        }

        public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fontMetricsInt) {
            return (int)paint.measureText(text, start, end);
        }
    }
}

