/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.widget;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.util.LruCache;
import android.util.SparseArray;
import android.view.View;
import java.util.Map;

class ViewsStateBundle {
    public static final int LIMIT_DEFAULT = 100;
    public static final int UNLIMITED = Integer.MAX_VALUE;
    private int mSavePolicy = 0;
    private int mLimitNumber = 100;
    private LruCache<String, SparseArray<Parcelable>> mChildStates;

    public void clear() {
        if (this.mChildStates != null) {
            this.mChildStates.evictAll();
        }
    }

    public void remove(int id2) {
        if (this.mChildStates != null && this.mChildStates.size() != 0) {
            this.mChildStates.remove((Object)ViewsStateBundle.getSaveStatesKey(id2));
        }
    }

    public final Bundle saveAsBundle() {
        if (this.mChildStates == null || this.mChildStates.size() == 0) {
            return null;
        }
        Map snapshot = this.mChildStates.snapshot();
        Bundle bundle = new Bundle();
        for (Map.Entry e : snapshot.entrySet()) {
            bundle.putSparseParcelableArray((String)e.getKey(), (SparseArray)e.getValue());
        }
        return bundle;
    }

    public final void loadFromBundle(Bundle savedBundle) {
        if (this.mChildStates != null && savedBundle != null) {
            this.mChildStates.evictAll();
            for (String key : savedBundle.keySet()) {
                this.mChildStates.put((Object)key, (Object)savedBundle.getSparseParcelableArray(key));
            }
        }
    }

    public final int getSavePolicy() {
        return this.mSavePolicy;
    }

    public final int getLimitNumber() {
        return this.mLimitNumber;
    }

    public final void setSavePolicy(int savePolicy) {
        this.mSavePolicy = savePolicy;
        this.applyPolicyChanges();
    }

    public final void setLimitNumber(int limitNumber) {
        this.mLimitNumber = limitNumber;
        this.applyPolicyChanges();
    }

    protected void applyPolicyChanges() {
        if (this.mSavePolicy == 2) {
            if (this.mLimitNumber <= 0) {
                throw new IllegalArgumentException();
            }
            if (this.mChildStates == null || this.mChildStates.maxSize() != this.mLimitNumber) {
                this.mChildStates = new LruCache(this.mLimitNumber);
            }
        } else if (this.mSavePolicy == 3 || this.mSavePolicy == 1) {
            if (this.mChildStates == null || this.mChildStates.maxSize() != Integer.MAX_VALUE) {
                this.mChildStates = new LruCache(Integer.MAX_VALUE);
            }
        } else {
            this.mChildStates = null;
        }
    }

    public final void loadView(View view, int id2) {
        String key;
        SparseArray container;
        if (this.mChildStates != null && (container = (SparseArray)this.mChildStates.remove((Object)(key = ViewsStateBundle.getSaveStatesKey(id2)))) != null) {
            view.restoreHierarchyState(container);
        }
    }

    protected final void saveViewUnchecked(View view, int id2) {
        if (this.mChildStates != null) {
            String key = ViewsStateBundle.getSaveStatesKey(id2);
            SparseArray container = new SparseArray();
            view.saveHierarchyState(container);
            this.mChildStates.put((Object)key, (Object)container);
        }
    }

    public final Bundle saveOnScreenView(Bundle bundle, View view, int id2) {
        if (this.mSavePolicy != 0) {
            String key = ViewsStateBundle.getSaveStatesKey(id2);
            SparseArray container = new SparseArray();
            view.saveHierarchyState(container);
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putSparseParcelableArray(key, container);
        }
        return bundle;
    }

    public final void saveOffscreenView(View view, int id2) {
        switch (this.mSavePolicy) {
            case 2: 
            case 3: {
                this.saveViewUnchecked(view, id2);
                break;
            }
            case 1: {
                this.remove(id2);
                break;
            }
        }
    }

    static String getSaveStatesKey(int id2) {
        return Integer.toString(id2);
    }
}

