/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.graphics;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.AsyncTask;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.os.AsyncTaskCompat;
import android.support.v7.graphics.ColorCutQuantizer;
import android.support.v7.graphics.DefaultGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Palette {
    private static final int DEFAULT_RESIZE_BITMAP_MAX_DIMENSION = 192;
    private static final int DEFAULT_CALCULATE_NUMBER_COLORS = 16;
    private static final float MIN_CONTRAST_TITLE_TEXT = 3.0f;
    private static final float MIN_CONTRAST_BODY_TEXT = 4.5f;
    private static final String LOG_TAG = "Palette";
    private static final boolean LOG_TIMINGS = false;
    private final List<Swatch> mSwatches;
    private final Generator mGenerator;

    public static Builder from(Bitmap bitmap) {
        return new Builder(bitmap);
    }

    public static Palette from(List<Swatch> swatches) {
        return new Builder(swatches).generate();
    }

    @Deprecated
    public static Palette generate(Bitmap bitmap) {
        return Palette.from(bitmap).generate();
    }

    @Deprecated
    public static Palette generate(Bitmap bitmap, int numColors) {
        return Palette.from(bitmap).maximumColorCount(numColors).generate();
    }

    @Deprecated
    public static AsyncTask<Bitmap, Void, Palette> generateAsync(Bitmap bitmap, PaletteAsyncListener listener) {
        return Palette.from(bitmap).generate(listener);
    }

    @Deprecated
    public static AsyncTask<Bitmap, Void, Palette> generateAsync(Bitmap bitmap, int numColors, PaletteAsyncListener listener) {
        return Palette.from(bitmap).maximumColorCount(numColors).generate(listener);
    }

    private Palette(List<Swatch> swatches, Generator generator) {
        this.mSwatches = swatches;
        this.mGenerator = generator;
    }

    public List<Swatch> getSwatches() {
        return Collections.unmodifiableList(this.mSwatches);
    }

    public Swatch getVibrantSwatch() {
        return this.mGenerator.getVibrantSwatch();
    }

    public Swatch getLightVibrantSwatch() {
        return this.mGenerator.getLightVibrantSwatch();
    }

    public Swatch getDarkVibrantSwatch() {
        return this.mGenerator.getDarkVibrantSwatch();
    }

    public Swatch getMutedSwatch() {
        return this.mGenerator.getMutedSwatch();
    }

    public Swatch getLightMutedSwatch() {
        return this.mGenerator.getLightMutedSwatch();
    }

    public Swatch getDarkMutedSwatch() {
        return this.mGenerator.getDarkMutedSwatch();
    }

    public int getVibrantColor(int defaultColor) {
        Swatch swatch = this.getVibrantSwatch();
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    public int getLightVibrantColor(int defaultColor) {
        Swatch swatch = this.getLightVibrantSwatch();
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    public int getDarkVibrantColor(int defaultColor) {
        Swatch swatch = this.getDarkVibrantSwatch();
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    public int getMutedColor(int defaultColor) {
        Swatch swatch = this.getMutedSwatch();
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    public int getLightMutedColor(int defaultColor) {
        Swatch swatch = this.getLightMutedSwatch();
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    public int getDarkMutedColor(int defaultColor) {
        Swatch swatch = this.getDarkMutedSwatch();
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    private static Bitmap scaleBitmapDown(Bitmap bitmap, int targetMaxDimension) {
        int maxDimension = Math.max(bitmap.getWidth(), bitmap.getHeight());
        if (maxDimension <= targetMaxDimension) {
            return bitmap;
        }
        float scaleRatio = (float)targetMaxDimension / (float)maxDimension;
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)Math.round((float)bitmap.getWidth() * scaleRatio), (int)Math.round((float)bitmap.getHeight() * scaleRatio), (boolean)false);
    }

    static abstract class Generator {
        Generator() {
        }

        public abstract void generate(List<Swatch> var1);

        public Swatch getVibrantSwatch() {
            return null;
        }

        public Swatch getLightVibrantSwatch() {
            return null;
        }

        public Swatch getDarkVibrantSwatch() {
            return null;
        }

        public Swatch getMutedSwatch() {
            return null;
        }

        public Swatch getLightMutedSwatch() {
            return null;
        }

        public Swatch getDarkMutedSwatch() {
            return null;
        }
    }

    public static final class Builder {
        private List<Swatch> mSwatches;
        private Bitmap mBitmap;
        private int mMaxColors = 16;
        private int mResizeMaxDimension = 192;
        private Generator mGenerator;

        public Builder(Bitmap bitmap) {
            if (bitmap == null || bitmap.isRecycled()) {
                throw new IllegalArgumentException("Bitmap is not valid");
            }
            this.mBitmap = bitmap;
        }

        public Builder(List<Swatch> swatches) {
            if (swatches == null || swatches.isEmpty()) {
                throw new IllegalArgumentException("List of Swatches is not valid");
            }
            this.mSwatches = swatches;
        }

        Builder generator(Generator generator) {
            this.mGenerator = generator;
            return this;
        }

        public Builder maximumColorCount(int colors) {
            this.mMaxColors = colors;
            return this;
        }

        public Builder resizeBitmapSize(int maxDimension) {
            this.mResizeMaxDimension = maxDimension;
            return this;
        }

        public Palette generate() {
            List<Swatch> swatches;
            Object logger = null;
            if (this.mBitmap != null) {
                if (this.mResizeMaxDimension <= 0) {
                    throw new IllegalArgumentException("Minimum dimension size for resizing should should be >= 1");
                }
                Bitmap scaledBitmap = Palette.scaleBitmapDown(this.mBitmap, this.mResizeMaxDimension);
                if (logger != null) {
                    logger.addSplit("Processed Bitmap");
                }
                ColorCutQuantizer quantizer = ColorCutQuantizer.fromBitmap(scaledBitmap, this.mMaxColors);
                if (scaledBitmap != this.mBitmap) {
                    scaledBitmap.recycle();
                }
                swatches = quantizer.getQuantizedColors();
                if (logger != null) {
                    logger.addSplit("Color quantization completed");
                }
            } else {
                swatches = this.mSwatches;
            }
            if (this.mGenerator == null) {
                this.mGenerator = new DefaultGenerator();
            }
            this.mGenerator.generate(swatches);
            if (logger != null) {
                logger.addSplit("Generator.generate() completed");
            }
            Palette p = new Palette(swatches, this.mGenerator);
            if (logger != null) {
                logger.addSplit("Created Palette");
                logger.dumpToLog();
            }
            return p;
        }

        public AsyncTask<Bitmap, Void, Palette> generate(final PaletteAsyncListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener can not be null");
            }
            return AsyncTaskCompat.executeParallel((AsyncTask)new AsyncTask<Bitmap, Void, Palette>(){

                protected Palette doInBackground(Bitmap ... params) {
                    return Builder.this.generate();
                }

                protected void onPostExecute(Palette colorExtractor) {
                    listener.onGenerated(colorExtractor);
                }
            }, (Object[])new Bitmap[]{this.mBitmap});
        }
    }

    public static final class Swatch {
        private final int mRed;
        private final int mGreen;
        private final int mBlue;
        private final int mRgb;
        private final int mPopulation;
        private boolean mGeneratedTextColors;
        private int mTitleTextColor;
        private int mBodyTextColor;
        private float[] mHsl;

        public Swatch(int color, int population) {
            this.mRed = Color.red((int)color);
            this.mGreen = Color.green((int)color);
            this.mBlue = Color.blue((int)color);
            this.mRgb = color;
            this.mPopulation = population;
        }

        Swatch(int red, int green, int blue, int population) {
            this.mRed = red;
            this.mGreen = green;
            this.mBlue = blue;
            this.mRgb = Color.rgb((int)red, (int)green, (int)blue);
            this.mPopulation = population;
        }

        public int getRgb() {
            return this.mRgb;
        }

        public float[] getHsl() {
            if (this.mHsl == null) {
                this.mHsl = new float[3];
                ColorUtils.RGBToHSL((int)this.mRed, (int)this.mGreen, (int)this.mBlue, (float[])this.mHsl);
            }
            return this.mHsl;
        }

        public int getPopulation() {
            return this.mPopulation;
        }

        public int getTitleTextColor() {
            this.ensureTextColorsGenerated();
            return this.mTitleTextColor;
        }

        public int getBodyTextColor() {
            this.ensureTextColorsGenerated();
            return this.mBodyTextColor;
        }

        private void ensureTextColorsGenerated() {
            if (!this.mGeneratedTextColors) {
                int lightBodyAlpha = ColorUtils.calculateMinimumAlpha((int)-1, (int)this.mRgb, (float)4.5f);
                int lightTitleAlpha = ColorUtils.calculateMinimumAlpha((int)-1, (int)this.mRgb, (float)3.0f);
                if (lightBodyAlpha != -1 && lightTitleAlpha != -1) {
                    this.mBodyTextColor = ColorUtils.setAlphaComponent((int)-1, (int)lightBodyAlpha);
                    this.mTitleTextColor = ColorUtils.setAlphaComponent((int)-1, (int)lightTitleAlpha);
                    this.mGeneratedTextColors = true;
                    return;
                }
                int darkBodyAlpha = ColorUtils.calculateMinimumAlpha((int)-16777216, (int)this.mRgb, (float)4.5f);
                int darkTitleAlpha = ColorUtils.calculateMinimumAlpha((int)-16777216, (int)this.mRgb, (float)3.0f);
                if (darkBodyAlpha != -1 && darkBodyAlpha != -1) {
                    this.mBodyTextColor = ColorUtils.setAlphaComponent((int)-16777216, (int)darkBodyAlpha);
                    this.mTitleTextColor = ColorUtils.setAlphaComponent((int)-16777216, (int)darkTitleAlpha);
                    this.mGeneratedTextColors = true;
                    return;
                }
                this.mBodyTextColor = lightBodyAlpha != -1 ? ColorUtils.setAlphaComponent((int)-1, (int)lightBodyAlpha) : ColorUtils.setAlphaComponent((int)-16777216, (int)darkBodyAlpha);
                this.mTitleTextColor = lightTitleAlpha != -1 ? ColorUtils.setAlphaComponent((int)-1, (int)lightTitleAlpha) : ColorUtils.setAlphaComponent((int)-16777216, (int)darkTitleAlpha);
                this.mGeneratedTextColors = true;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [RGB: #" + Integer.toHexString(this.getRgb()) + ']' + " [HSL: " + Arrays.toString(this.getHsl()) + ']' + " [Population: " + this.mPopulation + ']' + " [Title Text: #" + Integer.toHexString(this.getTitleTextColor()) + ']' + " [Body Text: #" + Integer.toHexString(this.getBodyTextColor()) + ']';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Swatch swatch = (Swatch)o;
            return this.mPopulation == swatch.mPopulation && this.mRgb == swatch.mRgb;
        }

        public int hashCode() {
            return 31 * this.mRgb + this.mPopulation;
        }
    }

    public static interface PaletteAsyncListener {
        public void onGenerated(Palette var1);
    }
}

