/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.ir.Constant;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Local;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.expr.ArrayExpr;
import com.googlecode.dex2jar.ir.expr.CastExpr;
import com.googlecode.dex2jar.ir.expr.FieldExpr;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.NewExpr;
import com.googlecode.dex2jar.ir.expr.NewMutiArrayExpr;
import com.googlecode.dex2jar.ir.expr.RefExpr;
import com.googlecode.dex2jar.ir.expr.TypeExpr;
import com.googlecode.dex2jar.ir.stmt.JumpStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.LookupSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.TableSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.UnopStmt;
import com.googlecode.dex2jar.ir.ts.LiveAnalyze;
import com.googlecode.dex2jar.ir.ts.LocalType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class IrMethod2AsmMethod
implements Opcodes {
    private static final boolean DEBUG = false;

    private void reIndexLocal(IrMethod ir) {
        LiveAnalyze la = new LiveAnalyze(ir);
        List phis = la.analyze();
        int index = 0;
        if ((ir.access & 8) == 0) {
            ++index;
        }
        int localSize = ir.locals.size();
        int[] parameterIdx = new int[ir.args.length];
        for (int i = 0; i < ir.args.length; ++i) {
            parameterIdx[i] = index;
            index += ir.args[i].getSize();
        }
        int[] maps = new int[localSize];
        for (int i = 0; i < localSize; ++i) {
            maps[i] = -1;
        }
        Local _thisLocal = null;
        Local[] _parameterLocals = new Local[ir.args.length];
        block6: for (Stmt stmt = ir.stmts.getFirst(); stmt != null; stmt = stmt.getNext()) {
            if (stmt.st != Stmt.ST.IDENTITY && stmt.st != Stmt.ST.ASSIGN) continue;
            Stmt.E2Stmt e2 = (Stmt.E2Stmt)stmt;
            switch (e2.op2.value.vt) {
                case THIS_REF: {
                    Local local = (Local)e2.op1.value;
                    maps[local._ls_index] = 0;
                    _thisLocal = local;
                    continue block6;
                }
                case PARAMETER_REF: {
                    Local local = (Local)e2.op1.value;
                    int i = ((RefExpr)e2.op2.value).parameterIndex;
                    maps[local._ls_index] = parameterIdx[i];
                    _parameterLocals[i] = local;
                }
            }
        }
        this.createGraph(ir, phis.size());
        if ((ir.access & 8) == 0 && _thisLocal != null) {
            this.markPhiNeverReuse(phis, _thisLocal);
        }
        for (Local local : _parameterLocals) {
            if (local == null) continue;
            this.markPhiNeverReuse(phis, local);
        }
        this.gradyColoring(phis, maps);
        for (Local local : ir.locals) {
            local._ls_index = maps[local._ls_index];
        }
    }

    private void markPhiNeverReuse(List<LiveAnalyze.Phi> phis, Local local) {
        LiveAnalyze.Phi nPhi = null;
        for (LiveAnalyze.Phi phi : phis) {
            if (phi.local != local) continue;
            nPhi = phi;
            break;
        }
        if (nPhi == null) {
            nPhi = new LiveAnalyze.Phi();
            nPhi.local = local;
        }
        for (LiveAnalyze.Phi phi : phis) {
            if (phi == nPhi) continue;
            phi.sets.add(nPhi);
            nPhi.sets.add(phi);
        }
    }

    private int findNextColor(LiveAnalyze.Phi v, int n, int max, int[] maps) {
        BitSet bs = new BitSet(max);
        bs.set(0, max);
        for (LiveAnalyze.Phi one : v.sets) {
            int x = maps[one.local._ls_index];
            if (x < 0) continue;
            bs.clear(x);
            if (IrMethod2AsmMethod.sizeOf(one) <= 1) continue;
            bs.clear(x + 1);
        }
        boolean wide = IrMethod2AsmMethod.sizeOf(v) > 1;
        int i = bs.nextSetBit(n);
        while (i >= 0) {
            if (wide) {
                if (i + 1 < bs.length() && bs.get(i + 1)) {
                    return i;
                }
            } else {
                return i;
            }
            i = bs.nextSetBit(i + 1);
        }
        return -1;
    }

    private void gradyColoring(List<LiveAnalyze.Phi> phis, int[] maps) {
        if (phis.size() <= 0) {
            return;
        }
        Collections.sort(phis, new Comparator<LiveAnalyze.Phi>(){

            @Override
            public int compare(LiveAnalyze.Phi o1, LiveAnalyze.Phi o2) {
                int r = o2.sets.size() - o1.sets.size();
                return r == 0 ? IrMethod2AsmMethod.sizeOf(o2) - IrMethod2AsmMethod.sizeOf(o1) : r;
            }
        });
        LiveAnalyze.Phi first = phis.get(0);
        int size = IrMethod2AsmMethod.sizeOf(first);
        for (LiveAnalyze.Phi p : first.sets) {
            size += IrMethod2AsmMethod.sizeOf(p);
        }
        BitSet toColor = new BitSet(phis.size());
        for (int i = 0; i < phis.size(); ++i) {
            LiveAnalyze.Phi p = phis.get(i);
            if (maps[p.local._ls_index] >= 0) continue;
            toColor.set(i);
        }
        while (!this.doColor(0, toColor, phis, size, maps)) {
            ++size;
        }
    }

    private boolean doColor(int idx, BitSet toColor, List<LiveAnalyze.Phi> phis, int size, int[] maps) {
        int x = toColor.nextSetBit(idx);
        if (x < 0) {
            return true;
        }
        LiveAnalyze.Phi phi = phis.get(x);
        int i = this.findNextColor(phi, 0, size, maps);
        while (i >= 0) {
            maps[phi.local._ls_index] = i;
            if (this.doColor(x + 1, toColor, phis, size, maps)) {
                return true;
            }
            maps[phi.local._ls_index] = -1;
            i = this.findNextColor(phi, i + 1, size, maps);
        }
        return false;
    }

    private static int sizeOf(LiveAnalyze.Phi p) {
        return LocalType.typeOf((Value)p.local).getSize();
    }

    private void createGraph(IrMethod ir, int localSize) {
        ArrayList<LiveAnalyze.Phi> tmp = new ArrayList<LiveAnalyze.Phi>(localSize);
        for (Stmt p = ir.stmts.getFirst(); p != null; p = p.getNext()) {
            tmp.clear();
            LiveAnalyze.Phi[] frame = (LiveAnalyze.Phi[])p._ls_forward_frame;
            p._ls_forward_frame = null;
            if (frame != null) {
                for (int i = 0; i < frame.length; ++i) {
                    LiveAnalyze.Phi r = frame[i];
                    if (r == null) continue;
                    tmp.add(r);
                }
            }
            for (int i = 0; i < tmp.size() - 1; ++i) {
                LiveAnalyze.Phi a = (LiveAnalyze.Phi)tmp.get(i);
                for (int j = i + 1; j < tmp.size(); ++j) {
                    LiveAnalyze.Phi b = (LiveAnalyze.Phi)tmp.get(j);
                    if (a == b) continue;
                    a.sets.add(b);
                    b.sets.add(a);
                }
            }
        }
    }

    public void convert(IrMethod ir, MethodVisitor asm) {
        this.reIndexLocal(ir);
        this.reBuildInstructions(ir, asm);
        this.reBuildTryCatchBlocks(ir, asm);
    }

    private void reBuildTryCatchBlocks(IrMethod ir, MethodVisitor asm) {
        for (Trap trap : ir.traps) {
            asm.visitTryCatchBlock(trap.start.label, trap.end.label, trap.handler.label, trap.type == null ? null : trap.type.getInternalName());
        }
    }

    private void reBuildInstructions(IrMethod ir, MethodVisitor asm) {
        block20: for (Stmt st : ir.stmts) {
            block0 : switch (st.st) {
                case LABEL: {
                    asm.visitLabel(((LabelStmt)st).label);
                    break;
                }
                case ASSIGN: {
                    Stmt.E2Stmt e2 = (Stmt.E2Stmt)st;
                    Value v1 = e2.op1.value;
                    Value v2 = e2.op2.value;
                    switch (v1.vt) {
                        case LOCAL: {
                            Local local = (Local)v1;
                            int i = local._ls_index;
                            boolean skipOrg = false;
                            if (LocalType.typeOf((Value)v1).equals((Object)Type.INT_TYPE)) {
                                Value.E2Expr e;
                                if (v2.vt == Value.VT.ADD) {
                                    e = (Value.E2Expr)v2;
                                    if (e.op1.value == local && e.op2.value.vt == Value.VT.CONSTANT || e.op2.value == local && e.op1.value.vt == Value.VT.CONSTANT) {
                                        int increment = (Integer)((Constant)(e.op1.value == local ? e.op2.value : e.op1.value)).value;
                                        asm.visitIincInsn(i, increment);
                                        skipOrg = true;
                                    }
                                } else if (v2.vt == Value.VT.SUB) {
                                    e = (Value.E2Expr)v2;
                                    if (e.op1.value == local && e.op2.value.vt == Value.VT.CONSTANT) {
                                        int increment = -((Integer)((Constant)e.op2.value).value).intValue();
                                        asm.visitIincInsn(i, increment);
                                        skipOrg = true;
                                    }
                                }
                            }
                            if (skipOrg) break;
                            IrMethod2AsmMethod.accept(v2, asm);
                            if (i >= 0) {
                                if (local._ls_read_count == 0) {
                                    asm.visitInsn(LocalType.typeOf((Value)v1).getSize() == 2 ? 88 : 87);
                                    break block0;
                                }
                                asm.visitVarInsn(LocalType.typeOf((Value)v1).getOpcode(54), i);
                                break block0;
                            }
                            if (LocalType.typeOf((Value)v1).equals((Object)Type.VOID_TYPE)) break;
                            asm.visitInsn(LocalType.typeOf((Value)v1).getSize() == 2 ? 88 : 87);
                            break block0;
                        }
                        case FIELD: {
                            FieldExpr fe = (FieldExpr)v1;
                            if (fe.op == null) {
                                IrMethod2AsmMethod.accept(v2, asm);
                                asm.visitFieldInsn(179, fe.fieldOwnerType.getInternalName(), fe.fieldName, fe.fieldType.getDescriptor());
                                break block0;
                            }
                            IrMethod2AsmMethod.accept(fe.op.value, asm);
                            IrMethod2AsmMethod.accept(v2, asm);
                            asm.visitFieldInsn(181, fe.fieldOwnerType.getInternalName(), fe.fieldName, fe.fieldType.getDescriptor());
                            break block0;
                        }
                        case ARRAY: {
                            ArrayExpr ae = (ArrayExpr)v1;
                            IrMethod2AsmMethod.accept(ae.op1.value, asm);
                            IrMethod2AsmMethod.accept(ae.op2.value, asm);
                            IrMethod2AsmMethod.accept(v2, asm);
                            Type tp1 = LocalType.typeOf((Value)ae.op1.value);
                            Type tp2 = LocalType.typeOf((Value)ae);
                            if (tp1.getSort() == 9) {
                                asm.visitInsn(Type.getType((String)tp1.getDescriptor().substring(1)).getOpcode(79));
                                break block0;
                            }
                            asm.visitInsn(tp2.getOpcode(79));
                        }
                    }
                    break;
                }
                case IDENTITY: {
                    Stmt.E2Stmt e2 = (Stmt.E2Stmt)st;
                    if (e2.op2.value.vt != Value.VT.EXCEPTION_REF) continue block20;
                    int index = ((Local)e2.op1.value)._ls_index;
                    if (index >= 0) {
                        asm.visitVarInsn(58, index);
                        break;
                    }
                    asm.visitInsn(87);
                    break;
                }
                case GOTO: {
                    asm.visitJumpInsn(167, ((JumpStmt)st).target.label);
                    break;
                }
                case IF: {
                    this.reBuildJumpInstructions((JumpStmt)st, asm);
                    break;
                }
                case LOCK: {
                    IrMethod2AsmMethod.accept(((UnopStmt)st).op.value, asm);
                    asm.visitInsn(194);
                    break;
                }
                case UNLOCK: {
                    IrMethod2AsmMethod.accept(((UnopStmt)st).op.value, asm);
                    asm.visitInsn(195);
                    break;
                }
                case NOP: {
                    break;
                }
                case RETURN: {
                    Value v = ((UnopStmt)st).op.value;
                    IrMethod2AsmMethod.accept(v, asm);
                    asm.visitInsn(LocalType.typeOf((Value)v).getOpcode(172));
                    break;
                }
                case RETURN_VOID: {
                    asm.visitInsn(177);
                    break;
                }
                case LOOKUP_SWITCH: {
                    LookupSwitchStmt lss = (LookupSwitchStmt)st;
                    IrMethod2AsmMethod.accept(lss.op.value, asm);
                    Label[] targets = new Label[lss.targets.length];
                    for (int i = 0; i < targets.length; ++i) {
                        targets[i] = lss.targets[i].label;
                    }
                    asm.visitLookupSwitchInsn(lss.defaultTarget.label, lss.lookupValues, targets);
                    break;
                }
                case TABLE_SWITCH: {
                    TableSwitchStmt tss = (TableSwitchStmt)st;
                    IrMethod2AsmMethod.accept(tss.op.value, asm);
                    Label[] targets = new Label[tss.targets.length];
                    for (int i = 0; i < targets.length; ++i) {
                        targets[i] = tss.targets[i].label;
                    }
                    asm.visitTableSwitchInsn(tss.lowIndex, tss.highIndex, tss.defaultTarget.label, targets);
                    break;
                }
                case THROW: {
                    IrMethod2AsmMethod.accept(((UnopStmt)st).op.value, asm);
                    asm.visitInsn(191);
                }
            }
        }
    }

    private void reBuildJumpInstructions(JumpStmt st, MethodVisitor asm) {
        Label target = st.target.label;
        Value v = st.op.value;
        Value v1 = ((Value.E2Expr)v).op1.value;
        Value v2 = ((Value.E2Expr)v).op2.value;
        Type type = LocalType.typeOf((Value)v1);
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (v1.vt == Value.VT.CONSTANT && ((Constant)v1).value.equals(new Integer(0)) || v2.vt == Value.VT.CONSTANT && ((Constant)v2).value.equals(new Integer(0))) {
                    if (v2.vt == Value.VT.CONSTANT && ((Constant)v2).value.equals(new Integer(0))) {
                        IrMethod2AsmMethod.accept(v1, asm);
                    } else {
                        IrMethod2AsmMethod.accept(v2, asm);
                    }
                    switch (v.vt) {
                        case NE: {
                            asm.visitJumpInsn(154, target);
                            break;
                        }
                        case EQ: {
                            asm.visitJumpInsn(153, target);
                            break;
                        }
                        case GE: {
                            asm.visitJumpInsn(156, target);
                            break;
                        }
                        case GT: {
                            asm.visitJumpInsn(157, target);
                            break;
                        }
                        case LE: {
                            asm.visitJumpInsn(158, target);
                            break;
                        }
                        case LT: {
                            asm.visitJumpInsn(155, target);
                        }
                    }
                    break;
                }
                IrMethod2AsmMethod.accept(v1, asm);
                IrMethod2AsmMethod.accept(v2, asm);
                switch (v.vt) {
                    case NE: {
                        asm.visitJumpInsn(160, target);
                        break;
                    }
                    case EQ: {
                        asm.visitJumpInsn(159, target);
                        break;
                    }
                    case GE: {
                        asm.visitJumpInsn(162, target);
                        break;
                    }
                    case GT: {
                        asm.visitJumpInsn(163, target);
                        break;
                    }
                    case LE: {
                        asm.visitJumpInsn(164, target);
                        break;
                    }
                    case LT: {
                        asm.visitJumpInsn(161, target);
                    }
                }
                break;
            }
            case 9: 
            case 10: {
                if (v1.vt == Value.VT.CONSTANT && ((Constant)v1).value.equals(Constant.Null) || v2.vt == Value.VT.CONSTANT && ((Constant)v2).value.equals(Constant.Null)) {
                    if (v2.vt == Value.VT.CONSTANT && ((Constant)v2).value.equals(Constant.Null)) {
                        IrMethod2AsmMethod.accept(v1, asm);
                    } else {
                        IrMethod2AsmMethod.accept(v2, asm);
                    }
                    asm.visitJumpInsn(v.vt == Value.VT.EQ ? 198 : 199, target);
                    break;
                }
                IrMethod2AsmMethod.accept(v1, asm);
                IrMethod2AsmMethod.accept(v2, asm);
                asm.visitJumpInsn(v.vt == Value.VT.EQ ? 165 : 166, target);
            }
        }
    }

    private static void accept(Value value, MethodVisitor asm) {
        switch (value.et) {
            case E0: {
                switch (value.vt) {
                    case LOCAL: {
                        asm.visitVarInsn(LocalType.typeOf((Value)value).getOpcode(21), ((Local)value)._ls_index);
                        break;
                    }
                    case CONSTANT: {
                        Constant cst = (Constant)value;
                        if (cst.value.equals(Constant.Null)) {
                            asm.visitInsn(1);
                            break;
                        }
                        asm.visitLdcInsn(cst.value);
                        break;
                    }
                    case NEW: {
                        asm.visitTypeInsn(187, ((NewExpr)value).type.getInternalName());
                    }
                }
                break;
            }
            case E1: {
                IrMethod2AsmMethod.reBuildE1Expression((Value.E1Expr)value, asm);
                break;
            }
            case E2: {
                IrMethod2AsmMethod.reBuildE2Expression((Value.E2Expr)value, asm);
                break;
            }
            case En: {
                IrMethod2AsmMethod.reBuildEnExpression((Value.EnExpr)value, asm);
            }
        }
    }

    private static void reBuildEnExpression(Value.EnExpr value, MethodVisitor asm) {
        if (value.vt == Value.VT.INVOKE_NEW) {
            asm.visitTypeInsn(187, ((InvokeExpr)value).methodOwnerType.getInternalName());
            asm.visitInsn(89);
        }
        for (ValueBox vb : value.ops) {
            IrMethod2AsmMethod.accept(vb.value, asm);
        }
        switch (value.vt) {
            case NEW_MUTI_ARRAY: {
                NewMutiArrayExpr nmae = (NewMutiArrayExpr)value;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < nmae.dimension; ++i) {
                    sb.append('[');
                }
                sb.append(nmae.baseType.getDescriptor());
                asm.visitMultiANewArrayInsn(sb.toString(), nmae.dimension);
                break;
            }
            case INVOKE_VIRTUAL: 
            case INVOKE_INTERFACE: 
            case INVOKE_NEW: 
            case INVOKE_SPECIAL: 
            case INVOKE_STATIC: {
                int opcode;
                InvokeExpr ie = (InvokeExpr)value;
                switch (value.vt) {
                    case INVOKE_VIRTUAL: {
                        opcode = 182;
                        break;
                    }
                    case INVOKE_INTERFACE: {
                        opcode = 185;
                        break;
                    }
                    case INVOKE_NEW: 
                    case INVOKE_SPECIAL: {
                        opcode = 183;
                        break;
                    }
                    case INVOKE_STATIC: {
                        opcode = 184;
                        break;
                    }
                    default: {
                        opcode = -1;
                    }
                }
                asm.visitMethodInsn(opcode, ie.methodOwnerType.getInternalName(), ie.methodName, Type.getMethodDescriptor((Type)(ie.vt == Value.VT.INVOKE_NEW ? Type.VOID_TYPE : ie.methodReturnType), (Type[])ie.argmentTypes));
            }
        }
    }

    private static void reBuildE1Expression(Value.E1Expr e1, MethodVisitor asm) {
        if (e1.op != null) {
            IrMethod2AsmMethod.accept(e1.op.value, asm);
        }
        block0 : switch (e1.vt) {
            case FIELD: {
                FieldExpr fe = (FieldExpr)e1;
                asm.visitFieldInsn(e1.op == null ? 178 : 180, fe.fieldOwnerType.getInternalName(), fe.fieldName, fe.fieldType.getDescriptor());
                break;
            }
            case NEW_ARRAY: {
                int operand;
                TypeExpr te = (TypeExpr)e1;
                switch (te.type.getSort()) {
                    case 9: 
                    case 10: {
                        asm.visitTypeInsn(189, te.type.getInternalName());
                        break block0;
                    }
                }
                switch (te.type.getSort()) {
                    case 1: {
                        operand = 4;
                        break;
                    }
                    case 3: {
                        operand = 8;
                        break;
                    }
                    case 4: {
                        operand = 9;
                        break;
                    }
                    case 2: {
                        operand = 5;
                        break;
                    }
                    case 5: {
                        operand = 10;
                        break;
                    }
                    case 6: {
                        operand = 6;
                        break;
                    }
                    case 7: {
                        operand = 11;
                        break;
                    }
                    case 8: {
                        operand = 7;
                        break;
                    }
                    default: {
                        operand = -1;
                    }
                }
                asm.visitIntInsn(188, operand);
                break;
            }
            case CHECK_CAST: 
            case INSTANCE_OF: {
                TypeExpr te = (TypeExpr)e1;
                asm.visitTypeInsn(e1.vt == Value.VT.CHECK_CAST ? 192 : 193, te.type.getInternalName());
                break;
            }
            case CAST: {
                CastExpr te = (CastExpr)e1;
                IrMethod2AsmMethod.cast2(LocalType.typeOf((Value)e1.op.value), te.to, asm);
                break;
            }
            case LENGTH: {
                asm.visitInsn(190);
                break;
            }
            case NEG: {
                asm.visitInsn(LocalType.typeOf((Value)e1).getOpcode(116));
            }
        }
    }

    private static void reBuildE2Expression(Value.E2Expr e2, MethodVisitor asm) {
        Type type = LocalType.typeOf((Value)e2.op2.value);
        IrMethod2AsmMethod.accept(e2.op1.value, asm);
        if ((e2.vt == Value.VT.ADD || e2.vt == Value.VT.SUB) && e2.op2.value.vt == Value.VT.CONSTANT) {
            Constant constant = (Constant)e2.op2.value;
            Type t = LocalType.typeOf((Value)constant);
            switch (t.getSort()) {
                case 3: 
                case 4: 
                case 5: {
                    int s = (Integer)constant.value;
                    if (s >= 0) break;
                    asm.visitLdcInsn((Object)(-s));
                    asm.visitInsn(type.getOpcode(e2.vt == Value.VT.ADD ? 100 : 96));
                    return;
                }
                case 6: {
                    float s = ((Float)constant.value).floatValue();
                    if (!(s < 0.0f)) break;
                    asm.visitLdcInsn((Object)Float.valueOf(-s));
                    asm.visitInsn(type.getOpcode(e2.vt == Value.VT.ADD ? 100 : 96));
                    return;
                }
                case 7: {
                    long s = (Long)constant.value;
                    if (s >= 0L) break;
                    asm.visitLdcInsn((Object)(-s));
                    asm.visitInsn(type.getOpcode(e2.vt == Value.VT.ADD ? 100 : 96));
                    return;
                }
                case 8: {
                    double s = (Double)constant.value;
                    if (!(s < 0.0)) break;
                    asm.visitLdcInsn((Object)(-s));
                    asm.visitInsn(type.getOpcode(e2.vt == Value.VT.ADD ? 100 : 96));
                    return;
                }
            }
        }
        IrMethod2AsmMethod.accept(e2.op2.value, asm);
        Type tp1 = LocalType.typeOf((Value)e2.op1.value);
        switch (e2.vt) {
            case ARRAY: {
                Type tp2 = LocalType.typeOf((Value)e2);
                if (tp1.getSort() == 9) {
                    asm.visitInsn(Type.getType((String)tp1.getDescriptor().substring(1)).getOpcode(46));
                    break;
                }
                asm.visitInsn(tp2.getOpcode(46));
                break;
            }
            case ADD: {
                asm.visitInsn(type.getOpcode(96));
                break;
            }
            case SUB: {
                asm.visitInsn(type.getOpcode(100));
                break;
            }
            case DIV: {
                asm.visitInsn(type.getOpcode(108));
                break;
            }
            case MUL: {
                asm.visitInsn(type.getOpcode(104));
                break;
            }
            case REM: {
                asm.visitInsn(type.getOpcode(112));
                break;
            }
            case AND: {
                asm.visitInsn(type.getOpcode(126));
                break;
            }
            case OR: {
                asm.visitInsn(type.getOpcode(128));
                break;
            }
            case XOR: {
                asm.visitInsn(type.getOpcode(130));
                break;
            }
            case SHL: {
                asm.visitInsn(tp1.getOpcode(120));
                break;
            }
            case SHR: {
                asm.visitInsn(tp1.getOpcode(122));
                break;
            }
            case USHR: {
                asm.visitInsn(tp1.getOpcode(124));
                break;
            }
            case LCMP: {
                asm.visitInsn(148);
                break;
            }
            case FCMPG: {
                asm.visitInsn(150);
                break;
            }
            case DCMPG: {
                asm.visitInsn(152);
                break;
            }
            case FCMPL: {
                asm.visitInsn(149);
                break;
            }
            case DCMPL: {
                asm.visitInsn(151);
            }
        }
    }

    private static void cast2(Type t1, Type t2, MethodVisitor asm) {
        int opcode;
        if (t1.equals((Object)t2)) {
            return;
        }
        switch (t1.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                t1 = Type.INT_TYPE;
            }
        }
        switch (t1.getSort() * 10 + t2.getSort()) {
            case 56: {
                opcode = 134;
                break;
            }
            case 57: {
                opcode = 133;
                break;
            }
            case 58: {
                opcode = 135;
                break;
            }
            case 52: {
                opcode = 146;
                break;
            }
            case 53: {
                opcode = 145;
                break;
            }
            case 54: {
                opcode = 147;
                break;
            }
            case 75: {
                opcode = 136;
                break;
            }
            case 76: {
                opcode = 137;
                break;
            }
            case 78: {
                opcode = 138;
                break;
            }
            case 65: {
                opcode = 139;
                break;
            }
            case 67: {
                opcode = 140;
                break;
            }
            case 68: {
                opcode = 141;
                break;
            }
            case 85: {
                opcode = 142;
                break;
            }
            case 86: {
                opcode = 144;
                break;
            }
            case 87: {
                opcode = 143;
                break;
            }
            default: {
                opcode = -1;
            }
        }
        if (opcode == -1) {
            throw new DexException("can't cast %s to %s", new Object[]{t1, t2});
        }
        asm.visitInsn(opcode);
    }
}

