/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.Annotation;
import com.googlecode.dex2jar.DexType;
import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.v3.V3AnnAdapter;
import com.googlecode.dex2jar.v3.V3FieldAdapter;
import com.googlecode.dex2jar.v3.V3MethodAdapter;
import com.googlecode.dex2jar.visitors.DexAnnotationVisitor;
import com.googlecode.dex2jar.visitors.DexClassVisitor;
import com.googlecode.dex2jar.visitors.DexFieldVisitor;
import com.googlecode.dex2jar.visitors.DexMethodVisitor;
import com.googlecode.dex2jar.visitors.EmptyVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class V3ClassAdapter
implements DexClassVisitor {
    protected int access_flags;
    protected Map<String, Integer> innerAccessFlagsMap;
    protected Map<String, String> innerNameMap;
    Map<String, Set<String>> extraMemberClass;
    protected List<Annotation> anns = new ArrayList<Annotation>();
    protected boolean build = false;
    protected String className;
    protected ClassVisitor cv;
    protected String file;
    protected String[] interfaceNames;
    protected String superClass;
    protected Map<Method, Exception> exceptions;
    Map<String, Object> annotationDefaults;
    boolean isInnerClass = false;

    public V3ClassAdapter(Map<String, Integer> accessFlagsMap, Map<String, String> innerNameMap, Map<String, Set<String>> extraMemberClass, Map<Method, Exception> exceptions, ClassVisitor cv, int access_flags, String className, String superClass, String[] interfaceNames) {
        this.innerAccessFlagsMap = accessFlagsMap;
        this.innerNameMap = innerNameMap;
        this.extraMemberClass = extraMemberClass;
        this.cv = cv;
        this.access_flags = access_flags;
        this.className = className;
        this.superClass = superClass;
        this.interfaceNames = interfaceNames;
        this.exceptions = exceptions;
    }

    protected void build() {
        if (!this.build) {
            Integer i;
            String signature = null;
            String enclosingClass = null;
            Iterator<Annotation> it = this.anns.iterator();
            while (it.hasNext()) {
                Annotation ann = it.next();
                if ("Ldalvik/annotation/Signature;".equals(ann.type)) {
                    it.remove();
                    for (Annotation.Item item : ann.items) {
                        if (!item.name.equals("value")) continue;
                        Annotation values = (Annotation)item.value;
                        StringBuilder sb = new StringBuilder();
                        for (Annotation.Item i2 : values.items) {
                            sb.append(i2.value.toString());
                        }
                        signature = sb.toString();
                    }
                    continue;
                }
                if (ann.type.equals("Ldalvik/annotation/EnclosingClass;")) {
                    it.remove();
                    for (Annotation.Item i3 : ann.items) {
                        if (!i3.name.equals("value")) continue;
                        enclosingClass = i3.value.toString();
                    }
                    continue;
                }
                if (!ann.type.equals("Ldalvik/annotation/EnclosingMethod;")) continue;
                for (Annotation.Item i3 : ann.items) {
                    if (!"value".equals(i3.name)) continue;
                    Method m = (Method)i3.value;
                    enclosingClass = m.getOwner();
                }
            }
            if (this.isInnerClass && (i = this.innerAccessFlagsMap.get(this.className)) != null) {
                this.access_flags = i;
            }
            int accessInClass = this.access_flags;
            if ((this.access_flags & 0x200) == 0) {
                accessInClass |= 0x20;
            }
            accessInClass &= 0xFFFFFFF5;
            if (this.isInnerClass && (this.access_flags & 4) != 0) {
                accessInClass &= 0xFFFFFFFB;
                accessInClass |= 1;
            }
            String[] nInterfaceNames = null;
            if (this.interfaceNames != null) {
                nInterfaceNames = new String[this.interfaceNames.length];
                for (int i4 = 0; i4 < this.interfaceNames.length; ++i4) {
                    nInterfaceNames[i4] = Type.getType((String)this.interfaceNames[i4]).getInternalName();
                }
            }
            this.cv.visit(50, accessInClass, Type.getType((String)this.className).getInternalName(), signature, this.superClass == null ? null : Type.getType((String)this.superClass).getInternalName(), nInterfaceNames);
            Set<String> extraMember = this.extraMemberClass.get(this.className);
            if (extraMember != null) {
                for (String innerName : extraMember) {
                    this.cv.visitInnerClass(Type.getType((String)innerName).getInternalName(), null, null, 0);
                }
            }
            for (Annotation ann : this.anns) {
                if (ann.type.equals("Ldalvik/annotation/MemberClasses;")) {
                    for (Annotation.Item i5 : ann.items) {
                        if (!i5.name.equals("value")) continue;
                        for (Annotation.Item j : ((Annotation)i5.value).items) {
                            String name = j.value.toString();
                            Integer access = this.innerAccessFlagsMap.get(name);
                            String innerName = this.innerNameMap.get(name);
                            this.cv.visitInnerClass(Type.getType((String)name).getInternalName(), Type.getType((String)this.className).getInternalName(), innerName, access == null ? 0 : access);
                        }
                    }
                    continue;
                }
                if (ann.type.equals("Ldalvik/annotation/InnerClass;")) {
                    String name = null;
                    for (Annotation.Item i2 : ann.items) {
                        if (!i2.name.equals("name")) continue;
                        name = (String)i2.value;
                    }
                    int accessInInnerClassAttr = this.access_flags & 0xFFFFFFDF;
                    if (name == null) {
                        this.cv.visitOuterClass(Type.getType((String)enclosingClass).getInternalName(), null, null);
                        this.cv.visitInnerClass(Type.getType((String)this.className).getInternalName(), null, null, accessInInnerClassAttr);
                        continue;
                    }
                    this.cv.visitInnerClass(Type.getType((String)this.className).getInternalName(), Type.getType((String)enclosingClass).getInternalName(), name, accessInInnerClassAttr);
                    continue;
                }
                if (ann.type.equals("Ldalvik/annotation/EnclosingMethod;")) {
                    for (Annotation.Item it2 : ann.items) {
                        if (!"value".equals(it2.name)) continue;
                        Method m = (Method)it2.value;
                        this.cv.visitOuterClass(Type.getType((String)m.getOwner()).getInternalName(), m.getName(), m.getDesc());
                    }
                    continue;
                }
                AnnotationVisitor av = this.cv.visitAnnotation(ann.type, ann.visible);
                V3AnnAdapter.accept(ann.items, av);
                av.visitEnd();
            }
            if (this.file != null) {
                this.cv.visitSource(this.file, null);
            }
            this.build = true;
        }
    }

    public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
        if (!this.isInnerClass) {
            this.isInnerClass = "Ldalvik/annotation/InnerClass;".equals(name);
        }
        if (name.equals("Ldalvik/annotation/AnnotationDefault;")) {
            return new EmptyVisitor(){

                public DexAnnotationVisitor visitAnnotation(String name, String desc) {
                    return new EmptyVisitor(){

                        public void visit(String name, Object value) {
                            if (V3ClassAdapter.this.annotationDefaults == null) {
                                V3ClassAdapter.this.annotationDefaults = new HashMap<String, Object>();
                            }
                            if (value instanceof DexType) {
                                value = Type.getType((String)((DexType)value).desc);
                            }
                            V3ClassAdapter.this.annotationDefaults.put(name, value);
                        }
                    };
                }
            };
        }
        Annotation ann = new Annotation(name, visible);
        this.anns.add(ann);
        return new V3AnnAdapter(ann);
    }

    public void visitEnd() {
        this.build();
        this.cv.visitEnd();
    }

    public DexFieldVisitor visitField(int accessFlags, Field field, Object value) {
        this.build();
        if (value instanceof DexType) {
            value = Type.getType((String)((DexType)value).desc);
        }
        return new V3FieldAdapter(this.cv, accessFlags, field, value);
    }

    public DexMethodVisitor visitMethod(int accessFlags, Method method) {
        this.build();
        return new V3MethodAdapter(accessFlags, method, this.exceptions){

            @Override
            public void visitEnd() {
                AnnotationVisitor av;
                Object value;
                super.visitEnd();
                if (V3ClassAdapter.this.annotationDefaults != null && (value = V3ClassAdapter.this.annotationDefaults.get(this.method.getName())) != null && (av = this.methodNode.visitAnnotationDefault()) != null) {
                    av.visit(null, value);
                    av.visitEnd();
                }
                this.methodNode.accept(V3ClassAdapter.this.cv);
            }
        };
    }

    public void visitSource(String file) {
        this.file = file;
    }
}

