/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.analysis;

import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.OdexOpcodes;
import com.googlecode.dex2jar.analysis.CodeNode;
import com.googlecode.dex2jar.analysis.Node;
import java.util.ArrayList;
import java.util.Stack;

public abstract class Analyzer
implements OdexOpcodes {
    protected final CodeNode cn;
    protected final int totalReg;

    private static void link(Node f, Node t) {
        if (!f._cfg_tos.contains(t)) {
            f._cfg_tos.add(t);
            ++t._cfg_froms;
        }
    }

    private static boolean mayThrow(int opcode) {
        switch (opcode) {
            case 28: 
            case 31: 
            case 33: 
            case 39: 
            case 68: 
            case 75: 
            case 82: 
            case 89: 
            case 96: 
            case 103: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 237: 
            case 238: 
            case 242: 
            case 245: 
            case 248: 
            case 250: 
            case 16711827: 
            case 16711899: {
                return true;
            }
        }
        return false;
    }

    public Analyzer(CodeNode cn) {
        this.cn = cn;
        this.totalReg = cn.total;
    }

    public void analyze() {
        Node p = this.cn.first;
        while (p != null) {
            p._cfg_froms = 0;
            if (p._cfg_tos != null) {
                p._cfg_tos.clear();
            } else {
                p._cfg_tos = new ArrayList<Node>(5);
            }
            p._cfg_visited = false;
            p.frame = null;
            p = p.next;
        }
        p = this.cn.first;
        while (p != null) {
            switch (p.opcode) {
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: {
                    Analyzer.link(p, p.next);
                    Analyzer.link(p, (Node)p.la.info);
                    break;
                }
                case 40: {
                    Analyzer.link(p, (Node)p.la.info);
                    break;
                }
                case 43: 
                case 44: {
                    Analyzer.link(p, (Node)p.la.info);
                    for (DexLabel dl : p.ls) {
                        Analyzer.link(p, (Node)dl.info);
                    }
                    break;
                }
                case 14: 
                case 15: 
                case 39: 
                case 237: {
                    break;
                }
                default: {
                    if (p.opcode == -1 && p.next == null) break;
                    Analyzer.link(p, p.next);
                }
            }
            p = p.next;
        }
        for (Node t : this.cn.trys) {
            Node endNode = (Node)t.lb.info;
            Node handlerNode = (Node)t.lc.info;
            Node pre = (Node)t.la.info;
            Node p2 = pre.next;
            while (p2 != endNode) {
                if (Analyzer.mayThrow(p2.opcode)) {
                    Analyzer.link(pre, handlerNode);
                }
                pre = p2;
                p2 = p2.next;
            }
            handlerNode.frame = this.createExceptionHandlerFrame(handlerNode, t.type == null ? "Ljava/lang/Throwable;" : t.type);
        }
        p = this.cn.first;
        p.frame = this.initFirstFrame(p);
        Stack<Node> stack = new Stack<Node>();
        stack.push(p);
        while (!stack.empty()) {
            p = (Node)stack.pop();
            if (p._cfg_visited) continue;
            p._cfg_visited = true;
            Object frame = this.exec(p);
            for (Node x : p._cfg_tos) {
                this.merge(frame, x);
                stack.push(x);
            }
        }
    }

    protected abstract Object exec(Node var1);

    protected abstract void merge(Object var1, Node var2);

    protected abstract Object initFirstFrame(Node var1);

    protected abstract Object createExceptionHandlerFrame(Node var1, String var2);
}

