/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.analysis;

import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.OdexOpcodes;
import com.googlecode.dex2jar.analysis.NodeDump;
import com.googlecode.dex2jar.visitors.OdexCodeVisitor;
import java.util.List;

public class Node
implements OdexOpcodes {
    public int opcode;
    public int a;
    public int b;
    public int c;
    public int d;
    public String type;
    public Object cst;
    public Field field;
    public Method method;
    public int[] args;
    public DexLabel la;
    public DexLabel lb;
    public DexLabel lc;
    public DexLabel[] ls;
    public Node next;
    public Object frame;
    public int _cfg_froms;
    public List<Node> _cfg_tos;
    public boolean _cfg_visited;

    public Node(int opcode, int a, int b, String type) {
        this.opcode = opcode;
        this.a = a;
        this.b = b;
        this.type = type;
    }

    public Node(int opcode, DexLabel la, DexLabel lb, DexLabel lc, String type) {
        this.opcode = opcode;
        this.la = la;
        this.lb = lb;
        this.lc = lc;
        this.type = type;
    }

    public Node(int opcode) {
        this.opcode = opcode;
    }

    public Node(int opcode, int a, int b, DexLabel la) {
        this.opcode = opcode;
        this.a = a;
        this.b = b;
        this.la = la;
    }

    public Node(int opcode, int a) {
        this.opcode = opcode;
        this.a = a;
    }

    public Node(int opcode, int a, int b) {
        this.opcode = opcode;
        this.a = a;
        this.b = b;
    }

    public Node(int opcode, int a, DexLabel la) {
        this.opcode = opcode;
        this.a = a;
        this.la = la;
    }

    public Node(int opcode, DexLabel la) {
        this.opcode = opcode;
        this.la = la;
    }

    public Node(int opcode, int[] args, String type) {
        this.opcode = opcode;
        this.args = args;
        this.type = type;
    }

    public Node(int opcode, int[] args, Method method) {
        this.opcode = opcode;
        this.args = args;
        this.method = method;
    }

    public Node(int opcode, int[] args, int a) {
        this.opcode = opcode;
        this.args = args;
        this.a = a;
    }

    public Node(int opcode, int a, Object cst) {
        this.opcode = opcode;
        this.a = a;
        this.cst = cst;
    }

    public Node(int opcode, int a, int b, Object cst) {
        this.opcode = opcode;
        this.a = a;
        this.b = b;
        this.cst = cst;
    }

    public Node(int opcode, int a, Object cst, int b) {
        this.opcode = opcode;
        this.a = a;
        this.b = b;
        this.cst = cst;
    }

    public Node(int opcode, int a, int b, Field f) {
        this.opcode = opcode;
        this.a = a;
        this.field = f;
        this.b = b;
    }

    public Node(int opcode, int a, int b, int c, Field f) {
        this.opcode = opcode;
        this.a = a;
        this.b = b;
        this.field = f;
        this.c = c;
    }

    public Node(int opcode, int a, String s) {
        this.opcode = opcode;
        this.a = a;
        this.type = s;
    }

    public Node(int opcode, int a, int b, int c, int d) {
        this.opcode = opcode;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public Node(int opcode, int a, int b, int c) {
        this.opcode = opcode;
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public Node(int opcode, int a, DexLabel la, int[] args, DexLabel[] ls) {
        this.opcode = opcode;
        this.a = a;
        this.la = la;
        this.args = args;
        this.ls = ls;
    }

    public Node(int opcode, int a, DexLabel la, int b, int c, DexLabel[] ls) {
        this.opcode = opcode;
        this.a = a;
        this.la = la;
        this.b = b;
        this.c = c;
        this.ls = ls;
    }

    public void accept(OdexCodeVisitor dcv) {
        switch (this.opcode) {
            case -1: {
                dcv.visitLabel(this.la);
                break;
            }
            case -2: {
                dcv.visitTryCatch(this.la, this.lb, this.lc, this.type);
                break;
            }
            case 68: 
            case 75: {
                dcv.visitArrayStmt(this.opcode, this.a, this.b, this.c, this.d);
                break;
            }
            case 16711896: 
            case 16711897: 
            case 16711898: 
            case 16711899: 
            case 16711900: 
            case 0xFF00DD: 
            case 16711902: 
            case 0xFF00DF: 
            case 0xFF00E0: 
            case 16711905: 
            case 16711906: {
                dcv.visitBinopLitXStmt(this.opcode, this.a, this.b, this.c);
                break;
            }
            case 0xFF0090: 
            case 16711825: 
            case 16711826: 
            case 16711827: 
            case 16711828: 
            case 16711829: 
            case 16711830: 
            case 16711831: 
            case 16711832: 
            case 0xFF0099: 
            case 16711834: {
                dcv.visitBinopStmt(this.opcode, this.a, this.b, this.c, this.d);
                break;
            }
            case 31: 
            case 34: {
                dcv.visitClassStmt(this.opcode, this.a, this.type);
                break;
            }
            case 32: 
            case 35: {
                dcv.visitClassStmt(this.opcode, this.a, this.b, this.type);
                break;
            }
            case 0xFF002F: 
            case 0xFF0030: 
            case 16711729: {
                dcv.visitCmpStmt(this.opcode, this.a, this.b, this.c, this.d);
                break;
            }
            case 20: 
            case 26: 
            case 28: {
                dcv.visitConstStmt(this.opcode, this.a, this.cst, this.b);
                break;
            }
            case 96: 
            case 103: {
                dcv.visitFieldStmt(this.opcode, this.a, this.field, this.b);
                break;
            }
            case 82: 
            case 89: {
                dcv.visitFieldStmt(this.opcode, this.a, this.b, this.field, this.c);
                break;
            }
            case 38: {
                dcv.visitFillArrayStmt(this.opcode, this.a, this.b, this.c, (Object[])this.cst);
                break;
            }
            case 36: {
                dcv.visitFilledNewArrayStmt(this.opcode, this.args, this.type);
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                dcv.visitJumpStmt(this.opcode, this.a, this.b, this.la);
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                dcv.visitJumpStmt(this.opcode, this.a, this.la);
                break;
            }
            case 40: {
                dcv.visitJumpStmt(this.opcode, this.la);
                break;
            }
            case 44: {
                dcv.visitLookupSwitchStmt(this.opcode, this.a, this.la, this.args, this.ls);
                break;
            }
            case 43: {
                dcv.visitTableSwitchStmt(this.opcode, this.a, this.la, this.b, this.c, this.ls);
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                dcv.visitMethodStmt(this.opcode, this.args, this.method);
                break;
            }
            case 29: 
            case 30: {
                dcv.visitMonitorStmt(this.opcode, this.a);
                break;
            }
            case 10: 
            case 13: {
                dcv.visitMoveStmt(this.opcode, this.a, this.b);
                break;
            }
            case 1: {
                dcv.visitMoveStmt(this.opcode, this.a, this.b, this.c);
                break;
            }
            case 14: {
                dcv.visitReturnStmt(this.opcode);
                break;
            }
            case 15: 
            case 39: {
                dcv.visitReturnStmt(this.opcode, this.a, this.b);
                break;
            }
            case 33: 
            case 16711803: 
            case 16711804: {
                dcv.visitUnopStmt(this.opcode, this.a, this.b, this.c);
                break;
            }
            case 242: 
            case 245: {
                dcv.visitFieldStmt(this.opcode, this.a, this.b, this.c, this.d);
                break;
            }
            case 238: 
            case 248: 
            case 250: {
                dcv.visitMethodStmt(this.opcode, this.args, this.a);
                break;
            }
            case 237: {
                dcv.visitReturnStmt(this.opcode, this.a, this.cst);
                break;
            }
            case 16711809: {
                dcv.visitUnopStmt(this.opcode, this.a, this.b, this.c, this.d);
            }
        }
    }

    public String toString() {
        NodeDump nd = new NodeDump();
        this.accept(nd);
        return nd.toString();
    }
}

