/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.analysis;

import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.DexOpcodeDump;
import com.googlecode.dex2jar.util.AbstractDumpDexCodeAdapter;

public class NodeDump
extends AbstractDumpDexCodeAdapter {
    public StringBuilder sb = new StringBuilder();

    @Override
    protected void info(int opcode, String format, Object ... args) {
        String s = String.format(format, args);
        if (opcode < 0) {
            this.sb.append(String.format("%-20s|%5s|%s\n", "", "", s));
        } else {
            this.sb.append(String.format("%-20s|%5s|%s\n", DexOpcodeDump.dump(opcode), "", s));
        }
    }

    @Override
    public void visitLabel(DexLabel label) {
        this.sb.append(String.format("%-20s|%5s:\n", "LABEL", this.labelToString(label)));
    }

    @Override
    public void visitTryCatch(DexLabel start, DexLabel end, DexLabel handler, String type) {
        this.sb.append(String.format("TRY %s %s %s > %s\n", this.labelToString(start), this.labelToString(end), this.labelToString(handler), type == null ? "ALL" : type));
    }

    @Override
    protected String labelToString(DexLabel label) {
        return label.toString();
    }

    public String toString() {
        return this.sb.toString();
    }
}

