/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.analysis.type;

import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.OdexOpcodes;
import com.googlecode.dex2jar.visitors.OdexCodeVisitor;

@Deprecated
public abstract class TypeVisitor<T>
implements OdexCodeVisitor,
OdexOpcodes {
    protected final int totalReg;
    protected final String returnType;
    public static String IFL = "_1IFL";
    public static String IL = "_3IL";
    public static String IF = "_4IF";
    public static String JD = "_2JD";
    public static String AIFL = "[_1IFL";
    public static String AJD = "[_2JD";
    static String[] descs = new String[]{IFL, JD, "L", "Z", "B", "C", "S", "I", "F", "J", "D"};
    static String[] descsArray = new String[]{AIFL, AJD, "[L", "[Z", "[B", "[C", "[S", "[I", "[F", "[J", "[D"};

    protected void useAndType(int reg, String desc) {
        this._type(this._use(reg), desc);
    }

    public TypeVisitor(int totalReg, String returnType) {
        this.totalReg = totalReg;
        this.returnType = returnType;
    }

    protected void newAndType(int reg, String desc) {
        T n = this._new();
        this._type(n, desc);
        this._put(reg, n);
    }

    public abstract void _put(int var1, T var2);

    public abstract T _new();

    public abstract T _use(int var1);

    public abstract void _type(T var1, String var2);

    @Override
    public void visitArrayStmt(int opcode, int formOrToReg, int arrayReg, int indexReg, int xt) {
        this.useAndType(arrayReg, descsArray[xt]);
        this.useAndType(indexReg, "I");
        if (opcode == 68) {
            this.newAndType(formOrToReg, descs[xt]);
        } else {
            this.useAndType(formOrToReg, descs[xt]);
        }
    }

    @Override
    public void visitBinopLitXStmt(int opcode, int distReg, int srcReg, int content) {
        this.useAndType(srcReg, "I");
        this.newAndType(distReg, "I");
    }

    @Override
    public void visitBinopStmt(int opcode, int toReg, int r1, int r2, int xt) {
        this.useAndType(r1, descs[xt]);
        this.useAndType(r2, descs[xt]);
        this.newAndType(toReg, descs[xt]);
    }

    @Override
    public void visitClassStmt(int opcode, int a, int b, String type) {
        if (opcode == 32) {
            this.useAndType(b, "L");
            this.newAndType(a, "Z");
        } else {
            this.useAndType(b, "I");
            this.newAndType(a, type);
        }
    }

    @Override
    public void visitClassStmt(int opcode, int saveTo, String type) {
        if (opcode == 31) {
            this.useAndType(saveTo, "L");
        }
        this.newAndType(saveTo, type);
    }

    @Override
    public void visitCmpStmt(int opcode, int distReg, int bB, int cC, int xt) {
        this.useAndType(bB, descs[xt]);
        this.useAndType(cC, descs[xt]);
        this.newAndType(distReg, "I");
    }

    @Override
    public void visitConstStmt(int opcode, int toReg, Object value, int xt) {
        if (opcode == 28) {
            this.newAndType(toReg, "Ljava/lang/Class;");
        } else if (opcode == 26) {
            this.newAndType(toReg, "Ljava/lang/String;");
        } else if (xt == 0) {
            int v = (Integer)value;
            if (v == 0) {
                this.newAndType(toReg, descs[xt]);
            } else {
                this.newAndType(toReg, IF);
            }
        } else {
            this.newAndType(toReg, descs[xt]);
        }
    }

    @Override
    public void visitFieldStmt(int opcode, int fromOrToReg, Field field, int xt) {
        if (opcode == 96) {
            this.newAndType(fromOrToReg, field.getType());
        } else {
            this.useAndType(fromOrToReg, field.getType());
        }
    }

    @Override
    public void visitFieldStmt(int opcode, int fromOrToReg, int objReg, Field field, int xt) {
        this.useAndType(objReg, field.getOwner());
        if (opcode == 82) {
            this.newAndType(fromOrToReg, field.getType());
        } else {
            this.useAndType(fromOrToReg, field.getType());
        }
    }

    @Override
    public void visitFillArrayStmt(int opcode, int aA, int elemWidth, int initLength, Object[] values) {
        this.newAndType(aA, "[");
    }

    @Override
    public void visitFilledNewArrayStmt(int opcode, int[] args, String type) {
        String eType = type.substring(1);
        for (int arg : args) {
            this.useAndType(arg, eType);
        }
        this.newAndType(this.totalReg, type);
    }

    @Override
    public void visitJumpStmt(int opcode, int a, int b, DexLabel label) {
        if (opcode == 50 || opcode == 51) {
            this.useAndType(a, IL);
            this.useAndType(b, IL);
        } else {
            this.useAndType(a, "I");
            this.useAndType(b, "I");
        }
    }

    @Override
    public void visitJumpStmt(int opcode, int a, DexLabel label) {
        if (opcode == 56 || opcode == 57) {
            this.useAndType(a, IL);
        } else {
            this.useAndType(a, "I");
        }
    }

    @Override
    public void visitJumpStmt(int opcode, DexLabel label) {
    }

    @Override
    public void visitLookupSwitchStmt(int opcode, int aA, DexLabel label, int[] cases, DexLabel[] labels) {
        this.useAndType(aA, "I");
    }

    @Override
    public void visitMethodStmt(int opcode, int[] args, Method method) {
        int i = 0;
        if (opcode != 113) {
            this.useAndType(args[i], method.getOwner());
            ++i;
        }
        for (String ps : method.getParameterTypes()) {
            this.useAndType(args[i], ps);
            ++i;
        }
        if (!"V".equals(method.getReturnType())) {
            this.newAndType(this.totalReg, method.getReturnType());
        }
    }

    @Override
    public void visitMonitorStmt(int opcode, int reg) {
        this.useAndType(reg, "L");
    }

    @Override
    public void visitMoveStmt(int opcode, int toReg, int xt) {
        if (opcode == 10) {
            this.useAndType(this.totalReg, descs[xt]);
            this._put(this.totalReg, null);
        } else {
            this.useAndType(this.totalReg + 1, descs[xt]);
            this._put(this.totalReg + 1, null);
        }
        this.newAndType(toReg, descs[xt]);
    }

    @Override
    public void visitMoveStmt(int opcode, int toReg, int fromReg, int xt) {
        this.useAndType(fromReg, descs[xt]);
        this.newAndType(toReg, descs[xt]);
    }

    @Override
    public void visitReturnStmt(int opcode) {
    }

    @Override
    public void visitReturnStmt(int opcode, int reg, int xt) {
        if (opcode == 39) {
            this.useAndType(reg, "Ljava/lang/Throwable;");
        } else {
            this.useAndType(reg, this.returnType);
        }
    }

    @Override
    public void visitTableSwitchStmt(int opcode, int aA, DexLabel label, int first_case, int last_case, DexLabel[] labels) {
        this.useAndType(aA, "I");
    }

    @Override
    public void visitUnopStmt(int opcode, int toReg, int fromReg, int xt) {
        if (opcode == 33) {
            this.useAndType(fromReg, "[");
            this.newAndType(toReg, "I");
        } else {
            this.useAndType(fromReg, descs[xt]);
            this.newAndType(toReg, descs[xt]);
        }
    }

    @Override
    public void visitUnopStmt(int opcode, int toReg, int fromReg, int xta, int xtb) {
        this.useAndType(fromReg, descs[xta]);
        this.newAndType(toReg, descs[xtb]);
    }

    @Override
    public void visitTryCatch(DexLabel start, DexLabel end, DexLabel handler, String type) {
    }

    @Override
    public void visitArguments(int total, int[] args) {
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public void visitLabel(DexLabel label) {
    }

    @Override
    public void visitLineNumber(int line, DexLabel label) {
    }

    @Override
    public void visitLocalVariable(String name, String type, String signature, DexLabel start, DexLabel end, int reg) {
    }

    @Override
    public void visitReturnStmt(int opcode, int cause, Object ref) {
    }

    @Override
    public void visitMethodStmt(int opcode, int[] args, int a) {
        if (opcode == 238) {
            for (int i = 0; i < args.length; ++i) {
                this._use(args[i]);
            }
        } else {
            this.useAndType(args[0], "L");
            for (int i = 1; i < args.length; ++i) {
                this._use(args[i]);
            }
        }
        this._put(this.totalReg, this._new());
    }

    @Override
    public void visitFieldStmt(int opcode, int fromOrToReg, int objReg, int fieldoff, int xt) {
        this.useAndType(objReg, "L");
        if (opcode == 242) {
            this.newAndType(fromOrToReg, descs[xt]);
        } else {
            this.useAndType(fromOrToReg, descs[xt]);
        }
    }
}

