/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.OdexOpcodes;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.reader.DexInternalOpcode;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import com.googlecode.dex2jar.visitors.OdexCodeVisitor;
import java.util.Map;

class DexOpcodeAdapter
implements OdexOpcodes,
DexInternalOpcode {
    private DexCodeVisitor dcv;
    private DexFileReader dex;
    private Map<Integer, DexLabel> labels;
    private int offset;

    DexOpcodeAdapter(DexFileReader dex, Map<Integer, DexLabel> labels, DexCodeVisitor dcv) {
        this.dex = dex;
        this.labels = labels;
        this.dcv = dcv;
    }

    private DexLabel getLabel(int offset) {
        return this.labels.get(this.offset + offset);
    }

    void offset(int currentOffset) {
        this.offset = currentOffset;
        DexLabel label = this.getLabel(0);
        if (label != null) {
            this.dcv.visitLabel(label);
        }
    }

    public void visitFillArrayStmt(int opcode, int aA, int elemWidth, int initLength, Object[] values) {
        this.dcv.visitFillArrayStmt(opcode, aA, elemWidth, initLength, values);
    }

    public void visitLookupSwitchStmt(int opcode, int aA, int defaultOffset, int[] cases, int[] iLabel) {
        DexLabel[] labels = new DexLabel[iLabel.length];
        for (int i = 0; i < iLabel.length; ++i) {
            labels[i] = this.getLabel(iLabel[i]);
        }
        this.dcv.visitLookupSwitchStmt(opcode, aA, this.getLabel(defaultOffset), cases, labels);
    }

    public void visitTableSwitchStmt(int opcode, int aA, int defaultOffset, int first_case, int last_case, int[] iLabel) {
        DexLabel[] labels = new DexLabel[iLabel.length];
        for (int i = 0; i < iLabel.length; ++i) {
            labels[i] = this.getLabel(iLabel[i]);
        }
        this.dcv.visitTableSwitchStmt(opcode, aA, this.getLabel(defaultOffset), first_case, last_case, labels);
    }

    public void x0t(int opcode, int offset) {
        switch (opcode) {
            case 40: 
            case 41: 
            case 42: {
                this.dcv.visitJumpStmt(40, this.getLabel(offset));
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x0x(int opcode) {
        switch (opcode) {
            case 0: {
                break;
            }
            case 14: 
            case 241: {
                this.dcv.visitReturnStmt(14);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1c(int opcode, int a, int b) {
        switch (opcode) {
            case 26: 
            case 27: {
                this.dcv.visitConstStmt(26, a, this.dex.getString(b), 2);
                break;
            }
            case 28: 
            case 65280: {
                this.dcv.visitConstStmt(28, a, this.dex.getType(b), 2);
                break;
            }
            case 31: 
            case 65281: {
                this.dcv.visitClassStmt(31, a, this.dex.getType(b));
                break;
            }
            case 34: 
            case 65283: {
                this.dcv.visitClassStmt(34, a, this.dex.getType(b));
                break;
            }
            case 96: 
            case 229: 
            case 65300: 
            case 65529: {
                this.dcv.visitFieldStmt(96, a, this.dex.getField(b), 0);
                break;
            }
            case 97: 
            case 234: 
            case 65301: 
            case 65530: {
                this.dcv.visitFieldStmt(96, a, this.dex.getField(b), 1);
                break;
            }
            case 98: 
            case 253: 
            case 65302: 
            case 65531: {
                this.dcv.visitFieldStmt(96, a, this.dex.getField(b), 2);
                break;
            }
            case 99: 
            case 65303: {
                this.dcv.visitFieldStmt(96, a, this.dex.getField(b), 3);
                break;
            }
            case 100: 
            case 65304: {
                this.dcv.visitFieldStmt(96, a, this.dex.getField(b), 4);
                break;
            }
            case 101: 
            case 65305: {
                this.dcv.visitFieldStmt(96, a, this.dex.getField(b), 5);
                break;
            }
            case 102: 
            case 65306: {
                this.dcv.visitFieldStmt(96, a, this.dex.getField(b), 6);
                break;
            }
            case 103: 
            case 230: 
            case 65307: 
            case 65532: {
                this.dcv.visitFieldStmt(103, a, this.dex.getField(b), 0);
                break;
            }
            case 104: 
            case 235: 
            case 65308: 
            case 65533: {
                this.dcv.visitFieldStmt(103, a, this.dex.getField(b), 1);
                break;
            }
            case 105: 
            case 254: 
            case 65309: 
            case 65534: {
                this.dcv.visitFieldStmt(103, a, this.dex.getField(b), 2);
                break;
            }
            case 106: 
            case 65310: {
                this.dcv.visitFieldStmt(103, a, this.dex.getField(b), 3);
                break;
            }
            case 107: 
            case 65311: {
                this.dcv.visitFieldStmt(103, a, this.dex.getField(b), 4);
                break;
            }
            case 108: 
            case 65312: {
                this.dcv.visitFieldStmt(103, a, this.dex.getField(b), 5);
                break;
            }
            case 109: 
            case 65313: {
                this.dcv.visitFieldStmt(103, a, this.dex.getField(b), 6);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1h(int opcode, int a, int b) {
        switch (opcode) {
            case 21: {
                this.dcv.visitConstStmt(20, a, b << 16, 0);
                break;
            }
            case 25: {
                this.dcv.visitConstStmt(20, a, (long)b << 48, 1);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1i(int opcode, int a, int b) {
        switch (opcode) {
            case 20: {
                this.dcv.visitConstStmt(opcode, a, b, 0);
                break;
            }
            case 23: {
                this.dcv.visitConstStmt(20, a, b, 1);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1l(int opcode, int a, long b) {
        switch (opcode) {
            case 24: {
                this.dcv.visitConstStmt(20, a, b, 1);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1n(int opcode, int a, int b) {
        switch (opcode) {
            case 18: {
                this.dcv.visitConstStmt(20, a, b, 0);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1s(int opcode, int a, int b) {
        switch (opcode) {
            case 19: {
                this.dcv.visitConstStmt(20, a, b, 0);
                break;
            }
            case 22: {
                this.dcv.visitConstStmt(20, a, b, 1);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1t(int opcode, int a, int offset) {
        switch (opcode) {
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                this.dcv.visitJumpStmt(opcode, a, this.getLabel(offset));
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1x(int opcode, int a) {
        switch (opcode) {
            case 10: {
                this.dcv.visitMoveStmt(10, a, 0);
                break;
            }
            case 11: {
                this.dcv.visitMoveStmt(10, a, 1);
                break;
            }
            case 12: {
                this.dcv.visitMoveStmt(10, a, 2);
                break;
            }
            case 13: {
                this.dcv.visitMoveStmt(13, a, 2);
                break;
            }
            case 15: {
                this.dcv.visitReturnStmt(15, a, 0);
                break;
            }
            case 16: {
                this.dcv.visitReturnStmt(15, a, 1);
                break;
            }
            case 17: {
                this.dcv.visitReturnStmt(15, a, 2);
                break;
            }
            case 39: {
                this.dcv.visitReturnStmt(opcode, a, 2);
                break;
            }
            case 29: 
            case 30: {
                this.dcv.visitMonitorStmt(opcode, a);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x2b(int opcode, int a, int b, int c) {
        switch (opcode) {
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: {
                this.dcv.visitBinopLitXStmt(opcode - -16711680, a, b, c);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x2c(int opcode, int a, int b, int c) {
        switch (opcode) {
            case 32: 
            case 65282: {
                this.dcv.visitClassStmt(32, a, b, this.dex.getType(c));
                break;
            }
            case 35: 
            case 65284: {
                this.dcv.visitClassStmt(35, a, b, this.dex.getType(c));
                break;
            }
            case 82: 
            case 227: 
            case 65286: 
            case 65523: {
                this.dcv.visitFieldStmt(82, a, b, this.dex.getField(c), 0);
                break;
            }
            case 83: 
            case 232: 
            case 65287: 
            case 65524: {
                this.dcv.visitFieldStmt(82, a, b, this.dex.getField(c), 1);
                break;
            }
            case 84: 
            case 231: 
            case 65288: 
            case 65525: {
                this.dcv.visitFieldStmt(82, a, b, this.dex.getField(c), 2);
                break;
            }
            case 85: 
            case 65289: {
                this.dcv.visitFieldStmt(82, a, b, this.dex.getField(c), 3);
                break;
            }
            case 86: 
            case 65290: {
                this.dcv.visitFieldStmt(82, a, b, this.dex.getField(c), 4);
                break;
            }
            case 87: 
            case 65291: {
                this.dcv.visitFieldStmt(82, a, b, this.dex.getField(c), 5);
                break;
            }
            case 88: 
            case 65292: {
                this.dcv.visitFieldStmt(82, a, b, this.dex.getField(c), 6);
                break;
            }
            case 89: 
            case 228: 
            case 65293: 
            case 65526: {
                this.dcv.visitFieldStmt(89, a, b, this.dex.getField(c), 0);
                break;
            }
            case 90: 
            case 233: 
            case 65294: 
            case 65527: {
                this.dcv.visitFieldStmt(89, a, b, this.dex.getField(c), 1);
                break;
            }
            case 91: 
            case 252: 
            case 65295: 
            case 65528: {
                this.dcv.visitFieldStmt(89, a, b, this.dex.getField(c), 2);
                break;
            }
            case 92: 
            case 65296: {
                this.dcv.visitFieldStmt(89, a, b, this.dex.getField(c), 3);
                break;
            }
            case 93: 
            case 65297: {
                this.dcv.visitFieldStmt(89, a, b, this.dex.getField(c), 4);
                break;
            }
            case 94: 
            case 65298: {
                this.dcv.visitFieldStmt(89, a, b, this.dex.getField(c), 5);
                break;
            }
            case 95: 
            case 65299: {
                this.dcv.visitFieldStmt(89, a, b, this.dex.getField(c), 6);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x2s(int opcode, int a, int b, int c) {
        switch (opcode) {
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                this.dcv.visitBinopLitXStmt(opcode - -16711688, a, b, c);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x2t(int opcode, int a, int b, int c) {
        switch (opcode) {
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.dcv.visitJumpStmt(opcode, a, b, this.getLabel(c));
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x2x(int opcode, int a, int b) {
        switch (opcode) {
            case 1: 
            case 2: 
            case 3: {
                this.dcv.visitMoveStmt(1, a, b, 0);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.dcv.visitMoveStmt(1, a, b, 1);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                this.dcv.visitMoveStmt(1, a, b, 2);
                break;
            }
            case 33: {
                this.dcv.visitUnopStmt(33, a, b, 7);
                break;
            }
            case 123: 
            case 124: {
                this.dcv.visitUnopStmt(opcode - -16711680, a, b, 7);
                break;
            }
            case 125: 
            case 126: {
                this.dcv.visitUnopStmt(opcode - -16711678, a, b, 9);
                break;
            }
            case 127: {
                this.dcv.visitUnopStmt(16711803, a, b, 8);
                break;
            }
            case 128: {
                this.dcv.visitUnopStmt(16711803, a, b, 10);
                break;
            }
            case 129: {
                this.dcv.visitUnopStmt(16711809, a, b, 7, 9);
                break;
            }
            case 130: {
                this.dcv.visitUnopStmt(16711809, a, b, 7, 8);
                break;
            }
            case 131: {
                this.dcv.visitUnopStmt(16711809, a, b, 7, 10);
                break;
            }
            case 132: {
                this.dcv.visitUnopStmt(16711809, a, b, 9, 7);
                break;
            }
            case 133: {
                this.dcv.visitUnopStmt(16711809, a, b, 9, 8);
                break;
            }
            case 134: {
                this.dcv.visitUnopStmt(16711809, a, b, 9, 10);
                break;
            }
            case 135: {
                this.dcv.visitUnopStmt(16711809, a, b, 8, 7);
                break;
            }
            case 136: {
                this.dcv.visitUnopStmt(16711809, a, b, 8, 9);
                break;
            }
            case 137: {
                this.dcv.visitUnopStmt(16711809, a, b, 8, 10);
                break;
            }
            case 138: {
                this.dcv.visitUnopStmt(16711809, a, b, 10, 7);
                break;
            }
            case 139: {
                this.dcv.visitUnopStmt(16711809, a, b, 10, 9);
                break;
            }
            case 140: {
                this.dcv.visitUnopStmt(16711809, a, b, 10, 8);
                break;
            }
            case 141: {
                this.dcv.visitUnopStmt(16711809, a, b, 7, 4);
                break;
            }
            case 142: {
                this.dcv.visitUnopStmt(16711809, a, b, 7, 5);
                break;
            }
            case 143: {
                this.dcv.visitUnopStmt(16711809, a, b, 7, 6);
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: {
                this.dcv.visitBinopStmt(opcode - -16711648, a, a, b, 7);
                break;
            }
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: {
                this.dcv.visitBinopStmt(opcode - -16711637, a, a, b, 9);
                break;
            }
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: {
                this.dcv.visitBinopStmt(opcode - -16711626, a, a, b, 8);
                break;
            }
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                this.dcv.visitBinopStmt(opcode - -16711621, a, a, b, 10);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x3x(int opcode, int a, int b, int c) {
        switch (opcode) {
            case 45: {
                this.dcv.visitCmpStmt(0xFF002F, a, b, c, 8);
                break;
            }
            case 46: {
                this.dcv.visitCmpStmt(0xFF0030, a, b, c, 8);
                break;
            }
            case 47: {
                this.dcv.visitCmpStmt(0xFF002F, a, b, c, 10);
                break;
            }
            case 48: {
                this.dcv.visitCmpStmt(0xFF0030, a, b, c, 10);
                break;
            }
            case 49: {
                this.dcv.visitCmpStmt(16711729, a, b, c, 9);
                break;
            }
            case 68: {
                this.dcv.visitArrayStmt(68, a, b, c, 0);
                break;
            }
            case 69: {
                this.dcv.visitArrayStmt(68, a, b, c, 1);
                break;
            }
            case 70: {
                this.dcv.visitArrayStmt(68, a, b, c, 2);
                break;
            }
            case 71: {
                this.dcv.visitArrayStmt(68, a, b, c, 3);
                break;
            }
            case 72: {
                this.dcv.visitArrayStmt(68, a, b, c, 4);
                break;
            }
            case 73: {
                this.dcv.visitArrayStmt(68, a, b, c, 5);
                break;
            }
            case 74: {
                this.dcv.visitArrayStmt(68, a, b, c, 6);
                break;
            }
            case 75: {
                this.dcv.visitArrayStmt(75, a, b, c, 0);
                break;
            }
            case 76: {
                this.dcv.visitArrayStmt(75, a, b, c, 1);
                break;
            }
            case 77: {
                this.dcv.visitArrayStmt(75, a, b, c, 2);
                break;
            }
            case 78: {
                this.dcv.visitArrayStmt(75, a, b, c, 3);
                break;
            }
            case 79: {
                this.dcv.visitArrayStmt(75, a, b, c, 4);
                break;
            }
            case 80: {
                this.dcv.visitArrayStmt(75, a, b, c, 5);
                break;
            }
            case 81: {
                this.dcv.visitArrayStmt(75, a, b, c, 6);
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: {
                this.dcv.visitBinopStmt(opcode - -16711680, a, b, c, 7);
                break;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: {
                this.dcv.visitBinopStmt(opcode - -16711669, a, b, c, 9);
                break;
            }
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: {
                this.dcv.visitBinopStmt(opcode - -16711658, a, b, c, 8);
                break;
            }
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                this.dcv.visitBinopStmt(opcode - -16711653, a, b, c, 10);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x5c(int opcode, int a, int c, int d, int e, int f, int g, int b) {
        int[] args;
        switch (a) {
            case 0: {
                args = new int[]{};
                break;
            }
            case 1: {
                args = new int[]{c};
                break;
            }
            case 2: {
                args = new int[]{c, d};
                break;
            }
            case 3: {
                args = new int[]{c, d, e};
                break;
            }
            case 4: {
                args = new int[]{c, d, e, f};
                break;
            }
            case 5: {
                args = new int[]{c, d, e, f, g};
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
        switch (opcode) {
            case 36: {
                this.dcv.visitFilledNewArrayStmt(opcode, args, this.dex.getType(b));
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 240: {
                Method m = this.dex.getMethod(b);
                if (240 == opcode) {
                    int[] nArgs;
                    try {
                        nArgs = this.reBuildArgs(112, args, m);
                    }
                    catch (Exception ex) {
                        throw new DexException(ex, "while rebuild argements for 0xF0 OP_INVOKE_DIRECT_EMPTY @0x%04x, this is typically because of a wrong apiLevel. current apiLevel is %d.", this.offset, this.dex.apiLevel);
                    }
                    this.dcv.visitMethodStmt(112, nArgs, m);
                    break;
                }
                int[] nArgs = this.reBuildArgs(opcode, args, m);
                this.dcv.visitMethodStmt(opcode, nArgs, m);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void xrc(int opcode, int a, int b, int c) {
        int[] args = new int[a];
        for (int i = 0; i < a; ++i) {
            args[i] = c + i;
        }
        switch (opcode) {
            case 37: 
            case 65285: {
                this.dcv.visitFilledNewArrayStmt(36, args, this.dex.getType(b));
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 240: 
            case 65314: 
            case 65315: 
            case 65316: 
            case 65317: 
            case 65318: 
            case 65522: {
                int nOpcode = opcode == 240 || opcode == 65522 ? 112 : opcode - ((opcode >> 4 == 255 ? 65314 : 116) - 110);
                Method m = this.dex.getMethod(b);
                if (opcode == 240) {
                    int[] nArgs;
                    try {
                        nArgs = this.reBuildArgs(nOpcode, args, m);
                    }
                    catch (Exception ex) {
                        throw new DexException(ex, "while rebuild argements for 0xF0 OP_INVOKE_OBJECT_INIT_RANGE @0x%04x, this is typically because of a wrong apiLevel. current apiLevel is %d.", this.offset, this.dex.apiLevel);
                    }
                    this.dcv.visitMethodStmt(nOpcode, nArgs, m);
                    break;
                }
                int[] nArgs = this.reBuildArgs(nOpcode, args, m);
                this.dcv.visitMethodStmt(nOpcode, nArgs, m);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    private int[] reBuildArgs(int opcode, int[] args, Method m) {
        int realSize = m.getParameterTypes().length + (opcode == 113 ? 0 : 1);
        if (realSize != args.length) {
            int[] nArgs = new int[realSize];
            int i = 0;
            int j = 0;
            if (opcode != 113) {
                nArgs[i++] = args[j++];
            }
            for (String t : m.getParameterTypes()) {
                nArgs[i++] = args[j];
                j += "J".equals(t) || "D".equals(t) ? 2 : 1;
            }
            return nArgs;
        }
        return args;
    }

    public void x0bc(int opcode, int a, int b) {
        switch (opcode) {
            case 237: {
                Object ref;
                switch (a >> 6) {
                    case 0: {
                        ref = this.dex.getType(b);
                        break;
                    }
                    case 1: {
                        ref = this.dex.getField(b);
                        break;
                    }
                    case 2: {
                        ref = this.dex.getMethod(b);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                if (!(this.dcv instanceof OdexCodeVisitor)) break;
                ((OdexCodeVisitor)this.dcv).visitReturnStmt(opcode, a & 0x3F, ref);
            }
        }
    }

    public void x2cs(int opcode, int a, int b, int c) {
        switch (opcode) {
            case 242: {
                if (!(this.dcv instanceof OdexCodeVisitor)) break;
                ((OdexCodeVisitor)this.dcv).visitFieldStmt(242, a, b, c, 0);
                break;
            }
            case 243: {
                if (!(this.dcv instanceof OdexCodeVisitor)) break;
                ((OdexCodeVisitor)this.dcv).visitFieldStmt(242, a, b, c, 1);
                break;
            }
            case 244: {
                if (!(this.dcv instanceof OdexCodeVisitor)) break;
                ((OdexCodeVisitor)this.dcv).visitFieldStmt(242, a, b, c, 2);
                break;
            }
            case 245: {
                if (!(this.dcv instanceof OdexCodeVisitor)) break;
                ((OdexCodeVisitor)this.dcv).visitFieldStmt(245, a, b, c, 0);
                break;
            }
            case 246: {
                if (!(this.dcv instanceof OdexCodeVisitor)) break;
                ((OdexCodeVisitor)this.dcv).visitFieldStmt(245, a, b, c, 1);
                break;
            }
            case 247: {
                if (!(this.dcv instanceof OdexCodeVisitor)) break;
                ((OdexCodeVisitor)this.dcv).visitFieldStmt(245, a, b, c, 2);
            }
        }
    }

    public void x5mi(int opcode, int a, int c, int d, int e, int f, int g, int b) {
        int[] args;
        switch (a) {
            case 0: {
                args = new int[]{};
                break;
            }
            case 1: {
                args = new int[]{c};
                break;
            }
            case 2: {
                args = new int[]{c, d};
                break;
            }
            case 3: {
                args = new int[]{c, d, e};
                break;
            }
            case 4: {
                args = new int[]{c, d, e, f};
                break;
            }
            case 5: {
                args = new int[]{c, d, e, f, g};
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
        switch (opcode) {
            case 238: {
                if (!(this.dcv instanceof OdexCodeVisitor)) break;
                ((OdexCodeVisitor)this.dcv).visitMethodStmt(opcode, args, b);
            }
        }
    }

    public void x5ms(int opcode, int a, int c, int d, int e, int f, int g, int b) {
        int[] args;
        switch (a) {
            case 0: {
                args = new int[]{};
                break;
            }
            case 1: {
                args = new int[]{c};
                break;
            }
            case 2: {
                args = new int[]{c, d};
                break;
            }
            case 3: {
                args = new int[]{c, d, e};
                break;
            }
            case 4: {
                args = new int[]{c, d, e, f};
                break;
            }
            case 5: {
                args = new int[]{c, d, e, f, g};
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
        switch (opcode) {
            case 248: 
            case 250: {
                if (!(this.dcv instanceof OdexCodeVisitor)) break;
                ((OdexCodeVisitor)this.dcv).visitMethodStmt(opcode, args, b);
            }
        }
    }

    public void xrms(int opcode, int a, int b, int c) {
        int[] args = new int[a];
        for (int i = 0; i < a; ++i) {
            args[i] = c + i;
        }
        switch (opcode) {
            case 249: 
            case 251: {
                if (!(this.dcv instanceof OdexCodeVisitor)) break;
                ((OdexCodeVisitor)this.dcv).visitMethodStmt(opcode - 1, args, b);
            }
        }
    }

    public void xrmi(int opcode, int a, int b, int c) {
        int[] args = new int[a];
        for (int i = 0; i < a; ++i) {
            args[i] = c + i;
        }
        switch (opcode) {
            case 239: {
                if (!(this.dcv instanceof OdexCodeVisitor)) break;
                ((OdexCodeVisitor)this.dcv).visitMethodStmt(238, args, b);
            }
        }
    }

    public void x0sc(int opcode, int a, int b) {
    }
}

