/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader.io;

import com.googlecode.dex2jar.reader.io.DataIn;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Stack;

public abstract class ArrayDataIn
extends ByteArrayInputStream
implements DataIn {
    private Stack<Integer> stack = new Stack();

    public ArrayDataIn(byte[] data) {
        super(data);
    }

    @Override
    public int readShortx() {
        return (short)this.readUShortx();
    }

    @Override
    public int readIntx() {
        return this.readUIntx();
    }

    @Override
    public int getCurrentPosition() {
        return this.pos;
    }

    @Override
    public void move(int absOffset) {
        this.pos = absOffset;
    }

    @Override
    public void pop() {
        this.pos = this.stack.pop();
    }

    @Override
    public void push() {
        this.stack.push(this.pos);
    }

    @Override
    public void pushMove(int absOffset) {
        this.push();
        this.move(absOffset);
    }

    @Override
    public byte[] readBytes(int size) {
        byte[] data = new byte[size];
        try {
            super.read(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    @Override
    public long readLeb128() {
        int inp;
        int bitpos = 0;
        long vln = 0L;
        do {
            inp = this.readUByte();
            vln |= (long)(inp & 0x7F) << bitpos;
            bitpos += 7;
        } while ((inp & 0x80) != 0);
        if ((1L << bitpos - 1 & vln) != 0L) {
            vln -= 1L << bitpos;
        }
        return vln;
    }

    @Override
    public long readULeb128() {
        long value = 0L;
        int count = 0;
        int b = this.readUByte();
        while ((b & 0x80) != 0) {
            value |= (long)((b & 0x7F) << count);
            count += 7;
            b = this.readUByte();
        }
        return value |= (long)((b & 0x7F) << count);
    }

    @Override
    public void skip(int bytes) {
        super.skip(bytes);
    }

    @Override
    public int readByte() {
        return (byte)this.readUByte();
    }

    @Override
    public int readUByte() {
        if (this.pos >= this.count) {
            throw new RuntimeException("EOF");
        }
        return super.read();
    }
}

