/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader.io;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.reader.io.DataIn;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Stack;

public class BeRandomAccessFileInput
implements DataIn,
Closeable {
    protected RandomAccessFile r;
    private Stack<Integer> stack = new Stack();

    public BeRandomAccessFileInput(File file) {
        try {
            this.r = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            throw new DexException(e);
        }
    }

    @Override
    public int getCurrentPosition() {
        try {
            return (int)this.r.getFilePointer();
        }
        catch (IOException e) {
            throw new DexException(e);
        }
    }

    @Override
    public void move(int absOffset) {
        try {
            this.r.seek(absOffset);
        }
        catch (IOException e) {
            throw new DexException(e);
        }
    }

    @Override
    public void pop() {
        this.move(this.stack.pop());
    }

    @Override
    public void push() {
        this.stack.push(this.getCurrentPosition());
    }

    @Override
    public void pushMove(int absOffset) {
        this.push();
        this.move(absOffset);
    }

    @Override
    public int readByte() {
        try {
            return this.r.read();
        }
        catch (IOException e) {
            throw new DexException(e);
        }
    }

    @Override
    public byte[] readBytes(int size) {
        byte[] data = new byte[size];
        try {
            this.r.read(data);
        }
        catch (IOException e) {
            throw new DexException(e);
        }
        return data;
    }

    @Override
    public int readIntx() {
        return this.readUIntx();
    }

    @Override
    public int readUIntx() {
        try {
            return this.r.readInt();
        }
        catch (IOException e) {
            throw new DexException(e);
        }
    }

    @Override
    public int readShortx() {
        try {
            return this.r.readShort();
        }
        catch (IOException e) {
            throw new DexException(e);
        }
    }

    @Override
    public int readUShortx() {
        try {
            return this.r.readUnsignedShort();
        }
        catch (IOException e) {
            throw new DexException(e);
        }
    }

    @Override
    public long readLeb128() {
        int inp;
        int bitpos = 0;
        long vln = 0L;
        do {
            inp = this.readUByte();
            vln |= (long)(inp & 0x7F) << bitpos;
            bitpos += 7;
        } while ((inp & 0x80) != 0);
        if ((1L << bitpos - 1 & vln) != 0L) {
            vln -= 1L << bitpos;
        }
        return vln;
    }

    @Override
    public long readULeb128() {
        long value = 0L;
        int count = 0;
        int b = this.readUByte();
        while ((b & 0x80) != 0) {
            value |= (long)((b & 0x7F) << count);
            count += 7;
            b = this.readUByte();
        }
        return value |= (long)((b & 0x7F) << count);
    }

    @Override
    public int readUByte() {
        try {
            return this.r.readUnsignedByte();
        }
        catch (IOException e) {
            throw new DexException(e);
        }
    }

    @Override
    public void skip(int bytes) {
        try {
            this.r.skipBytes(bytes);
        }
        catch (IOException e) {
            throw new DexException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.r.close();
    }
}

