/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.util;

import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.DexOpcodeDump;
import com.googlecode.dex2jar.DexOpcodes;
import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.util.Escape;
import com.googlecode.dex2jar.util.Out;
import com.googlecode.dex2jar.visitors.OdexCodeVisitor;

public class ASMifierCodeV
implements OdexCodeVisitor,
DexOpcodes {
    Out m;
    int i = 0;

    public ASMifierCodeV(Out m) {
        this.m = m;
    }

    @Override
    public void visitArrayStmt(int opcode, int formOrToReg, int arrayReg, int indexReg, int xt) {
        this.m.s("code.visitArrayStmt(%s,%s,%s,%s,%s);", this.op(opcode), formOrToReg, arrayReg, indexReg, xt);
    }

    @Override
    public void visitBinopLitXStmt(int opcode, int distReg, int srcReg, int content) {
        this.m.s("code.visitBinopLitXStmt(%s,%s,%s,%s);", this.op(opcode), distReg, srcReg, content);
    }

    @Override
    public void visitBinopStmt(int opcode, int toReg, int r1, int r2, int xt) {
        this.m.s("code.visitBinopStmt(%s,%s,%s,%s,%s);", this.op(opcode), toReg, r1, r2, xt);
    }

    @Override
    public void visitClassStmt(int opcode, int a, int b, String type) {
        this.m.s("code.visitClassStmt(%s,%s,%s,%s);", this.op(opcode), a, b, Escape.v(type));
    }

    @Override
    public void visitClassStmt(int opcode, int saveTo, String type) {
        this.m.s("code.visitClassStmt(%s,%s,%s);", this.op(opcode), saveTo, Escape.v(type));
    }

    @Override
    public void visitCmpStmt(int opcode, int distReg, int bB, int cC, int xt) {
        this.m.s("code.visitCmpStmt(%s,%s,%s,%s,%s);", this.op(opcode), distReg, bB, cC, xt);
    }

    @Override
    public void visitConstStmt(int opcode, int toReg, Object value, int xt) {
        if (value instanceof Integer) {
            this.m.s("code.visitConstStmt(%s,%s,%s,%s); // int: 0x%08x  float:%f", this.op(opcode), toReg, Escape.v(value), xt, value, Float.valueOf(Float.intBitsToFloat((Integer)value)));
        } else if (value instanceof Long) {
            this.m.s("code.visitConstStmt(%s,%s,%s,%s); // long: 0x%016x  double:%f", this.op(opcode), toReg, Escape.v(value), xt, value, Double.longBitsToDouble((Long)value));
        } else {
            this.m.s("code.visitConstStmt(%s,%s,%s,%s);", this.op(opcode), toReg, Escape.v(value), xt);
        }
    }

    @Override
    public void visitFieldStmt(int opcode, int fromOrToReg, Field field, int xt) {
        this.m.s("code.visitFieldStmt(%s,%s,%s,%s);", this.op(opcode), fromOrToReg, Escape.v(field), xt);
    }

    @Override
    public void visitFieldStmt(int opcode, int fromOrToReg, int objReg, Field field, int xt) {
        this.m.s("code.visitFieldStmt(%s,%s,%s,%s,%s);", this.op(opcode), fromOrToReg, objReg, Escape.v(field), xt);
    }

    @Override
    public void visitFillArrayStmt(int opcode, int aA, int elemWidth, int initLength, Object[] values) {
        this.m.s("code.visitFillArrayStmt(%s,%s,%s,%s,%s);", this.op(opcode), aA, elemWidth, initLength, Escape.v(values));
    }

    @Override
    public void visitFilledNewArrayStmt(int opcode, int[] args, String type) {
        this.m.s("code.visitFilledNewArrayStmt(%s,%s,%s);", this.op(opcode), Escape.v(args), Escape.v(type));
    }

    private Object v(DexLabel l) {
        if (l.info == null) {
            l.info = "L" + this.i++;
            this.m.s("DexLabel %s=new DexLabel();", l.info);
        }
        return l.info;
    }

    String op(int op) {
        return "OP_" + DexOpcodeDump.dump(op);
    }

    @Override
    public void visitJumpStmt(int opcode, int a, int b, DexLabel label) {
        this.m.s("code.visitJumpStmt(%s,%s,%s,%s);", this.op(opcode), a, b, this.v(label));
    }

    @Override
    public void visitJumpStmt(int opcode, int reg, DexLabel label) {
        this.m.s("code.visitJumpStmt(%s,%s,%s);", this.op(opcode), reg, this.v(label));
    }

    @Override
    public void visitJumpStmt(int opcode, DexLabel label) {
        this.m.s("code.visitJumpStmt(%s,%s);", this.op(opcode), this.v(label));
    }

    @Override
    public void visitLookupSwitchStmt(int opcode, int aA, DexLabel label, int[] cases, DexLabel[] labels) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (DexLabel dexLabel : labels) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(this.v(dexLabel));
        }
        this.m.s("code.visitLookupSwitchStmt(%s,%s,%s,%s,new DexLabel[]{%s});", this.op(opcode), aA, this.v(label), Escape.v(cases), sb.toString());
    }

    @Override
    public void visitMethodStmt(int opcode, int[] args, Method method) {
        this.m.s("code.visitMethodStmt(%s,%s,%s);", this.op(opcode), Escape.v(args), Escape.v(method));
    }

    @Override
    public void visitMonitorStmt(int opcode, int reg) {
        this.m.s("code.visitMonitorStmt(%s,%s);", this.op(opcode), reg);
    }

    @Override
    public void visitMoveStmt(int opcode, int toReg, int xt) {
        this.m.s("code.visitMoveStmt(%s,%s,%s);", this.op(opcode), toReg, xt);
    }

    @Override
    public void visitMoveStmt(int opcode, int toReg, int fromReg, int xt) {
        this.m.s("code.visitMoveStmt(%s,%s,%s,%s);", this.op(opcode), toReg, fromReg, xt);
    }

    @Override
    public void visitReturnStmt(int opcode) {
        this.m.s("code.visitReturnStmt(%s);", this.op(opcode));
    }

    @Override
    public void visitReturnStmt(int opcode, int reg, int xt) {
        this.m.s("code.visitReturnStmt(%s,%s,%s);", this.op(opcode), reg, xt);
    }

    @Override
    public void visitTableSwitchStmt(int opcode, int aA, DexLabel label, int first_case, int last_case, DexLabel[] labels) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (DexLabel dexLabel : labels) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(this.v(dexLabel));
        }
        this.m.s("code.visitTableSwitchStmt(%s,%s,%s,%s,%s,new DexLabel[]{%s});", this.op(opcode), aA, this.v(label), first_case, last_case, sb.toString());
    }

    @Override
    public void visitUnopStmt(int opcode, int toReg, int fromReg, int xt) {
        this.m.s("code.visitUnopStmt(%s,%s,%s,%s);", this.op(opcode), toReg, fromReg, xt);
    }

    @Override
    public void visitUnopStmt(int opcode, int toReg, int fromReg, int xta, int xtb) {
        this.m.s("code.visitUnopStmt(%s,%s,%s,%s,%s);", this.op(opcode), toReg, fromReg, xta, xtb);
    }

    @Override
    public void visitTryCatch(DexLabel start, DexLabel end, DexLabel handler, String type) {
        this.m.s("code.visitTryCatch(%s,%s,%s,%s);", this.v(start), this.v(end), this.v(handler), Escape.v(type));
    }

    @Override
    public void visitArguments(int total, int[] args) {
        this.m.s("code.visitArguments(%s,%s);", total, Escape.v(args));
    }

    @Override
    public void visitEnd() {
        this.m.s("code.visitEnd();");
    }

    @Override
    public void visitLabel(DexLabel label) {
        this.m.s("code.visitLabel(%s);", this.v(label));
    }

    @Override
    public void visitLineNumber(int line, DexLabel label) {
        this.m.s("code.visitLineNumber(%s,%s);", line, this.v(label));
    }

    @Override
    public void visitLocalVariable(String name, String type, String signature, DexLabel start, DexLabel end, int reg) {
        this.m.s("code.visitLocalVariable(%s,%s,%s,%s,%s,%s);", Escape.v(name), Escape.v(type), Escape.v(signature), this.v(start), this.v(end), reg);
    }

    @Override
    public void visitReturnStmt(int opcode, int cause, Object ref) {
        this.m.s("((OdexCodeVisitor)code).visitReturnStmt(%s,%s,%s);", this.op(opcode), cause, Escape.v(ref));
    }

    @Override
    public void visitMethodStmt(int opcode, int[] args, int a) {
        this.m.s("((OdexCodeVisitor)code).visitMethodStmt(%s,%s,%s);", this.op(opcode), Escape.v(args), a);
    }

    @Override
    public void visitFieldStmt(int opcode, int fromOrToReg, int objReg, int fieldoff, int xt) {
        this.m.s("((OdexCodeVisitor)code).visitFieldStmt(%s,%s,%s,%s,%s);", this.op(opcode), fromOrToReg, objReg, fieldoff, xt);
    }
}

