/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.util;

import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.util.Dump;
import com.googlecode.dex2jar.visitors.EmptyVisitor;

public abstract class AbstractDumpDexCodeAdapter
extends EmptyVisitor {
    protected static final String[] causes = new String[]{"no-error", "generic-error", "no-such-class", "no-such-field", "no-such-method", "illegal-class-access", "illegal-field-access", "illegal-method-access", "class-change-error", "instantiation-error"};

    protected static String toJavaClass(String type) {
        return Dump.toJavaClass(type);
    }

    protected abstract void info(int var1, String var2, Object ... var3);

    protected abstract String labelToString(DexLabel var1);

    @Override
    public void visitArrayStmt(int opcode, int value, int array, int index, int xt) {
        switch (opcode) {
            case 75: {
                this.info(opcode, "v%d[v%d]=v%d", array, index, value);
                break;
            }
            case 68: {
                this.info(opcode, "v%d=v%d[v%d]", value, array, index);
            }
        }
    }

    @Override
    public void visitBinopLitXStmt(int opcode, int saveToReg, int opReg, int value) {
        switch (opcode) {
            case 0xFF00DD: {
                this.info(opcode, "v%d = v%d & %d", saveToReg, opReg, value);
                break;
            }
            case 16711896: {
                this.info(opcode, "v%d = v%d + %d", saveToReg, opReg, value);
                break;
            }
            case 16711900: {
                this.info(opcode, "v%d = v%d %% %d", saveToReg, opReg, value);
                break;
            }
            case 16711899: {
                this.info(opcode, "v%d = v%d / %d", saveToReg, opReg, value);
                break;
            }
            case 16711898: {
                this.info(opcode, "v%d = v%d * %d", saveToReg, opReg, value);
                break;
            }
            case 16711905: {
                this.info(opcode, "v%d = v%d >> %d", saveToReg, opReg, value);
                break;
            }
            case 0xFF00E0: {
                this.info(opcode, "v%d = v%d << %d", saveToReg, opReg, value);
                break;
            }
            case 16711906: {
                this.info(opcode, "v%d = v%d >>> %d", saveToReg, opReg, value);
                break;
            }
            case 16711902: {
                this.info(opcode, "v%d = v%d | %d", saveToReg, opReg, value);
                break;
            }
            case 0xFF00DF: {
                this.info(opcode, "v%d = v%d ^ %d", saveToReg, opReg, value);
            }
        }
    }

    @Override
    public void visitBinopStmt(int opcode, int saveToReg, int opReg, int opReg2, int xt) {
        switch (opcode) {
            case 16711829: {
                this.info(opcode, "v%d = v%d & v%d", saveToReg, opReg, opReg2);
                break;
            }
            case 16711830: {
                this.info(opcode, "v%d = v%d | v%d", saveToReg, opReg, opReg2);
                break;
            }
            case 16711831: {
                this.info(opcode, "v%d = v%d ^ v%d", saveToReg, opReg, opReg2);
                break;
            }
            case 16711825: {
                this.info(opcode, "v%d = v%d - v%d", saveToReg, opReg, opReg2);
                break;
            }
            case 16711826: {
                this.info(opcode, "v%d = v%d * v%d", saveToReg, opReg, opReg2);
                break;
            }
            case 16711827: {
                this.info(opcode, "v%d = v%d / v%d", saveToReg, opReg, opReg2);
                break;
            }
            case 0xFF0090: {
                this.info(opcode, "v%d = v%d + v%d", saveToReg, opReg, opReg2);
                break;
            }
            case 16711828: {
                this.info(opcode, "v%d = v%d %% v%d", saveToReg, opReg, opReg2);
            }
        }
    }

    @Override
    public void visitClassStmt(int opcode, int toReg, int fromReg, String type) {
        switch (opcode) {
            case 32: {
                this.info(opcode, "v%d=v%d instanceof %s", toReg, fromReg, Dump.toJavaClass(type));
                break;
            }
            case 35: {
                this.info(opcode, "v%d=new %s[v%d]", toReg, Dump.toJavaClass(type), fromReg);
            }
        }
    }

    @Override
    public void visitClassStmt(int opcode, int toReg, String type) {
        switch (opcode) {
            case 34: {
                this.info(opcode, "v%d=NEW %s", toReg, type);
                break;
            }
            case 31: {
                this.info(opcode, "v%d=(%s) v%d", toReg, Dump.toJavaClass(type), toReg);
            }
        }
    }

    @Override
    public void visitCmpStmt(int opcode, int distReg, int bB, int cC, int xt) {
        switch (opcode) {
            case 0xFF002F: {
                this.info(opcode, "v%d = v%d cmpl v%d ", distReg, bB, cC);
                break;
            }
            case 0xFF0030: {
                this.info(opcode, "v%d = v%d cmpg v%d", distReg, bB, cC);
                break;
            }
            case 16711729: {
                this.info(opcode, "v%d = v%d cmp v%d", distReg, bB, cC);
            }
        }
    }

    @Override
    public void visitConstStmt(int opcode, int reg, Object value, int xt) {
        switch (opcode) {
            case 20: {
                if (xt == 0) {
                    this.info(opcode, "v%d=0x%08x  // int:%d   float:%f", reg, value, value, Float.valueOf(Float.intBitsToFloat((Integer)value)));
                    break;
                }
                this.info(opcode, "v%d=0x%016x  // long:%d   double:%f", reg, value, value, Double.longBitsToDouble((Long)value));
                break;
            }
            case 26: {
                this.info(opcode, "v%d=\"%s\"", reg, value);
                break;
            }
            case 28: {
                this.info(opcode, "v%d=%s.class", reg, value);
                break;
            }
            default: {
                this.info(opcode, "v%d=%s  //", reg, value);
            }
        }
    }

    @Override
    public void visitFieldStmt(int opcode, int fromOrToReg, Field field, int xt) {
        switch (opcode) {
            case 103: {
                this.info(opcode, "%s.%s=v%d  //%s", AbstractDumpDexCodeAdapter.toJavaClass(field.getOwner()), field.getName(), fromOrToReg, field);
                break;
            }
            case 96: {
                this.info(opcode, "v%d=%s.%s  //%s", fromOrToReg, AbstractDumpDexCodeAdapter.toJavaClass(field.getOwner()), field.getName(), field);
            }
        }
    }

    @Override
    public void visitFieldStmt(int opcode, int regFromOrTo, int owner_reg, Field field, int xt) {
        switch (opcode) {
            case 82: {
                this.info(opcode, "v%d=v%d.%s  //%s", regFromOrTo, owner_reg, field.getName(), field);
                break;
            }
            case 89: {
                this.info(opcode, "v%d.%s=v%d  //%s", owner_reg, field.getName(), regFromOrTo, field);
            }
        }
    }

    @Override
    public void visitFieldStmt(int opcode, int fromOrToReg, int objReg, int fieldoff, int xt) {
        switch (opcode) {
            case 242: {
                this.info(opcode, "Q+ v%d=v%d.fieldoff+%04x", fromOrToReg, objReg, fieldoff);
                break;
            }
            case 245: {
                this.info(opcode, "Q+ v%d.fieldoff+%04x=v%d", objReg, fieldoff, fromOrToReg);
            }
        }
    }

    @Override
    public void visitFillArrayStmt(int opcode, int reg, int elemWidth, int initLength, Object[] values) {
        StringBuilder sb = new StringBuilder();
        for (Object value : values) {
            sb.append(',').append(value);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        this.info(opcode, "v%d[0..%d]=[%s]", reg, initLength - 1, sb.toString());
    }

    @Override
    public void visitFilledNewArrayStmt(int opcode, int[] regs, String type) {
        this.info(opcode, "TEMP=new %s[%d]", Dump.toJavaClass(type.substring(1)), regs.length);
        for (int i = 0; i < regs.length; ++i) {
            this.info(opcode, "TEMP[%d]=v%d", i, regs[i]);
        }
    }

    @Override
    public void visitJumpStmt(int opcode, DexLabel label) {
        switch (opcode) {
            case 40: {
                this.info(opcode, "goto %s", this.labelToString(label));
            }
        }
    }

    @Override
    public void visitJumpStmt(int opcode, int reg, DexLabel label) {
        switch (opcode) {
            case 56: {
                this.info(opcode, "if v%d == 0 goto %s", reg, this.labelToString(label));
                break;
            }
            case 57: {
                this.info(opcode, "if v%d != 0 goto %s", reg, this.labelToString(label));
                break;
            }
            case 58: {
                this.info(opcode, "if v%d <  0 goto %s", reg, this.labelToString(label));
                break;
            }
            case 59: {
                this.info(opcode, "if v%d >= 0 goto %s", reg, this.labelToString(label));
                break;
            }
            case 60: {
                this.info(opcode, "if v%d >  0 goto %s", reg, this.labelToString(label));
                break;
            }
            case 61: {
                this.info(opcode, "if v%d <= 0 goto %s", reg, this.labelToString(label));
            }
        }
    }

    @Override
    public void visitJumpStmt(int opcode, int reg1, int reg2, DexLabel label) {
        switch (opcode) {
            case 50: {
                this.info(opcode, "if v%d == v%d goto %s", reg1, reg2, this.labelToString(label));
                break;
            }
            case 51: {
                this.info(opcode, "if v%d != v%d goto %s", reg1, reg2, this.labelToString(label));
                break;
            }
            case 52: {
                this.info(opcode, "if v%d <  v%d goto %s", reg1, reg2, this.labelToString(label));
                break;
            }
            case 53: {
                this.info(opcode, "if v%d >= v%d goto %s", reg1, reg2, this.labelToString(label));
                break;
            }
            case 54: {
                this.info(opcode, "if v%d >  v%d goto %s", reg1, reg2, this.labelToString(label));
                break;
            }
            case 55: {
                this.info(opcode, "if v%d <= v%d goto %s", reg1, reg2, this.labelToString(label));
            }
        }
    }

    @Override
    public void visitLookupSwitchStmt(int opcode, int reg, DexLabel label, int[] cases, DexLabel[] label2) {
        this.info(opcode, "switch(v%d)", reg);
        for (int i = 0; i < cases.length; ++i) {
            this.info(-1, "case %d: goto %s", cases[i], this.labelToString(label2[i]));
        }
        this.info(-1, "default: goto %s", this.labelToString(label));
    }

    @Override
    public void visitMethodStmt(int opcode, int[] args, int a) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < args.length; ++j) {
            sb.append('v').append(args[j]).append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        switch (opcode) {
            case 248: 
            case 250: {
                this.info(opcode, "Q+ TEMP=taboff+%04x(%s)", a, sb.toString());
                break;
            }
            case 238: {
                this.info(opcode, "Q+ TEMP=inline+%04x(%s)", a, sb.toString());
            }
        }
    }

    @Override
    public void visitMethodStmt(int opcode, int[] regs, Method method) {
        switch (opcode) {
            case 113: {
                int i = 0;
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < method.getParameterTypes().length; ++j) {
                    sb.append('v').append(regs[i++]).append(',');
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                if (method.getReturnType().equals("V")) {
                    this.info(opcode, "%s.%s(%s)  //%s", AbstractDumpDexCodeAdapter.toJavaClass(method.getOwner()), method.getName(), sb.toString(), method.toString());
                    break;
                }
                this.info(opcode, "TEMP=%s.%s(%s)  //%s", AbstractDumpDexCodeAdapter.toJavaClass(method.getOwner()), method.getName(), sb.toString(), method.toString());
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 114: {
                int i = 1;
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < method.getParameterTypes().length; ++j) {
                    sb.append(',').append('v').append(regs[i++]);
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(0);
                }
                if (method.getReturnType().equals("V")) {
                    this.info(opcode, "v%d.%s(%s)  //%s", regs[0], method.getName(), sb.toString(), method.toString());
                    break;
                }
                this.info(opcode, "TEMP=v%d.%s(%s)  //%s", regs[0], method.getName(), sb.toString(), method.toString());
            }
        }
    }

    @Override
    public void visitMonitorStmt(int opcode, int reg) {
        switch (opcode) {
            case 29: {
                this.info(opcode, "lock v%d", reg);
                break;
            }
            case 30: {
                this.info(opcode, "unlock v%d", reg);
            }
        }
    }

    @Override
    public void visitMoveStmt(int opcode, int reg, int xt) {
        switch (opcode) {
            case 10: {
                this.info(opcode, "v%d=TEMP", reg);
                break;
            }
            case 13: {
                this.info(opcode, "v%d=@Exception", reg);
            }
        }
    }

    @Override
    public void visitMoveStmt(int opcode, int toReg, int fromReg, int xt) {
        switch (opcode) {
            case 1: {
                this.info(opcode, "v%d = v%d", toReg, fromReg);
            }
        }
    }

    @Override
    public void visitReturnStmt(int opcode) {
        switch (opcode) {
            case 14: {
                this.info(opcode, "return", new Object[0]);
            }
        }
    }

    @Override
    public void visitReturnStmt(int opcode, int reg, int xt) {
        switch (opcode) {
            case 15: {
                this.info(opcode, "return v%d", reg);
                break;
            }
            case 39: {
                this.info(opcode, "throw v%d", reg);
            }
        }
    }

    @Override
    public void visitReturnStmt(int opcode, int cause, Object ref) {
        String c = cause >= causes.length ? "unknown" : causes[cause];
        this.info(opcode, "Q+ throw new VerificationError(%s)", c);
    }

    @Override
    public void visitTableSwitchStmt(int opcode, int reg, DexLabel label, int first_case, int last_case, DexLabel[] labels) {
        this.info(opcode, "switch(v%d)", reg);
        for (int i = 0; i < labels.length; ++i) {
            this.info(opcode, "case %d: goto %s", first_case + i, this.labelToString(labels[i]));
        }
        this.info(opcode, "default: goto %s", this.labelToString(label));
    }

    @Override
    public void visitUnopStmt(int opcode, int saveToReg, int opReg, int xt) {
        switch (opcode) {
            case 16711803: {
                this.info(opcode, "v%d = ~v%d", saveToReg, opReg);
                break;
            }
            case 16711804: {
                this.info(opcode, "v%d = !v%d", saveToReg, opReg);
                break;
            }
            case 33: {
                this.info(opcode, "v%d = v%d.length", saveToReg, opReg);
            }
        }
    }

    @Override
    public void visitUnopStmt(int opcode, int saveToReg, int opReg, int xta, int xtb) {
        block0 : switch (opcode) {
            case 16711809: {
                switch (xtb) {
                    case 3: {
                        this.info(opcode, "v%d = (boolean)v%d", saveToReg, opReg);
                        break block0;
                    }
                    case 4: {
                        this.info(opcode, "v%d = (byte)v%d", saveToReg, opReg);
                        break block0;
                    }
                    case 5: {
                        this.info(opcode, "v%d = (char)v%d", saveToReg, opReg);
                        break block0;
                    }
                    case 10: {
                        this.info(opcode, "v%d = (double)v%d", saveToReg, opReg);
                        break block0;
                    }
                    case 8: {
                        this.info(opcode, "v%d = (float)v%d", saveToReg, opReg);
                        break block0;
                    }
                    case 7: {
                        this.info(opcode, "v%d = (int)v%d", saveToReg, opReg);
                        break block0;
                    }
                    case 9: {
                        this.info(opcode, "v%d = (long)v%d", saveToReg, opReg);
                        break block0;
                    }
                    case 6: {
                        this.info(opcode, "v%d = (short)v%d", saveToReg, opReg);
                    }
                }
            }
        }
    }
}

