/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.util;

import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.DexOpcodeDump;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.util.AbstractDumpDexCodeAdapter;
import com.googlecode.dex2jar.util.Dump;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DumpDexCodeAdapter
extends AbstractDumpDexCodeAdapter {
    private List<DexLabel> labels = new ArrayList<DexLabel>();
    private Method method;
    private PrintWriter out;
    private List<TryCatch> trys = new ArrayList<TryCatch>();
    private Map<DexLabel, Integer> lines = new HashMap<DexLabel, Integer>();
    private boolean isStatic;

    public DumpDexCodeAdapter(boolean isStatic, Method m, PrintWriter out) {
        this.method = m;
        this.out = out;
        this.isStatic = isStatic;
    }

    @Override
    protected void info(int opcode, String format, Object ... args) {
        String s = String.format(format, args);
        if (opcode < 0) {
            this.out.printf("%-20s|%5s|%s\n", "", "", s);
        } else {
            this.out.printf("%-20s|%5s|%s\n", DexOpcodeDump.dump(opcode), "", s);
        }
    }

    @Override
    protected String labelToString(DexLabel label) {
        int i = this.labels.indexOf(label);
        if (i > -1) {
            return "L" + i;
        }
        this.labels.add(label);
        return "L" + this.labels.indexOf(label);
    }

    @Override
    public void visitArguments(int total, int[] args) {
        int i = 0;
        if (!this.isStatic) {
            int reg = args[i++];
            String type = Dump.toJavaClass(this.method.getOwner());
            this.out.printf("%20s:v%d   //%s\n", "this", reg, type);
        }
        for (String type : this.method.getParameterTypes()) {
            int reg = args[i++];
            type = Dump.toJavaClass(type);
            this.out.printf("%20s:v%d   //%s\n", "", reg, type);
        }
    }

    @Override
    public void visitLabel(DexLabel label) {
        Integer line;
        boolean find = false;
        for (TryCatch tc : this.trys) {
            if (!label.equals(tc.end)) continue;
            this.info(-1, " } // TC_%d", this.trys.indexOf(tc));
            find = true;
            break;
        }
        if ((line = this.lines.get(label)) != null) {
            this.out.printf("%-20s|%5s: line %d\n", "LABEL", "L" + this.labelToString(label), line);
        } else {
            this.out.printf("%-20s|%5s:\n", "LABEL", "L" + this.labelToString(label));
        }
        if (!find) {
            for (TryCatch tc : this.trys) {
                if (label.equals(tc.start)) {
                    this.info(-1, "try { // TC_%d ", this.trys.indexOf(tc));
                    break;
                }
                if (!label.equals(tc.handler)) continue;
                String t = tc.type;
                this.info(-1, "catch(%s) // TC_%d", t == null ? "all" : t, this.trys.indexOf(tc));
                break;
            }
        }
    }

    @Override
    public void visitTryCatch(DexLabel start, DexLabel end, DexLabel handler, String type) {
        TryCatch tc = new TryCatch(start, end, handler, type);
        this.trys.add(tc);
        int id = this.trys.indexOf(tc);
        if (type == null) {
            this.out.printf("TR_%d L%s ~ L%s > L%s all\n", id, this.labelToString(start), this.labelToString(end), this.labelToString(handler));
        } else {
            this.out.printf("TR_%d L%s ~ L%s > L%s %s\n", id, this.labelToString(start), this.labelToString(end), this.labelToString(handler), type);
        }
        super.visitTryCatch(start, end, handler, type);
    }

    @Override
    public void visitLineNumber(int line, DexLabel label) {
        this.lines.put(label, line);
    }

    @Override
    public void visitLocalVariable(String name, String type, String signature, DexLabel start, DexLabel end, int reg) {
        this.out.printf("LOCAL_VARIABLE L%s ~ L%s v%d -> %s // %s \n", this.labelToString(start), this.labelToString(end), reg, name, type);
    }

    private static class TryCatch {
        public DexLabel end;
        public DexLabel handler;
        public DexLabel start;
        public String type;

        public TryCatch(DexLabel start, DexLabel end, DexLabel handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }
}

