/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.openejb.server.httpd.FilterListener;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;

public class HttpListenerRegistry
implements HttpListener {
    private final Map<String, HttpListener> registry = new LinkedHashMap<String, HttpListener>();
    private final Map<String, Collection<HttpListener>> filterRegistry = new LinkedHashMap<String, Collection<HttpListener>>();
    private final ThreadLocal<FilterListener> currentFilterListener = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
        HashMap<String, Collection<HttpListener>> filters;
        String path = request.getURI().getPath();
        FilterListener currentFL = this.currentFilterListener.get();
        Map<String, Collection<HttpListener>> map = this.filterRegistry;
        synchronized (map) {
            filters = new HashMap<String, Collection<HttpListener>>(this.filterRegistry);
        }
        try {
            HashMap<String, HttpListener> listeners;
            boolean lastWasCurrent = false;
            for (Map.Entry entry : filters.entrySet()) {
                String pattern = (String)entry.getKey();
                for (HttpListener listener : (Collection)entry.getValue()) {
                    if ((lastWasCurrent || currentFL == null) && path.matches(pattern)) {
                        listener.onMessage(request, response);
                        return;
                    }
                    lastWasCurrent = listener == currentFL;
                }
            }
            Map<String, HttpListener> map2 = this.registry;
            synchronized (map2) {
                listeners = new HashMap<String, HttpListener>(this.registry);
            }
            for (Map.Entry entry3 : listeners.entrySet()) {
                String pattern = (String)entry3.getKey();
                if (!path.matches(pattern) && !path.equals(pattern)) continue;
                ((HttpListener)entry3.getValue()).onMessage(request, response);
                break;
            }
        }
        finally {
            if (currentFL == null) {
                this.currentFilterListener.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpListener(HttpListener listener, String regex) {
        Map<String, HttpListener> map = this.registry;
        synchronized (map) {
            this.registry.put(regex, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpListener removeHttpListener(String regex) {
        HttpListener listener;
        Map<String, HttpListener> map = this.registry;
        synchronized (map) {
            listener = this.registry.remove(regex);
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHttpFilter(HttpListener listener, String regex) {
        Map<String, Collection<HttpListener>> map = this.filterRegistry;
        synchronized (map) {
            if (!this.filterRegistry.containsKey(regex)) {
                this.filterRegistry.put(regex, new ArrayList());
            }
            this.filterRegistry.get(regex).add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HttpListener> removeHttpFilter(String regex) {
        Map<String, Collection<HttpListener>> map = this.filterRegistry;
        synchronized (map) {
            return this.filterRegistry.remove(regex);
        }
    }

    public void setOrigin(FilterListener origin) {
        if (origin == null) {
            this.currentFilterListener.remove();
        } else {
            this.currentFilterListener.set(origin);
        }
    }
}

