/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.inject.spi.SessionBeanType;
import javax.inject.Provider;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.CdiEjbBean;
import org.apache.openejb.cdi.CdiResourceInjectionService;
import org.apache.openejb.cdi.CurrentCreationalContext;
import org.apache.openejb.cdi.NewCdiEjbBean;
import org.apache.openejb.cdi.OpenEJBBeanBuilder;
import org.apache.openejb.cdi.WebappWebBeansContext;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.util.proxy.ProxyManager;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.ObserverMethodsBuilder;
import org.apache.webbeans.component.creation.ProducerFieldBeansBuilder;
import org.apache.webbeans.component.creation.ProducerMethodBeansBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.portable.events.ProcessAnnotatedTypeImpl;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.portable.events.generics.GProcessSessionBean;
import org.apache.webbeans.proxy.NormalScopeProxyFactory;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.spi.plugins.AbstractOwbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansJavaEEPlugin;
import org.apache.webbeans.util.WebBeansUtil;

public class CdiPlugin
extends AbstractOwbPlugin
implements OpenWebBeansJavaEEPlugin,
OpenWebBeansEjbPlugin {
    private Map<Class<?>, BeanContext> beans;
    private WebBeansContext webBeansContext;
    private CdiAppContextsService contexsServices;
    private ClassLoader classLoader;
    private Map<Contextual<?>, Object> cacheProxies;

    public void setWebBeansContext(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.cacheProxies = !WebappWebBeansContext.class.isInstance(webBeansContext) ? new ConcurrentHashMap() : ((CdiPlugin)((Object)CdiPlugin.class.cast((Object)((WebappWebBeansContext)((Object)WebappWebBeansContext.class.cast((Object)webBeansContext))).getParent().getPluginLoader().getEjbPlugin()))).cacheProxies;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void shutDown() {
        super.shutDown();
        if (this.beans != null) {
            this.beans.clear();
        }
    }

    public void configureDeployments(List<BeanContext> ejbDeployments) {
        this.beans = new WeakHashMap();
        for (BeanContext deployment : ejbDeployments) {
            if (!deployment.getComponentType().isSession()) continue;
            if (deployment.isLocalbean() && !deployment.isDynamicallyImplemented()) {
                this.beans.put(deployment.get(BeanContext.ProxyClass.class).getProxy(), deployment);
            }
            this.beans.put(deployment.getBeanClass(), deployment);
        }
    }

    public CdiAppContextsService getContexsServices() {
        return this.contexsServices;
    }

    public void startup() {
        this.contexsServices = (CdiAppContextsService)this.webBeansContext.getContextsService();
        this.contexsServices.init(null);
    }

    public void stop() throws OpenEJBException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.webBeansContext.getBeanManagerImpl().fireEvent((Object)new BeforeShutdownImpl(), new Annotation[0]);
            this.contexsServices.destroy(null);
            this.webBeansContext.getPluginLoader().shutDown();
            this.webBeansContext.getExtensionLoader().clear();
            this.webBeansContext.getBeanManagerImpl().getInjectionResolver().clearCaches();
            this.webBeansContext.getAnnotatedElementFactory().clear();
            CdiResourceInjectionService injectionServices = (CdiResourceInjectionService)this.webBeansContext.getService(ResourceInjectionService.class);
            injectionServices.clear();
            WebBeansFinder.clearInstances((Object)WebBeansUtil.getCurrentClassLoader());
        }
        catch (Exception e) {
            throw new OpenEJBException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public <T> T getSupportedService(Class<T> serviceClass) {
        return this.supportService(serviceClass) ? (T)serviceClass.cast((Object)this) : null;
    }

    public void isManagedBean(Class<?> clazz) {
    }

    public boolean supportService(Class<?> serviceClass) {
        return serviceClass == TransactionService.class || serviceClass == SecurityService.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSessionBeanProxy(Bean<?> inBean, Class<?> interfce, CreationalContext<?> creationalContext) {
        Object instance = this.cacheProxies.get(inBean);
        if (instance != null) {
            return instance;
        }
        Bean<?> bean = inBean;
        synchronized (bean) {
            instance = this.cacheProxies.get(inBean);
            if (instance != null) {
                return instance;
            }
            Class scopeClass = inBean.getScope();
            CdiEjbBean cdiEjbBean = (CdiEjbBean)inBean;
            CreationalContext<?> cc = creationalContext;
            if (scopeClass == null || Dependent.class == scopeClass) {
                return cdiEjbBean.createEjb(cc);
            }
            InstanceBean<Object> bean2 = new InstanceBean<Object>(cdiEjbBean);
            if (this.webBeansContext.getBeanManagerImpl().isNormalScope(scopeClass)) {
                BeanContext beanContext = cdiEjbBean.getBeanContext();
                final Provider provider = this.webBeansContext.getNormalScopeProxyFactory().getInstanceProvider(beanContext.getClassLoader(), (Bean)cdiEjbBean);
                if (!beanContext.isLocalbean()) {
                    ArrayList<Class<BeanContext.Removable>> interfaces = new ArrayList<Class<BeanContext.Removable>>();
                    InterfaceType type = beanContext.getInterfaceType(interfce);
                    if (type != null) {
                        interfaces.addAll(beanContext.getInterfaces(type));
                    } else {
                        interfaces.addAll(beanContext.getInterfaces(InterfaceType.BUSINESS_LOCAL));
                    }
                    interfaces.add(Serializable.class);
                    interfaces.add(IntraVmProxy.class);
                    if (BeanType.STATEFUL.equals((Object)beanContext.getComponentType()) || BeanType.MANAGED.equals((Object)beanContext.getComponentType())) {
                        interfaces.add(BeanContext.Removable.class);
                    }
                    try {
                        instance = ProxyManager.newProxyInstance(interfaces.toArray(new Class[interfaces.size()]), new InvocationHandler(){

                            @Override
                            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                                try {
                                    return method.invoke(provider.get(), args);
                                }
                                catch (InvocationTargetException ite) {
                                    throw ite.getCause();
                                }
                            }
                        });
                    }
                    catch (IllegalAccessException e) {
                        throw new OpenEJBRuntimeException(e);
                    }
                } else {
                    NormalScopeProxyFactory normalScopeProxyFactory = this.webBeansContext.getNormalScopeProxyFactory();
                    Class proxyClass = normalScopeProxyFactory.createProxyClass(beanContext.getClassLoader(), beanContext.getBeanClass());
                    instance = normalScopeProxyFactory.createProxyInstance(proxyClass, provider);
                }
                this.cacheProxies.put((Contextual<?>)inBean, instance);
            } else {
                Context context = this.webBeansContext.getBeanManagerImpl().getContext(scopeClass);
                instance = context.get(bean2, cc);
            }
            bean2.setOwbProxy(instance);
            return instance;
        }
    }

    public boolean isSessionBean(Class<?> clazz) {
        return this.beans != null && this.beans.containsKey(clazz);
    }

    public boolean isNewSessionBean(Class<?> clazz) {
        return this.isNewSessionBean(this.webBeansContext, clazz) || this.isNewSessionBean(CdiPlugin.superContext(this.webBeansContext), clazz);
    }

    private boolean isNewSessionBean(WebBeansContext ctx, Class<?> clazz) {
        if (ctx == null) {
            return false;
        }
        Map<Class<?>, BeanContext> map = CdiPlugin.pluginBeans(ctx);
        return map != null && (map.containsKey(clazz) || clazz.isInterface() && CdiPlugin.findBeanContext(ctx, clazz) != null);
    }

    private static WebBeansContext superContext(WebBeansContext ctx) {
        if (!WebappWebBeansContext.class.isInstance(ctx)) {
            return null;
        }
        return ((WebappWebBeansContext)((Object)WebappWebBeansContext.class.cast(ctx))).getParent();
    }

    private static BeanContext findBeanContext(WebBeansContext ctx, Class<?> clazz) {
        Map<Class<?>, BeanContext> beans = CdiPlugin.pluginBeans(ctx);
        BeanContext b = beans.get(clazz);
        if (b != null) {
            return b;
        }
        for (BeanContext bc : beans.values()) {
            CdiEjbBean cdiEjbBean;
            if (bc.isLocalbean() || (cdiEjbBean = bc.get(CdiEjbBean.class)) == null) continue;
            for (Class<?> itf : cdiEjbBean.getBusinessLocalInterfaces()) {
                if (!itf.equals(clazz)) continue;
                return bc;
            }
        }
        WebBeansContext parentCtx = CdiPlugin.superContext(ctx);
        if (parentCtx != null) {
            return CdiPlugin.findBeanContext(parentCtx, clazz);
        }
        return null;
    }

    public <T> Bean<T> defineSessionBean(Class<T> clazz, ProcessAnnotatedType<T> processAnnotateTypeEvent) {
        BeanContext bc = CdiPlugin.findBeanContext(this.webBeansContext, clazz);
        AnnotatedType annotatedType = processAnnotateTypeEvent.getAnnotatedType();
        BaseEjbBean bean = new OpenEJBBeanBuilder(bc, this.webBeansContext, annotatedType).createBean(clazz, CdiPlugin.isActivated(processAnnotateTypeEvent));
        bc.set(CdiEjbBean.class, bean);
        bc.set(CurrentCreationalContext.class, new CurrentCreationalContext());
        CdiPlugin.validateDisposeMethods(bean);
        CdiPlugin.validateScope(bean);
        Set observerMethods = bean.isEnabled() ? new ObserverMethodsBuilder(this.webBeansContext, bean.getAnnotatedType()).defineObserverMethods((AbstractOwbBean)bean) : new HashSet();
        WebBeansUtil webBeansUtil = this.webBeansContext.getWebBeansUtil();
        Set producerMethods = new ProducerMethodBeansBuilder(bean.getWebBeansContext(), bean.getAnnotatedType()).defineProducerMethods((InjectionTargetBean)bean);
        Set producerFields = new ProducerFieldBeansBuilder(bean.getWebBeansContext(), bean.getAnnotatedType()).defineProducerFields((InjectionTargetBean)bean);
        HashMap<ProducerMethodBean, AnnotatedMethod> annotatedMethods = new HashMap<ProducerMethodBean, AnnotatedMethod>();
        for (ProducerMethodBean producerMethod : producerMethods) {
            AnnotatedMethod method = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedMethod(producerMethod.getCreatorMethod(), annotatedType);
            webBeansUtil.inspectErrorStack("There are errors that are added by ProcessProducer event observers for ProducerMethods. Look at logs for further details");
            annotatedMethods.put(producerMethod, method);
        }
        HashMap<ProducerFieldBean, AnnotatedField> annotatedFields = new HashMap<ProducerFieldBean, AnnotatedField>();
        for (ProducerFieldBean producerField : producerFields) {
            webBeansUtil.inspectErrorStack("There are errors that are added by ProcessProducer event observers for ProducerFields. Look at logs for further details");
            annotatedFields.put(producerField, this.webBeansContext.getAnnotatedElementFactory().newAnnotatedField(producerField.getCreatorField(), this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(producerField.getBeanClass())));
        }
        HashMap observerMethodsMap = new HashMap();
        for (ObserverMethod observerMethod : observerMethods) {
            ObserverMethodImpl impl = (ObserverMethodImpl)observerMethod;
            AnnotatedMethod method = impl.getObserverMethod();
            observerMethodsMap.put(observerMethod, method);
        }
        CdiPlugin.validateProduceMethods(bean, producerMethods);
        CdiPlugin.validateObserverMethods(bean, observerMethodsMap);
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        this.webBeansContext.getBeanManagerImpl().fireEvent((Object)new GProcessSessionBean((Bean)Bean.class.cast(bean), annotatedType, bc.getEjbName(), bean.getEjbType()), new Annotation[0]);
        webBeansUtil.inspectErrorStack("There are errors that are added by ProcessSessionBean event observers for managed beans. Look at logs for further details");
        webBeansUtil.fireProcessProducerMethodBeanEvent(annotatedMethods, annotatedType);
        webBeansUtil.inspectErrorStack("There are errors that are added by ProcessProducerMethod event observers for producer method beans. Look at logs for further details");
        webBeansUtil.fireProcessProducerFieldBeanEvent(annotatedFields);
        webBeansUtil.inspectErrorStack("There are errors that are added by ProcessProducerField event observers for producer field beans. Look at logs for further details");
        webBeansUtil.fireProcessObservableMethodBeanEvent(observerMethodsMap);
        webBeansUtil.inspectErrorStack("There are errors that are added by ProcessObserverMethod event observers for observer methods. Look at logs for further details");
        if (!webBeansUtil.isAnnotatedTypeDecoratorOrInterceptor(annotatedType)) {
            for (ProducerMethodBean producerMethod : producerMethods) {
                beanManager.addBean((Bean)producerMethod);
            }
            for (ProducerFieldBean producerField : producerFields) {
                beanManager.addBean((Bean)producerField);
            }
        }
        beanManager.addBean((Bean)bean);
        return bean;
    }

    public <T> Bean<T> defineNewSessionBean(Class<T> clazz) {
        NewCdiEjbBean newBean = new NewCdiEjbBean(CdiPlugin.findBeanContext(this.webBeansContext, clazz).get(CdiEjbBean.class));
        this.webBeansContext.getBeanManagerImpl().addBean(newBean);
        return newBean;
    }

    private static Map<Class<?>, BeanContext> pluginBeans(WebBeansContext ctx) {
        return ((CdiPlugin)((Object)CdiPlugin.class.cast((Object)ctx.getPluginLoader().getEjbPlugin()))).beans;
    }

    private static void validateObserverMethods(CdiEjbBean<?> bean, Map<ObserverMethod<?>, AnnotatedMethod<?>> methods) {
        BeanContext beanContext = bean.getBeanContext();
        if (beanContext.isLocalbean()) {
            return;
        }
        for (Map.Entry<ObserverMethod<?>, AnnotatedMethod<?>> m : methods.entrySet()) {
            Method method = m.getValue().getJavaMember();
            if (Modifier.isStatic(method.getModifiers()) || CdiPlugin.doResolveViewMethod(bean, method) != null) continue;
            throw new WebBeansConfigurationException("@Observes " + method + " neither in the ejb view of ejb " + bean.getBeanContext().getEjbName() + " nor static");
        }
    }

    private static void validateProduceMethods(CdiEjbBean<?> bean, Set<ProducerMethodBean<?>> methods) {
        BeanContext beanContext = bean.getBeanContext();
        if (beanContext.isLocalbean()) {
            return;
        }
        for (ProducerMethodBean<?> m : methods) {
            Method method = m.getCreatorMethod();
            if (CdiPlugin.doResolveViewMethod(bean, method) != null) continue;
            throw new WebBeansConfigurationException("@Produces " + method + " not in the ejb view of ejb " + beanContext.getEjbName());
        }
    }

    private static void validateScope(CdiEjbBean<?> bean) {
        Class scope = bean.getScope();
        BeanType beanType = bean.getBeanContext().getComponentType();
        if (BeanType.STATELESS.equals((Object)beanType) && !Dependent.class.equals((Object)scope)) {
            throw new WebBeansConfigurationException("@Stateless can only be @Dependent");
        }
        if (BeanType.SINGLETON.equals((Object)beanType) && !Dependent.class.equals((Object)scope) && !ApplicationScoped.class.equals((Object)scope)) {
            throw new WebBeansConfigurationException("@Singleton can only be @Dependent or @ApplicationScoped");
        }
    }

    private static void validateDisposeMethods(CdiEjbBean<?> bean) {
        if (!bean.getBeanContext().isLocalbean()) {
            for (Method m : bean.getBeanContext().getBeanClass().getMethods()) {
                if (m.getDeclaringClass().equals(Object.class) || m.getParameterTypes().length <= 0) continue;
                Annotation[][] arr$ = m.getParameterAnnotations();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Annotation[] a;
                    for (Annotation ann : a = arr$[i$]) {
                        if (!ann.annotationType().equals(Disposes.class) || CdiPlugin.doResolveViewMethod(bean, m) != null) continue;
                        throw new WebBeansConfigurationException("@Disposes is forbidden on non business EJB methods");
                    }
                }
            }
        }
    }

    private static boolean isActivated(ProcessAnnotatedType<?> pat) {
        return !ProcessAnnotatedTypeImpl.class.isInstance(pat) || !((ProcessAnnotatedTypeImpl)ProcessAnnotatedTypeImpl.class.cast(pat)).isVeto();
    }

    public boolean isSingletonBean(Class<?> clazz) {
        throw new IllegalStateException("Statement should never be reached");
    }

    public boolean isStatefulBean(Class<?> clazz) {
        return BeanType.STATEFUL.equals((Object)this.beans.get(clazz).getComponentType());
    }

    public boolean isStatelessBean(Class<?> clazz) {
        throw new IllegalStateException("Statement should never be reached");
    }

    public static Method doResolveViewMethod(Bean<?> component, Method declaredMethod) {
        if (!(component instanceof CdiEjbBean)) {
            return declaredMethod;
        }
        CdiEjbBean cdiEjbBean = (CdiEjbBean)component;
        BeanContext beanContext = cdiEjbBean.getBeanContext();
        for (Class intface : beanContext.getBusinessLocalInterfaces()) {
            try {
                return intface.getMethod(declaredMethod.getName(), declaredMethod.getParameterTypes());
            }
            catch (NoSuchMethodException ignore) {
            }
        }
        return null;
    }

    public Method resolveViewMethod(Bean<?> component, Method declaredMethod) {
        Method m = CdiPlugin.doResolveViewMethod(component, declaredMethod);
        if (m == null) {
            return declaredMethod;
        }
        return m;
    }

    public void clearProxies() {
        this.cacheProxies.clear();
    }

    private static class EjbProducer<T>
    implements Producer<T> {
        private final CdiEjbBean<T> ejb;
        private final InstanceBean<T> instance;

        public EjbProducer(InstanceBean<T> tInstanceBean, CdiEjbBean<T> bean) {
            this.instance = tInstanceBean;
            this.ejb = bean;
        }

        public T produce(CreationalContext<T> creationalContext) {
            return this.instance.create(creationalContext);
        }

        public void dispose(T instance) {
            this.ejb.destroyComponentInstance(instance);
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }
    }

    private static class InstanceBean<T>
    implements OwbBean<T>,
    PassivationCapable {
        private final CdiEjbBean<T> bean;
        private T owbProxy;

        public InstanceBean(CdiEjbBean<T> tCdiEjbBean) {
            this.bean = tCdiEjbBean;
        }

        public Set<Type> getTypes() {
            return this.bean.getTypes();
        }

        public Set<Annotation> getQualifiers() {
            return this.bean.getQualifiers();
        }

        public Class<? extends Annotation> getScope() {
            return this.bean.getScope();
        }

        public String getName() {
            return this.bean.getName();
        }

        public boolean isNullable() {
            return this.bean.isNullable();
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public Class<?> getBeanClass() {
            return this.bean.getBeanClass();
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.bean.getStereotypes();
        }

        public boolean isAlternative() {
            return this.bean.isAlternative();
        }

        public T create(CreationalContext<T> creationalContext) {
            T instance = this.bean.createEjb(creationalContext);
            if (this.owbProxy != null && SessionBeanType.STATEFUL.equals((Object)this.bean.getEjbType())) {
                this.bean.storeStatefulInstance(this.owbProxy, instance);
            }
            return instance;
        }

        public void destroy(T instance, CreationalContext<T> cc) {
            if (!SessionBeanType.STATEFUL.equals((Object)this.bean.getEjbType())) {
                return;
            }
            this.bean.destroy(instance, cc);
        }

        public Producer<T> getProducer() {
            return new EjbProducer<T>(this, this.bean);
        }

        public WebBeansType getWebBeansType() {
            return this.bean.getWebBeansType();
        }

        public Class<T> getReturnType() {
            return this.bean.getReturnType();
        }

        public void setSpecializedBean(boolean specialized) {
        }

        public boolean isSpecializedBean() {
            return this.bean.isSpecializedBean();
        }

        public void setEnabled(boolean enabled) {
        }

        public boolean isEnabled() {
            return this.bean.isEnabled();
        }

        public String getId() {
            return this.bean.getId();
        }

        public boolean isPassivationCapable() {
            return this.bean.isPassivationCapable();
        }

        public boolean isDependent() {
            return this.bean.isDependent();
        }

        public WebBeansContext getWebBeansContext() {
            return this.bean.getWebBeansContext();
        }

        public void setOwbProxy(T owbProxy) {
            this.owbProxy = owbProxy;
        }

        public boolean equals(Object o) {
            if (AbstractOwbBean.class.isInstance(o)) {
                return ((Object)this.bean).equals(o);
            }
            return InstanceBean.class.isInstance(o) && ((Object)this.bean).equals(((InstanceBean)InstanceBean.class.cast((Object)o)).bean);
        }

        public int hashCode() {
            return ((Object)this.bean).hashCode();
        }
    }
}

