/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.classloader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.classloader.FalseFilter;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;

public class ProvisioningClassLoaderConfigurer
implements ClassLoaderConfigurer {
    private URL[] added = new URL[0];
    private Filter excluded = FalseFilter.INSTANCE;

    @Override
    public URL[] additionalURLs() {
        return this.added;
    }

    @Override
    public boolean accept(URL url) {
        try {
            File file = URLs.toFile(url);
            return !this.excluded.accept(file.getName());
        }
        catch (IllegalArgumentException iae) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(String configFile) {
        ArrayList<URL> toAdd = new ArrayList<URL>();
        ArrayList<String> toExclude = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(configFile));
            while ((line = reader.readLine()) != null) {
                String computedHash;
                if ((line = PropertyPlaceHolderHelper.SUBSTITUTOR.replace(line.trim())).startsWith("#")) continue;
                if (line.startsWith("-")) {
                    toExclude.add(line);
                    continue;
                }
                if (line.startsWith("+")) {
                    line = line.substring(1);
                }
                String location = line;
                String algo = "MD5";
                String hash = null;
                boolean validJar = line.contains("|");
                if (validJar) {
                    String[] segments = line.split("|");
                    location = segments[0];
                    if (segments.length >= 2) {
                        hash = segments[1];
                    }
                    if (segments.length >= 3) {
                        algo = segments[2].trim();
                    }
                }
                Set<URL> repos = Files.listJars(ProvisioningUtil.realLocation(location));
                toAdd.addAll(repos);
                if (!validJar || (computedHash = Files.hash(repos, algo)).equals(hash)) continue;
                throw new IllegalStateException("Hash of " + location + "(" + computedHash + ") doesn't match expected one (" + hash + ")");
            }
        }
        catch (Exception e) {
            try {
                Logger.getInstance(LogCategory.OPENEJB, ProvisioningClassLoaderConfigurer.class).error("Can't read " + configFile, e);
            }
            catch (Throwable throwable) {
                IO.close(reader);
                throw throwable;
            }
            IO.close(reader);
        }
        IO.close(reader);
        this.added = toAdd.toArray(new URL[toAdd.size()]);
        if (toExclude.size() > 0) {
            this.excluded = Filters.prefixes((String[])toExclude.toArray(new String[toExclude.size()]));
        }
    }
}

