/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.interceptor.InvocationContext;
import javax.xml.rpc.handler.MessageContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.Interceptor;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.JaxRpcInvocationContext;
import org.apache.openejb.core.interceptor.JaxWsInvocationContext;
import org.apache.openejb.core.interceptor.ReflectionInvocationContext;
import org.apache.openejb.util.proxy.DynamicProxyImplFactory;

public class InterceptorStack {
    private final Object beanInstance;
    private final List<Interceptor> interceptors;
    private final Method targetMethod;
    private final Operation operation;

    public InterceptorStack(Object beanInstance, Method targetMethod, Operation operation, List<InterceptorData> interceptorDatas, Map<String, Object> interceptorInstances) {
        if (interceptorDatas == null) {
            throw new NullPointerException("interceptorDatas is null");
        }
        if (interceptorInstances == null) {
            throw new NullPointerException("interceptorInstances is null");
        }
        this.beanInstance = beanInstance;
        this.targetMethod = targetMethod;
        this.operation = operation;
        this.interceptors = new ArrayList<Interceptor>(interceptorDatas.size());
        for (InterceptorData interceptorData : interceptorDatas) {
            Class interceptorClass = interceptorData.getInterceptorClass();
            Object interceptorInstance = interceptorInstances.get(interceptorClass.getName());
            if (interceptorInstance == null) {
                throw new IllegalArgumentException("No interceptor of type " + interceptorClass.getName());
            }
            Set<Method> methods = interceptorData.getMethods(operation);
            for (Method method : methods) {
                Object handler = DynamicProxyImplFactory.realHandler(interceptorInstance);
                Interceptor interceptor = handler != null && method.getDeclaringClass().equals(handler.getClass()) ? new Interceptor(handler, method) : new Interceptor(interceptorInstance, method);
                this.interceptors.add(interceptor);
            }
        }
    }

    public InvocationContext createInvocationContext(Object ... parameters) {
        return new ReflectionInvocationContext(this.operation, this.interceptors, this.beanInstance, this.targetMethod, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object ... parameters) throws Exception {
        try {
            InvocationContext invocationContext = this.createInvocationContext(parameters);
            if (ThreadContext.getThreadContext() != null) {
                ThreadContext.getThreadContext().set(InvocationContext.class, invocationContext);
            }
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            if (ThreadContext.getThreadContext() != null) {
                ThreadContext.getThreadContext().remove(InvocationContext.class);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(javax.xml.ws.handler.MessageContext messageContext, Object ... parameters) throws Exception {
        try {
            JaxWsInvocationContext invocationContext = new JaxWsInvocationContext(this.operation, this.interceptors, this.beanInstance, this.targetMethod, messageContext, parameters);
            ThreadContext.getThreadContext().set(InvocationContext.class, invocationContext);
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            ThreadContext.getThreadContext().remove(InvocationContext.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MessageContext messageContext, Object ... parameters) throws Exception {
        try {
            JaxRpcInvocationContext invocationContext = new JaxRpcInvocationContext(this.operation, this.interceptors, this.beanInstance, this.targetMethod, messageContext, parameters);
            ThreadContext.getThreadContext().set(InvocationContext.class, invocationContext);
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            ThreadContext.getThreadContext().remove(InvocationContext.class);
        }
    }
}

