/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.openejb.OpenEJBRuntimeException;

public final class Reflections {
    private Reflections() {
    }

    public static Method findMethod(String name, Class<?> type, Class<?> ... args) {
        try {
            return type.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Can't find public method " + name + " in " + type.getName());
        }
    }

    public static Object invokeByReflection(Object obj, String mtdName, Class<?>[] paramTypes, Object[] args) {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            boolean acc = true;
            Method mtd = null;
            try {
                mtd = clazz.getDeclaredMethod(mtdName, paramTypes);
                acc = mtd.isAccessible();
                mtd.setAccessible(true);
                Object object = mtd.invoke(obj, args);
                return object;
            }
            catch (NoSuchMethodException nsme) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                if (mtd != null) {
                    mtd.setAccessible(acc);
                }
            }
        }
        throw new IllegalArgumentException(new NoSuchMethodException(obj.getClass().getName() + " ." + mtdName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Object instance, String field, Object value) {
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field f = clazz.getDeclaredField(field);
                boolean acc = f.isAccessible();
                f.setAccessible(true);
                try {
                    f.set(instance, value);
                    return;
                }
                finally {
                    f.setAccessible(acc);
                }
            }
            catch (NoSuchFieldException nsfe) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Object instance, String field) {
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field f = clazz.getDeclaredField(field);
            boolean acc = f.isAccessible();
            f.setAccessible(true);
            try {
                Object object = f.get(instance);
                f.setAccessible(acc);
                return object;
            }
            catch (Throwable throwable) {
                try {
                    f.setAccessible(acc);
                    throw throwable;
                }
                catch (NoSuchFieldException nsfe) {
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        throw new OpenEJBRuntimeException(new NoSuchFieldException(field));
    }
}

