/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.impl;

import java.util.ArrayList;
import java.util.List;

public class SectionUniqueIdCounter {
    private List<Section> _counterStack;
    private int _activeSection = 0;
    private final String _prefix;
    private final StringBuilder _builder;
    private char[] _bufferConversion;
    private final int _radix;
    private final String[] _uniqueIdsCache;

    public SectionUniqueIdCounter() {
        this._radix = 36;
        this._counterStack = new ArrayList<Section>();
        this._counterStack.add(new Section(null, 1L, this._radix));
        this._prefix = null;
        this._builder = new StringBuilder(30);
        this._bufferConversion = new char[15];
        this._uniqueIdsCache = null;
    }

    public SectionUniqueIdCounter(String prefix) {
        this._radix = 36;
        this._counterStack = new ArrayList<Section>();
        this._counterStack.add(new Section(null, 1L, this._radix));
        this._prefix = prefix;
        this._builder = new StringBuilder(30);
        this._bufferConversion = new char[15];
        this._uniqueIdsCache = null;
    }

    public SectionUniqueIdCounter(String prefix, String[] cache) {
        this._radix = 36;
        this._counterStack = new ArrayList<Section>();
        this._counterStack.add(new Section(null, 1L, this._radix));
        this._prefix = prefix;
        this._builder = new StringBuilder(30);
        this._bufferConversion = new char[15];
        this._uniqueIdsCache = cache;
    }

    public SectionUniqueIdCounter(String prefix, int radix) {
        this._radix = radix;
        this._counterStack = new ArrayList<Section>();
        this._counterStack.add(new Section(null, 1L, this._radix));
        this._prefix = prefix;
        this._builder = new StringBuilder(30);
        this._bufferConversion = new char[15];
        this._uniqueIdsCache = null;
    }

    public static String[] generateUniqueIdCache(String prefix, int count) {
        String[] cache = new String[count];
        SectionUniqueIdCounter counter = new SectionUniqueIdCounter(prefix);
        for (int i = 0; i < count; ++i) {
            cache[i] = counter.generateUniqueId();
        }
        return cache;
    }

    public String startUniqueIdSection() {
        this._builder.delete(0, this._builder.length());
        if (!this._counterStack.isEmpty()) {
            String lastPrefix = this._counterStack.get(this._counterStack.size() - 1).getPrefix();
            if (lastPrefix != null) {
                this._builder.append(lastPrefix);
                this._builder.append('_');
            }
            SectionUniqueIdCounter.appendToBuilder(this._counterStack.get(this._counterStack.size() - 1).getCounter(), this._radix, this._builder, this._bufferConversion);
        }
        this._counterStack.add(new Section(this._builder.toString(), 1L, this._radix));
        ++this._activeSection;
        return this._builder.toString();
    }

    public String startUniqueIdSection(String base) {
        this._builder.delete(0, this._builder.length());
        if (!this._counterStack.isEmpty()) {
            String lastPrefix = this._counterStack.get(this._counterStack.size() - 1).getPrefix();
            if (lastPrefix != null) {
                this._builder.append(lastPrefix);
                this._builder.append('_');
            }
            SectionUniqueIdCounter.appendToBuilder(this._counterStack.get(this._counterStack.size() - 1).getCounter(), this._radix, this._builder, this._bufferConversion);
        }
        if (base != null && base.length() > 0) {
            this._builder.append('_');
            this._builder.append(base);
        }
        this._counterStack.add(new Section(this._builder.toString(), 1L, this._radix));
        ++this._activeSection;
        return this._builder.toString();
    }

    public String generateUniqueId() {
        if (this._activeSection == 0 && this._uniqueIdsCache != null) {
            long i = this._counterStack.get(this._activeSection).getCounter();
            if ((long)((int)i) < (long)this._uniqueIdsCache.length) {
                this._counterStack.get(this._activeSection).incrementUniqueId();
                return this._uniqueIdsCache[(int)i - 1];
            }
            return this._counterStack.get(this._activeSection).generateUniqueId(this._prefix);
        }
        return this._counterStack.get(this._activeSection).generateUniqueId(this._prefix);
    }

    public void generateUniqueId(StringBuilder builderToAdd) {
        this._counterStack.get(this._activeSection).generateUniqueId(this._prefix, builderToAdd);
    }

    public void incrementUniqueId() {
        this._counterStack.get(this._activeSection).incrementUniqueId();
    }

    public void endUniqueIdSection() {
        if (this._activeSection <= 0) {
            this._counterStack.get(this._activeSection).generateUniqueId(this._prefix);
            return;
        }
        this._counterStack.remove(this._activeSection);
        --this._activeSection;
        this._counterStack.get(this._activeSection).generateUniqueId(this._prefix);
    }

    public void endUniqueIdSection(String base) {
        if (this._activeSection <= 0) {
            return;
        }
        this._counterStack.remove(this._activeSection);
        --this._activeSection;
    }

    private static void appendToBuilder(long l, int radix, StringBuilder builder, char[] bufferConversion) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (l == 0L) {
            builder.append('0');
            return;
        }
        int count = 2;
        long j = l;
        boolean bl = negative = l < 0L;
        if (!negative) {
            count = 1;
            j = -l;
        }
        while ((l /= (long)radix) != 0L) {
            ++count;
        }
        if (bufferConversion.length < count) {
            bufferConversion = new char[count];
        }
        int finalCount = count;
        char[] buffer = bufferConversion;
        do {
            int ch;
            ch = (ch = 0 - (int)(j % (long)radix)) > 9 ? ch - 10 + 97 : (ch += 48);
            buffer[--count] = (char)ch;
        } while ((j /= (long)radix) != 0L);
        if (negative) {
            buffer[0] = 45;
        }
        for (int i = 0; i < finalCount; ++i) {
            builder.append(buffer[i]);
        }
    }

    private static class Section {
        private String prefix;
        private long counter;
        private final StringBuilder _builder;
        private char[] _bufferConversion;
        private final int _radix;

        public Section(String prefix, long counter, int radix) {
            this.prefix = prefix;
            this.counter = counter;
            this._builder = new StringBuilder(30);
            this._bufferConversion = new char[15];
            this._radix = radix;
        }

        public long getCounter() {
            return this.counter;
        }

        public void incrementUniqueId() {
            ++this.counter;
        }

        public void generateUniqueId(String base, StringBuilder builder) {
            long i = this.counter++;
            if (base != null) {
                builder.append(base);
            }
            if (this.prefix != null) {
                builder.append(this.prefix);
                builder.append('_');
            }
            SectionUniqueIdCounter.appendToBuilder(i, this._radix, builder, this._bufferConversion);
        }

        public String generateUniqueId(String base) {
            long i = this.counter++;
            this._builder.delete(0, this._builder.length());
            if (base != null) {
                this._builder.append(base);
            }
            if (this.prefix != null) {
                this._builder.append(this.prefix);
                this._builder.append('_');
            }
            SectionUniqueIdCounter.appendToBuilder(i, this._radix, this._builder, this._bufferConversion);
            return this._builder.toString();
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

