/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class DrawableUtils {
    private static final String LOG_TAG = "DrawableUtils";
    private static Field sDrawableContainerStateField;
    private static boolean sDrawableContainerStateFieldFetched;
    private static Method sSetConstantStateMethod;
    private static boolean sSetConstantStateMethodFetched;

    private DrawableUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean setContainerConstantState(DrawableContainer drawableContainer, Drawable.ConstantState constantState) {
        if (Build.VERSION.SDK_INT < 9) return DrawableUtils.setContainerConstantStateV7(drawableContainer, constantState);
        return DrawableUtils.setContainerConstantStateV9(drawableContainer, constantState);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean setContainerConstantStateV7(DrawableContainer drawableContainer, Drawable.ConstantState constantState) {
        boolean bl2 = true;
        if (!sDrawableContainerStateFieldFetched) {
            try {
                sDrawableContainerStateField = DrawableContainer.class.getDeclaredField("mDrawableContainerStateField");
                sDrawableContainerStateField.setAccessible(true);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                Log.e((String)LOG_TAG, (String)"Could not fetch mDrawableContainerStateField. Oh well.");
            }
            sDrawableContainerStateFieldFetched = true;
        }
        if (sDrawableContainerStateField == null) return false;
        try {
            sDrawableContainerStateField.set(drawableContainer, constantState);
            return bl2;
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Could not set mDrawableContainerStateField. Oh well.");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean setContainerConstantStateV9(DrawableContainer drawableContainer, Drawable.ConstantState constantState) {
        boolean bl2 = true;
        if (!sSetConstantStateMethodFetched) {
            try {
                sSetConstantStateMethod = DrawableContainer.class.getDeclaredMethod("setConstantState", DrawableContainer.DrawableContainerState.class);
                sSetConstantStateMethod.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.e((String)LOG_TAG, (String)"Could not fetch setConstantState(). Oh well.");
            }
            sSetConstantStateMethodFetched = true;
        }
        if (sSetConstantStateMethod == null) return false;
        try {
            sSetConstantStateMethod.invoke((Object)drawableContainer, constantState);
            return bl2;
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Could not invoke setConstantState(). Oh well.");
        }
        return false;
    }
}

