/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.graphics.Rect;
import android.os.Build;
import android.support.design.widget.ViewGroupUtilsHoneycomb;
import android.view.View;
import android.view.ViewGroup;

class ViewGroupUtils {
    private static final ViewGroupUtilsImpl IMPL;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (Build.VERSION.SDK_INT >= 11) {
            IMPL = new ViewGroupUtilsImplHoneycomb();
            return;
        }
        IMPL = new ViewGroupUtilsImplBase();
    }

    ViewGroupUtils() {
    }

    static void getDescendantRect(ViewGroup viewGroup, View view, Rect rect) {
        rect.set(0, 0, view.getWidth(), view.getHeight());
        ViewGroupUtils.offsetDescendantRect(viewGroup, view, rect);
    }

    static void offsetDescendantRect(ViewGroup viewGroup, View view, Rect rect) {
        IMPL.offsetDescendantRect(viewGroup, view, rect);
    }

    private static interface ViewGroupUtilsImpl {
        public void offsetDescendantRect(ViewGroup var1, View var2, Rect var3);
    }

    private static class ViewGroupUtilsImplBase
    implements ViewGroupUtilsImpl {
        private ViewGroupUtilsImplBase() {
        }

        @Override
        public void offsetDescendantRect(ViewGroup viewGroup, View view, Rect rect) {
            viewGroup.offsetDescendantRectToMyCoords(view, rect);
            rect.offset(view.getScrollX(), view.getScrollY());
        }
    }

    private static class ViewGroupUtilsImplHoneycomb
    implements ViewGroupUtilsImpl {
        private ViewGroupUtilsImplHoneycomb() {
        }

        @Override
        public void offsetDescendantRect(ViewGroup viewGroup, View view, Rect rect) {
            ViewGroupUtilsHoneycomb.offsetDescendantRect(viewGroup, view, rect);
        }
    }
}

