/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.support.v4.view.ViewCompat;
import android.view.View;

class ViewOffsetHelper {
    private int mLayoutLeft;
    private int mLayoutTop;
    private int mOffsetLeft;
    private int mOffsetTop;
    private final View mView;

    public ViewOffsetHelper(View view) {
        this.mView = view;
    }

    private void updateOffsets() {
        ViewCompat.offsetTopAndBottom(this.mView, this.mOffsetTop - (this.mView.getTop() - this.mLayoutTop));
        ViewCompat.offsetLeftAndRight(this.mView, this.mOffsetLeft - (this.mView.getLeft() - this.mLayoutLeft));
    }

    public int getLeftAndRightOffset() {
        return this.mOffsetLeft;
    }

    public int getTopAndBottomOffset() {
        return this.mOffsetTop;
    }

    public void onViewLayout() {
        this.mLayoutTop = this.mView.getTop();
        this.mLayoutLeft = this.mView.getLeft();
        this.updateOffsets();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setLeftAndRightOffset(int n2) {
        if (this.mOffsetLeft == n2) return false;
        this.mOffsetLeft = n2;
        this.updateOffsets();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setTopAndBottomOffset(int n2) {
        if (this.mOffsetTop == n2) return false;
        this.mOffsetTop = n2;
        this.updateOffsets();
        return true;
    }
}

