/*
 * Decompiled with CFR 0.152.
 */
package android.support.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.graphics.drawable.AndroidResources;
import android.support.graphics.drawable.VectorDrawableCommon;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@TargetApi(value=21)
public class AnimatedVectorDrawableCompat
extends VectorDrawableCommon
implements Animatable {
    private static final String ANIMATED_VECTOR = "animated-vector";
    private static final boolean DBG_ANIMATION_VECTOR_DRAWABLE = false;
    private static final String LOGTAG = "AnimatedVDCompat";
    private static final String TARGET = "target";
    private AnimatedVectorDrawableCompatState mAnimatedVectorState;
    private ArgbEvaluator mArgbEvaluator = null;
    AnimatedVectorDrawableDelegateState mCachedConstantStateDelegate;
    private final Drawable.Callback mCallback = new Drawable.Callback(){

        public void invalidateDrawable(Drawable drawable2) {
            AnimatedVectorDrawableCompat.this.invalidateSelf();
        }

        public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l2) {
            AnimatedVectorDrawableCompat.this.scheduleSelf(runnable, l2);
        }

        public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
            AnimatedVectorDrawableCompat.this.unscheduleSelf(runnable);
        }
    };
    private Context mContext;

    private AnimatedVectorDrawableCompat() {
        this(null, null, null);
    }

    private AnimatedVectorDrawableCompat(@Nullable Context context) {
        this(context, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AnimatedVectorDrawableCompat(@Nullable Context context, @Nullable AnimatedVectorDrawableCompatState animatedVectorDrawableCompatState, @Nullable Resources resources) {
        this.mContext = context;
        if (animatedVectorDrawableCompatState != null) {
            this.mAnimatedVectorState = animatedVectorDrawableCompatState;
            return;
        }
        this.mAnimatedVectorState = new AnimatedVectorDrawableCompatState(context, animatedVectorDrawableCompatState, this.mCallback, resources);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static AnimatedVectorDrawableCompat create(@NonNull Context object, @DrawableRes int n2) {
        XmlResourceParser xmlResourceParser;
        if (Build.VERSION.SDK_INT >= 23) {
            AnimatedVectorDrawableCompat animatedVectorDrawableCompat = new AnimatedVectorDrawableCompat((Context)object);
            animatedVectorDrawableCompat.mDelegateDrawable = ResourcesCompat.getDrawable(object.getResources(), n2, object.getTheme());
            animatedVectorDrawableCompat.mDelegateDrawable.setCallback(animatedVectorDrawableCompat.mCallback);
            animatedVectorDrawableCompat.mCachedConstantStateDelegate = new AnimatedVectorDrawableDelegateState(animatedVectorDrawableCompat.mDelegateDrawable.getConstantState());
            return animatedVectorDrawableCompat;
        }
        Resources resources = object.getResources();
        try {
            xmlResourceParser = resources.getXml(n2);
            resources = Xml.asAttributeSet((XmlPullParser)xmlResourceParser);
            while ((n2 = xmlResourceParser.next()) != 2 && n2 != 1) {
            }
            if (n2 != 2) {
                object = new XmlPullParserException("No start tag found");
                throw object;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            Log.e((String)LOGTAG, (String)"parser error", (Throwable)xmlPullParserException);
            return null;
        }
        try {
            return AnimatedVectorDrawableCompat.createFromXmlInner(object, object.getResources(), (XmlPullParser)xmlResourceParser, (AttributeSet)resources, object.getTheme());
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"parser error", (Throwable)iOException);
            return null;
        }
    }

    public static AnimatedVectorDrawableCompat createFromXmlInner(Context object, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        object = new AnimatedVectorDrawableCompat((Context)object);
        ((AnimatedVectorDrawableCompat)object).inflate(resources, xmlPullParser, attributeSet, theme);
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStarted() {
        ArrayList<Animator> arrayList = this.mAnimatedVectorState.mAnimators;
        if (arrayList == null) {
            return false;
        }
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            if (arrayList.get(n3).isRunning()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static TypedArray obtainAttributes(Resources resources, Resources.Theme theme, AttributeSet attributeSet, int[] nArray) {
        if (theme != null) return theme.obtainStyledAttributes(attributeSet, nArray, 0, 0);
        return resources.obtainAttributes(attributeSet, nArray);
    }

    private void setupAnimatorsForTarget(String string2, Animator animator) {
        animator.setTarget(this.mAnimatedVectorState.mVectorDrawable.getTargetByName(string2));
        if (Build.VERSION.SDK_INT < 21) {
            this.setupColorAnimator(animator);
        }
        if (this.mAnimatedVectorState.mAnimators == null) {
            this.mAnimatedVectorState.mAnimators = new ArrayList();
            this.mAnimatedVectorState.mTargetNameMap = new ArrayMap();
        }
        this.mAnimatedVectorState.mAnimators.add(animator);
        this.mAnimatedVectorState.mTargetNameMap.put(animator, string2);
    }

    private void setupColorAnimator(Animator object) {
        ArrayList arrayList;
        if (object instanceof AnimatorSet && (arrayList = ((AnimatorSet)object).getChildAnimations()) != null) {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                this.setupColorAnimator((Animator)arrayList.get(i2));
            }
        }
        if (object instanceof ObjectAnimator && ("fillColor".equals(object = (arrayList = (ObjectAnimator)object).getPropertyName()) || "strokeColor".equals(object))) {
            if (this.mArgbEvaluator == null) {
                this.mArgbEvaluator = new ArgbEvaluator();
            }
            arrayList.setEvaluator((TypeEvaluator)this.mArgbEvaluator);
        }
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.applyTheme(this.mDelegateDrawable, theme);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canApplyTheme() {
        if (this.mDelegateDrawable == null) return false;
        return DrawableCompat.canApplyTheme(this.mDelegateDrawable);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.draw(canvas);
            return;
        }
        this.mAnimatedVectorState.mVectorDrawable.draw(canvas);
        if (!this.isStarted()) return;
        this.invalidateSelf();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getAlpha() {
        if (this.mDelegateDrawable == null) return this.mAnimatedVectorState.mVectorDrawable.getAlpha();
        return DrawableCompat.getAlpha(this.mDelegateDrawable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getChangingConfigurations() {
        if (this.mDelegateDrawable == null) return super.getChangingConfigurations() | this.mAnimatedVectorState.mChangingConfigurations;
        return this.mDelegateDrawable.getChangingConfigurations();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable.ConstantState getConstantState() {
        if (this.mDelegateDrawable == null) return null;
        return new AnimatedVectorDrawableDelegateState(this.mDelegateDrawable.getConstantState());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIntrinsicHeight() {
        if (this.mDelegateDrawable == null) return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicHeight();
        return this.mDelegateDrawable.getIntrinsicHeight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIntrinsicWidth() {
        if (this.mDelegateDrawable == null) return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicWidth();
        return this.mDelegateDrawable.getIntrinsicWidth();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getOpacity() {
        if (this.mDelegateDrawable == null) return this.mAnimatedVectorState.mVectorDrawable.getOpacity();
        return this.mDelegateDrawable.getOpacity();
    }

    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        this.inflate(resources, xmlPullParser, attributeSet, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.inflate(this.mDelegateDrawable, resources, xmlPullParser, attributeSet, theme);
            return;
        }
        int n2 = xmlPullParser.getEventType();
        while (n2 != 1) {
            if (n2 == 2) {
                Object object;
                String string2 = xmlPullParser.getName();
                if (ANIMATED_VECTOR.equals(string2)) {
                    string2 = AnimatedVectorDrawableCompat.obtainAttributes(resources, theme, attributeSet, AndroidResources.styleable_AnimatedVectorDrawable);
                    n2 = string2.getResourceId(0, 0);
                    if (n2 != 0) {
                        object = VectorDrawableCompat.create(resources, n2, theme);
                        ((VectorDrawableCompat)object).setAllowCaching(false);
                        object.setCallback(this.mCallback);
                        if (this.mAnimatedVectorState.mVectorDrawable != null) {
                            this.mAnimatedVectorState.mVectorDrawable.setCallback(null);
                        }
                        this.mAnimatedVectorState.mVectorDrawable = object;
                    }
                    string2.recycle();
                } else if (TARGET.equals(string2)) {
                    string2 = resources.obtainAttributes(attributeSet, AndroidResources.styleable_AnimatedVectorDrawableTarget);
                    object = string2.getString(0);
                    n2 = string2.getResourceId(1, 0);
                    if (n2 != 0) {
                        if (this.mContext == null) {
                            throw new IllegalStateException("Context can't be null when inflating animators");
                        }
                        this.setupAnimatorsForTarget((String)object, AnimatorInflater.loadAnimator((Context)this.mContext, (int)n2));
                    }
                    string2.recycle();
                }
            }
            n2 = xmlPullParser.next();
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRunning() {
        if (this.mDelegateDrawable != null) {
            return ((AnimatedVectorDrawable)this.mDelegateDrawable).isRunning();
        }
        ArrayList<Animator> arrayList = this.mAnimatedVectorState.mAnimators;
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            if (arrayList.get(n3).isRunning()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isStateful() {
        if (this.mDelegateDrawable == null) return this.mAnimatedVectorState.mVectorDrawable.isStateful();
        return this.mDelegateDrawable.isStateful();
    }

    public Drawable mutate() {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.mutate();
            return this;
        }
        throw new IllegalStateException("Mutate() is not supported for older platform");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onBoundsChange(Rect rect) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.setBounds(rect);
            return;
        }
        this.mAnimatedVectorState.mVectorDrawable.setBounds(rect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onLevelChange(int n2) {
        if (this.mDelegateDrawable == null) return this.mAnimatedVectorState.mVectorDrawable.setLevel(n2);
        return this.mDelegateDrawable.setLevel(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean onStateChange(int[] nArray) {
        if (this.mDelegateDrawable == null) return this.mAnimatedVectorState.mVectorDrawable.setState(nArray);
        return this.mDelegateDrawable.setState(nArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAlpha(int n2) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.setAlpha(n2);
            return;
        }
        this.mAnimatedVectorState.mVectorDrawable.setAlpha(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.setColorFilter(colorFilter);
            return;
        }
        this.mAnimatedVectorState.mVectorDrawable.setColorFilter(colorFilter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTint(int n2) {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.setTint(this.mDelegateDrawable, n2);
            return;
        }
        this.mAnimatedVectorState.mVectorDrawable.setTint(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTintList(ColorStateList colorStateList) {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.setTintList(this.mDelegateDrawable, colorStateList);
            return;
        }
        this.mAnimatedVectorState.mVectorDrawable.setTintList(colorStateList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.setTintMode(this.mDelegateDrawable, mode);
            return;
        }
        this.mAnimatedVectorState.mVectorDrawable.setTintMode(mode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setVisible(boolean bl2, boolean bl3) {
        if (this.mDelegateDrawable != null) {
            return this.mDelegateDrawable.setVisible(bl2, bl3);
        }
        this.mAnimatedVectorState.mVectorDrawable.setVisible(bl2, bl3);
        return super.setVisible(bl2, bl3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void start() {
        if (this.mDelegateDrawable != null) {
            ((AnimatedVectorDrawable)this.mDelegateDrawable).start();
            return;
        }
        if (this.isStarted()) return;
        ArrayList<Animator> arrayList = this.mAnimatedVectorState.mAnimators;
        int n2 = arrayList.size();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                this.invalidateSelf();
                return;
            }
            arrayList.get(n3).start();
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void stop() {
        if (this.mDelegateDrawable != null) {
            ((AnimatedVectorDrawable)this.mDelegateDrawable).stop();
            return;
        } else {
            ArrayList<Animator> arrayList = this.mAnimatedVectorState.mAnimators;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.get(i2).end();
            }
        }
    }

    private static class AnimatedVectorDrawableCompatState
    extends Drawable.ConstantState {
        ArrayList<Animator> mAnimators;
        int mChangingConfigurations;
        ArrayMap<Animator, String> mTargetNameMap;
        VectorDrawableCompat mVectorDrawable;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public AnimatedVectorDrawableCompatState(Context context, AnimatedVectorDrawableCompatState animatedVectorDrawableCompatState, Drawable.Callback object, Resources resources) {
            int n2 = 0;
            if (animatedVectorDrawableCompatState != null) {
                this.mChangingConfigurations = animatedVectorDrawableCompatState.mChangingConfigurations;
                if (animatedVectorDrawableCompatState.mVectorDrawable != null) {
                    void var4_7;
                    context = animatedVectorDrawableCompatState.mVectorDrawable.getConstantState();
                    this.mVectorDrawable = var4_7 != null ? (VectorDrawableCompat)context.newDrawable((Resources)var4_7) : (VectorDrawableCompat)context.newDrawable();
                    this.mVectorDrawable = (VectorDrawableCompat)this.mVectorDrawable.mutate();
                    this.mVectorDrawable.setCallback((Drawable.Callback)object);
                    this.mVectorDrawable.setBounds(animatedVectorDrawableCompatState.mVectorDrawable.getBounds());
                    this.mVectorDrawable.setAllowCaching(false);
                }
                if (animatedVectorDrawableCompatState.mAnimators != null) {
                    int n3 = animatedVectorDrawableCompatState.mAnimators.size();
                    this.mAnimators = new ArrayList(n3);
                    this.mTargetNameMap = new ArrayMap(n3);
                    while (n2 < n3) {
                        Animator animator = animatedVectorDrawableCompatState.mAnimators.get(n2);
                        context = animator.clone();
                        String string2 = (String)animatedVectorDrawableCompatState.mTargetNameMap.get(animator);
                        context.setTarget(this.mVectorDrawable.getTargetByName(string2));
                        this.mAnimators.add((Animator)context);
                        this.mTargetNameMap.put((Animator)context, string2);
                        ++n2;
                    }
                }
            }
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public Drawable newDrawable() {
            throw new IllegalStateException("No constant state support for SDK < 23.");
        }

        public Drawable newDrawable(Resources resources) {
            throw new IllegalStateException("No constant state support for SDK < 23.");
        }
    }

    private static class AnimatedVectorDrawableDelegateState
    extends Drawable.ConstantState {
        private final Drawable.ConstantState mDelegateState;

        public AnimatedVectorDrawableDelegateState(Drawable.ConstantState constantState) {
            this.mDelegateState = constantState;
        }

        public boolean canApplyTheme() {
            return this.mDelegateState.canApplyTheme();
        }

        public int getChangingConfigurations() {
            return this.mDelegateState.getChangingConfigurations();
        }

        public Drawable newDrawable() {
            AnimatedVectorDrawableCompat animatedVectorDrawableCompat = new AnimatedVectorDrawableCompat();
            animatedVectorDrawableCompat.mDelegateDrawable = this.mDelegateState.newDrawable();
            animatedVectorDrawableCompat.mDelegateDrawable.setCallback(animatedVectorDrawableCompat.mCallback);
            return animatedVectorDrawableCompat;
        }

        public Drawable newDrawable(Resources resources) {
            AnimatedVectorDrawableCompat animatedVectorDrawableCompat = new AnimatedVectorDrawableCompat();
            animatedVectorDrawableCompat.mDelegateDrawable = this.mDelegateState.newDrawable(resources);
            animatedVectorDrawableCompat.mDelegateDrawable.setCallback(animatedVectorDrawableCompat.mCallback);
            return animatedVectorDrawableCompat;
        }

        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            AnimatedVectorDrawableCompat animatedVectorDrawableCompat = new AnimatedVectorDrawableCompat();
            animatedVectorDrawableCompat.mDelegateDrawable = this.mDelegateState.newDrawable(resources, theme);
            animatedVectorDrawableCompat.mDelegateDrawable.setCallback(animatedVectorDrawableCompat.mCallback);
            return animatedVectorDrawableCompat;
        }
    }
}

