/*
 * Decompiled with CFR 0.152.
 */
package android.support.graphics.drawable;

import android.annotation.TargetApi;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.graphics.drawable.TintAwareDrawable;
import android.util.AttributeSet;

@TargetApi(value=21)
abstract class VectorDrawableCommon
extends Drawable
implements TintAwareDrawable {
    Drawable mDelegateDrawable;

    VectorDrawableCommon() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static TypedArray obtainAttributes(Resources resources, Resources.Theme theme, AttributeSet attributeSet, int[] nArray) {
        if (theme != null) return theme.obtainStyledAttributes(attributeSet, nArray, 0, 0);
        return resources.obtainAttributes(attributeSet, nArray);
    }

    public void applyTheme(Resources.Theme theme) {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.applyTheme(this.mDelegateDrawable, theme);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearColorFilter() {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.clearColorFilter();
            return;
        }
        super.clearColorFilter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ColorFilter getColorFilter() {
        if (this.mDelegateDrawable == null) return null;
        return DrawableCompat.getColorFilter(this.mDelegateDrawable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Drawable getCurrent() {
        if (this.mDelegateDrawable == null) return super.getCurrent();
        return this.mDelegateDrawable.getCurrent();
    }

    public int getLayoutDirection() {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.getLayoutDirection(this.mDelegateDrawable);
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMinimumHeight() {
        if (this.mDelegateDrawable == null) return super.getMinimumHeight();
        return this.mDelegateDrawable.getMinimumHeight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMinimumWidth() {
        if (this.mDelegateDrawable == null) return super.getMinimumWidth();
        return this.mDelegateDrawable.getMinimumWidth();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getPadding(Rect rect) {
        if (this.mDelegateDrawable == null) return super.getPadding(rect);
        return this.mDelegateDrawable.getPadding(rect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] getState() {
        if (this.mDelegateDrawable == null) return super.getState();
        return this.mDelegateDrawable.getState();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Region getTransparentRegion() {
        if (this.mDelegateDrawable == null) return super.getTransparentRegion();
        return this.mDelegateDrawable.getTransparentRegion();
    }

    public boolean isAutoMirrored() {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.isAutoMirrored(this.mDelegateDrawable);
        }
        return false;
    }

    public void jumpToCurrentState() {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.jumpToCurrentState(this.mDelegateDrawable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onBoundsChange(Rect rect) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.setBounds(rect);
            return;
        }
        super.onBoundsChange(rect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean onLevelChange(int n2) {
        if (this.mDelegateDrawable == null) return super.onLevelChange(n2);
        return this.mDelegateDrawable.setLevel(n2);
    }

    public void setAutoMirrored(boolean bl2) {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.setAutoMirrored(this.mDelegateDrawable, bl2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setChangingConfigurations(int n2) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.setChangingConfigurations(n2);
            return;
        }
        super.setChangingConfigurations(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setColorFilter(int n2, PorterDuff.Mode mode) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.setColorFilter(n2, mode);
            return;
        }
        super.setColorFilter(n2, mode);
    }

    public void setFilterBitmap(boolean bl2) {
        if (this.mDelegateDrawable != null) {
            this.mDelegateDrawable.setFilterBitmap(bl2);
        }
    }

    public void setHotspot(float f2, float f3) {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.setHotspot(this.mDelegateDrawable, f2, f3);
        }
    }

    public void setHotspotBounds(int n2, int n3, int n4, int n5) {
        if (this.mDelegateDrawable != null) {
            DrawableCompat.setHotspotBounds(this.mDelegateDrawable, n2, n3, n4, n5);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setState(int[] nArray) {
        if (this.mDelegateDrawable == null) return super.setState(nArray);
        return this.mDelegateDrawable.setState(nArray);
    }
}

