/*
 * Decompiled with CFR 0.152.
 */
package android.support.multidex;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.support.multidex.ZipUtil;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

final class MultiDexExtractor {
    private static final int BUFFER_SIZE = 16384;
    private static final String DEX_PREFIX = "classes";
    private static final String DEX_SUFFIX = ".dex";
    private static final String EXTRACTED_NAME_EXT = ".classes";
    private static final String EXTRACTED_SUFFIX = ".zip";
    private static final String KEY_CRC = "crc";
    private static final String KEY_DEX_NUMBER = "dex.number";
    private static final String KEY_TIME_STAMP = "timestamp";
    private static final int MAX_EXTRACT_ATTEMPTS = 3;
    private static final long NO_VALUE = -1L;
    private static final String PREFS_FILE = "multidex.version";
    private static final String TAG = "MultiDex";
    private static Method sApplyMethod;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        try {
            sApplyMethod = SharedPreferences.Editor.class.getMethod("apply", new Class[0]);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            sApplyMethod = null;
            return;
        }
    }

    MultiDexExtractor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void apply(SharedPreferences.Editor editor) {
        if (sApplyMethod != null) {
            try {
                sApplyMethod.invoke((Object)editor, new Object[0]);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        editor.commit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)"Failed to close resource", (Throwable)iOException);
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extract(ZipFile var0, ZipEntry var1_1, File var2_4, String var3_5) throws IOException, FileNotFoundException {
        block9: {
            var0 = var0.getInputStream((ZipEntry)var1_1);
            var3_5 = File.createTempFile((String)var3_5, ".zip", var2_4.getParentFile());
            Log.i((String)"MultiDex", (String)("Extracting " + var3_5.getPath()));
            var6_8 = new FileOutputStream((File)var3_5);
            var5_7 = new BufferedOutputStream(var6_8);
            var4_6 = new ZipOutputStream((OutputStream)var5_7);
            {
                catch (Throwable var1_2) {
                    MultiDexExtractor.closeQuietly(var0);
                    var3_5.delete();
                    throw var1_2;
                }
            }
            var5_7 = new ZipEntry("classes.dex");
            var5_7.setTime(var1_1.getTime());
            var4_6.putNextEntry((ZipEntry)var5_7);
            var1_1 = new byte[16384];
            var7_9 = var0.read((byte[])var1_1);
            while (var7_9 != -1) {
                var4_6.write((byte[])var1_1, 0, var7_9);
                var7_9 = var0.read((byte[])var1_1);
            }
            var4_6.closeEntry();
            var1_1 = new StringBuilder();
            Log.i((String)"MultiDex", (String)var1_1.append("Renaming to ").append(var2_4.getPath()).toString());
            if (!var3_5.renameTo(var2_4)) {
                var1_1 = new StringBuilder();
                var4_6 = new IOException(var1_1.append("Failed to rename \"").append(var3_5.getAbsolutePath()).append("\" to \"").append(var2_4.getAbsolutePath()).append("\"").toString());
                throw var4_6;
            }
            break block9;
            finally {
                ** try [egrp 2[TRYBLOCK] [4 : 151->248)] { 
lbl36:
                // 1 sources

                var4_6.close();
            }
        }
        MultiDexExtractor.closeQuietly(var0);
        var3_5.delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SharedPreferences getMultiDexPreferences(Context context) {
        int n2;
        if (Build.VERSION.SDK_INT < 11) {
            n2 = 0;
            return context.getSharedPreferences(PREFS_FILE, n2);
        }
        n2 = 4;
        return context.getSharedPreferences(PREFS_FILE, n2);
    }

    private static long getTimeStamp(File file) {
        long l2;
        long l3 = l2 = file.lastModified();
        if (l2 == -1L) {
            l3 = l2 - 1L;
        }
        return l3;
    }

    private static long getZipCrc(File file) throws IOException {
        long l2;
        long l3 = l2 = ZipUtil.getZipCrc(file);
        if (l2 == -1L) {
            l3 = l2 - 1L;
        }
        return l3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isModified(Context context, File file, long l2) {
        if ((context = MultiDexExtractor.getMultiDexPreferences(context)).getLong(KEY_TIME_STAMP, -1L) != MultiDexExtractor.getTimeStamp(file)) return true;
        if (context.getLong(KEY_CRC, -1L) == l2) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<File> load(Context object, ApplicationInfo object2, File file, boolean bl2) throws IOException {
        Log.i((String)TAG, (String)("MultiDexExtractor.load(" + ((ApplicationInfo)object2).sourceDir + ", " + bl2 + ")"));
        File file2 = new File(((ApplicationInfo)object2).sourceDir);
        long l2 = MultiDexExtractor.getZipCrc(file2);
        if (!bl2 && !MultiDexExtractor.isModified((Context)object, file2, l2)) {
            try {
                object = object2 = MultiDexExtractor.loadExistingExtractions((Context)object, file2, file);
            }
            catch (IOException iOException) {
                Log.w((String)TAG, (String)"Failed to reload existing extracted secondary dex files, falling back to fresh extraction", (Throwable)iOException);
                List<File> list = MultiDexExtractor.performExtractions(file2, file);
                MultiDexExtractor.putStoredApkInfo((Context)object, MultiDexExtractor.getTimeStamp(file2), l2, list.size() + 1);
                object = list;
            }
        } else {
            Log.i((String)TAG, (String)"Detected that extraction must be performed.");
            object2 = MultiDexExtractor.performExtractions(file2, file);
            MultiDexExtractor.putStoredApkInfo((Context)object, MultiDexExtractor.getTimeStamp(file2), l2, object2.size() + 1);
            object = object2;
        }
        Log.i((String)TAG, (String)("load found " + object.size() + " secondary dex files"));
        return object;
    }

    private static List<File> loadExistingExtractions(Context object, File object2, File file) throws IOException {
        Log.i((String)TAG, (String)"loading existing secondary dex files");
        object2 = ((File)object2).getName() + EXTRACTED_NAME_EXT;
        int n2 = MultiDexExtractor.getMultiDexPreferences((Context)object).getInt(KEY_DEX_NUMBER, 1);
        object = new ArrayList(n2);
        for (int i2 = 2; i2 <= n2; ++i2) {
            File file2 = new File(file, (String)object2 + i2 + EXTRACTED_SUFFIX);
            if (file2.isFile()) {
                object.add(file2);
                if (MultiDexExtractor.verifyZipFile(file2)) continue;
                Log.i((String)TAG, (String)("Invalid zip file: " + file2));
                throw new IOException("Invalid ZIP file.");
            }
            throw new IOException("Missing extracted secondary dex file '" + file2.getPath() + "'");
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void mkdirChecked(File file) throws IOException {
        file.mkdir();
        if (file.isDirectory()) return;
        File file2 = file.getParentFile();
        if (file2 == null) {
            Log.e((String)TAG, (String)("Failed to create dir " + file.getPath() + ". Parent file is null."));
            throw new IOException("Failed to create cache directory " + file.getPath());
        }
        Log.e((String)TAG, (String)("Failed to create dir " + file.getPath() + ". parent file is a dir " + file2.isDirectory() + ", a file " + file2.isFile() + ", exists " + file2.exists() + ", readable " + file2.canRead() + ", writable " + file2.canWrite()));
        throw new IOException("Failed to create cache directory " + file.getPath());
    }

    /*
     * Exception decompiling
     */
    private static List<File> performExtractions(File var0, File var1_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [7 : 420->456)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void prepareDexDir(File file, String fileArray) throws IOException {
        MultiDexExtractor.mkdirChecked(file.getParentFile());
        MultiDexExtractor.mkdirChecked(file);
        fileArray = file.listFiles(new FileFilter((String)fileArray){
            final /* synthetic */ String val$extractedFilePrefix;
            {
                this.val$extractedFilePrefix = string2;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean accept(File file) {
                if (file.getName().startsWith(this.val$extractedFilePrefix)) return false;
                return true;
            }
        });
        if (fileArray == null) {
            Log.w((String)TAG, (String)("Failed to list secondary dex dir content (" + file.getPath() + ")."));
            return;
        }
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            file = fileArray[n3];
            Log.i((String)TAG, (String)("Trying to delete old file " + file.getPath() + " of size " + file.length()));
            if (!file.delete()) {
                Log.w((String)TAG, (String)("Failed to delete old file " + file.getPath()));
            } else {
                Log.i((String)TAG, (String)("Deleted old file " + file.getPath()));
            }
            ++n3;
        }
        return;
    }

    private static void putStoredApkInfo(Context context, long l2, long l3, int n2) {
        context = MultiDexExtractor.getMultiDexPreferences(context).edit();
        context.putLong(KEY_TIME_STAMP, l2);
        context.putLong(KEY_CRC, l3);
        context.putInt(KEY_DEX_NUMBER, n2);
        MultiDexExtractor.apply((SharedPreferences.Editor)context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean verifyZipFile(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            try {
                zipFile.close();
                return true;
            }
            catch (IOException iOException) {
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    Log.w((String)TAG, (String)stringBuilder.append("Failed to close zip file: ").append(file.getAbsolutePath()).toString());
                    return false;
                }
                catch (IOException iOException2) {
                    Log.w((String)TAG, (String)("Got an IOException trying to open zip file: " + file.getAbsolutePath()), (Throwable)iOException2);
                }
                return false;
            }
        }
        catch (ZipException zipException) {
            Log.w((String)TAG, (String)("File " + file.getAbsolutePath() + " is not a valid zip file."), (Throwable)zipException);
            return false;
        }
    }
}

