/*
 * Decompiled with CFR 0.152.
 */
package android.support.multidex;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.CRC32;
import java.util.zip.ZipException;

final class ZipUtil {
    private static final int BUFFER_SIZE = 16384;
    private static final int ENDHDR = 22;
    private static final int ENDSIG = 101010256;

    ZipUtil() {
    }

    static long computeCrcOfCentralDir(RandomAccessFile randomAccessFile, CentralDirectory object) throws IOException {
        CRC32 cRC32 = new CRC32();
        long l2 = ((CentralDirectory)object).size;
        randomAccessFile.seek(((CentralDirectory)object).offset);
        int n2 = (int)Math.min(16384L, l2);
        object = new byte[16384];
        n2 = randomAccessFile.read((byte[])object, 0, n2);
        while (true) {
            block4: {
                block3: {
                    if (n2 == -1) break block3;
                    cRC32.update((byte[])object, 0, n2);
                    if ((l2 -= (long)n2) != 0L) break block4;
                }
                return cRC32.getValue();
            }
            n2 = randomAccessFile.read((byte[])object, 0, (int)Math.min(16384L, l2));
        }
    }

    static CentralDirectory findCentralDirectory(RandomAccessFile randomAccessFile) throws IOException, ZipException {
        long l2 = 0L;
        long l3 = randomAccessFile.length() - 22L;
        if (l3 < 0L) {
            throw new ZipException("File too short to be a zip file: " + randomAccessFile.length());
        }
        long l4 = l3 - 65536L;
        if (l4 < 0L) {
            l4 = l2;
        }
        int n2 = Integer.reverseBytes(101010256);
        do {
            randomAccessFile.seek(l3);
            if (randomAccessFile.readInt() == n2) {
                randomAccessFile.skipBytes(2);
                randomAccessFile.skipBytes(2);
                randomAccessFile.skipBytes(2);
                randomAccessFile.skipBytes(2);
                CentralDirectory centralDirectory = new CentralDirectory();
                centralDirectory.size = (long)Integer.reverseBytes(randomAccessFile.readInt()) & 0xFFFFFFFFL;
                centralDirectory.offset = (long)Integer.reverseBytes(randomAccessFile.readInt()) & 0xFFFFFFFFL;
                return centralDirectory;
            }
            l3 = l2 = l3 - 1L;
        } while (l2 >= l4);
        throw new ZipException("End Of Central Directory signature not found");
    }

    static long getZipCrc(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            long l2 = ZipUtil.computeCrcOfCentralDir(randomAccessFile, ZipUtil.findCentralDirectory(randomAccessFile));
            return l2;
        }
        finally {
            randomAccessFile.close();
        }
    }

    static class CentralDirectory {
        long offset;
        long size;

        CentralDirectory() {
        }
    }
}

