/*
 * Decompiled with CFR 0.152.
 */
package android.support.v13.app;

import android.app.Fragment;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v13.app.FragmentCompat23;
import android.support.v13.app.FragmentCompatICS;
import android.support.v13.app.FragmentCompatICSMR1;
import java.util.Arrays;

public class FragmentCompat {
    static final FragmentCompatImpl IMPL;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (Build.VERSION.SDK_INT >= 23) {
            IMPL = new MncFragmentCompatImpl();
            return;
        }
        if (Build.VERSION.SDK_INT >= 15) {
            IMPL = new ICSMR1FragmentCompatImpl();
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            IMPL = new ICSFragmentCompatImpl();
            return;
        }
        IMPL = new BaseFragmentCompatImpl();
    }

    public static void requestPermissions(@NonNull Fragment fragment, @NonNull String[] stringArray, int n2) {
        IMPL.requestPermissions(fragment, stringArray, n2);
    }

    public static void setMenuVisibility(Fragment fragment, boolean bl2) {
        IMPL.setMenuVisibility(fragment, bl2);
    }

    public static void setUserVisibleHint(Fragment fragment, boolean bl2) {
        IMPL.setUserVisibleHint(fragment, bl2);
    }

    public static boolean shouldShowRequestPermissionRationale(@NonNull Fragment fragment, @NonNull String string2) {
        return IMPL.shouldShowRequestPermissionRationale(fragment, string2);
    }

    static class BaseFragmentCompatImpl
    implements FragmentCompatImpl {
        BaseFragmentCompatImpl() {
        }

        @Override
        public void requestPermissions(final Fragment fragment, final String[] stringArray, final int n2) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    int[] nArray = new int[stringArray.length];
                    Object object = fragment.getActivity();
                    if (object != null) {
                        PackageManager packageManager = object.getPackageManager();
                        object = object.getPackageName();
                        int n22 = stringArray.length;
                        for (int i2 = 0; i2 < n22; ++i2) {
                            nArray[i2] = packageManager.checkPermission(stringArray[i2], (String)object);
                        }
                    } else {
                        Arrays.fill(nArray, -1);
                    }
                    ((OnRequestPermissionsResultCallback)fragment).onRequestPermissionsResult(n2, stringArray, nArray);
                }
            });
        }

        @Override
        public void setMenuVisibility(Fragment fragment, boolean bl2) {
        }

        @Override
        public void setUserVisibleHint(Fragment fragment, boolean bl2) {
        }

        @Override
        public boolean shouldShowRequestPermissionRationale(Fragment fragment, String string2) {
            return false;
        }
    }

    static interface FragmentCompatImpl {
        public void requestPermissions(Fragment var1, String[] var2, int var3);

        public void setMenuVisibility(Fragment var1, boolean var2);

        public void setUserVisibleHint(Fragment var1, boolean var2);

        public boolean shouldShowRequestPermissionRationale(Fragment var1, String var2);
    }

    static class ICSFragmentCompatImpl
    extends BaseFragmentCompatImpl {
        ICSFragmentCompatImpl() {
        }

        @Override
        public void setMenuVisibility(Fragment fragment, boolean bl2) {
            FragmentCompatICS.setMenuVisibility(fragment, bl2);
        }
    }

    static class ICSMR1FragmentCompatImpl
    extends ICSFragmentCompatImpl {
        ICSMR1FragmentCompatImpl() {
        }

        @Override
        public void setUserVisibleHint(Fragment fragment, boolean bl2) {
            FragmentCompatICSMR1.setUserVisibleHint(fragment, bl2);
        }
    }

    static class MncFragmentCompatImpl
    extends ICSMR1FragmentCompatImpl {
        MncFragmentCompatImpl() {
        }

        @Override
        public void requestPermissions(Fragment fragment, String[] stringArray, int n2) {
            FragmentCompat23.requestPermissions(fragment, stringArray, n2);
        }

        @Override
        public boolean shouldShowRequestPermissionRationale(Fragment fragment, String string2) {
            return FragmentCompat23.shouldShowRequestPermissionRationale(fragment, string2);
        }
    }

    public static interface OnRequestPermissionsResultCallback {
        public void onRequestPermissionsResult(int var1, @NonNull String[] var2, @NonNull int[] var3);
    }
}

