/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.v4.app.BackStackRecord;
import android.support.v4.app.BackStackState;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentContainer;
import android.support.v4.app.FragmentController;
import android.support.v4.app.FragmentHostCallback;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentManagerState;
import android.support.v4.app.FragmentState;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.app.NoSaveStateFrameLayout;
import android.support.v4.app.v;
import android.support.v4.util.DebugUtils;
import android.support.v4.util.LogWriter;
import android.support.v4.view.LayoutInflaterFactory;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class FragmentManagerImpl
extends FragmentManager
implements LayoutInflaterFactory {
    static final Interpolator ACCELERATE_CUBIC;
    static final Interpolator ACCELERATE_QUINT;
    static final int ANIM_DUR = 220;
    public static final int ANIM_STYLE_CLOSE_ENTER = 3;
    public static final int ANIM_STYLE_CLOSE_EXIT = 4;
    public static final int ANIM_STYLE_FADE_ENTER = 5;
    public static final int ANIM_STYLE_FADE_EXIT = 6;
    public static final int ANIM_STYLE_OPEN_ENTER = 1;
    public static final int ANIM_STYLE_OPEN_EXIT = 2;
    static boolean DEBUG = false;
    static final Interpolator DECELERATE_CUBIC;
    static final Interpolator DECELERATE_QUINT;
    static final boolean HONEYCOMB;
    static final String TAG = "FragmentManager";
    static final String TARGET_REQUEST_CODE_STATE_TAG = "android:target_req_state";
    static final String TARGET_STATE_TAG = "android:target_state";
    static final String USER_VISIBLE_HINT_TAG = "android:user_visible_hint";
    static final String VIEW_STATE_TAG = "android:view_state";
    static Field sAnimationListenerField;
    ArrayList<Fragment> mActive;
    ArrayList<Fragment> mAdded;
    ArrayList<Integer> mAvailBackStackIndices;
    ArrayList<Integer> mAvailIndices;
    ArrayList<BackStackRecord> mBackStack;
    ArrayList<FragmentManager.OnBackStackChangedListener> mBackStackChangeListeners;
    ArrayList<BackStackRecord> mBackStackIndices;
    FragmentContainer mContainer;
    FragmentController mController;
    ArrayList<Fragment> mCreatedMenus;
    int mCurState = 0;
    boolean mDestroyed;
    Runnable mExecCommit = new Runnable(){

        @Override
        public void run() {
            FragmentManagerImpl.this.execPendingActions();
        }
    };
    boolean mExecutingActions;
    boolean mHavePendingDeferredStart;
    FragmentHostCallback mHost;
    boolean mNeedMenuInvalidate;
    String mNoTransactionsBecause;
    Fragment mParent;
    ArrayList<Runnable> mPendingActions;
    SparseArray<Parcelable> mStateArray = null;
    Bundle mStateBundle = null;
    boolean mStateSaved;
    Runnable[] mTmpActions;

    static {
        boolean bl2 = false;
        DEBUG = false;
        if (Build.VERSION.SDK_INT >= 11) {
            bl2 = true;
        }
        HONEYCOMB = bl2;
        sAnimationListenerField = null;
        DECELERATE_QUINT = new DecelerateInterpolator(2.5f);
        DECELERATE_CUBIC = new DecelerateInterpolator(1.5f);
        ACCELERATE_QUINT = new AccelerateInterpolator(2.5f);
        ACCELERATE_CUBIC = new AccelerateInterpolator(1.5f);
    }

    FragmentManagerImpl() {
    }

    private void checkStateLoss() {
        if (this.mStateSaved) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
        if (this.mNoTransactionsBecause != null) {
            throw new IllegalStateException("Can not perform this action inside of " + this.mNoTransactionsBecause);
        }
    }

    static Animation makeFadeAnimation(Context context, float f2, float f3) {
        context = new AlphaAnimation(f2, f3);
        context.setInterpolator(DECELERATE_CUBIC);
        context.setDuration(220L);
        return context;
    }

    static Animation makeOpenCloseAnimation(Context context, float f2, float f3, float f4, float f5) {
        context = new AnimationSet(false);
        ScaleAnimation scaleAnimation = new ScaleAnimation(f2, f3, f2, f3, 1, 0.5f, 1, 0.5f);
        scaleAnimation.setInterpolator(DECELERATE_QUINT);
        scaleAnimation.setDuration(220L);
        context.addAnimation((Animation)scaleAnimation);
        scaleAnimation = new AlphaAnimation(f4, f5);
        scaleAnimation.setInterpolator(DECELERATE_CUBIC);
        scaleAnimation.setDuration(220L);
        context.addAnimation((Animation)scaleAnimation);
        return context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean modifiesAlpha(Animation object) {
        boolean bl2 = false;
        if (object instanceof AlphaAnimation) {
            return true;
        }
        boolean bl3 = bl2;
        if (!(object instanceof AnimationSet)) return bl3;
        object = ((AnimationSet)object).getAnimations();
        int n2 = 0;
        while (true) {
            bl3 = bl2;
            if (n2 >= object.size()) return bl3;
            if (object.get(n2) instanceof AlphaAnimation) {
                return true;
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int reverseTransit(int n2) {
        int n3 = 0;
        switch (n2) {
            default: {
                return n3;
            }
            case 4097: {
                return 8194;
            }
            case 8194: {
                return 4097;
            }
            case 4099: 
        }
        return 4099;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setHWLayerAnimListenerIfAlpha(View view, Animation animation) {
        Animation.AnimationListener animationListener;
        if (view == null) return;
        if (animation == null) {
            return;
        }
        if (!FragmentManagerImpl.shouldRunOnHWLayer(view, animation)) return;
        try {
            if (sAnimationListenerField == null) {
                sAnimationListenerField = Animation.class.getDeclaredField("mListener");
                sAnimationListenerField.setAccessible(true);
            }
            animationListener = (Animation.AnimationListener)sAnimationListenerField.get(animation);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Log.e((String)TAG, (String)"No field with the name mListener is found in Animation class", (Throwable)noSuchFieldException);
            animationListener = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)TAG, (String)"Cannot access Animation's mListener field", (Throwable)illegalAccessException);
            animationListener = null;
        }
        animation.setAnimationListener((Animation.AnimationListener)new AnimateOnHWLayerIfNeededListener(view, animation, animationListener));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean shouldRunOnHWLayer(View view, Animation animation) {
        if (Build.VERSION.SDK_INT < 19) return false;
        if (ViewCompat.getLayerType(view) != 0) return false;
        if (!ViewCompat.hasOverlappingRendering(view)) return false;
        if (!FragmentManagerImpl.modifiesAlpha(animation)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void throwException(RuntimeException runtimeException) {
        Log.e((String)TAG, (String)runtimeException.getMessage());
        Log.e((String)TAG, (String)"Activity state:");
        PrintWriter printWriter = new PrintWriter(new LogWriter(TAG));
        if (this.mHost != null) {
            try {
                this.mHost.onDump("  ", null, printWriter, new String[0]);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)exception);
                throw runtimeException;
            }
            throw runtimeException;
        }
        try {
            this.dump("  ", null, printWriter, new String[0]);
            throw runtimeException;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Failed dumping state", (Throwable)exception);
            throw runtimeException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int transitToStyleIndex(int n2, boolean bl2) {
        int n3 = -1;
        switch (n2) {
            default: {
                return n3;
            }
            case 4097: {
                if (!bl2) return 2;
                return 1;
            }
            case 8194: {
                if (!bl2) return 4;
                return 3;
            }
            case 4099: 
        }
        if (!bl2) return 6;
        return 5;
    }

    void addBackStackState(BackStackRecord backStackRecord) {
        if (this.mBackStack == null) {
            this.mBackStack = new ArrayList();
        }
        this.mBackStack.add(backStackRecord);
        this.reportBackStackChanged();
    }

    public void addFragment(Fragment fragment, boolean bl2) {
        if (this.mAdded == null) {
            this.mAdded = new ArrayList();
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("add: " + fragment));
        }
        this.makeActive(fragment);
        if (!fragment.mDetached) {
            if (this.mAdded.contains(fragment)) {
                throw new IllegalStateException("Fragment already added: " + fragment);
            }
            this.mAdded.add(fragment);
            fragment.mAdded = true;
            fragment.mRemoving = false;
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            if (bl2) {
                this.moveToState(fragment);
            }
        }
    }

    @Override
    public void addOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener onBackStackChangedListener) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList();
        }
        this.mBackStackChangeListeners.add(onBackStackChangedListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int allocBackStackIndex(BackStackRecord backStackRecord) {
        synchronized (this) {
            int n2;
            if (this.mAvailBackStackIndices == null || this.mAvailBackStackIndices.size() <= 0) {
                Serializable serializable;
                if (this.mBackStackIndices == null) {
                    serializable = new ArrayList();
                    this.mBackStackIndices = serializable;
                }
                n2 = this.mBackStackIndices.size();
                if (DEBUG) {
                    serializable = new StringBuilder();
                    Log.v((String)TAG, (String)((StringBuilder)serializable).append("Setting back stack index ").append(n2).append(" to ").append(backStackRecord).toString());
                }
                this.mBackStackIndices.add(backStackRecord);
                return n2;
            }
            n2 = this.mAvailBackStackIndices.remove(this.mAvailBackStackIndices.size() - 1);
            if (DEBUG) {
                StringBuilder stringBuilder = new StringBuilder();
                Log.v((String)TAG, (String)stringBuilder.append("Adding back stack index ").append(n2).append(" with ").append(backStackRecord).toString());
            }
            this.mBackStackIndices.set(n2, backStackRecord);
            return n2;
        }
    }

    public void attachController(FragmentHostCallback fragmentHostCallback, FragmentContainer fragmentContainer, Fragment fragment) {
        if (this.mHost != null) {
            throw new IllegalStateException("Already attached");
        }
        this.mHost = fragmentHostCallback;
        this.mContainer = fragmentContainer;
        this.mParent = fragment;
    }

    public void attachFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("attach: " + fragment));
        }
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (!fragment.mAdded) {
                if (this.mAdded == null) {
                    this.mAdded = new ArrayList();
                }
                if (this.mAdded.contains(fragment)) {
                    throw new IllegalStateException("Fragment already added: " + fragment);
                }
                if (DEBUG) {
                    Log.v((String)TAG, (String)("add from attach: " + fragment));
                }
                this.mAdded.add(fragment);
                fragment.mAdded = true;
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                this.moveToState(fragment, this.mCurState, n2, n3, false);
            }
        }
    }

    @Override
    public FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    public void detachFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("detach: " + fragment));
        }
        if (!fragment.mDetached) {
            fragment.mDetached = true;
            if (fragment.mAdded) {
                if (this.mAdded != null) {
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("remove from detach: " + fragment));
                    }
                    this.mAdded.remove(fragment);
                }
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                fragment.mAdded = false;
                this.moveToState(fragment, 1, n2, n3, false);
            }
        }
    }

    public void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.moveToState(2, false);
    }

    public void dispatchConfigurationChanged(Configuration configuration) {
        if (this.mAdded != null) {
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null) continue;
                fragment.performConfigurationChanged(configuration);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchContextItemSelected(MenuItem menuItem) {
        boolean bl2;
        boolean bl3 = bl2 = false;
        if (this.mAdded == null) return bl3;
        int n2 = 0;
        while (true) {
            bl3 = bl2;
            if (n2 >= this.mAdded.size()) return bl3;
            Fragment fragment = this.mAdded.get(n2);
            if (fragment != null && fragment.performContextItemSelected(menuItem)) {
                return true;
            }
            ++n2;
        }
    }

    public void dispatchCreate() {
        this.mStateSaved = false;
        this.moveToState(1, false);
    }

    public boolean dispatchCreateOptionsMenu(Menu object, MenuInflater menuInflater) {
        boolean bl2;
        int n2;
        int n3 = 0;
        ArrayList<Fragment> arrayList = null;
        ArrayList<Fragment> arrayList2 = null;
        if (this.mAdded != null) {
            n2 = 0;
            boolean bl3 = false;
            while (true) {
                arrayList = arrayList2;
                bl2 = bl3;
                if (n2 < this.mAdded.size()) {
                    Fragment fragment = this.mAdded.get(n2);
                    arrayList = arrayList2;
                    bl2 = bl3;
                    if (fragment != null) {
                        arrayList = arrayList2;
                        bl2 = bl3;
                        if (fragment.performCreateOptionsMenu((Menu)object, menuInflater)) {
                            bl2 = true;
                            arrayList = arrayList2;
                            if (arrayList2 == null) {
                                arrayList = new ArrayList<Fragment>();
                            }
                            arrayList.add(fragment);
                        }
                    }
                    ++n2;
                    bl3 = bl2;
                    arrayList2 = arrayList;
                    continue;
                }
                break;
            }
        } else {
            bl2 = false;
        }
        if (this.mCreatedMenus != null) {
            for (n2 = n3; n2 < this.mCreatedMenus.size(); ++n2) {
                object = this.mCreatedMenus.get(n2);
                if (arrayList != null && arrayList.contains(object)) continue;
                ((Fragment)object).onDestroyOptionsMenu();
            }
        }
        this.mCreatedMenus = arrayList;
        return bl2;
    }

    public void dispatchDestroy() {
        this.mDestroyed = true;
        this.execPendingActions();
        this.moveToState(0, false);
        this.mHost = null;
        this.mContainer = null;
        this.mParent = null;
    }

    public void dispatchDestroyView() {
        this.moveToState(1, false);
    }

    public void dispatchLowMemory() {
        if (this.mAdded != null) {
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null) continue;
                fragment.performLowMemory();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchOptionsItemSelected(MenuItem menuItem) {
        boolean bl2;
        boolean bl3 = bl2 = false;
        if (this.mAdded == null) return bl3;
        int n2 = 0;
        while (true) {
            bl3 = bl2;
            if (n2 >= this.mAdded.size()) return bl3;
            Fragment fragment = this.mAdded.get(n2);
            if (fragment != null && fragment.performOptionsItemSelected(menuItem)) {
                return true;
            }
            ++n2;
        }
    }

    public void dispatchOptionsMenuClosed(Menu menu) {
        if (this.mAdded != null) {
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null) continue;
                fragment.performOptionsMenuClosed(menu);
            }
        }
    }

    public void dispatchPause() {
        this.moveToState(4, false);
    }

    public boolean dispatchPrepareOptionsMenu(Menu menu) {
        boolean bl2;
        if (this.mAdded != null) {
            int n2 = 0;
            boolean bl3 = false;
            while (true) {
                bl2 = bl3;
                if (n2 < this.mAdded.size()) {
                    Fragment fragment = this.mAdded.get(n2);
                    bl2 = bl3;
                    if (fragment != null) {
                        bl2 = bl3;
                        if (fragment.performPrepareOptionsMenu(menu)) {
                            bl2 = true;
                        }
                    }
                    ++n2;
                    bl3 = bl2;
                    continue;
                }
                break;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public void dispatchReallyStop() {
        this.moveToState(2, false);
    }

    public void dispatchResume() {
        this.mStateSaved = false;
        this.moveToState(5, false);
    }

    public void dispatchStart() {
        this.mStateSaved = false;
        this.moveToState(4, false);
    }

    public void dispatchStop() {
        this.mStateSaved = true;
        this.moveToState(3, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void dump(String string2, FileDescriptor object, PrintWriter printWriter, String[] stringArray) {
        Object object2;
        int n2;
        int n3;
        int n4 = 0;
        String string3 = string2 + "    ";
        if (this.mActive != null && (n3 = this.mActive.size()) > 0) {
            printWriter.print(string2);
            printWriter.print("Active Fragments in ");
            printWriter.print(Integer.toHexString(System.identityHashCode(this)));
            printWriter.println(":");
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = this.mActive.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(object2);
                if (object2 == null) continue;
                ((Fragment)object2).dump(string3, (FileDescriptor)object, printWriter, stringArray);
            }
        }
        if (this.mAdded != null && (n3 = this.mAdded.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Added Fragments:");
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = this.mAdded.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(((Fragment)object2).toString());
            }
        }
        if (this.mCreatedMenus != null && (n3 = this.mCreatedMenus.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Fragments Created Menus:");
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = this.mCreatedMenus.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(((Fragment)object2).toString());
            }
        }
        if (this.mBackStack != null && (n3 = this.mBackStack.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Back Stack:");
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = this.mBackStack.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(((BackStackRecord)object2).toString());
                ((BackStackRecord)object2).dump(string3, (FileDescriptor)object, printWriter, stringArray);
            }
        }
        // MONITORENTER : this
        if (this.mBackStackIndices != null && (n3 = this.mBackStackIndices.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Back Stack Indices:");
            for (n2 = 0; n2 < n3; ++n2) {
                object = this.mBackStackIndices.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(object);
            }
        }
        if (this.mAvailBackStackIndices != null && this.mAvailBackStackIndices.size() > 0) {
            printWriter.print(string2);
            printWriter.print("mAvailBackStackIndices: ");
            printWriter.println(Arrays.toString(this.mAvailBackStackIndices.toArray()));
        }
        // MONITOREXIT : this
        if (this.mPendingActions != null && (n3 = this.mPendingActions.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Pending Actions:");
            for (n2 = n4; n2 < n3; ++n2) {
                object = this.mPendingActions.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(object);
            }
        }
        printWriter.print(string2);
        printWriter.println("FragmentManager misc state:");
        printWriter.print(string2);
        printWriter.print("  mHost=");
        printWriter.println(this.mHost);
        printWriter.print(string2);
        printWriter.print("  mContainer=");
        printWriter.println(this.mContainer);
        if (this.mParent != null) {
            printWriter.print(string2);
            printWriter.print("  mParent=");
            printWriter.println(this.mParent);
        }
        printWriter.print(string2);
        printWriter.print("  mCurState=");
        printWriter.print(this.mCurState);
        printWriter.print(" mStateSaved=");
        printWriter.print(this.mStateSaved);
        printWriter.print(" mDestroyed=");
        printWriter.println(this.mDestroyed);
        if (this.mNeedMenuInvalidate) {
            printWriter.print(string2);
            printWriter.print("  mNeedMenuInvalidate=");
            printWriter.println(this.mNeedMenuInvalidate);
        }
        if (this.mNoTransactionsBecause != null) {
            printWriter.print(string2);
            printWriter.print("  mNoTransactionsBecause=");
            printWriter.println(this.mNoTransactionsBecause);
        }
        if (this.mAvailIndices == null) return;
        if (this.mAvailIndices.size() <= 0) return;
        printWriter.print(string2);
        printWriter.print("  mAvailIndices: ");
        printWriter.println(Arrays.toString(this.mAvailIndices.toArray()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueueAction(Runnable object, boolean bl2) {
        if (!bl2) {
            this.checkStateLoss();
        }
        synchronized (this) {
            if (this.mDestroyed || this.mHost == null) {
                object = new IllegalStateException("Activity has been destroyed");
                throw object;
            }
            if (this.mPendingActions == null) {
                ArrayList arrayList = new ArrayList();
                this.mPendingActions = arrayList;
            }
            this.mPendingActions.add((Runnable)object);
            if (this.mPendingActions.size() == 1) {
                this.mHost.getHandler().removeCallbacks(this.mExecCommit);
                this.mHost.getHandler().post(this.mExecCommit);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execPendingActions() {
        boolean bl2;
        block14: {
            int n2;
            if (this.mExecutingActions) {
                throw new IllegalStateException("Recursive entry to executePendingTransactions");
            }
            if (Looper.myLooper() != this.mHost.getHandler().getLooper()) {
                throw new IllegalStateException("Must be called from main thread of process");
            }
            bl2 = false;
            while (true) {
                int n3;
                synchronized (this) {
                    if (this.mPendingActions == null || this.mPendingActions.size() == 0) {
                        // MONITOREXIT @DISABLED, blocks:[3, 4, 13] lbl9 : MonitorExitStatement: MONITOREXIT : this
                        if (!this.mHavePendingDeferredStart) break block14;
                        n2 = 0;
                        for (n3 = 0; n3 < this.mActive.size(); ++n3) {
                            Fragment fragment = this.mActive.get(n3);
                            int n4 = n2;
                            if (fragment != null) {
                                n4 = n2;
                                if (fragment.mLoaderManager != null) {
                                    n4 = n2 | fragment.mLoaderManager.hasRunningLoaders();
                                }
                            }
                            n2 = n4;
                        }
                        break;
                    }
                    n3 = this.mPendingActions.size();
                    if (this.mTmpActions == null || this.mTmpActions.length < n3) {
                        this.mTmpActions = new Runnable[n3];
                    }
                    this.mPendingActions.toArray(this.mTmpActions);
                    this.mPendingActions.clear();
                    this.mHost.getHandler().removeCallbacks(this.mExecCommit);
                }
                this.mExecutingActions = true;
                for (n2 = 0; n2 < n3; ++n2) {
                    this.mTmpActions[n2].run();
                    this.mTmpActions[n2] = null;
                }
                this.mExecutingActions = false;
                bl2 = true;
            }
            if (n2 == 0) {
                this.mHavePendingDeferredStart = false;
                this.startPendingDeferredFragments();
            }
        }
        return bl2;
    }

    @Override
    public boolean executePendingTransactions() {
        return this.execPendingActions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Fragment findFragmentById(int n2) {
        Fragment fragment;
        int n3;
        if (this.mAdded != null) {
            for (n3 = this.mAdded.size() - 1; n3 >= 0; --n3) {
                fragment = this.mAdded.get(n3);
                if (fragment == null || fragment.mFragmentId != n2) continue;
                return fragment;
            }
        }
        if (this.mActive == null) return null;
        n3 = this.mActive.size() - 1;
        while (n3 >= 0) {
            Fragment fragment2 = this.mActive.get(n3);
            if (fragment2 != null) {
                fragment = fragment2;
                if (fragment2.mFragmentId == n2) return fragment;
            }
            --n3;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Fragment findFragmentByTag(String string2) {
        Fragment fragment;
        int n2;
        if (this.mAdded != null && string2 != null) {
            for (n2 = this.mAdded.size() - 1; n2 >= 0; --n2) {
                fragment = this.mAdded.get(n2);
                if (fragment == null || !string2.equals(fragment.mTag)) continue;
                return fragment;
            }
        }
        if (this.mActive == null) return null;
        if (string2 == null) return null;
        n2 = this.mActive.size() - 1;
        while (n2 >= 0) {
            Fragment fragment2 = this.mActive.get(n2);
            if (fragment2 != null) {
                fragment = fragment2;
                if (string2.equals(fragment2.mTag)) return fragment;
            }
            --n2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Fragment findFragmentByWho(String object) {
        if (this.mActive == null) return null;
        if (object == null) return null;
        int n2 = this.mActive.size() - 1;
        while (n2 >= 0) {
            Fragment fragment = this.mActive.get(n2);
            if (fragment != null && (fragment = fragment.findFragmentByWho((String)object)) != null) {
                return fragment;
            }
            --n2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void freeBackStackIndex(int n2) {
        synchronized (this) {
            Serializable serializable;
            this.mBackStackIndices.set(n2, null);
            if (this.mAvailBackStackIndices == null) {
                serializable = new ArrayList();
                this.mAvailBackStackIndices = serializable;
            }
            if (DEBUG) {
                serializable = new StringBuilder();
                Log.v((String)TAG, (String)((StringBuilder)serializable).append("Freeing back stack index ").append(n2).toString());
            }
            this.mAvailBackStackIndices.add(n2);
            return;
        }
    }

    @Override
    public FragmentManager.BackStackEntry getBackStackEntryAt(int n2) {
        return this.mBackStack.get(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getBackStackEntryCount() {
        if (this.mBackStack == null) return 0;
        return this.mBackStack.size();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Fragment getFragment(Bundle object, String string2) {
        Fragment fragment;
        void var1_3;
        void var2_6;
        int n2 = object.getInt((String)var2_6, -1);
        if (n2 == -1) {
            return var1_3;
        }
        if (n2 >= this.mActive.size()) {
            this.throwException(new IllegalStateException("Fragment no longer exists for key " + (String)var2_6 + ": index " + n2));
        }
        Fragment fragment2 = fragment = this.mActive.get(n2);
        if (fragment != null) return var1_3;
        this.throwException(new IllegalStateException("Fragment no longer exists for key " + (String)var2_6 + ": index " + n2));
        Fragment fragment3 = fragment;
        return var1_3;
    }

    @Override
    public List<Fragment> getFragments() {
        return this.mActive;
    }

    LayoutInflaterFactory getLayoutInflaterFactory() {
        return this;
    }

    public void hideFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("hide: " + fragment));
        }
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            if (fragment.mView != null) {
                Animation animation = this.loadAnimation(fragment, n2, false, n3);
                if (animation != null) {
                    this.setHWLayerAnimListenerIfAlpha(fragment.mView, animation);
                    fragment.mView.startAnimation(animation);
                }
                fragment.mView.setVisibility(8);
            }
            if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.onHiddenChanged(true);
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Animation loadAnimation(Fragment fragment, int n2, boolean bl2, int n3) {
        Animation animation = fragment.onCreateAnimation(n2, bl2, fragment.mNextAnim);
        if (animation != null) {
            return animation;
        }
        if (fragment.mNextAnim != 0) {
            animation = AnimationUtils.loadAnimation((Context)this.mHost.getContext(), (int)fragment.mNextAnim);
            fragment = animation;
            if (animation != null) return fragment;
        }
        if (n2 == 0) {
            return null;
        }
        if ((n2 = FragmentManagerImpl.transitToStyleIndex(n2, bl2)) < 0) {
            return null;
        }
        switch (n2) {
            default: {
                n2 = n3;
                if (n3 == 0) {
                    n2 = n3;
                    if (this.mHost.onHasWindowAnimations()) {
                        n2 = this.mHost.onGetWindowAnimations();
                    }
                }
                if (n2 != 0) return null;
                return null;
            }
            case 1: {
                return FragmentManagerImpl.makeOpenCloseAnimation(this.mHost.getContext(), 1.125f, 1.0f, 0.0f, 1.0f);
            }
            case 2: {
                return FragmentManagerImpl.makeOpenCloseAnimation(this.mHost.getContext(), 1.0f, 0.975f, 1.0f, 0.0f);
            }
            case 3: {
                return FragmentManagerImpl.makeOpenCloseAnimation(this.mHost.getContext(), 0.975f, 1.0f, 0.0f, 1.0f);
            }
            case 4: {
                return FragmentManagerImpl.makeOpenCloseAnimation(this.mHost.getContext(), 1.0f, 1.075f, 1.0f, 0.0f);
            }
            case 5: {
                return FragmentManagerImpl.makeFadeAnimation(this.mHost.getContext(), 0.0f, 1.0f);
            }
            case 6: {
                return FragmentManagerImpl.makeFadeAnimation(this.mHost.getContext(), 1.0f, 0.0f);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void makeActive(Fragment fragment) {
        if (fragment.mIndex >= 0) {
            return;
        }
        if (this.mAvailIndices == null || this.mAvailIndices.size() <= 0) {
            if (this.mActive == null) {
                this.mActive = new ArrayList();
            }
            fragment.setIndex(this.mActive.size(), this.mParent);
            this.mActive.add(fragment);
        } else {
            fragment.setIndex(this.mAvailIndices.remove(this.mAvailIndices.size() - 1), this.mParent);
            this.mActive.set(fragment.mIndex, fragment);
        }
        if (!DEBUG) return;
        Log.v((String)TAG, (String)("Allocated fragment index " + fragment));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void makeInactive(Fragment fragment) {
        if (fragment.mIndex < 0) {
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("Freeing fragment index " + fragment));
        }
        this.mActive.set(fragment.mIndex, null);
        if (this.mAvailIndices == null) {
            this.mAvailIndices = new ArrayList();
        }
        this.mAvailIndices.add(fragment.mIndex);
        this.mHost.inactivateFragment(fragment.mWho);
        fragment.initState();
    }

    /*
     * Enabled aggressive block sorting
     */
    void moveToState(int n2, int n3, int n4, boolean bl2) {
        if (this.mHost == null && n2 != 0) {
            throw new IllegalStateException("No host");
        }
        if (!bl2 && this.mCurState == n2) {
            return;
        }
        this.mCurState = n2;
        if (this.mActive == null) return;
        boolean bl3 = false;
        for (int i2 = 0; i2 < this.mActive.size(); ++i2) {
            Fragment fragment = this.mActive.get(i2);
            if (fragment == null) continue;
            this.moveToState(fragment, n2, n3, n4, false);
            if (fragment.mLoaderManager == null) continue;
            bl3 |= fragment.mLoaderManager.hasRunningLoaders();
        }
        if (!bl3) {
            this.startPendingDeferredFragments();
        }
        if (!this.mNeedMenuInvalidate) return;
        if (this.mHost == null) return;
        if (this.mCurState != 5) return;
        this.mHost.onSupportInvalidateOptionsMenu();
        this.mNeedMenuInvalidate = false;
    }

    void moveToState(int n2, boolean bl2) {
        this.moveToState(n2, 0, 0, bl2);
    }

    void moveToState(Fragment fragment) {
        this.moveToState(fragment, this.mCurState, 0, 0, false);
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    void moveToState(final Fragment var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) {
        block72: {
            block75: {
                block74: {
                    block73: {
                        if (!var1_1.mAdded) break block73;
                        var6_6 = var2_2;
                        if (!var1_1.mDetached) break block74;
                    }
                    var6_6 = var2_2;
                    if (var2_2 > 1) {
                        var6_6 = 1;
                    }
                }
                var7_7 = var6_6;
                if (var1_1.mRemoving) {
                    var7_7 = var6_6;
                    if (var6_6 > var1_1.mState) {
                        var7_7 = var1_1.mState;
                    }
                }
                var2_2 = var7_7;
                if (var1_1.mDeferStart) {
                    var2_2 = var7_7;
                    if (var1_1.mState < 4) {
                        var2_2 = var7_7;
                        if (var7_7 > 3) {
                            var2_2 = 3;
                        }
                    }
                }
                if (var1_1.mState >= var2_2) ** GOTO lbl101
                if (var1_1.mFromLayout && !var1_1.mInLayout) {
                    return;
                }
                if (var1_1.mAnimatingAway != null) {
                    var1_1.mAnimatingAway = null;
                    this.moveToState(var1_1, var1_1.mStateAfterAnimating, 0, 0, true);
                }
                var7_7 = var2_2;
                var8_8 = var2_2;
                var6_6 = var2_2;
                cfr_temp_0 = -2147483648;
lbl31:
                // 2 sources

                block13: while (true) {
                    switch (cfr_temp_0 == -2147483648 ? var1_1.mState : cfr_temp_0) {
                        default: {
                            var7_7 = var2_2;
                            break block72;
                        }
                        case 0: {
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)"FragmentManager", (String)("moveto CREATED: " + var1_1));
                            }
                            var6_6 = var2_2;
                            if (var1_1.mSavedFragmentState != null) {
                                var1_1.mSavedFragmentState.setClassLoader(this.mHost.getContext().getClassLoader());
                                var1_1.mSavedViewState = var1_1.mSavedFragmentState.getSparseParcelableArray("android:view_state");
                                var1_1.mTarget = this.getFragment(var1_1.mSavedFragmentState, "android:target_state");
                                if (var1_1.mTarget != null) {
                                    var1_1.mTargetRequestCode = var1_1.mSavedFragmentState.getInt("android:target_req_state", 0);
                                }
                                var1_1.mUserVisibleHint = var1_1.mSavedFragmentState.getBoolean("android:user_visible_hint", true);
                                var6_6 = var2_2;
                                if (!var1_1.mUserVisibleHint) {
                                    var1_1.mDeferStart = true;
                                    var6_6 = var2_2;
                                    if (var2_2 > 3) {
                                        var6_6 = 3;
                                    }
                                }
                            }
                            var1_1.mHost = this.mHost;
                            var1_1.mParentFragment = this.mParent;
                            var9_9 = this.mParent != null ? this.mParent.mChildFragmentManager : this.mHost.getFragmentManagerImpl();
                            var1_1.mFragmentManager = var9_9;
                            var1_1.mCalled = false;
                            var1_1.onAttach(this.mHost.getContext());
                            if (!var1_1.mCalled) {
                                throw new v("Fragment " + var1_1 + " did not call through to super.onAttach()");
                            }
                            if (var1_1.mParentFragment == null) {
                                this.mHost.onAttachFragment(var1_1);
                            }
                            if (!var1_1.mRetaining) {
                                var1_1.performCreate(var1_1.mSavedFragmentState);
                            }
                            var1_1.mRetaining = false;
                            var7_7 = var6_6;
                            if (!var1_1.mFromLayout) ** GOTO lbl80
                            var1_1.mView = var1_1.performCreateView(var1_1.getLayoutInflater(var1_1.mSavedFragmentState), null, var1_1.mSavedFragmentState);
                            if (var1_1.mView == null) ** GOTO lbl82
                            var1_1.mInnerView = var1_1.mView;
                            if (Build.VERSION.SDK_INT >= 11) {
                                ViewCompat.setSaveFromParentEnabled(var1_1.mView, false);
                            } else {
                                var1_1.mView = NoSaveStateFrameLayout.wrap(var1_1.mView);
                            }
                            if (var1_1.mHidden) {
                                var1_1.mView.setVisibility(8);
                            }
                            var1_1.onViewCreated(var1_1.mView, var1_1.mSavedFragmentState);
                            var7_7 = var6_6;
                        }
lbl80:
                        // 3 sources

                        case 1: {
                            ** GOTO lbl84
                        }
lbl82:
                        // 1 sources

                        var1_1.mInnerView = null;
                        var7_7 = var6_6;
lbl84:
                        // 2 sources

                        var8_8 = var7_7;
                        cfr_temp_0 = 2;
                        if (var7_7 <= 1) continue block13;
                        if (FragmentManagerImpl.DEBUG) {
                            Log.v((String)"FragmentManager", (String)("moveto ACTIVITY_CREATED: " + var1_1));
                        }
                        if (var1_1.mFromLayout) ** GOTO lbl199
                        if (var1_1.mContainerId == 0) ** GOTO lbl179
                        var10_11 = (ViewGroup)this.mContainer.onFindViewById(var1_1.mContainerId);
                        var9_9 = var10_11;
                        if (var10_11 == null) {
                            var9_9 = var10_11;
                            if (!var1_1.mRestored) {
                                this.throwException(new IllegalArgumentException("No view found for id 0x" + Integer.toHexString(var1_1.mContainerId) + " (" + var1_1.getResources().getResourceName(var1_1.mContainerId) + ") for fragment " + var1_1));
                                var9_9 = var10_11;
                            }
                        }
                        ** GOTO lbl180
lbl101:
                        // 1 sources

                        var7_7 = var2_2;
                        if (var1_1.mState > var2_2) {
                            switch (var1_1.mState) {
                                default: {
                                    var7_7 = var2_2;
                                    break;
                                }
                                case 5: {
                                    if (var2_2 < 5) {
                                        if (FragmentManagerImpl.DEBUG) {
                                            Log.v((String)"FragmentManager", (String)("movefrom RESUMED: " + var1_1));
                                        }
                                        var1_1.performPause();
                                    }
                                }
                                case 4: {
                                    if (var2_2 < 4) {
                                        if (FragmentManagerImpl.DEBUG) {
                                            Log.v((String)"FragmentManager", (String)("movefrom STARTED: " + var1_1));
                                        }
                                        var1_1.performStop();
                                    }
                                }
                                case 3: {
                                    if (var2_2 < 3) {
                                        if (FragmentManagerImpl.DEBUG) {
                                            Log.v((String)"FragmentManager", (String)("movefrom STOPPED: " + var1_1));
                                        }
                                        var1_1.performReallyStop();
                                    }
                                }
                                case 2: {
                                    if (var2_2 < 2) {
                                        if (FragmentManagerImpl.DEBUG) {
                                            Log.v((String)"FragmentManager", (String)("movefrom ACTIVITY_CREATED: " + var1_1));
                                        }
                                        if (var1_1.mView != null && this.mHost.onShouldSaveFragmentState(var1_1) && var1_1.mSavedViewState == null) {
                                            this.saveFragmentViewState(var1_1);
                                        }
                                        var1_1.performDestroyView();
                                        if (var1_1.mView != null && var1_1.mContainer != null) {
                                            var9_10 /* !! */  = this.mCurState > 0 && this.mDestroyed == false ? this.loadAnimation(var1_1, var3_3, false, var4_4) : null;
                                            if (var9_10 /* !! */  != null) {
                                                var1_1.mAnimatingAway = var1_1.mView;
                                                var1_1.mStateAfterAnimating = var2_2;
                                                var9_10 /* !! */ .setAnimationListener((Animation.AnimationListener)new AnimateOnHWLayerIfNeededListener(var1_1.mView, (Animation)var9_10 /* !! */ ){

                                                    @Override
                                                    public void onAnimationEnd(Animation animation) {
                                                        super.onAnimationEnd(animation);
                                                        if (var1_1.mAnimatingAway != null) {
                                                            var1_1.mAnimatingAway = null;
                                                            FragmentManagerImpl.this.moveToState(var1_1, var1_1.mStateAfterAnimating, 0, 0, false);
                                                        }
                                                    }
                                                });
                                                var1_1.mView.startAnimation((Animation)var9_10 /* !! */ );
                                            }
                                            var1_1.mContainer.removeView(var1_1.mView);
                                        }
                                        var1_1.mContainer = null;
                                        var1_1.mView = null;
                                        var1_1.mInnerView = null;
                                    }
                                }
                                case 1: {
                                    var7_7 = var2_2;
                                    if (var2_2 >= 1) break;
                                    if (this.mDestroyed && var1_1.mAnimatingAway != null) {
                                        var9_10 /* !! */  = var1_1.mAnimatingAway;
                                        var1_1.mAnimatingAway = null;
                                        var9_10 /* !! */ .clearAnimation();
                                    }
                                    if (var1_1.mAnimatingAway != null) {
                                        var1_1.mStateAfterAnimating = var2_2;
                                        var7_7 = 1;
                                        break;
                                    }
                                    if (FragmentManagerImpl.DEBUG) {
                                        Log.v((String)"FragmentManager", (String)("movefrom CREATED: " + var1_1));
                                    }
                                    if (!var1_1.mRetaining) {
                                        var1_1.performDestroy();
                                    } else {
                                        var1_1.mState = 0;
                                    }
                                    var1_1.mCalled = false;
                                    var1_1.onDetach();
                                    if (!var1_1.mCalled) {
                                        throw new v("Fragment " + var1_1 + " did not call through to super.onDetach()");
                                    }
                                    var7_7 = var2_2;
                                    if (var5_5) break;
                                    if (!var1_1.mRetaining) {
                                        this.makeInactive(var1_1);
                                        var7_7 = var2_2;
                                        break;
                                    }
                                    var1_1.mHost = null;
                                    var1_1.mParentFragment = null;
                                    var1_1.mFragmentManager = null;
                                    var1_1.mChildFragmentManager = null;
                                    var7_7 = var2_2;
                                    break;
                                }
                            }
                        }
                        break block72;
lbl179:
                        // 1 sources

                        var9_9 = null;
lbl180:
                        // 2 sources

                        var1_1.mContainer = var9_9;
                        var1_1.mView = var1_1.performCreateView(var1_1.getLayoutInflater(var1_1.mSavedFragmentState), (ViewGroup)var9_9, var1_1.mSavedFragmentState);
                        if (var1_1.mView != null) {
                            var1_1.mInnerView = var1_1.mView;
                            if (Build.VERSION.SDK_INT >= 11) {
                                ViewCompat.setSaveFromParentEnabled(var1_1.mView, false);
                            } else {
                                var1_1.mView = NoSaveStateFrameLayout.wrap(var1_1.mView);
                            }
                            if (var9_9 != null) {
                                var10_11 = this.loadAnimation(var1_1, var3_3, true, var4_4);
                                if (var10_11 != null) {
                                    this.setHWLayerAnimListenerIfAlpha(var1_1.mView, (Animation)var10_11);
                                    var1_1.mView.startAnimation((Animation)var10_11);
                                }
                                var9_9.addView(var1_1.mView);
                            }
                            if (var1_1.mHidden) {
                                var1_1.mView.setVisibility(8);
                            }
                            var1_1.onViewCreated(var1_1.mView, var1_1.mSavedFragmentState);
                        } else {
                            var1_1.mInnerView = null;
                        }
lbl199:
                        // 3 sources

                        var1_1.performActivityCreated(var1_1.mSavedFragmentState);
                        if (var1_1.mView != null) {
                            var1_1.restoreViewState(var1_1.mSavedFragmentState);
                        }
                        var1_1.mSavedFragmentState = null;
                        cfr_temp_0 = 2;
                        var8_8 = var7_7;
                        case 2: 
                        case 3: {
                            var6_6 = var8_8;
                            if (var8_8 <= 3) break block13;
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)"FragmentManager", (String)("moveto STARTED: " + var1_1));
                            }
                            var1_1.performStart();
                            var6_6 = var8_8;
                        }
                        case 4: 
                    }
                    break;
                }
                break block75;
                ** while (true)
            }
            var7_7 = var6_6;
            if (var6_6 > 4) {
                if (FragmentManagerImpl.DEBUG) {
                    Log.v((String)"FragmentManager", (String)("moveto RESUMED: " + var1_1));
                }
                var1_1.performResume();
                var1_1.mSavedFragmentState = null;
                var1_1.mSavedViewState = null;
                var7_7 = var6_6;
            }
        }
        if (var1_1.mState == var7_7) return;
        Log.w((String)"FragmentManager", (String)("moveToState: Fragment state for " + var1_1 + " not updated inline; " + "expected state " + var7_7 + " found " + var1_1.mState));
        var1_1.mState = var7_7;
    }

    public void noteStateNotSaved() {
        this.mStateSaved = false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public View onCreateView(View object, String object2, Context context, AttributeSet attributeSet) {
        void var1_8;
        void var3_11;
        void var4_12;
        void var1_3;
        Object object3;
        if (!"fragment".equals(object3)) {
            return var1_3;
        }
        String string2 = var4_12.getAttributeValue(null, "class");
        object3 = var3_11.obtainStyledAttributes((AttributeSet)var4_12, FragmentTag.Fragment);
        if (string2 == null) {
            string2 = object3.getString(0);
        }
        int n2 = object3.getResourceId(1, -1);
        String string3 = object3.getString(2);
        object3.recycle();
        if (!Fragment.isSupportFragmentClass(this.mHost.getContext(), string2)) {
            return var1_3;
        }
        int n3 = object != null ? object.getId() : 0;
        if (n3 == -1 && n2 == -1 && string3 == null) {
            throw new IllegalArgumentException(var4_12.getPositionDescription() + ": Must specify unique android:id, android:tag, or have a parent with an id for " + string2);
        }
        object3 = n2 != -1 ? this.findFragmentById(n2) : null;
        Object object4 = object3;
        if (object3 == null) {
            Object object5 = object3;
            if (string3 != null) {
                Fragment fragment = this.findFragmentByTag(string3);
            }
        }
        object3 = var1_8;
        if (var1_8 == null) {
            object3 = var1_8;
            if (n3 != -1) {
                object3 = this.findFragmentById(n3);
            }
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("onCreateView: id=0x" + Integer.toHexString(n2) + " fname=" + string2 + " existing=" + object3));
        }
        if (object3 == null) {
            object3 = Fragment.instantiate((Context)var3_11, string2);
            ((Fragment)object3).mFromLayout = true;
            int n4 = n2 != 0 ? n2 : n3;
            ((Fragment)object3).mFragmentId = n4;
            ((Fragment)object3).mContainerId = n3;
            ((Fragment)object3).mTag = string3;
            ((Fragment)object3).mInLayout = true;
            ((Fragment)object3).mFragmentManager = this;
            ((Fragment)object3).mHost = this.mHost;
            ((Fragment)object3).onInflate(this.mHost.getContext(), (AttributeSet)var4_12, ((Fragment)object3).mSavedFragmentState);
            this.addFragment((Fragment)object3, true);
        } else {
            if (((Fragment)object3).mInLayout) {
                throw new IllegalArgumentException(var4_12.getPositionDescription() + ": Duplicate id 0x" + Integer.toHexString(n2) + ", tag " + string3 + ", or parent id 0x" + Integer.toHexString(n3) + " with another fragment for " + string2);
            }
            ((Fragment)object3).mInLayout = true;
            ((Fragment)object3).mHost = this.mHost;
            if (!((Fragment)object3).mRetaining) {
                ((Fragment)object3).onInflate(this.mHost.getContext(), (AttributeSet)var4_12, ((Fragment)object3).mSavedFragmentState);
            }
        }
        if (this.mCurState < 1 && ((Fragment)object3).mFromLayout) {
            this.moveToState((Fragment)object3, 1, 0, 0, false);
        } else {
            this.moveToState((Fragment)object3);
        }
        if (((Fragment)object3).mView == null) {
            throw new IllegalStateException("Fragment " + string2 + " did not create a view.");
        }
        if (n2 != 0) {
            ((Fragment)object3).mView.setId(n2);
        }
        if (((Fragment)object3).mView.getTag() == null) {
            ((Fragment)object3).mView.setTag((Object)string3);
        }
        View view = ((Fragment)object3).mView;
        return var1_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performPendingDeferredStart(Fragment fragment) {
        block4: {
            block3: {
                if (!fragment.mDeferStart) break block3;
                if (!this.mExecutingActions) break block4;
                this.mHavePendingDeferredStart = true;
            }
            return;
        }
        fragment.mDeferStart = false;
        this.moveToState(fragment, this.mCurState, 0, 0, false);
    }

    @Override
    public void popBackStack() {
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mHost.getHandler(), null, -1, 0);
            }
        }, false);
    }

    @Override
    public void popBackStack(final int n2, final int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Bad id: " + n2);
        }
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mHost.getHandler(), null, n2, n3);
            }
        }, false);
    }

    @Override
    public void popBackStack(final String string2, final int n2) {
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mHost.getHandler(), string2, -1, n2);
            }
        }, false);
    }

    @Override
    public boolean popBackStackImmediate() {
        this.checkStateLoss();
        this.executePendingTransactions();
        return this.popBackStackState(this.mHost.getHandler(), null, -1, 0);
    }

    @Override
    public boolean popBackStackImmediate(int n2, int n3) {
        this.checkStateLoss();
        this.executePendingTransactions();
        if (n2 < 0) {
            throw new IllegalArgumentException("Bad id: " + n2);
        }
        return this.popBackStackState(this.mHost.getHandler(), null, n2, n3);
    }

    @Override
    public boolean popBackStackImmediate(String string2, int n2) {
        this.checkStateLoss();
        this.executePendingTransactions();
        return this.popBackStackState(this.mHost.getHandler(), string2, -1, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean popBackStackState(Handler object, String object2, int n2, int n3) {
        int n4;
        boolean bl2;
        boolean bl3;
        block10: {
            int n5;
            bl3 = false;
            if (this.mBackStack == null) {
                return bl3;
            }
            if (object2 == null && n2 < 0 && (n3 & 1) == 0) {
                n2 = this.mBackStack.size() - 1;
                bl2 = bl3;
                if (n2 < 0) return bl2;
                BackStackRecord backStackRecord = this.mBackStack.remove(n2);
                object = new SparseArray();
                object2 = new SparseArray();
                backStackRecord.calculateBackFragments((SparseArray<Fragment>)object, (SparseArray<Fragment>)object2);
                backStackRecord.popFromBackStack(true, null, (SparseArray<Fragment>)object, (SparseArray<Fragment>)object2);
                this.reportBackStackChanged();
                return true;
            }
            n4 = -1;
            if (object2 == null && n2 < 0) break block10;
            for (n5 = this.mBackStack.size() - 1; n5 >= 0; --n5) {
                object = this.mBackStack.get(n5);
                if (object2 != null && ((String)object2).equals(((BackStackRecord)object).getName()) || n2 >= 0 && n2 == ((BackStackRecord)object).mIndex) break;
            }
            bl2 = bl3;
            if (n5 < 0) return bl2;
            n4 = n5;
            if ((n3 & 1) != 0) {
                n3 = n5 - 1;
                while (true) {
                    n4 = --n3;
                    if (n3 < 0) break;
                    object = this.mBackStack.get(n3);
                    if (object2 != null && ((String)object2).equals(((BackStackRecord)object).getName())) continue;
                    n4 = n3;
                    if (n2 < 0) break;
                    n4 = n3;
                    if (n2 != ((BackStackRecord)object).mIndex) break;
                }
            }
        }
        bl2 = bl3;
        if (n4 == this.mBackStack.size() - 1) return bl2;
        object2 = new ArrayList();
        for (n2 = this.mBackStack.size() - 1; n2 > n4; --n2) {
            ((ArrayList)object2).add(this.mBackStack.remove(n2));
        }
        n3 = ((ArrayList)object2).size() - 1;
        SparseArray sparseArray = new SparseArray();
        SparseArray sparseArray2 = new SparseArray();
        for (n2 = 0; n2 <= n3; ++n2) {
            ((BackStackRecord)((ArrayList)object2).get(n2)).calculateBackFragments((SparseArray<Fragment>)sparseArray, (SparseArray<Fragment>)sparseArray2);
        }
        object = null;
        for (n2 = 0; n2 <= n3; ++n2) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Popping back stack state: " + ((ArrayList)object2).get(n2)));
            }
            BackStackRecord backStackRecord = (BackStackRecord)((ArrayList)object2).get(n2);
            bl2 = n2 == n3;
            object = backStackRecord.popFromBackStack(bl2, (BackStackRecord.TransitionState)object, (SparseArray<Fragment>)sparseArray, (SparseArray<Fragment>)sparseArray2);
        }
        this.reportBackStackChanged();
        return true;
    }

    @Override
    public void putFragment(Bundle bundle, String string2, Fragment fragment) {
        if (fragment.mIndex < 0) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        bundle.putInt(string2, fragment.mIndex);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("remove: " + fragment + " nesting=" + fragment.mBackStackNesting));
        }
        int n4 = !fragment.isInBackStack() ? 1 : 0;
        if (!fragment.mDetached || n4 != 0) {
            if (this.mAdded != null) {
                this.mAdded.remove(fragment);
            }
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.mAdded = false;
            fragment.mRemoving = true;
            n4 = n4 != 0 ? 0 : 1;
            this.moveToState(fragment, n4, n2, n3, false);
        }
    }

    @Override
    public void removeOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener onBackStackChangedListener) {
        if (this.mBackStackChangeListeners != null) {
            this.mBackStackChangeListeners.remove(onBackStackChangedListener);
        }
    }

    void reportBackStackChanged() {
        if (this.mBackStackChangeListeners != null) {
            for (int i2 = 0; i2 < this.mBackStackChangeListeners.size(); ++i2) {
                this.mBackStackChangeListeners.get(i2).onBackStackChanged();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void restoreAllState(Parcelable parcelable, List<Fragment> object) {
        Object object2;
        Object object3;
        int n2;
        if (parcelable == null) {
            return;
        }
        parcelable = (FragmentManagerState)parcelable;
        if (parcelable.mActive == null) return;
        if (object != null) {
            for (n2 = 0; n2 < object.size(); ++n2) {
                object3 = (Fragment)object.get(n2);
                if (DEBUG) {
                    Log.v((String)TAG, (String)("restoreAllState: re-attaching retained " + object3));
                }
                object2 = parcelable.mActive[((Fragment)object3).mIndex];
                ((FragmentState)object2).mInstance = object3;
                ((Fragment)object3).mSavedViewState = null;
                ((Fragment)object3).mBackStackNesting = 0;
                ((Fragment)object3).mInLayout = false;
                ((Fragment)object3).mAdded = false;
                ((Fragment)object3).mTarget = null;
                if (((FragmentState)object2).mSavedFragmentState == null) continue;
                ((FragmentState)object2).mSavedFragmentState.setClassLoader(this.mHost.getContext().getClassLoader());
                ((Fragment)object3).mSavedViewState = ((FragmentState)object2).mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
                ((Fragment)object3).mSavedFragmentState = ((FragmentState)object2).mSavedFragmentState;
            }
        }
        this.mActive = new ArrayList(parcelable.mActive.length);
        if (this.mAvailIndices != null) {
            this.mAvailIndices.clear();
        }
        for (n2 = 0; n2 < parcelable.mActive.length; ++n2) {
            object3 = parcelable.mActive[n2];
            if (object3 != null) {
                object2 = ((FragmentState)object3).instantiate(this.mHost, this.mParent);
                if (DEBUG) {
                    Log.v((String)TAG, (String)("restoreAllState: active #" + n2 + ": " + object2));
                }
                this.mActive.add((Fragment)object2);
                ((FragmentState)object3).mInstance = null;
                continue;
            }
            this.mActive.add(null);
            if (this.mAvailIndices == null) {
                this.mAvailIndices = new ArrayList();
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("restoreAllState: avail #" + n2));
            }
            this.mAvailIndices.add(n2);
        }
        if (object != null) {
            for (n2 = 0; n2 < object.size(); ++n2) {
                object3 = (Fragment)object.get(n2);
                if (((Fragment)object3).mTargetIndex < 0) continue;
                if (((Fragment)object3).mTargetIndex < this.mActive.size()) {
                    ((Fragment)object3).mTarget = this.mActive.get(((Fragment)object3).mTargetIndex);
                    continue;
                }
                Log.w((String)TAG, (String)("Re-attaching retained fragment " + object3 + " target no longer exists: " + ((Fragment)object3).mTargetIndex));
                ((Fragment)object3).mTarget = null;
            }
        }
        if (parcelable.mAdded == null) {
            this.mAdded = null;
        } else {
            this.mAdded = new ArrayList(parcelable.mAdded.length);
            for (n2 = 0; n2 < parcelable.mAdded.length; ++n2) {
                object = this.mActive.get(parcelable.mAdded[n2]);
                if (object == null) {
                    this.throwException(new IllegalStateException("No instantiated fragment for index #" + parcelable.mAdded[n2]));
                }
                ((Fragment)object).mAdded = true;
                if (DEBUG) {
                    Log.v((String)TAG, (String)("restoreAllState: added #" + n2 + ": " + object));
                }
                if (this.mAdded.contains(object)) {
                    throw new IllegalStateException("Already added!");
                }
                this.mAdded.add((Fragment)object);
            }
        }
        if (parcelable.mBackStack == null) {
            this.mBackStack = null;
            return;
        }
        this.mBackStack = new ArrayList(parcelable.mBackStack.length);
        n2 = 0;
        while (n2 < parcelable.mBackStack.length) {
            object = parcelable.mBackStack[n2].instantiate(this);
            if (DEBUG) {
                Log.v((String)TAG, (String)("restoreAllState: back stack #" + n2 + " (index " + ((BackStackRecord)object).mIndex + "): " + object));
                ((BackStackRecord)object).dump("  ", new PrintWriter(new LogWriter(TAG)), false);
            }
            this.mBackStack.add((BackStackRecord)object);
            if (((BackStackRecord)object).mIndex >= 0) {
                this.setBackStackIndex(((BackStackRecord)object).mIndex, (BackStackRecord)object);
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    ArrayList<Fragment> retainNonConfig() {
        ArrayList<Fragment> arrayList = null;
        ArrayList<Fragment> arrayList2 = null;
        if (this.mActive == null) return arrayList;
        int n2 = 0;
        while (true) {
            arrayList = arrayList2;
            if (n2 >= this.mActive.size()) {
                return arrayList;
            }
            Fragment fragment = this.mActive.get(n2);
            ArrayList<Fragment> arrayList3 = arrayList2;
            if (fragment != null) {
                arrayList3 = arrayList2;
                if (fragment.mRetainInstance) {
                    arrayList = arrayList2;
                    if (arrayList2 == null) {
                        arrayList = new ArrayList<Fragment>();
                    }
                    arrayList.add(fragment);
                    fragment.mRetaining = true;
                    int n3 = fragment.mTarget != null ? fragment.mTarget.mIndex : -1;
                    fragment.mTargetIndex = n3;
                    arrayList3 = arrayList;
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("retainNonConfig: keeping retained " + fragment));
                        arrayList3 = arrayList;
                    }
                }
            }
            ++n2;
            arrayList2 = arrayList3;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    Parcelable saveAllState() {
        void var3_16;
        int n2;
        void var3_8;
        int[] nArray = null;
        Object[] objectArray = null;
        this.execPendingActions();
        if (HONEYCOMB) {
            this.mStateSaved = true;
        }
        int[] nArray2 = objectArray;
        if (this.mActive == null) return var3_8;
        if (this.mActive.size() <= 0) {
            int[] nArray3 = objectArray;
            return var3_8;
        }
        int n3 = this.mActive.size();
        FragmentState[] fragmentStateArray = new FragmentState[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            FragmentState fragmentState;
            Fragment fragment;
            block21: {
                block20: {
                    fragment = this.mActive.get(n2);
                    if (fragment == null) continue;
                    if (fragment.mIndex < 0) {
                        this.throwException(new IllegalStateException("Failure saving state: active " + fragment + " has cleared index: " + fragment.mIndex));
                    }
                    fragmentStateArray[n2] = fragmentState = new FragmentState(fragment);
                    if (fragment.mState <= 0 || fragmentState.mSavedFragmentState != null) break block20;
                    fragmentState.mSavedFragmentState = this.saveFragmentBasicState(fragment);
                    if (fragment.mTarget != null) {
                        if (fragment.mTarget.mIndex < 0) {
                            this.throwException(new IllegalStateException("Failure saving state: " + fragment + " has target not in fragment manager: " + fragment.mTarget));
                        }
                        if (fragmentState.mSavedFragmentState == null) {
                            fragmentState.mSavedFragmentState = new Bundle();
                        }
                        this.putFragment(fragmentState.mSavedFragmentState, TARGET_STATE_TAG, fragment.mTarget);
                        if (fragment.mTargetRequestCode != 0) {
                            fragmentState.mSavedFragmentState.putInt(TARGET_REQUEST_CODE_STATE_TAG, fragment.mTargetRequestCode);
                        }
                    }
                    break block21;
                }
                fragmentState.mSavedFragmentState = fragment.mSavedFragmentState;
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("Saved state of " + fragment + ": " + fragmentState.mSavedFragmentState));
            }
            n4 = 1;
        }
        if (n4 == 0) {
            int[] nArray4 = objectArray;
            if (!DEBUG) return var3_8;
            Log.v((String)TAG, (String)"saveAllState: no fragments!");
            int[] nArray5 = objectArray;
            return var3_8;
        }
        if (this.mAdded != null && (n2 = this.mAdded.size()) > 0) {
            objectArray = new int[n2];
            n4 = 0;
            while (true) {
                int[] nArray6 = objectArray;
                if (n4 < n2) {
                    objectArray[n4] = this.mAdded.get((int)n4).mIndex;
                    if (objectArray[n4] < 0) {
                        this.throwException(new IllegalStateException("Failure saving state: active " + this.mAdded.get(n4) + " has cleared index: " + objectArray[n4]));
                    }
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("saveAllState: adding fragment #" + n4 + ": " + this.mAdded.get(n4)));
                    }
                    ++n4;
                    continue;
                }
                break;
            }
        } else {
            Object var3_15 = null;
        }
        objectArray = nArray;
        if (this.mBackStack != null) {
            n2 = this.mBackStack.size();
            objectArray = nArray;
            if (n2 > 0) {
                BackStackState[] backStackStateArray = new BackStackState[n2];
                n4 = 0;
                while (true) {
                    objectArray = backStackStateArray;
                    if (n4 >= n2) break;
                    backStackStateArray[n4] = new BackStackState(this.mBackStack.get(n4));
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("saveAllState: adding back stack #" + n4 + ": " + this.mBackStack.get(n4)));
                    }
                    ++n4;
                }
            }
        }
        FragmentManagerState fragmentManagerState = new FragmentManagerState();
        fragmentManagerState.mActive = fragmentStateArray;
        fragmentManagerState.mAdded = var3_16;
        fragmentManagerState.mBackStack = (BackStackState[])objectArray;
        FragmentManagerState fragmentManagerState2 = fragmentManagerState;
        return var3_8;
    }

    /*
     * Enabled aggressive block sorting
     */
    Bundle saveFragmentBasicState(Fragment fragment) {
        Bundle bundle;
        if (this.mStateBundle == null) {
            this.mStateBundle = new Bundle();
        }
        fragment.performSaveInstanceState(this.mStateBundle);
        if (!this.mStateBundle.isEmpty()) {
            bundle = this.mStateBundle;
            this.mStateBundle = null;
        } else {
            bundle = null;
        }
        if (fragment.mView != null) {
            this.saveFragmentViewState(fragment);
        }
        Bundle bundle2 = bundle;
        if (fragment.mSavedViewState != null) {
            bundle2 = bundle;
            if (bundle == null) {
                bundle2 = new Bundle();
            }
            bundle2.putSparseParcelableArray(VIEW_STATE_TAG, fragment.mSavedViewState);
        }
        bundle = bundle2;
        if (!fragment.mUserVisibleHint) {
            bundle = bundle2;
            if (bundle2 == null) {
                bundle = new Bundle();
            }
            bundle.putBoolean(USER_VISIBLE_HINT_TAG, fragment.mUserVisibleHint);
        }
        return bundle;
    }

    @Override
    public Fragment.SavedState saveFragmentInstanceState(Fragment fragment) {
        Fragment.SavedState savedState = null;
        if (fragment.mIndex < 0) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        Fragment.SavedState savedState2 = savedState;
        if (fragment.mState > 0) {
            fragment = this.saveFragmentBasicState(fragment);
            savedState2 = savedState;
            if (fragment != null) {
                savedState2 = new Fragment.SavedState((Bundle)fragment);
            }
        }
        return savedState2;
    }

    /*
     * Enabled aggressive block sorting
     */
    void saveFragmentViewState(Fragment fragment) {
        if (fragment.mInnerView == null) {
            return;
        }
        if (this.mStateArray == null) {
            this.mStateArray = new SparseArray();
        } else {
            this.mStateArray.clear();
        }
        fragment.mInnerView.saveHierarchyState(this.mStateArray);
        if (this.mStateArray.size() <= 0) return;
        fragment.mSavedViewState = this.mStateArray;
        this.mStateArray = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBackStackIndex(int n2, BackStackRecord backStackRecord) {
        synchronized (this) {
            int n3;
            Serializable serializable;
            if (this.mBackStackIndices == null) {
                serializable = new ArrayList();
                this.mBackStackIndices = serializable;
            }
            if (n2 < n3) {
                if (DEBUG) {
                    serializable = new StringBuilder();
                    Log.v((String)TAG, (String)((StringBuilder)serializable).append("Setting back stack index ").append(n2).append(" to ").append(backStackRecord).toString());
                }
                this.mBackStackIndices.set(n2, backStackRecord);
            } else {
                for (int i2 = n3 = this.mBackStackIndices.size(); i2 < n2; ++i2) {
                    this.mBackStackIndices.add(null);
                    if (this.mAvailBackStackIndices == null) {
                        serializable = new ArrayList();
                        this.mAvailBackStackIndices = serializable;
                    }
                    if (DEBUG) {
                        serializable = new StringBuilder();
                        Log.v((String)TAG, (String)((StringBuilder)serializable).append("Adding available back stack index ").append(i2).toString());
                    }
                    this.mAvailBackStackIndices.add(i2);
                }
                if (DEBUG) {
                    serializable = new StringBuilder();
                    Log.v((String)TAG, (String)((StringBuilder)serializable).append("Adding back stack index ").append(n2).append(" with ").append(backStackRecord).toString());
                }
                this.mBackStackIndices.add(backStackRecord);
            }
            return;
        }
    }

    public void showFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("show: " + fragment));
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            if (fragment.mView != null) {
                Animation animation = this.loadAnimation(fragment, n2, true, n3);
                if (animation != null) {
                    this.setHWLayerAnimListenerIfAlpha(fragment.mView, animation);
                    fragment.mView.startAnimation(animation);
                }
                fragment.mView.setVisibility(0);
            }
            if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.onHiddenChanged(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void startPendingDeferredFragments() {
        if (this.mActive != null) {
            for (int i2 = 0; i2 < this.mActive.size(); ++i2) {
                Fragment fragment = this.mActive.get(i2);
                if (fragment == null) continue;
                this.performPendingDeferredStart(fragment);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("FragmentManager{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(" in ");
        if (this.mParent != null) {
            DebugUtils.buildShortClassTag(this.mParent, stringBuilder);
        } else {
            DebugUtils.buildShortClassTag(this.mHost, stringBuilder);
        }
        stringBuilder.append("}}");
        return stringBuilder.toString();
    }

    static class AnimateOnHWLayerIfNeededListener
    implements Animation.AnimationListener {
        private Animation.AnimationListener mOrignalListener = null;
        private boolean mShouldRunOnHWLayer = false;
        private View mView = null;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public AnimateOnHWLayerIfNeededListener(View view, Animation animation) {
            if (view == null || animation == null) {
                return;
            }
            this.mView = view;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public AnimateOnHWLayerIfNeededListener(View view, Animation animation, Animation.AnimationListener animationListener) {
            if (view == null || animation == null) {
                return;
            }
            this.mOrignalListener = animationListener;
            this.mView = view;
        }

        @CallSuper
        public void onAnimationEnd(Animation animation) {
            if (this.mView != null && this.mShouldRunOnHWLayer) {
                this.mView.post(new Runnable(){

                    @Override
                    public void run() {
                        ViewCompat.setLayerType(AnimateOnHWLayerIfNeededListener.this.mView, 0, null);
                    }
                });
            }
            if (this.mOrignalListener != null) {
                this.mOrignalListener.onAnimationEnd(animation);
            }
        }

        public void onAnimationRepeat(Animation animation) {
            if (this.mOrignalListener != null) {
                this.mOrignalListener.onAnimationRepeat(animation);
            }
        }

        @CallSuper
        public void onAnimationStart(Animation animation) {
            if (this.mView != null) {
                this.mShouldRunOnHWLayer = FragmentManagerImpl.shouldRunOnHWLayer(this.mView, animation);
                if (this.mShouldRunOnHWLayer) {
                    this.mView.post(new Runnable(){

                        @Override
                        public void run() {
                            ViewCompat.setLayerType(AnimateOnHWLayerIfNeededListener.this.mView, 2, null);
                        }
                    });
                }
            }
            if (this.mOrignalListener != null) {
                this.mOrignalListener.onAnimationStart(animation);
            }
        }
    }

    static class FragmentTag {
        public static final int[] Fragment = new int[]{0x1010003, 0x10100D0, 0x10100D1};
        public static final int Fragment_id = 1;
        public static final int Fragment_name = 0;
        public static final int Fragment_tag = 2;

        FragmentTag() {
        }
    }
}

