/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompatApi21;
import android.support.v4.content.ContextCompatApi23;
import android.support.v4.content.ContextCompatFroyo;
import android.support.v4.content.ContextCompatHoneycomb;
import android.support.v4.content.ContextCompatJellybean;
import android.support.v4.content.ContextCompatKitKat;
import android.util.Log;
import java.io.File;

public class ContextCompat {
    private static final String DIR_ANDROID = "Android";
    private static final String DIR_CACHE = "cache";
    private static final String DIR_DATA = "data";
    private static final String DIR_FILES = "files";
    private static final String DIR_OBB = "obb";
    private static final String TAG = "ContextCompat";

    /*
     * Enabled aggressive block sorting
     */
    private static File buildPath(File file, String ... stringArray) {
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (file == null) {
                file = new File(string2);
            } else if (string2 != null) {
                file = new File(file, string2);
            }
            ++n3;
        }
        return file;
    }

    public static int checkSelfPermission(@NonNull Context context, @NonNull String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        return context.checkPermission(string2, Process.myPid(), Process.myUid());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File createFilesDir(File file) {
        synchronized (ContextCompat.class) {
            Comparable<File> comparable;
            block5: {
                comparable = file;
                if (file.exists()) return comparable;
                comparable = file;
                if (file.mkdirs()) return comparable;
                boolean bl2 = file.exists();
                if (!bl2) break block5;
                return file;
            }
            comparable = new Comparable<File>();
            Log.w((String)TAG, (String)((StringBuilder)comparable).append("Unable to create files subdir ").append(file.getPath()).toString());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getCodeCacheDir(Context object) {
        void var0_2;
        if (Build.VERSION.SDK_INT >= 21) {
            File file = ContextCompatApi21.getCodeCacheDir(object);
            return var0_2;
        }
        File file = ContextCompat.createFilesDir(new File(object.getApplicationInfo().dataDir, "code_cache"));
        return var0_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int getColor(Context context, int n2) {
        if (Build.VERSION.SDK_INT < 23) return context.getResources().getColor(n2);
        return ContextCompatApi23.getColor(context, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ColorStateList getColorStateList(Context context, int n2) {
        if (Build.VERSION.SDK_INT < 23) return context.getResources().getColorStateList(n2);
        return ContextCompatApi23.getColorStateList(context, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Drawable getDrawable(Context context, int n2) {
        if (Build.VERSION.SDK_INT < 21) return context.getResources().getDrawable(n2);
        return ContextCompatApi21.getDrawable(context, n2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static File[] getExternalCacheDirs(Context object) {
        void var0_4;
        void var0_2;
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 19) {
            File[] fileArray = ContextCompatKitKat.getExternalCacheDirs((Context)object);
            return var0_2;
        }
        if (n2 >= 8) {
            File file = ContextCompatFroyo.getExternalCacheDir((Context)object);
        } else {
            File file = ContextCompat.buildPath(Environment.getExternalStorageDirectory(), DIR_ANDROID, DIR_DATA, object.getPackageName(), DIR_CACHE);
        }
        File[] fileArray = new File[]{var0_4};
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static File[] getExternalFilesDirs(Context object, String string2) {
        void var0_4;
        void var0_2;
        void var1_7;
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 19) {
            File[] fileArray = ContextCompatKitKat.getExternalFilesDirs((Context)object, (String)var1_7);
            return var0_2;
        }
        if (n2 >= 8) {
            File file = ContextCompatFroyo.getExternalFilesDir((Context)object, (String)var1_7);
        } else {
            File file = ContextCompat.buildPath(Environment.getExternalStorageDirectory(), new String[]{DIR_ANDROID, DIR_DATA, object.getPackageName(), DIR_FILES, var1_7});
        }
        File[] fileArray = new File[]{var0_4};
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static File[] getObbDirs(Context object) {
        void var0_4;
        void var0_2;
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 19) {
            File[] fileArray = ContextCompatKitKat.getObbDirs((Context)object);
            return var0_2;
        }
        if (n2 >= 11) {
            File file = ContextCompatHoneycomb.getObbDir((Context)object);
        } else {
            File file = ContextCompat.buildPath(Environment.getExternalStorageDirectory(), DIR_ANDROID, DIR_OBB, object.getPackageName());
        }
        File[] fileArray = new File[]{var0_4};
        return var0_2;
    }

    public static boolean startActivities(Context context, Intent[] intentArray) {
        return ContextCompat.startActivities(context, intentArray, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean startActivities(Context context, Intent[] intentArray, Bundle bundle) {
        boolean bl2 = true;
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 16) {
            ContextCompatJellybean.startActivities(context, intentArray, bundle);
            return bl2;
        }
        if (n2 < 11) return false;
        ContextCompatHoneycomb.startActivities(context, intentArray);
        return bl2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final File getNoBackupFilesDir(Context object) {
        void var1_3;
        if (Build.VERSION.SDK_INT >= 21) {
            File file = ContextCompatApi21.getNoBackupFilesDir(object);
            return var1_3;
        }
        File file = ContextCompat.createFilesDir(new File(object.getApplicationInfo().dataDir, "no_backup"));
        return var1_3;
    }
}

