/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.Context;
import android.os.Binder;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.v4.app.AppOpsManagerCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class PermissionChecker {
    public static final int PERMISSION_DENIED = -1;
    public static final int PERMISSION_DENIED_APP_OP = -2;
    public static final int PERMISSION_GRANTED = 0;

    private PermissionChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int checkCallingOrSelfPermission(@NonNull Context context, @NonNull String string2) {
        String string3;
        if (Binder.getCallingPid() == Process.myPid()) {
            string3 = context.getPackageName();
            return PermissionChecker.checkPermission(context, string2, Binder.getCallingPid(), Binder.getCallingUid(), string3);
        }
        string3 = null;
        return PermissionChecker.checkPermission(context, string2, Binder.getCallingPid(), Binder.getCallingUid(), string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int checkCallingPermission(@NonNull Context context, @NonNull String string2, String string3) {
        if (Binder.getCallingPid() != Process.myPid()) return PermissionChecker.checkPermission(context, string2, Binder.getCallingPid(), Binder.getCallingUid(), string3);
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int checkPermission(@NonNull Context context, @NonNull String object, int n2, int n3, String string2) {
        void var1_5;
        void var4_8;
        void var3_7;
        int n4;
        int n5 = -1;
        if (context.checkPermission((String)object, n4, (int)var3_7) == -1) {
            return n5;
        }
        String string3 = AppOpsManagerCompat.permissionToOp((String)object);
        if (string3 == null) {
            return 0;
        }
        void var1_2 = var4_8;
        if (var4_8 == null) {
            String[] stringArray = context.getPackageManager().getPackagesForUid((int)var3_7);
            n4 = n5;
            if (stringArray == null) return n4;
            n4 = n5;
            if (stringArray.length <= 0) return n4;
            String string4 = stringArray[0];
        }
        if (AppOpsManagerCompat.noteProxyOp(context, string3, (String)var1_5) == 0) return 0;
        return -2;
    }

    public static int checkSelfPermission(@NonNull Context context, @NonNull String string2) {
        return PermissionChecker.checkPermission(context, string2, Process.myPid(), Process.myUid(), context.getPackageName());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionResult {
    }
}

