/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.graphics.Bitmap;
import android.os.Build;
import android.support.v4.graphics.BitmapCompatHoneycombMr1;
import android.support.v4.graphics.BitmapCompatJellybeanMR2;
import android.support.v4.graphics.BitmapCompatKitKat;

public final class BitmapCompat {
    static final BitmapImpl IMPL;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 19) {
            IMPL = new KitKatBitmapCompatImpl();
            return;
        }
        if (n2 >= 18) {
            IMPL = new JbMr2BitmapCompatImpl();
            return;
        }
        if (n2 >= 12) {
            IMPL = new HcMr1BitmapCompatImpl();
            return;
        }
        IMPL = new BaseBitmapImpl();
    }

    private BitmapCompat() {
    }

    public static int getAllocationByteCount(Bitmap bitmap) {
        return IMPL.getAllocationByteCount(bitmap);
    }

    public static boolean hasMipMap(Bitmap bitmap) {
        return IMPL.hasMipMap(bitmap);
    }

    public static void setHasMipMap(Bitmap bitmap, boolean bl2) {
        IMPL.setHasMipMap(bitmap, bl2);
    }

    static class BaseBitmapImpl
    implements BitmapImpl {
        BaseBitmapImpl() {
        }

        @Override
        public int getAllocationByteCount(Bitmap bitmap) {
            return bitmap.getRowBytes() * bitmap.getHeight();
        }

        @Override
        public boolean hasMipMap(Bitmap bitmap) {
            return false;
        }

        @Override
        public void setHasMipMap(Bitmap bitmap, boolean bl2) {
        }
    }

    static interface BitmapImpl {
        public int getAllocationByteCount(Bitmap var1);

        public boolean hasMipMap(Bitmap var1);

        public void setHasMipMap(Bitmap var1, boolean var2);
    }

    static class HcMr1BitmapCompatImpl
    extends BaseBitmapImpl {
        HcMr1BitmapCompatImpl() {
        }

        @Override
        public int getAllocationByteCount(Bitmap bitmap) {
            return BitmapCompatHoneycombMr1.getAllocationByteCount(bitmap);
        }
    }

    static class JbMr2BitmapCompatImpl
    extends HcMr1BitmapCompatImpl {
        JbMr2BitmapCompatImpl() {
        }

        @Override
        public boolean hasMipMap(Bitmap bitmap) {
            return BitmapCompatJellybeanMR2.hasMipMap(bitmap);
        }

        @Override
        public void setHasMipMap(Bitmap bitmap, boolean bl2) {
            BitmapCompatJellybeanMR2.setHasMipMap(bitmap, bl2);
        }
    }

    static class KitKatBitmapCompatImpl
    extends JbMr2BitmapCompatImpl {
        KitKatBitmapCompatImpl() {
        }

        @Override
        public int getAllocationByteCount(Bitmap bitmap) {
            return BitmapCompatKitKat.getAllocationByteCount(bitmap);
        }
    }
}

