/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.hardware.display;

import android.content.Context;
import android.os.Build;
import android.support.v4.hardware.display.DisplayManagerJellybeanMr1;
import android.view.Display;
import android.view.WindowManager;
import java.util.WeakHashMap;

public abstract class DisplayManagerCompat {
    public static final String DISPLAY_CATEGORY_PRESENTATION = "android.hardware.display.category.PRESENTATION";
    private static final WeakHashMap<Context, DisplayManagerCompat> sInstances = new WeakHashMap();

    DisplayManagerCompat() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DisplayManagerCompat getInstance(Context context) {
        WeakHashMap<Context, DisplayManagerCompat> weakHashMap = sInstances;
        synchronized (weakHashMap) {
            DisplayManagerCompat displayManagerCompat;
            DisplayManagerCompat displayManagerCompat2 = displayManagerCompat = sInstances.get(context);
            if (displayManagerCompat == null) {
                displayManagerCompat2 = Build.VERSION.SDK_INT >= 17 ? new JellybeanMr1Impl(context) : new LegacyImpl(context);
                sInstances.put(context, displayManagerCompat2);
            }
            return displayManagerCompat2;
        }
    }

    public abstract Display getDisplay(int var1);

    public abstract Display[] getDisplays();

    public abstract Display[] getDisplays(String var1);

    private static class JellybeanMr1Impl
    extends DisplayManagerCompat {
        private final Object mDisplayManagerObj;

        public JellybeanMr1Impl(Context context) {
            this.mDisplayManagerObj = DisplayManagerJellybeanMr1.getDisplayManager(context);
        }

        @Override
        public Display getDisplay(int n2) {
            return DisplayManagerJellybeanMr1.getDisplay(this.mDisplayManagerObj, n2);
        }

        @Override
        public Display[] getDisplays() {
            return DisplayManagerJellybeanMr1.getDisplays(this.mDisplayManagerObj);
        }

        @Override
        public Display[] getDisplays(String string2) {
            return DisplayManagerJellybeanMr1.getDisplays(this.mDisplayManagerObj, string2);
        }
    }

    private static class LegacyImpl
    extends DisplayManagerCompat {
        private final WindowManager mWindowManager;

        public LegacyImpl(Context context) {
            this.mWindowManager = (WindowManager)context.getSystemService("window");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Display getDisplay(int n2) {
            Display display = this.mWindowManager.getDefaultDisplay();
            if (display.getDisplayId() != n2) return null;
            return display;
        }

        @Override
        public Display[] getDisplays() {
            return new Display[]{this.mWindowManager.getDefaultDisplay()};
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Display[] getDisplays(String displayArray) {
            if (displayArray != null) return new Display[0];
            return this.getDisplays();
        }
    }
}

