/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.Intent;
import android.media.MediaDescription;
import android.media.browse.MediaBrowser;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.v4.media.IMediaBrowserServiceAdapterApi21;
import android.support.v4.media.IMediaBrowserServiceCallbacksAdapterApi21;
import android.support.v4.media.ParceledListSliceAdapterApi21;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class MediaBrowserServiceCompatApi21 {
    MediaBrowserServiceCompatApi21() {
    }

    public static Object createService() {
        return new MediaBrowserServiceAdaptorApi21();
    }

    public static IBinder onBind(Object object, Intent intent) {
        return ((MediaBrowserServiceAdaptorApi21)object).onBind(intent);
    }

    public static void onCreate(Object object, ServiceImplApi21 serviceImplApi21) {
        ((MediaBrowserServiceAdaptorApi21)object).onCreate(serviceImplApi21);
    }

    static class MediaBrowserServiceAdaptorApi21 {
        ServiceBinderProxyApi21 mBinder;

        MediaBrowserServiceAdaptorApi21() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IBinder onBind(Intent object) {
            void var1_3;
            if (!"android.media.browse.MediaBrowserService".equals(object.getAction())) return var1_3;
            ServiceBinderProxyApi21 serviceBinderProxyApi21 = this.mBinder;
            return var1_3;
        }

        public void onCreate(ServiceImplApi21 serviceImplApi21) {
            this.mBinder = new ServiceBinderProxyApi21(serviceImplApi21);
        }

        static class ServiceBinderProxyApi21
        extends IMediaBrowserServiceAdapterApi21.Stub {
            final ServiceImplApi21 mServiceImpl;

            ServiceBinderProxyApi21(ServiceImplApi21 serviceImplApi21) {
                this.mServiceImpl = serviceImplApi21;
            }

            @Override
            public void addSubscription(String string2, Object object) {
                this.mServiceImpl.addSubscription(string2, new ServiceCallbacksApi21(object));
            }

            @Override
            public void connect(String string2, Bundle bundle, Object object) {
                this.mServiceImpl.connect(string2, bundle, new ServiceCallbacksApi21(object));
            }

            @Override
            public void disconnect(Object object) {
                this.mServiceImpl.disconnect(new ServiceCallbacksApi21(object));
            }

            @Override
            public void getMediaItem(String string2, ResultReceiver resultReceiver) {
            }

            @Override
            public void removeSubscription(String string2, Object object) {
                this.mServiceImpl.removeSubscription(string2, new ServiceCallbacksApi21(object));
            }
        }
    }

    public static interface ServiceCallbacks {
        public IBinder asBinder();

        public void onConnect(String var1, Object var2, Bundle var3) throws RemoteException;

        public void onConnectFailed() throws RemoteException;

        public void onLoadChildren(String var1, List<Parcel> var2) throws RemoteException;
    }

    public static class ServiceCallbacksApi21
    implements ServiceCallbacks {
        private static Object sNullParceledListSliceObj;
        private final IMediaBrowserServiceCallbacksAdapterApi21 mCallbacks;

        static {
            MediaBrowser.MediaItem mediaItem = new MediaBrowser.MediaItem(new MediaDescription.Builder().setMediaId("android.support.v4.media.MediaBrowserCompat.NULL_MEDIA_ITEM").build(), 0);
            ArrayList<MediaBrowser.MediaItem> arrayList = new ArrayList<MediaBrowser.MediaItem>();
            arrayList.add(mediaItem);
            sNullParceledListSliceObj = ParceledListSliceAdapterApi21.newInstance(arrayList);
        }

        ServiceCallbacksApi21(Object object) {
            this.mCallbacks = new IMediaBrowserServiceCallbacksAdapterApi21(object);
        }

        @Override
        public IBinder asBinder() {
            return this.mCallbacks.asBinder();
        }

        @Override
        public void onConnect(String string2, Object object, Bundle bundle) throws RemoteException {
            this.mCallbacks.onConnect(string2, object, bundle);
        }

        @Override
        public void onConnectFailed() throws RemoteException {
            this.mCallbacks.onConnectFailed();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onLoadChildren(String string2, List<Parcel> object) throws RemoteException {
            Object var3_3 = null;
            if (object != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    object = (Parcel)iterator.next();
                    object.setDataPosition(0);
                    arrayList.add(MediaBrowser.MediaItem.CREATOR.createFromParcel((Parcel)object));
                    object.recycle();
                }
                object = arrayList;
            } else {
                object = null;
            }
            object = Build.VERSION.SDK_INT > 23 ? (object == null ? var3_3 : ParceledListSliceAdapterApi21.newInstance((List<MediaBrowser.MediaItem>)object)) : (object == null ? sNullParceledListSliceObj : ParceledListSliceAdapterApi21.newInstance((List<MediaBrowser.MediaItem>)object));
            this.mCallbacks.onLoadChildren(string2, object);
        }
    }

    public static interface ServiceImplApi21 {
        public void addSubscription(String var1, ServiceCallbacks var2);

        public void connect(String var1, Bundle var2, ServiceCallbacks var3);

        public void disconnect(ServiceCallbacks var1);

        public void removeSubscription(String var1, ServiceCallbacks var2);
    }
}

