/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.util;

import android.support.v4.util.ArrayMap;
import android.support.v4.util.ContainerHelpers;
import java.util.Map;

public class SimpleArrayMap<K, V> {
    private static final int BASE_SIZE = 4;
    private static final int CACHE_SIZE = 10;
    private static final boolean DEBUG = false;
    private static final String TAG = "ArrayMap";
    static Object[] mBaseCache;
    static int mBaseCacheSize;
    static Object[] mTwiceBaseCache;
    static int mTwiceBaseCacheSize;
    Object[] mArray;
    int[] mHashes;
    int mSize;

    public SimpleArrayMap() {
        this.mHashes = ContainerHelpers.EMPTY_INTS;
        this.mArray = ContainerHelpers.EMPTY_OBJECTS;
        this.mSize = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public SimpleArrayMap(int n2) {
        if (n2 == 0) {
            this.mHashes = ContainerHelpers.EMPTY_INTS;
            this.mArray = ContainerHelpers.EMPTY_OBJECTS;
        } else {
            this.allocArrays(n2);
        }
        this.mSize = 0;
    }

    public SimpleArrayMap(SimpleArrayMap simpleArrayMap) {
        this();
        if (simpleArrayMap != null) {
            this.putAll(simpleArrayMap);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void allocArrays(int n2) {
        if (n2 == 8) {
            synchronized (ArrayMap.class) {
                if (mTwiceBaseCache != null) {
                    Object[] objectArray = mTwiceBaseCache;
                    this.mArray = objectArray;
                    mTwiceBaseCache = (Object[])objectArray[0];
                    this.mHashes = (int[])objectArray[1];
                    objectArray[1] = null;
                    objectArray[0] = null;
                    --mTwiceBaseCacheSize;
                    return;
                }
            }
        } else if (n2 == 4) {
            synchronized (ArrayMap.class) {
                if (mBaseCache != null) {
                    Object[] objectArray = mBaseCache;
                    this.mArray = objectArray;
                    mBaseCache = (Object[])objectArray[0];
                    this.mHashes = (int[])objectArray[1];
                    objectArray[1] = null;
                    objectArray[0] = null;
                    --mBaseCacheSize;
                    return;
                }
            }
        }
        this.mHashes = new int[n2];
        this.mArray = new Object[n2 << 1];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void freeArrays(int[] nArray, Object[] objectArray, int n2) {
        if (nArray.length == 8) {
            synchronized (ArrayMap.class) {
                if (mTwiceBaseCacheSize >= 10) return;
                objectArray[0] = mTwiceBaseCache;
                objectArray[1] = nArray;
                n2 = (n2 << 1) - 1;
                while (true) {
                    if (n2 < 2) {
                        mTwiceBaseCache = objectArray;
                        ++mTwiceBaseCacheSize;
                        return;
                    }
                    objectArray[n2] = null;
                    --n2;
                }
            }
        }
        if (nArray.length != 4) return;
        synchronized (ArrayMap.class) {
            if (mBaseCacheSize >= 10) return;
            objectArray[0] = mBaseCache;
            objectArray[1] = nArray;
            n2 = (n2 << 1) - 1;
            while (true) {
                if (n2 < 2) {
                    mBaseCache = objectArray;
                    ++mBaseCacheSize;
                    return;
                }
                objectArray[n2] = null;
                --n2;
            }
        }
    }

    public void clear() {
        if (this.mSize != 0) {
            SimpleArrayMap.freeArrays(this.mHashes, this.mArray, this.mSize);
            this.mHashes = ContainerHelpers.EMPTY_INTS;
            this.mArray = ContainerHelpers.EMPTY_OBJECTS;
            this.mSize = 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsKey(Object object) {
        if (this.indexOfKey(object) < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsValue(Object object) {
        if (this.indexOfValue(object) < 0) return false;
        return true;
    }

    public void ensureCapacity(int n2) {
        if (this.mHashes.length < n2) {
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.allocArrays(n2);
            if (this.mSize > 0) {
                System.arraycopy(nArray, 0, this.mHashes, 0, this.mSize);
                System.arraycopy(objectArray, 0, this.mArray, 0, this.mSize << 1);
            }
            SimpleArrayMap.freeArrays(nArray, objectArray, this.mSize);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        boolean bl2 = true;
        if (this == object) {
            return bl2;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        object = (Map)object;
        if (this.size() != object.size()) {
            return false;
        }
        int n2 = 0;
        while (true) {
            boolean bl3 = bl2;
            try {
                if (n2 >= this.mSize) return bl3;
                K k2 = this.keyAt(n2);
                V v2 = this.valueAt(n2);
                Object v3 = object.get(k2);
                if (v2 == null) {
                    if (v3 != null) return false;
                    if (!object.containsKey(k2)) {
                        return false;
                    }
                } else {
                    bl3 = v2.equals(v3);
                    if (!bl3) {
                        return false;
                    }
                }
                ++n2;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public V get(Object object) {
        int n2 = this.indexOfKey(object);
        if (n2 >= 0) {
            object = this.mArray[(n2 << 1) + 1];
            return (V)object;
        }
        object = null;
        return (V)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int[] nArray = this.mHashes;
        Object[] objectArray = this.mArray;
        int n2 = this.mSize;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2) {
            Object object = objectArray[n3];
            int n6 = nArray[n4];
            int n7 = object == null ? 0 : object.hashCode();
            n5 += n7 ^ n6;
            ++n4;
            n3 += 2;
        }
        return n5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int indexOf(Object object, int n2) {
        int n3;
        int n4;
        int n5 = this.mSize;
        if (n5 == 0) {
            return -1;
        }
        int n6 = n4 = ContainerHelpers.binarySearch(this.mHashes, n5, n2);
        if (n4 < 0) return n6;
        n6 = n4;
        if (object.equals(this.mArray[n4 << 1])) return n6;
        for (n3 = n4 + 1; n3 < n5 && this.mHashes[n3] == n2; ++n3) {
            if (!object.equals(this.mArray[n3 << 1])) continue;
            return n3;
        }
        --n4;
        while (n4 >= 0) {
            if (this.mHashes[n4] != n2) return ~n3;
            n6 = n4;
            if (object.equals(this.mArray[n4 << 1])) return n6;
            --n4;
        }
        return ~n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOfKey(Object object) {
        if (object != null) return this.indexOf(object, object.hashCode());
        return this.indexOfNull();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int indexOfNull() {
        int n2;
        int n3;
        int n4 = this.mSize;
        if (n4 == 0) {
            return -1;
        }
        int n5 = n3 = ContainerHelpers.binarySearch(this.mHashes, n4, 0);
        if (n3 < 0) return n5;
        n5 = n3;
        if (this.mArray[n3 << 1] == null) return n5;
        for (n2 = n3 + 1; n2 < n4 && this.mHashes[n2] == 0; ++n2) {
            if (this.mArray[n2 << 1] != null) continue;
            return n2;
        }
        --n3;
        while (n3 >= 0) {
            if (this.mHashes[n3] != 0) return ~n2;
            n5 = n3;
            if (this.mArray[n3 << 1] == null) return n5;
            --n3;
        }
        return ~n2;
    }

    /*
     * Unable to fully structure code
     */
    int indexOfValue(Object var1_1) {
        block3: {
            var2_2 = 1;
            var3_3 = 1;
            var4_4 = this.mSize * 2;
            var5_5 = this.mArray;
            if (var1_1 != null) ** GOTO lbl13
            for (var2_2 = var3_3; var2_2 < var4_4; var2_2 += 2) {
                if (var5_5[var2_2] != null) continue;
                var2_2 >>= 1;
lbl9:
                // 3 sources

                return var2_2;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var2_2 += 2;
lbl13:
                // 2 sources

                if (var2_2 >= var4_4) break block3;
                ** while (!var1_1.equals((Object)var5_5[var2_2]))
            }
lbl15:
            // 1 sources

            var2_2 >>= 1;
            ** GOTO lbl9
        }
        var2_2 = -1;
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEmpty() {
        if (this.mSize > 0) return false;
        return true;
    }

    public K keyAt(int n2) {
        return (K)this.mArray[n2 << 1];
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public V put(K object, V v2) {
        void var1_3;
        void var2_5;
        int n2;
        int n3;
        int n4 = 8;
        if (object == null) {
            n3 = this.indexOfNull();
            n2 = 0;
        } else {
            n2 = object.hashCode();
            n3 = this.indexOf(object, n2);
        }
        if (n3 >= 0) {
            n3 = (n3 << 1) + 1;
            Object object2 = this.mArray[n3];
            this.mArray[n3] = var2_5;
            return var1_3;
        }
        int n5 = ~n3;
        if (this.mSize >= this.mHashes.length) {
            if (this.mSize >= 8) {
                n3 = this.mSize + (this.mSize >> 1);
            } else {
                n3 = n4;
                if (this.mSize < 4) {
                    n3 = 4;
                }
            }
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.allocArrays(n3);
            if (this.mHashes.length > 0) {
                System.arraycopy(nArray, 0, this.mHashes, 0, nArray.length);
                System.arraycopy(objectArray, 0, this.mArray, 0, objectArray.length);
            }
            SimpleArrayMap.freeArrays(nArray, objectArray, this.mSize);
        }
        if (n5 < this.mSize) {
            System.arraycopy(this.mHashes, n5, this.mHashes, n5 + 1, this.mSize - n5);
            System.arraycopy(this.mArray, n5 << 1, this.mArray, n5 + 1 << 1, this.mSize - n5 << 1);
        }
        this.mHashes[n5] = n2;
        this.mArray[n5 << 1] = object;
        this.mArray[(n5 << 1) + 1] = var2_5;
        ++this.mSize;
        return var1_3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void putAll(SimpleArrayMap<? extends K, ? extends V> simpleArrayMap) {
        int n2 = simpleArrayMap.mSize;
        this.ensureCapacity(this.mSize + n2);
        if (this.mSize == 0) {
            if (n2 <= 0) return;
            System.arraycopy(simpleArrayMap.mHashes, 0, this.mHashes, 0, n2);
            System.arraycopy(simpleArrayMap.mArray, 0, this.mArray, 0, n2 << 1);
            this.mSize = n2;
            return;
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.put(simpleArrayMap.keyAt(i2), simpleArrayMap.valueAt(i2));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public V remove(Object object) {
        int n2 = this.indexOfKey(object);
        if (n2 >= 0) {
            object = this.removeAt(n2);
            return (V)object;
        }
        object = null;
        return (V)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public V removeAt(int n2) {
        int n3 = 8;
        Object object = this.mArray[(n2 << 1) + 1];
        if (this.mSize <= 1) {
            SimpleArrayMap.freeArrays(this.mHashes, this.mArray, this.mSize);
            this.mHashes = ContainerHelpers.EMPTY_INTS;
            this.mArray = ContainerHelpers.EMPTY_OBJECTS;
            this.mSize = 0;
            return (V)object;
        }
        if (this.mHashes.length > 8 && this.mSize < this.mHashes.length / 3) {
            if (this.mSize > 8) {
                n3 = this.mSize + (this.mSize >> 1);
            }
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.allocArrays(n3);
            --this.mSize;
            if (n2 > 0) {
                System.arraycopy(nArray, 0, this.mHashes, 0, n2);
                System.arraycopy(objectArray, 0, this.mArray, 0, n2 << 1);
            }
            if (n2 >= this.mSize) return (V)object;
            System.arraycopy(nArray, n2 + 1, this.mHashes, n2, this.mSize - n2);
            System.arraycopy(objectArray, n2 + 1 << 1, this.mArray, n2 << 1, this.mSize - n2 << 1);
            return (V)object;
        }
        --this.mSize;
        if (n2 < this.mSize) {
            System.arraycopy(this.mHashes, n2 + 1, this.mHashes, n2, this.mSize - n2);
            System.arraycopy(this.mArray, n2 + 1 << 1, this.mArray, n2 << 1, this.mSize - n2 << 1);
        }
        this.mArray[this.mSize << 1] = null;
        this.mArray[(this.mSize << 1) + 1] = null;
        return (V)object;
    }

    public V setValueAt(int n2, V v2) {
        n2 = (n2 << 1) + 1;
        Object object = this.mArray[n2];
        this.mArray[n2] = v2;
        return (V)object;
    }

    public int size() {
        return this.mSize;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        CharSequence charSequence = new StringBuilder(this.mSize * 28);
        ((StringBuilder)charSequence).append('{');
        int n2 = 0;
        while (true) {
            K k2;
            if (n2 >= this.mSize) {
                ((StringBuilder)charSequence).append('}');
                return ((StringBuilder)charSequence).toString();
            }
            if (n2 > 0) {
                ((StringBuilder)charSequence).append(", ");
            }
            if ((k2 = this.keyAt(n2)) != this) {
                ((StringBuilder)charSequence).append(k2);
            } else {
                ((StringBuilder)charSequence).append("(this Map)");
            }
            ((StringBuilder)charSequence).append('=');
            V v2 = this.valueAt(n2);
            if (v2 != this) {
                ((StringBuilder)charSequence).append(v2);
            } else {
                ((StringBuilder)charSequence).append("(this Map)");
            }
            ++n2;
        }
    }

    public V valueAt(int n2) {
        return (V)this.mArray[(n2 << 1) + 1];
    }
}

